/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.olap;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.data.fsa.olap.OlapServerBaseMetaInfo;
import kd.data.fsa.olap.TmplDimPosition;

public class Template
extends OlapServerBaseMetaInfo {
    @JSONField(serialize=false)
    Map<String, Integer> dimTypeIndex;
    @JSONField(serialize=false)
    Map<String, Long> viewpoint;
    @JSONField(serialize=false)
    Map<String, List<Long>> pageDim;
    @JSONField(serialize=false)
    List<TmplDimPosition> tmplDimPositions;

    @Override
    protected int getArraySize() {
        return super.getArraySize() + 3;
    }

    public Map<String, Long> getViewpoint() {
        return this.viewpoint;
    }

    public void setViewpoint(Map<String, Long> viewpoint) {
        this.viewpoint = viewpoint;
    }

    public Map<String, List<Long>> getPageDim() {
        return this.pageDim;
    }

    public void setPageDim(Map<String, List<Long>> pageDim) {
        this.pageDim = pageDim;
    }

    public List<TmplDimPosition> getTmplDimPositions() {
        return this.tmplDimPositions;
    }

    public void setTmplDimPositions(List<TmplDimPosition> tmplDimPositions) {
        this.tmplDimPositions = tmplDimPositions;
    }

    @Override
    protected Object[] appendSerializedArray(Object[] targetArray) {
        super.appendSerializedArray(targetArray);
        int index = super.getArraySize();
        targetArray[index++] = this.viewpoint;
        targetArray[index++] = this.pageDim;
        targetArray[index] = this.tmplDimPositions;
        return targetArray;
    }

    @Override
    protected void updateValueArray(Object[] v) {
        super.updateValueArray(v);
        int index = super.getArraySize();
        this.viewpoint = (Map)v[index++];
        this.pageDim = (Map)v[index++];
        List tmplDimPositionList = (List)v[index];
        this.dimTypeIndex = new HashMap<String, Integer>(16);
        if (tmplDimPositionList != null && tmplDimPositionList.size() > 0) {
            this.tmplDimPositions = new ArrayList<TmplDimPosition>(tmplDimPositionList.size());
            for (Map map : tmplDimPositionList) {
                TmplDimPosition tmplDimPosition = new TmplDimPosition();
                List list = (List)map.get("v");
                tmplDimPosition.setV(list.toArray());
                Map<String, List<Long>> rowDim = tmplDimPosition.getRowDim();
                Map<String, List<Long>> colDim = tmplDimPosition.getColDim();
                rowDim.keySet().forEach(p -> this.dimTypeIndex.putIfAbsent((String)p, 3));
                colDim.keySet().forEach(p -> this.dimTypeIndex.putIfAbsent((String)p, 4));
                this.tmplDimPositions.add(tmplDimPosition);
            }
        }
        if (this.viewpoint != null) {
            this.viewpoint.keySet().forEach(p -> this.dimTypeIndex.put((String)p, 1));
        }
        if (this.pageDim != null) {
            this.pageDim.keySet().forEach(p -> this.dimTypeIndex.put((String)p, 2));
        }
    }

    public String toString() {
        return "Template{id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", viewpoint=" + this.viewpoint + ", pageDim=" + this.pageDim + ", tmplDimPositions=" + this.tmplDimPositions + '}';
    }

    public Map<String, Integer> getDimTypeIndex() {
        return this.dimTypeIndex;
    }
}

