/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.data.disf.utils.IDataMServiceUtil;
import kd.data.disf.utils.Tuple;
import kd.data.fsa.model.UnionFindSetModel;
import kd.data.fsa.olap.OlapConnectionInformation;
import kd.data.fsa.olap.OlapCslSchemeInfo;
import kd.data.fsa.olap.OlapDimensionLookupMetaInfo;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.olap.Template;
import kd.data.fsa.olap.TemplateCatalog;
import kd.data.fsa.olap.TmplDimPosition;

public class FSABcmDataProvider
extends IDataMServiceUtil {
    private static final Log logger = LogFactory.getLog(FSABcmDataProvider.class);

    public static <T> T invokeBCMBizServiceEx(Class<T> jsonObjectClassType, String methodName, Object ... params) {
        return (T)FSABcmDataProvider.invokeBizService(jsonObjectClassType, (String)"fi", (String)"bcm", (String)"BCMToFSAMsService", (String)methodName, (Object[])params);
    }

    public static Map<String, OlapServerDimemsionMetaInfo> loadModuleAllDimensionMetas(Long moduleId) {
        try {
            return FSABcmDataProvider.deserializeOlapServerDimemsionMetaInfoMap((Map)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadModuleAllDimensionMetas", moduleId), OlapServerDimemsionMetaInfo.class);
        }
        catch (Exception e) {
            logger.error(String.format("[bcm] Call loadModuleAllDimensionMetas error,param: moduleId=%s", moduleId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public static OlapCslSchemeInfo loadDefaultCslSchemeInfo(long moduleId) {
        List list = (List)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadDefaultCslscheme", moduleId);
        if (list != null && list.size() > 0) {
            String json = (String)list.get(0);
            return FSABcmDataProvider.deserialize(json, OlapCslSchemeInfo.class);
        }
        return null;
    }

    public static boolean exitMoudleId(long moduleId) {
        List list = (List)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadModules", new QFilter("id", "=", (Object)moduleId));
        return !list.isEmpty();
    }

    public static boolean exitCslSchemeInfo(long cslSchemeId) {
        List list = (List)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadCslscheme", new QFilter("id", "=", (Object)cslSchemeId));
        return !list.isEmpty();
    }

    private static <T> T deserialize(String jsonStr, Class<T> tClass) {
        try {
            return (T)JSONUtils.cast((String)jsonStr, tClass, (boolean)true);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", "\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff1a" + e.getMessage() + ": jsonStr=" + jsonStr), new Object[0]);
        }
    }

    private static <T> List<T> deserializeToList(List<String> jsonList, Class<T> tClass) {
        try {
            return jsonList.stream().map(p -> SerializationUtils.fromJsonString((String)p, (Class)tClass)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", "\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff1a" + e.getMessage() + ": jsonStr=" + jsonList), new Object[0]);
        }
    }

    private static <T> Map<String, T> deserializeOlapServerDimemsionMetaInfoMap(Map<String, String> jsonStrMap, Class<T> classz) {
        return FSABcmDataProvider.deserializeOlapServerDimemsionMetaInfoMap(jsonStrMap, classz, t -> t);
    }

    private static <T, K, R> Map<K, R> deserializeOlapServerDimemsionMetaInfoMap(Map<K, String> jsonStrMap, Class<T> classz, Function<T, R> dataHander) {
        if (jsonStrMap == null || jsonStrMap.isEmpty()) {
            return new HashMap(0);
        }
        LinkedHashMap<K, R> result = new LinkedHashMap<K, R>(jsonStrMap.size());
        for (Map.Entry<K, String> en : jsonStrMap.entrySet()) {
            T deserialize = FSABcmDataProvider.deserialize(en.getValue(), classz);
            result.put(en.getKey(), dataHander.apply(deserialize));
        }
        return result;
    }

    public static OlapDimensionLookupMetaInfo loadModuleDimensionMetas(long moduleId, String[] hierarchyNumbers, String[] commonNumbers, Long OrganizationViewId, Map<String, Set<Long>> dimNumberMapMemberIdSet) {
        try {
            OlapDimensionLookupMetaInfo loadModuleOlapDimensionLookupMetaInfo = FSABcmDataProvider.invokeBCMBizServiceEx(OlapDimensionLookupMetaInfo.class, "loadModuleOlapDimensionLookupMetaInfo", moduleId, OrganizationViewId, hierarchyNumbers, commonNumbers, dimNumberMapMemberIdSet);
            return loadModuleOlapDimensionLookupMetaInfo;
        }
        catch (Exception e) {
            String hierarchyNumbersLog = hierarchyNumbers != null ? org.apache.commons.lang3.StringUtils.join((Object[])hierarchyNumbers, (String)"!") : null;
            String commonNumberLog = commonNumbers != null ? org.apache.commons.lang3.StringUtils.join((Object[])commonNumbers, (String)"!") : null;
            logger.error(String.format("[FSA] call loadModuleDimensionMetas error, params: moduleId=%s,hierarchyNumbers=%s,commonNumber=%s,viewId=%s", moduleId, hierarchyNumbersLog, commonNumberLog, OrganizationViewId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public static OlapServerDimemsionMetaInfo loadModuleDimensionMeta(Long moduleId, String dimNumber) {
        String jsonStr = (String)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadModuleDimensionMeta", moduleId, dimNumber);
        return StringUtils.isEmpty((String)jsonStr) ? null : FSABcmDataProvider.deserialize(jsonStr, OlapServerDimemsionMetaInfo.class);
    }

    public static Map<String, OlapServerDimMemberMetaInfo> loadDimensionMembers(Long moduleId, Long viewId, String dimensionEntityName, Long dimId, String filterColumnName, Collection<?> filterParamList, boolean includeMode, Long loginUserId) {
        try {
            return FSABcmDataProvider.deserializeOlapServerDimemsionMetaInfoMap((Map)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadDimensionMembers", moduleId, viewId, dimensionEntityName, dimId, filterColumnName, filterParamList, includeMode, loginUserId), OlapServerDimMemberMetaInfo.class, t -> t);
        }
        catch (Exception e) {
            String filterParamListLog = filterParamList != null ? org.apache.commons.lang3.StringUtils.join(filterParamList, (String)"!") : null;
            logger.error(String.format("[FSA] call loadDimensionMembers error, params: moduleId=%s,viewId=%s,dimensionEntityName=%s,dimId=%s,filterColumnName=%s,filterParamList=%s,includeMode=%s", moduleId, viewId, dimensionEntityName, dimId, filterColumnName, filterParamListLog, includeMode));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public static Map<String, OlapServerDimMemberMetaInfo> loadScenaio(Long moduleId) {
        try {
            return FSABcmDataProvider.deserializeOlapServerDimemsionMetaInfoMap((Map)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadDimensionMembers", moduleId, null, "Scenario", "number", Collections.singleton("Scenario"), Boolean.FALSE, null), OlapServerDimMemberMetaInfo.class, t -> t);
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call loadDimensionMembers error, params: moduleId=%s", moduleId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public static List<Template> loadTemplate(long moduleId, Set<Long> templateCatalogIds, int[] filters, Object[][] params) {
        Object[][] paramszq;
        int[] filterzq;
        if (filters == null) {
            filterzq = new int[]{4};
            paramszq = new Object[][]{{2, false, "Year", "Period"}};
        } else {
            filterzq = new int[filters.length + 1];
            paramszq = new Object[params.length + 1][];
            System.arraycopy(filters, 0, filterzq, 0, filters.length);
            System.arraycopy(params, 0, paramszq, 0, params.length);
            filterzq[filterzq.length - 1] = 4;
            paramszq[paramszq.length - 1] = new Object[]{2, false, "Year", "Period"};
        }
        try {
            return FSABcmDataProvider.deserializeToList((List)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadTemplates", new Object[]{moduleId, templateCatalogIds, filterzq, paramszq}), Template.class);
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call loadDimensionMembers error, params: moduleId=%s", moduleId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public static List<Template> loadTemplate(long moduleId, Long templateCatalogId, int[] filters, Object[][] params) {
        return FSABcmDataProvider.loadTemplate(moduleId, templateCatalogId == null ? null : Collections.singleton(templateCatalogId), filters, params);
    }

    public static List<TemplateCatalog> loadTemplateCatalog(long moduleId, int[] filters, Object[][] params) {
        try {
            return FSABcmDataProvider.deserializeToList((List)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadTemplatecatalogs", new Object[]{moduleId, filters, params}), TemplateCatalog.class);
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call loadDimensionMembers error, params: moduleId=%s", moduleId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public static Map<String, OlapServerDimMemberMetaInfo> loadDimensionMembers(Long moduleId, Long viewId, String entity, Long dimId) {
        try {
            return FSABcmDataProvider.loadDimensionMembers(moduleId, viewId, entity, dimId, null, null, false, null);
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call loadDimensionMembers error, params: moduleId=%s,viewId=%s,entity=%s,dimId=%s", moduleId, viewId, entity, dimId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public static Map<String, OlapServerDimMemberMetaInfo> loadDimensionMembers(Long moduleId, Long viewId, String dimNumber, String filterColumnName, Collection<?> filterParamList, boolean include) {
        try {
            return FSABcmDataProvider.deserializeOlapServerDimemsionMetaInfoMap((Map)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadDimensionMembers", moduleId, viewId, dimNumber, filterColumnName, filterParamList, include, null), OlapServerDimMemberMetaInfo.class, t -> t);
        }
        catch (Exception e) {
            String filterParamListLog = filterParamList != null ? org.apache.commons.lang3.StringUtils.join(filterParamList, (String)"!") : null;
            logger.error(String.format("[FSA] call loadDimensionMembers error, params: moduleId=%s,viewId=%s,dimNumber=%s,filterColumnName=%s,filterParamList=%s,include=%s", moduleId, viewId, dimNumber, filterColumnName, filterParamListLog, include));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public static Map<String, OlapServerDimMemberMetaInfo> loadDimensionMembersByAuth(Long moduleId, Long viewId, String entity, Long dimId) {
        return FSABcmDataProvider.loadDimensionMembers(moduleId, viewId, entity, dimId, null, null, false, RequestContext.get().getCurrUserId());
    }

    public static OlapServerDimMemberMetaInfo loadDimensionMembersTopOne(Long moduleId, Long viewId, String dimensionEntityName, Long dimId, String dimNumber) {
        Map<String, OlapServerDimMemberMetaInfo> olapServerDimMemberMetaInfoMap = FSABcmDataProvider.loadDimensionMembers(moduleId, viewId, dimensionEntityName, dimId, "level", Arrays.asList(1, 2), true, null);
        Iterator<Map.Entry<String, OlapServerDimMemberMetaInfo>> iterator = olapServerDimMemberMetaInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            OlapServerDimMemberMetaInfo value = iterator.next().getValue();
            if (dimNumber.equals(value.getNumber())) continue;
            return value;
        }
        return null;
    }

    public static Map<String, String> loadCurrentUserVisiableEntities(long moduleId, Long dimId) {
        return (Map)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadCurrentUserVisiableEntities", moduleId, dimId);
    }

    @Deprecated
    public static Map<String, String> loadDimensionMemberNumberNames(String srcEntityName, long dimensionId, Collection<Long> filterIds, boolean sort) {
        return (Map)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadDimensionMemberNumberNames", srcEntityName, dimensionId, filterIds, sort);
    }

    @Deprecated
    public static Map<String, String> loadDimensionMemberNumberId(String srcEntityName, long dimensionId, Collection<Long> filterIds, boolean sort) {
        return (Map)FSABcmDataProvider.invokeBCMBizServiceEx(null, "loadDimensionMemberNumberId", srcEntityName, dimensionId, filterIds, sort);
    }

    public static OlapConnectionInformation getOlapConnectionInformation(String cubeCatelog, Integer version) {
        return new OlapConnectionInformation((Map)FSABcmDataProvider.invokeBCMBizServiceEx(null, "getOlapConnectionInformation", cubeCatelog, version));
    }

    public static OlapConnectionInformation getOlapConnectionInformation(String cubeCatelog) {
        return new OlapConnectionInformation((Map)FSABcmDataProvider.invokeBCMBizServiceEx(null, "getOlapConnectionInformation", cubeCatelog, null));
    }

    public static OlapConnectionInformation getOlapConnectionInformation(String cubeCatelog, String olapServerAddress) {
        return new OlapConnectionInformation((Map)FSABcmDataProvider.invokeBCMBizServiceEx(null, "getOlapConnectionInformation", cubeCatelog, olapServerAddress));
    }

    public static String getModelNumber(Long moduleId) {
        try {
            return (String)FSABcmDataProvider.invokeBCMBizServiceEx(null, "getModelNumber", moduleId);
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call getModelNumber error, params: moduleId=%s", moduleId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public static Template loadDimMemberFromTemplate(Long templateId) {
        Template template = FSABcmDataProvider.invokeBCMBizServiceEx(Template.class, "loadDimMemberFromTemplate", templateId);
        TmplDimPositionUnionFindModel unionFind = new TmplDimPositionUnionFindModel(template.getTmplDimPositions());
        List<TmplDimPosition> tmplDimPositions = unionFind.doUnionFindOp();
        tmplDimPositions.sort((a, b) -> b.getColDim().values().stream().map(p -> p.size()).reduce((x, y) -> x * y).get() * b.getRowDim().values().stream().map(p -> p.size()).reduce((x, y) -> x * y).get() - a.getColDim().values().stream().map(p -> p.size()).reduce((x, y) -> x * y).get() * a.getRowDim().values().stream().map(p -> p.size()).reduce((x, y) -> x * y).get());
        template.setTmplDimPositions(tmplDimPositions);
        return template;
    }

    public static class TmplDimPositionUnionFindModel
    extends UnionFindSetModel<TmplDimPosition> {
        List<TmplDimPosition> list;
        LinkedHashMap<UnionFindSetModel.Element<TmplDimPosition>, TmplDimPosition> unionedTmpldimPosition;
        Map<String, String> diffDimName = new HashMap<String, String>(2);

        public TmplDimPositionUnionFindModel(List<TmplDimPosition> list) {
            super(list);
            this.unionedTmpldimPosition = new LinkedHashMap(list.size());
            for (TmplDimPosition tmplDimPosition : list) {
                UnionFindSetModel.Element tmplDimPositionElement = (UnionFindSetModel.Element)this.elementMap.get(tmplDimPosition);
                this.unionedTmpldimPosition.put(this.findFather(tmplDimPositionElement), tmplDimPosition);
            }
            this.list = list;
        }

        public List<TmplDimPosition> doUnionFindOp() {
            for (int i = 0; i < this.list.size(); ++i) {
                for (int i1 = 0; i1 < this.list.size(); ++i1) {
                    TmplDimPosition arearangeB;
                    TmplDimPosition arearangeA = this.list.get(i);
                    if (arearangeA.equals(arearangeB = this.list.get(i1))) continue;
                    this.union(arearangeA, arearangeB);
                }
            }
            ArrayList<TmplDimPosition> returnList = new ArrayList<TmplDimPosition>(this.unionedTmpldimPosition.values());
            return returnList;
        }

        @Override
        public boolean union(TmplDimPosition a, TmplDimPosition b) {
            Tuple<UnionFindSetModel.Element<TmplDimPosition>, UnionFindSetModel.Element<TmplDimPosition>> elementElementTuple = this.checkFatherAndChild(a, b);
            boolean isSuccess = super.union(a, b);
            if (isSuccess) {
                String newPositonName = a.getArearange() + "_" + b.getArearange();
                String dimName = this.diffDimName.get(newPositonName);
                Map<String, List<Long>> dima = a.getColDim();
                Map<String, List<Long>> dimb = b.getColDim();
                if (dima != null && dima.get(dimName) != null) {
                    List<Long> memidA = dima.get(dimName);
                    List<Long> memidB = dimb.get(dimName);
                    memidA.addAll(memidB);
                    List collect = memidA.stream().distinct().collect(Collectors.toList());
                    dima.put(dimName, collect);
                    a.setColDim(dima);
                }
                Map<String, List<Long>> rowdima = a.getRowDim();
                Map<String, List<Long>> rowdimb = b.getRowDim();
                if (rowdima != null && rowdima.get(dimName) != null) {
                    List<Long> memidA = rowdima.get(dimName);
                    List<Long> memidB = rowdimb.get(dimName);
                    memidA.addAll(memidB);
                    List collect = memidA.stream().distinct().collect(Collectors.toList());
                    rowdima.put(dimName, collect);
                    a.setRowDim(rowdima);
                }
                a.setArearange(a.getArearange() + "_" + b.getArearange());
                this.unionedTmpldimPosition.put((UnionFindSetModel.Element<TmplDimPosition>)elementElementTuple.getK(), a);
                this.unionedTmpldimPosition.remove(elementElementTuple.getV());
            }
            return isSuccess;
        }

        @Override
        public boolean checkElementCanBeUnion(UnionFindSetModel.Element<TmplDimPosition> tmplDimPositionElementA, UnionFindSetModel.Element<TmplDimPosition> tmplDimPositionElementB) {
            TmplDimPosition tmplDimPositionA = this.unionedTmpldimPosition.get(this.findFather(tmplDimPositionElementA));
            HashMap<String, List<Long>> arearangeADim = new HashMap<String, List<Long>>();
            arearangeADim.putAll(tmplDimPositionA.getColDim());
            arearangeADim.putAll(tmplDimPositionA.getRowDim());
            HashMap<String, List<Long>> arearangeBDim = new HashMap<String, List<Long>>();
            TmplDimPosition tmplDimPositionB = this.unionedTmpldimPosition.get(this.findFather(tmplDimPositionElementB));
            arearangeBDim.putAll(tmplDimPositionB.getColDim());
            arearangeBDim.putAll(tmplDimPositionB.getRowDim());
            Iterator iterator = arearangeADim.entrySet().iterator();
            int diffcount = 0;
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String key = (String)next.getKey();
                List bMember = (List)arearangeBDim.get(key);
                List aMember = (List)next.getValue();
                if (this.containAll(aMember, bMember)) continue;
                if (diffcount++ > 0) {
                    return false;
                }
                this.diffDimName.put(tmplDimPositionA.getArearange() + "_" + tmplDimPositionB.getArearange(), key);
            }
            return true;
        }

        private <T> boolean containAll(List<T> list1, List<T> list2) {
            HashSet<T> ts1 = new HashSet<T>(list1);
            HashSet<T> ts2 = new HashSet<T>(list2);
            return ts1.equals(ts2);
        }
    }
}

