/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.data.fsa.model.rpt.operation.FSARptFactOperationParam;

public class FSABusinessServiceHelper {
    public static Map<String, String> getEntityPropFieldNames(MainEntityType entityType, String ... propNames) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (entityType != null && propNames != null && propNames.length > 0) {
            DataEntityPropertyCollection props = entityType.getProperties();
            for (String name : propNames) {
                IDataEntityProperty propType = (IDataEntityProperty)props.get((Object)name);
                if (propType == null) continue;
                resultMap.put(name, propType.getAlias());
            }
        }
        return resultMap;
    }

    protected QFilter buildRptFactTableFilterCondition(FSARptFactOperationParam param) {
        if (param != null && param.getEntityType() != null) {
            Map<String, String> fieldName;
            ArrayList<String> fieldNames = new ArrayList<String>(2);
            fieldNames.add("org_id");
            fieldNames.add("period_id");
            if (param.getSrcItemId() != null) {
                fieldNames.add("srcitem_id");
            }
            if (param.getAcctBookTypeIds() != null) {
                fieldNames.add("acctbooktype_id");
            }
            if ((fieldName = FSABusinessServiceHelper.getEntityPropFieldNames(param.getEntityType(), fieldNames.toArray(new String[fieldNames.size()]))).size() >= fieldNames.size()) {
                QFilter filter = new QFilter(fieldName.get("org_id"), "in", param.getOrgId()).and(fieldName.get("period_id"), "in", param.getPeriodId());
                if (param.getSrcItemId() != null) {
                    filter.and(fieldName.get("srcitem_id"), "in", param.getSrcItemId());
                }
                if (param.getAcctBookTypeIds() != null) {
                    filter.and(fieldName.get("acctbooktype_id"), "in", param.getAcctBookTypeIds());
                }
                return filter;
            }
        }
        return null;
    }

    public int markDeleteReportFacts(FSARptFactOperationParam param, long token) {
        QFilter filter = this.buildRptFactTableFilterCondition(param);
        if (filter != null) {
            MainEntityType entityType = param.getEntityType();
            String sql = String.format("UPDATE %s SET fdel = " + token + " where (fdel is null or fdel = 0) and %s", entityType.getAlias(), filter.toString());
            return DB.update((DBRoute)new DBRoute(entityType.getDBRouteKey()), (String)sql);
        }
        return -1;
    }

    public int markDeleteRollbackReportFacts(FSARptFactOperationParam param, long token) {
        QFilter filter = this.buildRptFactTableFilterCondition(param);
        if (filter != null) {
            MainEntityType entityType = param.getEntityType();
            String sql = String.format("UPDATE %s SET fdel = 0 where (fdel =" + token + ") and %s", entityType.getAlias(), filter.toString());
            return DB.update((DBRoute)new DBRoute(entityType.getDBRouteKey()), (String)sql);
        }
        return -1;
    }

    public int saveRollBackReportFacts(FSARptFactOperationParam param) {
        QFilter filter = this.buildRptFactTableFilterCondition(param);
        if (filter != null) {
            MainEntityType entityType = param.getEntityType();
            String sql = String.format("Delete From %s Where fdel = '0' and %s", entityType.getAlias(), filter.toString());
            return DB.update((DBRoute)new DBRoute(entityType.getDBRouteKey()), (String)sql);
        }
        return -1;
    }

    public int deleteReportFacts(MainEntityType entityType, long deleteToken) {
        if (entityType != null) {
            return DB.update((DBRoute)new DBRoute(entityType.getDBRouteKey()), (String)String.format("delete From %s Where fdel = %s", entityType.getAlias(), deleteToken));
        }
        return -1;
    }

    public int updateRptIndicators(FSARptFactOperationParam param) {
        return -1;
    }
}

