/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.disf.model.impl.IDataMapEntry;

public class FSACalculateUtils<T extends Number> {
    private static final Log logger = LogFactory.getLog(FSACalculateUtils.class);
    List<Map<String, T>> dataCacheLists;
    Map<String, T> dataCache;
    Map<String, String> numberCalcformulars;
    Map<String, String> legitimateCalcformulars;
    private Set<String> hasParsedNumber = new HashSet<String>();

    public FSACalculateUtils(Map<String, T[]> map, int top) {
        if (!map.isEmpty()) {
            this.dataCacheLists = new ArrayList<Map<String, T>>(top);
            for (int i = 0; i < top; ++i) {
                HashMap<String, T> cacheMap = new HashMap<String, T>((int)((float)map.size() / 0.75f) + 1);
                for (Map.Entry<String, T[]> entry : map.entrySet()) {
                    String key = entry.getKey();
                    Number value = ((Number[])entry.getValue())[i];
                    cacheMap.put("A" + key, value);
                }
                this.dataCache = cacheMap;
                this.dataCacheLists.add(cacheMap);
            }
        }
    }

    public FSACalculateUtils(Map<String, T> ... maps) {
        if (maps.length > 0) {
            this.dataCacheLists = new ArrayList<Map<String, T>>(maps.length);
            for (Map<String, T> map : maps) {
                HashMap<String, T> cacheMap = new HashMap<String, T>((int)((float)map.size() / 0.75f) + 1);
                for (Map.Entry<String, T> entry : map.entrySet()) {
                    String key = entry.getKey();
                    Number value = (Number)entry.getValue();
                    cacheMap.put("A" + key, value);
                }
                this.dataCache = cacheMap;
                this.dataCacheLists.add(cacheMap);
            }
        }
    }

    public List<T> calculate(String calcformular) {
        if (StringUtils.isEmpty((String)calcformular) || CollectionUtils.isEmpty(this.dataCacheLists)) {
            logger.error("calcformular is null or dataCacheLists is empty");
            throw new KDBizException("calcformular is null or dataCacheLists is empty");
        }
        String[] split = calcformular.split("\\s+");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String str = split[i].replaceAll("\\s+", "").replaceAll("\\[", "A").replaceAll("]", "");
            sb.append(str);
        }
        ArrayList<Number> returnList = new ArrayList<Number>(this.dataCacheLists.size());
        String strCalcformular = sb.toString();
        for (Map<String, T> map : this.dataCacheLists) {
            Number ts;
            try {
                ts = (Number)FormulaEngine.runFormula((String)strCalcformular, map);
            }
            catch (RunFormulaException e) {
                logger.error("script:" + calcformular + ",error :" + e.getMessage(), (Throwable)e);
                if (e.getMessage().contains("null")) {
                    String errMsg = ResManager.loadKDString((String)"\u68c0\u67e5\u5b57\u6bb5\u7684\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u68c0\u67e5", (String)"RunFormulaException_0", (String)"data-fsa-core", (Object[])new Object[0]);
                    throw new KDBizException(errMsg);
                }
                ts = null;
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
            returnList.add(ts);
        }
        return returnList;
    }

    public List<IDataMapEntry<String, List<T>>> calculate(Map<String, String> map) {
        Map<String, String> cacheCalculates = this.depend2Independent(map);
        ArrayList<IDataMapEntry<String, List<T>>> list = new ArrayList<IDataMapEntry<String, List<T>>>(cacheCalculates.size());
        for (Map.Entry<String, String> entry : cacheCalculates.entrySet()) {
            list.add(new IDataMapEntry((Object)entry.getKey().substring(1), this.calculate(entry.getValue())));
        }
        return list;
    }

    private Map<String, String> depend2Independent(Map<String, String> map) {
        this.numberCalcformulars = this.calculateMapKeySetA(map);
        this.legitimateCalcformulars = new HashMap<String, String>((int)((float)map.size() / 0.75f) + 1);
        for (Map.Entry<String, String> tuple2 : this.numberCalcformulars.entrySet()) {
            String number = tuple2.getKey();
            String calcformular = this.parseCalcformular(number);
            this.legitimateCalcformulars.put(number, calcformular);
        }
        return this.legitimateCalcformulars;
    }

    private Map<String, String> calculateMapKeySetA(Map<String, String> map) {
        HashMap<String, String> cacheMap = new HashMap<String, String>((int)((float)map.size() / 0.75f) + 1);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            cacheMap.put("A" + key, value);
        }
        return cacheMap;
    }

    private String parseCalcformular(String number) {
        this.hasParsedNumber.add(number);
        String calcformulars = this.numberCalcformulars.get(number);
        String numberFormula = this.legitimateCalcformulars.get(number);
        return numberFormula != null ? numberFormula : this.parseElement(calcformulars);
    }

    private String parseElement(String calcformular) {
        Pattern pattern = Pattern.compile("\\[(.*?)\\]");
        Matcher m = pattern.matcher(calcformular);
        while (m.find()) {
            boolean isNeedParentheses = true;
            String needToReplaceStr = m.group(0);
            String calcformularElement = m.group(1);
            String number = "A" + calcformularElement.trim();
            String numberCalcformular = "";
            String numberFormula = this.legitimateCalcformulars.get(number);
            if (numberFormula != null) {
                numberCalcformular = numberFormula;
            } else if (this.dataCache.containsKey(number)) {
                numberCalcformular = "[" + number.substring(1) + "]";
                isNeedParentheses = false;
            } else if (this.numberCalcformulars.containsKey(number)) {
                if (this.hasParsedNumber.contains(number)) {
                    throw new KDBizException("unresolved number : " + number);
                }
                numberCalcformular = this.parseCalcformular(number);
                this.legitimateCalcformulars.put(number, numberCalcformular);
            } else {
                throw new KDBizException("the " + number + " is not defined");
            }
            if (isNeedParentheses) {
                numberCalcformular = "(" + numberCalcformular + ")";
            }
            calcformular = calcformular.replace(needToReplaceStr, numberCalcformular);
        }
        return calcformular;
    }
}

