/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.utils.FSABcmDataProvider;

public class FSADataCollectionHelper {
    public static Map<String, Object> getSrcParamFromCol(Long dataCollectionId) {
        QFilter filter = new QFilter("id", "=", (Object)dataCollectionId);
        DynamicObject dataCol = QueryServiceHelper.queryOne((String)"fsa_data_collection", (String)"paramsrc_tag", (QFilter[])filter.toArray());
        return FSADataCollectionHelper.getSrcParamFromCol(dataCol);
    }

    public static Map<String, Object> getSrcParamFromCol(DynamicObject dataCollection) {
        String srcParamJson = dataCollection.getString("paramsrc_tag");
        return FSADataCollectionHelper.getSrcParamMapFromJson(srcParamJson);
    }

    public static Map<String, Object> getSrcParamMapFromJson(String srcParamJson) {
        if (srcParamJson == null || srcParamJson.isEmpty()) {
            return null;
        }
        return (Map)JSONObject.parseObject((String)srcParamJson, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
    }

    public static Map<String, String> getRigidConditionDimMemMap(DynamicObject dataCollection) {
        DynamicObjectCollection dataColSrcFilerCollection = dataCollection.getDynamicObjectCollection("datacolsrcfilter");
        HashMap<String, String> rigidConditionDimMemMap = new HashMap<String, String>(10);
        for (DynamicObject dynObj : dataColSrcFilerCollection) {
            rigidConditionDimMemMap.put(dynObj.getString("srcdimnumber").toLowerCase(), dynObj.getString("srcdimdefault"));
        }
        return rigidConditionDimMemMap;
    }

    public static String preJudgeDataCollection(Long dataCollectionPkId) {
        StringBuilder tips = new StringBuilder();
        DynamicObject datacollectionDynObj = BusinessDataReader.loadSingle((Object)dataCollectionPkId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fsa_data_collection"));
        Object dataSrcType = datacollectionDynObj.get("datasrctype");
        if (!"bcmParamSource".equals(dataSrcType)) {
            return null;
        }
        Map<String, Object> srcParam = FSADataCollectionHelper.getSrcParamFromCol(datacollectionDynObj);
        if (srcParam != null) {
            boolean orgViewExist;
            Long moduleId = IDataValueUtil.getLong((Object)srcParam.get("moduleId"));
            Long orgView = IDataValueUtil.getLong((Object)srcParam.get("OrgView"));
            boolean moduleExist = moduleId != null && FSABcmDataProvider.exitMoudleId(moduleId);
            boolean bl = orgViewExist = orgView == null || FSABcmDataProvider.exitCslSchemeInfo(orgView);
            if (!moduleExist) {
                tips.append(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5408\u6765\u6e90\u53c2\u6570\u5408\u5e76\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"FSADataCollectionHelper_0", (String)"data-fsa-core", (Object[])new Object[0]));
            } else if (!orgViewExist) {
                tips.append(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5408\u6765\u6e90\u53c2\u6570\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"FSADataCollectionHelper_1", (String)"data-fsa-core", (Object[])new Object[0]));
            }
        } else {
            tips.append(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5408\u6765\u6e90\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"FSADataCollectionHelper_2", (String)"data-fsa-core", (Object[])new Object[0]));
        }
        return tips.length() > 0 ? tips.toString() : null;
    }
}

