/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.disf.enums.FSAStatusEnum;
import kd.data.disf.utils.IDataDateUtil;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSADvRefParamEnum;
import kd.data.fsa.model.gdt.FSADataVersionModel;
import kd.data.fsa.model.sync.FSADataSyncTaskDimFilterModel;

public class FSADataversionUtils {
    public static String getVersionToDateString() {
        Date date = new Date(FSADataversionUtils.getVersion(1));
        return IDataDateUtil.dateToString((Date)date, (String)"yyyyMMddHHmmssSSS");
    }

    public static Long getVersionToDateLong() {
        String versionToDateString = FSADataversionUtils.getVersionToDateString();
        return Long.parseLong(versionToDateString);
    }

    public static String getEntity(Long paramId, Long version) {
        QFilter paramFilter = new QFilter("refparam", "=", (Object)paramId);
        QFilter versionFilter = new QFilter("version", "=", (Object)version);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fsa_dataversion", (String)"targetentity", (QFilter[])new QFilter[]{paramFilter, versionFilter});
        return dynamicObject.getString("targetentity");
    }

    public static void setStatus(Long paramId, List<Long> versions, FSAStatusEnum status) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("refparam", "=", (Object)paramId));
        if (versions != null && !versions.isEmpty()) {
            qFilters.add(new QFilter("version", "in", versions));
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"fsa_dataversion", (String)"status,modifytime", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        Date date = new Date();
        for (int i = 0; i < load.length; ++i) {
            DynamicObject dynamicObject = load[i];
            dynamicObject.set("status", (Object)status.getCodeString());
            dynamicObject.set("modifytime", (Object)date);
        }
        SaveServiceHelper.update((DynamicObject[])load);
    }

    public static long getVersionFromDateString(String versionString) {
        Date versionDate = IDataDateUtil.stringToDate((String)versionString, (String)"yyyyMMddHHmmssSSS");
        if (versionDate == null) {
            String fSADataversionUtilsException_0 = String.format(ResManager.loadKDString((String)"version\u503c\u4e3a\uff1a%s\u4e0d\u80fd\u8f6c\u6362\u4e3ayyyyMMddHHmmssSSS\u683c\u5f0f", (String)"FSADataversionUtilsException_0", (String)"data-fsa-core", (Object[])new Object[0]), versionString);
            throw new KDBizException(fSADataversionUtilsException_0);
        }
        return versionDate.getTime();
    }

    public static long getVersion(int stategy) {
        switch (stategy) {
            case 1: {
                return System.currentTimeMillis();
            }
            case 2: {
                return ID.genLongId();
            }
        }
        return System.currentTimeMillis();
    }

    public static FSADataVersionModel insertDb(long version, String entity, String srcType, long syncParamId, List<FSADataSyncTaskDimFilterModel> dimFilterModels) {
        FSADataVersionModel fsaDataVersionModel = new FSADataVersionModel(version, entity, FSADvRefParamEnum.getEnum(srcType), syncParamId, dimFilterModels);
        return FSADataversionUtils.insertDb(fsaDataVersionModel);
    }

    public static FSADataVersionModel insertDb(String entity, String srcType, long syncParamId, List<FSADataSyncTaskDimFilterModel> dimFilterModels) {
        long version = FSADataversionUtils.getVersion(1);
        return FSADataversionUtils.insertDb(version, entity, srcType, syncParamId, dimFilterModels);
    }

    public static FSADataVersionModel insertDb(FSADataVersionModel fsaDataVersionModel) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fsa_dataversion");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
        dynamicObject = fsaDataVersionModel.writeValueIntoDynamicObject(dynamicObject);
        DynamicObject save = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject})[0];
        fsaDataVersionModel.setId(save.getLong("id"));
        return fsaDataVersionModel;
    }

    public static FSADataVersionModel insertDb(DynamicObject dynamicObject) {
        DynamicObject save = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject})[0];
        FSADataVersionModel fsaDataVersionModel = new FSADataVersionModel(save);
        return fsaDataVersionModel;
    }

    public static List<FSADataVersionModel> load(Long[] ids) {
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fsa_dataversion"));
        ArrayList<FSADataVersionModel> list = new ArrayList<FSADataVersionModel>(load.length);
        for (DynamicObject dynamicObject : load) {
            list.add(new FSADataVersionModel(dynamicObject));
        }
        return list;
    }

    public static List<FSADataVersionModel> load(FSAStatusEnum status, int batchCount) {
        QFilter qFilter = new QFilter("status", "=", (Object)status.getCodeString());
        DynamicObjectCollection load = QueryServiceHelper.query((String)"fsa_dataversion", (String)"id", (QFilter[])new QFilter[]{qFilter}, null, (int)batchCount);
        Set<Long> ids = load.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
        return FSADataversionUtils.load(ids.toArray(new Long[ids.size()]));
    }

    public static int tombstoneWithVersion(List<FSADataVersionModel> fsaDataVersionModels) {
        QFilter refParam = FSADataversionUtils.getRefParam(fsaDataVersionModels);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"fsa_dataversion", (String)"status,modifytime", (QFilter[])new QFilter[]{refParam});
        Date date = new Date();
        for (int i = 0; i < load.length; ++i) {
            DynamicObject dynamicObject = load[i];
            dynamicObject.set("status", (Object)"-1");
            dynamicObject.set("modifytime", (Object)date);
        }
        SaveServiceHelper.update((DynamicObject[])load);
        return load.length;
    }

    public static int deleteWithVersins(List<FSADataVersionModel> fsaDataVersionModels) {
        QFilter refParam = FSADataversionUtils.getRefParam(fsaDataVersionModels);
        return DeleteServiceHelper.delete((String)"fsa_dataversion", (QFilter[])new QFilter[]{refParam});
    }

    private static QFilter getRefParam(List<FSADataVersionModel> fsaDataVersionModels) {
        if (fsaDataVersionModels == null || fsaDataVersionModels.isEmpty()) {
            String fsaDataversionUtilsException_1 = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6a21\u578b\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FSADataversionUtilsException_1", (String)"data-fsa-core", (Object[])new Object[0]);
            throw new KDBizException(fsaDataversionUtilsException_1);
        }
        Map collect = fsaDataVersionModels.stream().collect(Collectors.groupingBy(FSADataVersionModel::getRefParam, Collectors.mapping(FSADataVersionModel::getVersion, Collectors.toSet())));
        Iterator iterator = collect.entrySet().iterator();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(collect.size());
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            Long refParam = next.getKey();
            Set versions = next.getValue();
            QFilter perFilter = new QFilter("refparam", "=", (Object)refParam).and(new QFilter("version", "in", versions));
            qFilters.add(perFilter);
        }
        return (QFilter)qFilters.stream().reduce((a, b) -> a.or(b)).get();
    }

    public static int deleteWithParamId(Set<Long> refparams) {
        QFilter qFilter = new QFilter("refparam", "in", refparams);
        return DeleteServiceHelper.delete((String)"fsa_dataversion", (QFilter[])new QFilter[]{qFilter});
    }

    public static int tombstoneWithParamId(Set<Long> refparams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("refparam", "in", refparams));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"fsa_dataversion", (String)"status,modifytime", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        Date date = new Date();
        for (int i = 0; i < load.length; ++i) {
            DynamicObject dynamicObject = load[i];
            dynamicObject.set("status", (Object)FSAStatusEnum.DELETED.getCodeString());
            dynamicObject.set("modifytime", (Object)date);
        }
        SaveServiceHelper.update((DynamicObject[])load);
        return load.length;
    }

    public static List<Long> getEnableVersion(long refparam, Set<Long> excludeVersion, boolean newestVersion) {
        LinkedList<Long> returnList = new LinkedList<Long>();
        QFilter qFilters = new QFilter("refparam", "=", (Object)refparam).and("status", "=", (Object)FSAStatusEnum.ENABLE.getCodeString());
        if (excludeVersion != null && !excludeVersion.isEmpty()) {
            qFilters.and("version", "not in", excludeVersion);
        }
        String orderBys = "createtime desc";
        DynamicObjectCollection versions = QueryServiceHelper.query((String)"fsa_dataversion", (String)"version", (QFilter[])qFilters.toArray(), (String)orderBys);
        if (versions != null && !versions.isEmpty()) {
            if (newestVersion) {
                Optional firstOp = versions.stream().findFirst();
                if (firstOp.isPresent()) {
                    DynamicObject first = (DynamicObject)firstOp.get();
                    returnList.add(first.getLong("version"));
                }
            } else {
                versions.forEach(p -> returnList.add(p.getLong("version")));
            }
        }
        return returnList;
    }

    public static DynamicObjectCollection getInfoBySyncParamId(Long syncParamId) {
        QFilter qFilter = new QFilter("refparam", "=", (Object)syncParamId);
        DynamicObjectCollection dataVersions = QueryServiceHelper.query((String)"fsa_dataversion", (String)"version,createtime,status", (QFilter[])qFilter.toArray(), (String)"createtime desc,status desc");
        return dataVersions;
    }

    public static DynamicObject getVersionEntryInfo(Long version) {
        QFilter qFilter = new QFilter("version", "=", (Object)version);
        DynamicObject versionField = BusinessDataServiceHelper.loadSingle((String)"fsa_dataversion", (String)"entryentity.dimname, subentryentity.membername", (QFilter[])qFilter.toArray());
        return versionField;
    }

    public static void deleteVersionAndData(String tableNumber, Long syncParamId, Set<Long> versionSet) {
        QFilter versionFilter = new QFilter("version", "in", versionSet);
        DeleteServiceHelper.delete((String)FSACommonConstant.buildEntityName(tableNumber), (QFilter[])versionFilter.toArray());
        QFilter filter = new QFilter("refparam", "=", (Object)syncParamId).and(versionFilter);
        DeleteServiceHelper.delete((String)"fsa_dataversion", (QFilter[])filter.toArray());
    }
}

