/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.disf.utils.IDataMServiceUtil;
import kd.data.disf.utils.QFilterBuilder;
import kd.data.fsa.common.enums.FSAStandardReportTypeEnum;
import kd.data.fsa.model.rpt.config.gl.FSAGLBaseReportItemModel;
import kd.data.fsa.model.rpt.config.gl.KDGLAccountBook;

public class FSAGLReportDataProvider
extends IDataMServiceUtil {
    private static final Log logger = LogFactory.getLog(FSAGLReportDataProvider.class);
    private static final String selectFields = "accountingSys,org,booksType,accountTable,baseCurrency,exratetable,periodType,startPeriod,curPeriod,defaultVoucherType,yearProfitAcct,assetBook,policyBook,costAccount,aporg,casorg";

    private FSAGLReportDataProvider() {
    }

    public static KDGLAccountBook getGLAcctBookAndPeriodTypeCode(long orgId, long acctBookTypeId) {
        Map<IDataMapEntry<Long, Long>, KDGLAccountBook> result = FSAGLReportDataProvider.getGLAcctBookAndPeriodTypeCode(Collections.singletonList(new IDataMapEntry((Object)orgId, (Object)acctBookTypeId)));
        return result != null && !result.isEmpty() ? result.values().iterator().next() : null;
    }

    public static Map<IDataMapEntry<Long, Long>, KDGLAccountBook> getGLAcctBookAndPeriodTypeCode(Collection<IDataMapEntry<Long, Long>> filterConditions) {
        return FSAGLReportDataProvider.getKDGLAccountBookByConditions(filterConditions, x -> new QFilter("org", "=", x.getKey()).and("booksType", "=", x.getValue()));
    }

    public static Map<IDataMapEntry<Long, Long>, KDGLAccountBook> getKDGLAccountBookByConditions(Collection<IDataMapEntry<Long, Long>> filterConditions, Function<IDataMapEntry<Long, Long>, QFilter> function) {
        QFilterBuilder builder = new QFilterBuilder();
        for (IDataMapEntry<Long, Long> next : filterConditions) {
            builder.or(function.apply(next));
        }
        return FSAGLReportDataProvider.getKDGLAccountBookByConditions(builder);
    }

    public static Map<IDataMapEntry<Long, Long>, KDGLAccountBook> getKDGLAccountBookByConditions(QFilterBuilder filterBuilder) {
        DynamicObjectCollection doCol = QueryServiceHelper.query((String)"gl_accountbook", (String)selectFields, (QFilter[])filterBuilder.toArray());
        HashMap<IDataMapEntry<Long, Long>, KDGLAccountBook> returnMap = new HashMap<IDataMapEntry<Long, Long>, KDGLAccountBook>();
        if (doCol != null && !doCol.isEmpty()) {
            for (DynamicObject dyn : doCol) {
                KDGLAccountBook acctBook = new KDGLAccountBook();
                acctBook.loadFromDynamicObject(dyn);
                IDataMapEntry iDataMapEntry = new IDataMapEntry((Object)acctBook.getOrg(), (Object)acctBook.getBooksType());
                returnMap.put((IDataMapEntry<Long, Long>)iDataMapEntry, acctBook);
            }
        }
        return returnMap;
    }

    private static QFilter[] getGLCommonQFilters(Collection<Long> orgIds, Long acctBookTypeId, Long acctTableId, String singleColRptType) {
        LinkedList<QFilter> flist = new LinkedList<QFilter>();
        if (orgIds != null && !orgIds.isEmpty()) {
            flist.add(new QFilter("org", "in", orgIds));
        }
        if (acctTableId != null) {
            flist.add(new QFilter("accounttable", "=", (Object)acctTableId));
        }
        if (acctBookTypeId != null) {
            flist.add(new QFilter("booktype", "=", (Object)acctBookTypeId));
        }
        if (singleColRptType != null) {
            flist.add(new QFilter("type", "=", (Object)singleColRptType));
        }
        return flist.isEmpty() ? null : flist.toArray(new QFilter[0]);
    }

    public static Map<String, Map<String, Object>> getGLAllkpis(Collection<Long> orgIds, Long acctBookTypeId, Long acctTableId, Long periodTypeId, Long periodId, Long orgViewId, int amtPrecision) {
        return (Map)FSAGLReportDataProvider.invokeGLBizService(Map.class, (String)"FdaKpiService", (String)"getKpi", (Object[])new Object[]{orgIds, orgViewId, acctBookTypeId, acctTableId, periodTypeId, periodId, amtPrecision});
    }

    public static Map<Long, List<List<BigDecimal>>> getReportItemCalcValues(String reportTypeCode, Collection<Long> orgIds, Long orgViewId, Long acctBookTypeId, Long acctTableId, Long periodTypeId, Collection<Long> periodIds, int amtPrecision) {
        return (Map)FSAGLReportDataProvider.invokeGLBizService(null, (String)"FdaKpiService", (String)"getReportItemCalcValues", (Object[])new Object[]{reportTypeCode, orgIds, orgViewId, acctBookTypeId, acctTableId, periodTypeId, periodIds, amtPrecision});
    }

    public static Map<Long, Map<String, BigDecimal[]>> getReportItemValues(String reportTypeCode, Collection<Long> orgIds, Long orgViewId, Long acctBookTypeId, Long acctTableId, Long periodTypeId, Collection<Long> periodIds, int amtPrecision) {
        return (Map)FSAGLReportDataProvider.invokeGLBizService(null, (String)"FdaKpiService", (String)"getReportItemValues", (Object[])new Object[]{reportTypeCode, orgIds, orgViewId, acctBookTypeId, acctTableId, periodTypeId, periodIds, amtPrecision});
    }

    public static List<FSAGLBaseReportItemModel> getGLReportItems(FSAStandardReportTypeEnum reportType, List<Long> orgIds, String dataSourceType) {
        ArrayList<FSAGLBaseReportItemModel> resultList = new ArrayList<FSAGLBaseReportItemModel>();
        FSAGLReportDataProvider.queryGLReportItems(item -> resultList.add((FSAGLBaseReportItemModel)((Object)item)), reportType, orgIds, dataSourceType);
        return resultList;
    }

    public static Map<String, FSAGLBaseReportItemModel> getGLReportItemMap(FSAStandardReportTypeEnum reportType, List<Long> orgIds, String dataSourceType) {
        HashMap<String, FSAGLBaseReportItemModel> resultMap = new HashMap<String, FSAGLBaseReportItemModel>();
        FSAGLReportDataProvider.queryGLReportItems(item -> resultMap.put(item.getName(), (FSAGLBaseReportItemModel)((Object)item)), reportType, orgIds, dataSourceType);
        return resultMap;
    }

    public static void queryGLReportItems(Consumer<FSAGLBaseReportItemModel> ouputConsumer, FSAStandardReportTypeEnum reportType, List<Long> orgIds, String dataSourceType) {
        DynamicObjectCollection dyns;
        if (ouputConsumer == null) {
            return;
        }
        LinkedList<QFilter> filterList = new LinkedList<QFilter>();
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        if (reportType != null) {
            String glReportType = null;
            switch (reportType) {
                case Balance_Sheet: {
                    glReportType = "gl_balancesheet";
                    break;
                }
                case Income_Statement: {
                    glReportType = "gl_cashflowstat";
                    break;
                }
                case Cash_Flow: {
                    glReportType = "gl_taxshow";
                    break;
                }
            }
            filterList.add(new QFilter("rptunit", "=", (Object)glReportType));
        }
        if (orgIds != null && !orgIds.isEmpty()) {
            filterList.add(new QFilter("org", "in", orgIds));
        }
        if (dataSourceType != null) {
            filterList.add(new QFilter("datasource", "=", (Object)dataSourceType));
        }
        if ((dyns = QueryServiceHelper.query((String)"gl_manage_rptitem", (String)"id,number,name,org, istotalrow, datasource, rptunit", (QFilter[])filterList.toArray(new QFilter[0]))) != null && !dyns.isEmpty()) {
            for (DynamicObject dyn : dyns) {
                FSAGLBaseReportItemModel fsaglBaseReportItemModel = new FSAGLBaseReportItemModel();
                fsaglBaseReportItemModel.loadFromDynamicObject(dyn, true);
                ouputConsumer.accept(fsaglBaseReportItemModel);
            }
        }
    }
}

