/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FSAListUtil {
    public static <T, R, O> List<O> batchOperaByGroup(Collection<T> collection, int batchSize, IGroupBatchOpera<T, R, O> groupBatchOpera) {
        return FSAListUtil.batchOperaByGroup(collection, batchSize, groupBatchOpera, true);
    }

    public static <T, R, O> List<O> batchOperaByGroup(Collection<T> collection, int batchSize, IGroupBatchOpera<T, R, O> groupBatchOpera, boolean isNeedReturn) {
        int size = collection.size();
        int batch = size > batchSize ? batchSize : size;
        int group = size % batchSize == 0 ? size / batchSize : size / batchSize + 1;
        Iterator<T> iterator = collection.iterator();
        ArrayList<O> returnList = new ArrayList<O>(group);
        ArrayList<R> batchList = new ArrayList<R>(batch);
        for (int i = 0; i < group; ++i) {
            int left = size - i * batch;
            int thisGroupSize = left > batch ? batch : left;
            for (int j = 0; j < thisGroupSize; ++j) {
                batchList.add(groupBatchOpera.elementChange(iterator.next()));
            }
            O o = groupBatchOpera.groupOpera(batchList);
            batchList.clear();
            if (!isNeedReturn) continue;
            returnList.add(o);
        }
        return returnList;
    }

    @FunctionalInterface
    public static interface IGroupBatchOpera<T, R, O> {
        default public R elementChange(T t) {
            return (R)t;
        }

        public O groupOpera(List<R> var1);
    }
}

