/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.data.disf.enums.DimensionTypeEnum;
import kd.data.fsa.cacheservice.FSADataCacheMgr;
import kd.data.fsa.common.enums.FSAFieldTypeEnum;
import kd.data.fsa.olap.OlapDimensionLookupMetaInfo;

public class FSAPreviewDataHelper {
    public static Set<String> getDimensionSetFromDataCol(DynamicObject dataCollectionObj) {
        HashSet<String> dimensionNumberSet = new HashSet<String>(16);
        DynamicObjectCollection dataEntityCol = dataCollectionObj.getDynamicObjectCollection("dataentryentity");
        if (dataEntityCol != null && !dataEntityCol.isEmpty()) {
            for (DynamicObject dyObj : dataEntityCol) {
                if (!DimensionTypeEnum.DATA_DIM.getCodeString().equals(dyObj.get("dimtype")) || FSAFieldTypeEnum.CUSTOM_FIELD.getCodeString().equals(dyObj.getString("fieldcreatetype"))) continue;
                dimensionNumberSet.add(dyObj.getString("dimnumber").toLowerCase());
            }
        }
        return dimensionNumberSet;
    }

    public static Map<String, String> getDimensionSourceNumberMap(DynamicObject dataCollectionObj) {
        HashMap<String, String> dimensionSourceNumberMap = new HashMap<String, String>(16);
        DynamicObjectCollection dataEntityCol = dataCollectionObj.getDynamicObjectCollection("dataentryentity");
        if (dataEntityCol != null && !dataEntityCol.isEmpty()) {
            for (DynamicObject dyObj : dataEntityCol) {
                if (!DimensionTypeEnum.DATA_DIM.getCodeString().equals(dyObj.get("dimtype")) || FSAFieldTypeEnum.CUSTOM_FIELD.getCodeString().equals(dyObj.getString("fieldcreatetype"))) continue;
                String dimensionNumber = dyObj.getString("dimnumber").toLowerCase();
                String sourceDimensionNumber = dyObj.getString("srcnumber");
                dimensionSourceNumberMap.put(dimensionNumber, sourceDimensionNumber);
            }
        }
        return dimensionSourceNumberMap;
    }

    public static Map<String, Map<String, String>> numberMappingNameMap(Map<String, Object> viewAndModuleMap, String[] dimensionArray) {
        Map<String, OlapDimensionLookupMetaInfo.BaseDimMemLookupValueItem>[] dimMemberLookupMaps;
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(dimensionArray.length);
        OlapDimensionLookupMetaInfo odmInfo = FSADataCacheMgr.instance.getOlapDimensionLookupMetaInfo(viewAndModuleMap, dimensionArray);
        if (odmInfo != null && (dimMemberLookupMaps = odmInfo.getDimMemberLookupMaps()) != null && dimMemberLookupMaps.length == dimensionArray.length) {
            for (int i = 0; i < dimMemberLookupMaps.length; ++i) {
                String currentDimension = dimensionArray[i];
                Map membersNumberAndNameMap = resultMap.computeIfAbsent(currentDimension, k -> new HashMap(16));
                Map<String, OlapDimensionLookupMetaInfo.BaseDimMemLookupValueItem> dimMemberLookupMap = dimMemberLookupMaps[i];
                if (dimMemberLookupMap == null || dimMemberLookupMap.isEmpty()) continue;
                for (Map.Entry<String, OlapDimensionLookupMetaInfo.BaseDimMemLookupValueItem> en : dimMemberLookupMap.entrySet()) {
                    Object[][] valueArray = en.getValue().getValueArray(new Object[0]);
                    membersNumberAndNameMap.put(en.getKey(), valueArray[0][0].toString());
                }
            }
        }
        return resultMap;
    }
}

