/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.fsa.common.enums.FSARptDataMappingSrcTypeEnum;
import kd.data.fsa.common.enums.FSAStandardReportTypeEnum;
import kd.data.fsa.common.enums.FSASyncLogStatusEnum;
import kd.data.fsa.model.rpt.config.FSABaseRptModel;
import kd.data.fsa.model.rpt.config.FSAPeriod;
import kd.data.fsa.model.rpt.config.FSARptBalanceModel;
import kd.data.fsa.model.rpt.config.FSARptCashFlowModel;
import kd.data.fsa.model.rpt.config.FSARptIncomeModel;
import kd.data.fsa.model.rpt.operation.FSARptDataSynComputeResult;
import kd.data.fsa.model.rpt.operation.FSARptFactOperationParam;
import kd.data.fsa.utils.FSABusinessServiceHelper;
import kd.data.fsa.utils.FSACalculateUtils;
import kd.data.fsa.utils.FSAGLReportDataProvider;
import kd.data.fsa.utils.FSAListUtil;
import kd.data.fsa.utils.FSAPeriodUtils;
import org.apache.commons.lang3.StringUtils;

public class FSARptDataSyncHelper {
    private static final Log logger = LogFactory.getLog(FSARptDataSyncHelper.class);
    private long token;
    private boolean isNeedReturnList = false;
    DynamicObjectCollection dyc;
    private int breakPoint = 0;

    public FSARptDataSyncHelper(Long token) {
        this(false, token);
    }

    public FSARptDataSyncHelper(boolean isNeedReturnList, Long token) {
        this.isNeedReturnList = isNeedReturnList;
        this.token = token;
    }

    public static IDataMapEntry<FSASyncLogStatusEnum, String> synData(Long token, List<Long> mappingIds, List<Long> orgIds, List<Long> periodIds) {
        IDataMapEntry iDataMapEntry;
        FSARptDataSyncHelper fSARptDataSyncHelper = new FSARptDataSyncHelper(token);
        try {
            fSARptDataSyncHelper.synDatastart(mappingIds, orgIds, periodIds);
            iDataMapEntry = new IDataMapEntry((Object)FSASyncLogStatusEnum.SUCCESS, (Object)"success");
        }
        catch (Exception e) {
            logger.error("Synchronization task failed", (Throwable)e);
            fSARptDataSyncHelper.rollBack(orgIds, periodIds);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        IDataWorkTaskManager.getInstance().execute(() -> fSARptDataSyncHelper.deleteFsaData(fSARptDataSyncHelper.dyc, fSARptDataSyncHelper.token));
        return iDataMapEntry;
    }

    public static IDataMapEntry<FSASyncLogStatusEnum, String> synData(Long token, Long mappingId, Long orgId, Long periodId, FSAPeriod fsatStartPeriod, FSAPeriod fsatEndPeriod) {
        List<Long> mappingIds = Collections.singletonList(mappingId);
        List<Long> orgIds = Collections.singletonList(orgId);
        List<Long> periodIds = FSAPeriodUtils.getIdBetweenPeriods(periodId, fsatStartPeriod, fsatEndPeriod);
        return FSARptDataSyncHelper.synData(token, mappingIds, orgIds, periodIds);
    }

    private void rollBack(List<Long> orgIds, List<Long> periodIds) {
        if (this.dyc != null && this.breakPoint == 1) {
            this.saveRollBackFsaData(this.dyc, orgIds, periodIds);
            this.markDeleteRollBackFsaData(this.dyc, orgIds, periodIds);
        }
    }

    private List<DynamicObject> synDatastart(List<Long> mappingIds, List<Long> orgIds, List<Long> periodIds) {
        this.dyc = this.queryFSARptMappings(mappingIds);
        this.markDeleteFsaData(this.dyc, orgIds, periodIds);
        this.breakPoint = 1;
        Long orgViewId = 0L;
        int amtPrecision = 6;
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>(1);
        for (int i = 0; i < this.dyc.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)this.dyc.get(i);
            String reportTypeCode = FSAStandardReportTypeEnum.getGLReportTypeCode(dynamicObject.getString("mappingrpttype"));
            Long acctBookTypeId = dynamicObject.getLong("acctbooktype_id");
            Long acctTableId = dynamicObject.getLong("accounttable.id");
            Long periodTypeId = dynamicObject.getLong("acctperiodtype.id");
            Map<Long, Map<String, BigDecimal[]>> reportItemValues = FSAGLReportDataProvider.getReportItemValues(reportTypeCode, orgIds, orgViewId, acctBookTypeId, acctTableId, periodTypeId, periodIds, amtPrecision);
            List<FSARptDataSynComputeResult> fsaComputeResults = this.operaExtData(dynamicObject, reportItemValues, acctBookTypeId);
            results.addAll(this.saveInRpts(fsaComputeResults));
        }
        return results;
    }

    private List<DynamicObject> saveInRpts(List<FSARptDataSynComputeResult> fsaRptDataSynComputeResults) {
        HashMap<FSAStandardReportTypeEnum, List> collect = new HashMap<FSAStandardReportTypeEnum, List>();
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        for (int i = 0; i < fsaRptDataSynComputeResults.size(); ++i) {
            FSARptDataSynComputeResult fsaRptDataSynComputeResult = fsaRptDataSynComputeResults.get(i);
            FSAStandardReportTypeEnum entity = fsaRptDataSynComputeResult.getEntity();
            List<FSARptDataSynComputeResult> list = Collections.singletonList(fsaRptDataSynComputeResult);
            collect.merge(entity, new ArrayList<FSARptDataSynComputeResult>(list), (vold, vnew) -> {
                vold.add(fsaRptDataSynComputeResult);
                return vold;
            });
        }
        for (Map.Entry reportType : collect.entrySet()) {
            List<DynamicObject> hasIdList = this.saveInRpt((FSAStandardReportTypeEnum)((Object)reportType.getKey()), (List)reportType.getValue());
            if (!this.isNeedReturnList) continue;
            resultList.addAll(hasIdList);
        }
        return resultList;
    }

    private List<DynamicObject> saveInRpt(FSAStandardReportTypeEnum fSAStandardReportTypeEnum, List<FSARptDataSynComputeResult> fsaRptDatas) {
        final MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)fSAStandardReportTypeEnum.getEntity());
        int size = fsaRptDatas.size();
        ArrayList<DynamicObject> returnList = new ArrayList<DynamicObject>(size);
        List<Object[]> returnSaveList = FSAListUtil.batchOperaByGroup(fsaRptDatas, 5000, new FSAListUtil.IGroupBatchOpera<FSARptDataSynComputeResult, DynamicObject, Object[]>(){

            @Override
            public DynamicObject elementChange(FSARptDataSynComputeResult result) {
                return FSARptDataSyncHelper.this.createDynamicObject(result, dataEntityType);
            }

            @Override
            public Object[] groupOpera(List<DynamicObject> list) {
                return BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])list.toArray());
            }
        }, this.isNeedReturnList);
        for (Object[] objects : returnSaveList) {
            for (Object o : objects) {
                returnList.add((DynamicObject)o);
            }
        }
        if (!this.isNeedReturnList) {
            return null;
        }
        return returnList;
    }

    private DynamicObject createDynamicObject(FSARptDataSynComputeResult fsResult, MainEntityType dataEntityType) {
        FSABaseRptModel rptModel = null;
        Long orgId = fsResult.getOrgId();
        Long periodId = fsResult.getPeriodId();
        Long srcItemId = fsResult.getSrcItemId();
        Long acctBookTypeId = fsResult.getAcctBookTypeId();
        FSARptDataMappingSrcTypeEnum mappingSrcType = fsResult.getMappingSrcType();
        BigDecimal[] bigDecimals = fsResult.getBigDecimals();
        BigDecimal beginOrCurValue = null;
        BigDecimal endOrYearValue = null;
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                beginOrCurValue = bigDecimals[i];
                continue;
            }
            endOrYearValue = bigDecimals[i];
        }
        switch (fsResult.getEntity()) {
            case Balance_Sheet: {
                rptModel = new FSARptBalanceModel(orgId, periodId, srcItemId, mappingSrcType, beginOrCurValue, endOrYearValue, acctBookTypeId);
                break;
            }
            case Cash_Flow: {
                rptModel = new FSARptCashFlowModel(orgId, periodId, srcItemId, mappingSrcType, beginOrCurValue, endOrYearValue, acctBookTypeId);
                break;
            }
            case Income_Statement: {
                rptModel = new FSARptIncomeModel(orgId, periodId, srcItemId, mappingSrcType, beginOrCurValue, endOrYearValue, acctBookTypeId);
                break;
            }
            default: {
                throw new KDBizException(new ErrorCode("", "There is no corresponding enumeration type"), new Object[0]);
            }
        }
        return rptModel.writeValueIntoDynamicObject(new DynamicObject((DynamicObjectType)dataEntityType));
    }

    private DynamicObjectCollection queryFSARptMappings(List<Long> ids) {
        String entity = "fsa_rptmappings";
        QFilter qFilter = new QFilter("id", "in", ids);
        String select = "id,number,acctorg,acctbooktype,srcstdrpt,mappingsrctype,status,mappingrpttype,acctperiodtype.id,accounttable.id,fsa_rptmappingent,fsa_rptmappingent.srcrptitem,fsa_rptmappingent.calcformular";
        return QueryServiceHelper.query((String)entity, (String)select, (QFilter[])new QFilter[]{qFilter});
    }

    private void markDeleteFsaData(DynamicObjectCollection doc, List<Long> orgIds, List<Long> periodIds) {
        this.OperaOrRollBackFsaData(doc, orgIds, periodIds, (x, y) -> x.markDeleteReportFacts((FSARptFactOperationParam)y, this.token));
    }

    private void deleteFsaData(DynamicObjectCollection doc, long token) {
        this.OperaOrRollBackFsaData(doc, null, null, (x, y) -> x.deleteReportFacts(y.getEntityType(), token));
    }

    private void markDeleteRollBackFsaData(DynamicObjectCollection doc, List<Long> orgIds, List<Long> periodIds) {
        this.OperaOrRollBackFsaData(doc, orgIds, periodIds, (x, y) -> x.markDeleteRollbackReportFacts((FSARptFactOperationParam)y, this.token));
    }

    private void saveRollBackFsaData(DynamicObjectCollection doc, List<Long> orgIds, List<Long> periodIds) {
        this.OperaOrRollBackFsaData(doc, orgIds, periodIds, (x, y) -> x.saveRollBackReportFacts((FSARptFactOperationParam)y));
    }

    private void OperaOrRollBackFsaData(DynamicObjectCollection doc, List<Long> orgIds, List<Long> periodIds, BiFunction<FSABusinessServiceHelper, FSARptFactOperationParam, Integer> biFunction) {
        Set<String> mappingRptTypeSet = this.getParamByMapping(doc, mapping -> this.getStdrptsByMapping((DynamicObject)mapping));
        Set<Long> acctBookTypeIds = this.getParamByMapping(doc, mapping -> mapping.getLong("acctbooktype.id"));
        for (String rptType : mappingRptTypeSet) {
            String entity = FSAStandardReportTypeEnum.getEntity(rptType);
            if (!StringUtils.isNotEmpty((CharSequence)entity)) continue;
            FSABusinessServiceHelper fsaBusinessServiceHelper = new FSABusinessServiceHelper();
            FSARptFactOperationParam parma = new FSARptFactOperationParam(FSAStandardReportTypeEnum.getEnum(rptType), entity, orgIds, periodIds, null, acctBookTypeIds);
            Integer count = biFunction.apply(fsaBusinessServiceHelper, parma);
            logger.debug("opera count=" + count);
        }
    }

    private String getStdrptsByMapping(DynamicObject mapping) {
        Object srcstdrpt = mapping.get("srcstdrpt");
        String rpttype = null;
        if (srcstdrpt != null) {
            DynamicObject dynamicObject = (DynamicObject)srcstdrpt;
            rpttype = dynamicObject.getString("rpttype");
        }
        return rpttype;
    }

    private <R> Set<R> getParamByMapping(DynamicObjectCollection mappings, Function<DynamicObject, R> function) {
        int i;
        HashSet<R> returnSet = new HashSet<R>(mappings.size());
        DynamicObject mapping = null;
        for (i = 0; i < 1; ++i) {
            mapping = (DynamicObject)mappings.get(i);
        }
        for (i = 0; i < mappings.size(); ++i) {
            returnSet.add(function.apply(mapping));
        }
        return returnSet;
    }

    private List<FSARptDataSynComputeResult> operaExtData(DynamicObject mapping, Map<Long, Map<String, BigDecimal[]>> map, Long acctBookTypeId) {
        Long orgId = mapping.getLong("acctorg_id");
        FSARptDataMappingSrcTypeEnum mappingSrcType = FSARptDataMappingSrcTypeEnum.getEnum(mapping.getString("mappingsrctype"));
        String rpttype = this.getStdrptsByMapping(mapping);
        DynamicObjectCollection mappingEntries = mapping.getDynamicObjectCollection("fsa_rptmappingent");
        ArrayList<FSARptDataSynComputeResult> returnList = new ArrayList<FSARptDataSynComputeResult>();
        for (Map.Entry<Long, Map<String, BigDecimal[]>> entry : map.entrySet()) {
            Long periodId = entry.getKey();
            Map<String, BigDecimal[]> codeValues = entry.getValue();
            FSACalculateUtils fsaCalculateUtils = new FSACalculateUtils(codeValues, 2);
            HashMap<String, Long> rptnumberIdMap = new HashMap<String, Long>((int)((float)mappingEntries.size() / 0.75f) + 1);
            HashMap<String, String> calculaters = new HashMap<String, String>((int)((float)mappingEntries.size() / 0.75f) + 1);
            for (int index = 0; index < mappingEntries.size(); ++index) {
                DynamicObject mappingEntrie = (DynamicObject)mappingEntries.get(index);
                DynamicObject srcrptitem = mappingEntrie.getDynamicObject("srcrptitem");
                Long srcRptItemId = srcrptitem.getLong("id");
                String srcRptItemNumber = srcrptitem.getString("number");
                rptnumberIdMap.put(srcRptItemNumber, srcRptItemId);
                String calcformular = mappingEntrie.getString("calcformular");
                if (StringUtils.isEmpty((CharSequence)calcformular)) continue;
                calculaters.put(srcRptItemNumber, calcformular);
            }
            List calculateResult = fsaCalculateUtils.calculate(calculaters);
            for (IDataMapEntry tuple2 : calculateResult) {
                List value = (List)tuple2.getValue();
                String number = (String)tuple2.getKey();
                BigDecimal[] bigDecimals = value.toArray(new BigDecimal[value.size()]);
                if (bigDecimals == null) continue;
                FSARptDataSynComputeResult fsaRptComputeResult = new FSARptDataSynComputeResult(rpttype, orgId, periodId, (Long)rptnumberIdMap.get(number), bigDecimals, mappingSrcType, acctBookTypeId);
                returnList.add(fsaRptComputeResult);
            }
        }
        return returnList;
    }
}

