/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.utils.IDataDateUtil;
import kd.data.fsa.common.enums.FSASyncLogStatusEnum;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;

public class FSASyncTaskLogHelper {
    public static DynamicObject createSyncLog(IWorkTaskTransLog<Long> transLog) {
        if (transLog instanceof FSAWorkTaskMeta) {
            FSAWorkTaskMeta meta = (FSAWorkTaskMeta)transLog;
            DynamicObject syncLog = BusinessDataServiceHelper.newDynamicObject((String)"fsa_rptdata_synclog");
            syncLog.set("status", (Object)FSASyncLogStatusEnum.NEW.getCodeString());
            syncLog.set("datasynctask", (Object)meta.getTaskId());
            syncLog.set("datasyncparam_id", (Object)meta.getSyncParamId());
            QFilter syncParamIdFilter = new QFilter("id", "=", (Object)meta.getSyncParamId());
            DynamicObject syncParam = QueryServiceHelper.queryOne((String)"fsa_syncparam", (String)"datacollection,datasrctype", (QFilter[])syncParamIdFilter.toArray());
            if (syncParam != null) {
                syncLog.set("datasrctype", (Object)syncParam.getString("datasrctype"));
                syncLog.set("datacollection_id", (Object)syncParam.getLong("datacollection"));
            }
            syncLog.set("tasktype", (Object)String.valueOf(meta.getTaskType().getValue()));
            syncLog.set("paramdetail_tag", (Object)meta.getParamDetail());
            syncLog.set("createtime", (Object)new Date());
            OperationServiceImpl operationService = new OperationServiceImpl();
            OperationResult saveSyncLogResult = operationService.localInvokeOperation("save", new DynamicObject[]{syncLog}, OperateOption.create());
            if (saveSyncLogResult.isSuccess()) {
                Long logId = Long.parseLong(saveSyncLogResult.getSuccessPkIds().get(0).toString());
                syncLog.set("id", (Object)logId);
                if (syncParam != null && String.valueOf(FSAWorkTaskTypeEnum.BCM_OLAP_GROUP_Data_Sync_Task.getValue()).equals(syncParam.getString("datasrctype"))) {
                    meta.setTransLogId(syncLog.getLong("id"));
                }
                return syncLog;
            }
        }
        return null;
    }

    public static void updateTaskStatus(Long taskId, String status) {
        String originStatus;
        DynamicObject taskDbj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"fsa_rptdata_synctask");
        if (taskDbj != null && !status.equals(originStatus = taskDbj.getString("status"))) {
            taskDbj.set("status", (Object)status);
            taskDbj.set("updatetime", (Object)new Date());
            SaveServiceHelper.update((DynamicObject)taskDbj);
        }
    }

    public static void calExecutionTime(Long taskId) {
        DynamicObject taskDbj;
        if (taskId > 0L && (taskDbj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"fsa_rptdata_synctask")) != null) {
            QFilter idFilter = new QFilter("datasynctask", "=", (Object)taskId);
            DynamicObjectCollection beginTimeCols = QueryServiceHelper.query((String)"fsa_rptdata_synclog", (String)"createtime", (QFilter[])idFilter.toArray(), (String)"createtime");
            DynamicObjectCollection endTimeCol = QueryServiceHelper.query((String)"fsa_rptdata_synclog", (String)"updatetime", (QFilter[])idFilter.toArray(), (String)"updatetime desc");
            if (!CollectionUtils.isEmpty((Collection)beginTimeCols) && !CollectionUtils.isEmpty((Collection)endTimeCol)) {
                Date beginCreateTime = ((DynamicObject)beginTimeCols.get(0)).getDate("createtime");
                Date endUpdateTime = ((DynamicObject)endTimeCol.get(0)).getDate("updatetime");
                String executionTime = IDataDateUtil.getTimeDiff((Date)endUpdateTime, (Date)beginCreateTime);
                taskDbj.set("executiontime", (Object)executionTime);
                SaveServiceHelper.update((DynamicObject)taskDbj);
            }
        }
    }

    public static Long createSyncTask(Long srcParamId, String version, FSAWorkTaskTypeEnum taskType) {
        DynamicObject syncTask = BusinessDataServiceHelper.newDynamicObject((String)"fsa_rptdata_synctask");
        syncTask.set("rptdatasyncparam", (Object)srcParamId);
        syncTask.set("creator", (Object)RequestContext.get().getCurrUserId());
        syncTask.set("createtime", (Object)new Date());
        syncTask.set("status", (Object)"0");
        syncTask.set("version", (Object)version);
        syncTask.set("tasktype", (Object)String.valueOf(taskType.getValue()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncTask});
        return (Long)syncTask.getPkValue();
    }
}

