/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.fsa.common.enums.FSASyncLogStatusEnum;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskFactory;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.utils.FSASyncTaskLogHelper;

public class FSATableUtil {
    private static final Log logger = LogFactory.getLog(FSATableUtil.class);

    public static boolean createOrDropTable(Long dataSyncParamId, FSAWorkTaskTypeEnum tableEnum, String tableNumber, String tableName, boolean reCreate) {
        boolean dropTableResult;
        if (tableEnum != FSAWorkTaskTypeEnum.Create_Table_Task && tableEnum != FSAWorkTaskTypeEnum.Drop_Table_Task || dataSyncParamId == null || dataSyncParamId == 0L || StringUtils.isBlank((CharSequence)tableNumber)) {
            return false;
        }
        tableNumber = tableNumber.toLowerCase();
        if (reCreate && !(dropTableResult = FSATableUtil.createOrDropTable(dataSyncParamId, FSAWorkTaskTypeEnum.Drop_Table_Task, tableNumber, tableName, false))) {
            return false;
        }
        Long taskId = FSASyncTaskLogHelper.createSyncTask(dataSyncParamId, null, tableEnum);
        if (taskId == null) {
            return false;
        }
        FSAWorkTaskMeta taskMeta = new FSAWorkTaskMeta(dataSyncParamId.toString(), taskId, dataSyncParamId, tableEnum, true, tableNumber, tableName);
        try {
            IDataAbstractWorkTask workTask = FSAWorkTaskFactory.createFSAWorkTask(tableEnum.getValue(), taskMeta, true);
            IDataMapEntry result = (IDataMapEntry)workTask.call();
            return result != null && result.getKey() == FSASyncLogStatusEnum.SUCCESS;
        }
        catch (Exception e) {
            logger.error(tableEnum == FSAWorkTaskTypeEnum.Create_Table_Task ? "\u521b\u5efa" : "\u5220\u9664\u8868\u7684\u540c\u6b65\u4efb\u52a1\u63d0\u4ea4\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }
}

