/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.DistinctSelectCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.fsa.engine.task.FSAOlapDataStatisticsTask;
import kd.data.fsa.olap.FSAOlapDataStatisticsInfo;
import kd.data.fsa.olap.OlapConnectionInformation;
import kd.data.fsa.olap.OlapSQLBuilder;
import kd.data.fsa.utils.FSABcmDataProvider;

public class KdOlapServerHelper {
    private static final Log logger = LogFactory.getLog(KdOlapServerHelper.class);

    private KdOlapServerHelper() {
    }

    public static OlapConnection getOlapConnection(String cubeCatelog) {
        OlapConnectionInformation connectInfo = FSABcmDataProvider.getOlapConnectionInformation(cubeCatelog);
        OlapConnection conn = new OlapConnection(connectInfo.getConnectSerial());
        conn.setUserName(connectInfo.getUsername());
        conn.setPassword(connectInfo.getPassword());
        return conn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T consumOlapServerConnection(String cubeCatelog, Function<OlapConnection, T> olapConnectionConsumer) {
        OlapConnection t;
        if (olapConnectionConsumer == null) {
            throw new KDBizException("\u65e0\u6548\u7684OLAP\u6570\u636e\u8fde\u63a5\u5904\u7406\u5668");
        }
        OlapConnection olapConnection = null;
        try {
            olapConnection = KdOlapServerHelper.getOlapConnection(cubeCatelog);
            olapConnection.Open();
            t = olapConnectionConsumer.apply(olapConnection);
            if (olapConnection == null) return (T)t;
        }
        catch (Exception ex) {
            try {
                throw new KDBizException((Throwable)ex, new ErrorCode("", String.format("\u4f7f\u7528OLAP\u6570\u636e\u8fde\u63a5\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%s, CubeCatelog=%s", ex.getMessage(), cubeCatelog)), new Object[0]);
            }
            catch (Throwable throwable) {
                if (olapConnection == null) throw throwable;
                try {
                    olapConnection.Close();
                    throw throwable;
                }
                catch (Exception ex2) {
                    logger.error(String.format("Close OLAP Server[%s] Error: %s", cubeCatelog, ex2.getMessage()), (Throwable)ex2);
                }
                throw throwable;
            }
        }
        try {
            olapConnection.Close();
            return (T)t;
        }
        catch (Exception ex) {
            logger.error(String.format("Close OLAP Server[%s] Error: %s", cubeCatelog, ex.getMessage()), (Throwable)ex);
        }
        return (T)t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FSAOlapDataStatisticsInfo consumOlapServerConnectionOlapStatistics(String cubeCatelog, Function<OlapConnection, FSAOlapDataStatisticsInfo> olapConnectionConsumer) {
        FSAOlapDataStatisticsInfo fSAOlapDataStatisticsInfo;
        if (olapConnectionConsumer == null) {
            throw new KDBizException("\u65e0\u6548\u7684OLAP\u6570\u636e\u8fde\u63a5\u5904\u7406\u5668");
        }
        OlapConnection olapConnection = null;
        try {
            olapConnection = KdOlapServerHelper.getOlapConnection(cubeCatelog);
            olapConnection.Open();
            fSAOlapDataStatisticsInfo = olapConnectionConsumer.apply(olapConnection);
            if (olapConnection == null) return fSAOlapDataStatisticsInfo;
        }
        catch (Exception ex) {
            try {
                throw new KDBizException((Throwable)ex, new ErrorCode("", String.format("\u4f7f\u7528OLAP\u6570\u636e\u8fde\u63a5\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%s, CubeCatelog=%s", ex.getMessage(), cubeCatelog)), new Object[0]);
            }
            catch (Throwable throwable) {
                if (olapConnection == null) throw throwable;
                try {
                    olapConnection.Close();
                    throw throwable;
                }
                catch (Exception ex2) {
                    logger.error(String.format("Close OLAP Server[%s] Error: %s", cubeCatelog, ex2.getMessage()), (Throwable)ex2);
                }
                throw throwable;
            }
        }
        try {
            olapConnection.Close();
            return fSAOlapDataStatisticsInfo;
        }
        catch (Exception ex) {
            logger.error(String.format("Close OLAP Server[%s] Error: %s", cubeCatelog, ex.getMessage()), (Throwable)ex);
        }
        return fSAOlapDataStatisticsInfo;
    }

    public static long queryDataToReader(OlapSQLBuilder sqlBuilder, MainEntityType outputDynEntity, BiFunction<SelectCommandInfo, OlapDataReader, Long> dataConsumer) {
        if (dataConsumer == null) {
            throw new KDBizException("\u65e0\u6548\u7684OLAP\u6570\u636e\u5904\u7406\u5668");
        }
        if (sqlBuilder == null || !sqlBuilder.validate()) {
            throw new KDBizException("\u65e0\u6548\u7684OLAP \u67e5\u8be2\u4fe1\u606f\uff1a" + (sqlBuilder != null ? sqlBuilder.toString() : null));
        }
        return KdOlapServerHelper.consumOlapServerConnection(sqlBuilder.getCubeCatalog(), olapConnection -> (Long)KdOlapServerHelper.queryOlapDataToReader(olapConnection, sqlBuilder.buildSelectCommandInfo(), dataConsumer));
    }

    public static <T> T queryOlapDataToReader(OlapConnection olapConnection, SelectCommandInfo queryInfo, BiFunction<SelectCommandInfo, OlapDataReader, T> dataConsumer) {
        try {
            OlapDataReader dataReader = new OlapCommand(olapConnection, (CommandInfo)queryInfo).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
            return dataConsumer.apply(queryInfo, dataReader);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", String.format("OLAP \u67e5\u8be2\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%s, SelectCommandInfo=%s", ex.getMessage(), queryInfo)), new Object[0]);
        }
    }

    public static FSAOlapDataStatisticsInfo queryOlapDataToReaderOlapStatistics(OlapConnection olapConnection, SelectCommandInfo queryInfo, BiFunction<SelectCommandInfo, OlapDataReader, FSAOlapDataStatisticsInfo> dataConsumer) {
        try {
            OlapDataReader dataReader = new OlapCommand(olapConnection, (CommandInfo)queryInfo).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
            return dataConsumer.apply(queryInfo, dataReader);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", String.format("OLAP \u67e5\u8be2\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%s, SelectCommandInfo=%s", ex.getMessage(), queryInfo)), new Object[0]);
        }
    }

    public static Long queryOlapDataDistinctDimFilter(List<String> dimList, Map<String, Set<String>> dimFilterMap, OlapSQLBuilder sqlBuilder) {
        return KdOlapServerHelper.consumOlapServerConnection(sqlBuilder.getCubeCatalog(), olapConnection -> KdOlapServerHelper.queryOlapDataToReader(olapConnection, (SelectCommandInfo)sqlBuilder.buildDitinctSelectCommandInfo(dimList, dimFilterMap), (selectCommandInfo, dataReader) -> {
            Long recCnt = 0L;
            Object[] rowBuffer = new Object[dimList.size()];
            while (dataReader.next()) {
                dataReader.getValues(rowBuffer);
                Long l = recCnt;
                Long l2 = recCnt = Long.valueOf(recCnt + 1L);
            }
            return recCnt;
        }));
    }

    public static boolean isDimMemberExisted(String cubeCatelog, String dimNumber, String ... dimMembers) {
        try {
            DistinctSelectCommandInfo queryInfo = new DistinctSelectCommandInfo();
            queryInfo.addDims(new String[]{dimNumber});
            if (dimMembers != null && dimMembers.length > 0) {
                queryInfo.addFilter(dimNumber, dimMembers);
            }
            KdOlapServerHelper.consumOlapServerConnection(cubeCatelog, olapConnection -> KdOlapServerHelper.queryOlapDataToReader(olapConnection, (SelectCommandInfo)queryInfo, (selectCommandInfo, dataReader) -> {
                dataReader.next();
                return 0L;
            }));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Long statisticsTotalCount(String cubeCatelog, String dimNumber, Map<String, Set<String>> dimFilterMap) {
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(new String[]{dimNumber});
        if (dimFilterMap != null && dimFilterMap.size() > 0) {
            for (Map.Entry<String, Set<String>> filterEntry : dimFilterMap.entrySet()) {
                queryInfo.addFilter(filterEntry.getKey(), filterEntry.getValue().toArray(new String[0]));
            }
        }
        return KdOlapServerHelper.consumOlapServerConnection(cubeCatelog, olapConnection -> KdOlapServerHelper.queryOlapDataToReader(olapConnection, queryInfo, (selectCommandInfo, dataReader) -> {
            Long recCnt = 0L;
            Object[] rowBuffer = new Object[1];
            while (dataReader.next()) {
                dataReader.getValues(rowBuffer);
                Long l = recCnt;
                Long l2 = recCnt = Long.valueOf(recCnt + 1L);
            }
            return recCnt;
        }));
    }

    public static FSAOlapDataStatisticsInfo queryDimMemComboStatistics(String cubeCatelog, String mainDimNumber, String splitDimNumber, Map<String, Set<String>> queryDimFilters, boolean ignoreMeasureNull, boolean superLongData) {
        FSAOlapDataStatisticsTask statisticsTask;
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(new String[]{mainDimNumber});
        queryInfo.addMeasures(new String[]{"FMONEY"});
        IDataMapEntry mainDim = new IDataMapEntry((Object)mainDimNumber, (Object)1);
        if (splitDimNumber != null) {
            queryInfo.addDims(new String[]{splitDimNumber});
            IDataMapEntry splitDim = new IDataMapEntry((Object)splitDimNumber, (Object)2);
            statisticsTask = new FSAOlapDataStatisticsTask(ignoreMeasureNull, new IDataMapEntry[]{mainDim, splitDim});
        } else {
            statisticsTask = new FSAOlapDataStatisticsTask(ignoreMeasureNull, new IDataMapEntry[]{mainDim});
        }
        for (Map.Entry<String, Set<String>> filterEntry : queryDimFilters.entrySet()) {
            queryInfo.addFilter(filterEntry.getKey(), filterEntry.getValue().toArray(new String[0]));
        }
        return KdOlapServerHelper.consumOlapServerConnectionOlapStatistics(cubeCatelog, olapConnection -> KdOlapServerHelper.queryOlapDataToReaderOlapStatistics(olapConnection, queryInfo, (selectCommandInfo, dataReader) -> statisticsTask.processOlapQueryReader((SelectCommandInfo)selectCommandInfo, (OlapDataReader)dataReader)));
    }

    public static List<SelectCommandInfo> generateSelectCommandInfos(OlapSQLBuilder olapSQLBuilder, Map<String, Integer> splitDimMembers, String splitDimNumber, Integer limitAmount) {
        ArrayList<SelectCommandInfo> resultList = new ArrayList<SelectCommandInfo>();
        int splitDimMembersCount = 0;
        HashSet<String> splitDimMemberSet = new HashSet<String>(10);
        for (Map.Entry<String, Integer> next : splitDimMembers.entrySet()) {
            if ((splitDimMembersCount += next.getValue().intValue()) > limitAmount) {
                if (splitDimMemberSet.size() > 0) {
                    SelectCommandInfo queryInfo = olapSQLBuilder.buildSelectCommandInfo();
                    queryInfo.addFilter(splitDimNumber, splitDimMemberSet.toArray(new String[0]));
                    resultList.add(queryInfo);
                }
                splitDimMemberSet.clear();
                splitDimMemberSet.add(next.getKey());
                splitDimMembersCount = next.getValue();
                continue;
            }
            splitDimMemberSet.add(next.getKey());
        }
        if (!splitDimMemberSet.isEmpty()) {
            SelectCommandInfo queryInfo = olapSQLBuilder.buildSelectCommandInfo();
            queryInfo.addFilter(splitDimNumber, splitDimMemberSet.toArray(new String[0]));
            resultList.add(queryInfo);
        }
        return resultList;
    }

    public static List<String> queryDimMember(String cubeCatelog, String dimNumber, Map<String, Set<String>> queryDimFilters) {
        DistinctSelectCommandInfo queryInfo = new DistinctSelectCommandInfo();
        queryInfo.addDims(new String[]{dimNumber});
        if (queryDimFilters != null) {
            for (Map.Entry<String, Set<String>> filterEntry : queryDimFilters.entrySet()) {
                queryInfo.addFilter(filterEntry.getKey(), filterEntry.getValue().toArray(new String[0]));
            }
        }
        return KdOlapServerHelper.consumOlapServerConnection(cubeCatelog, olapConnection -> KdOlapServerHelper.queryOlapDataToReader(olapConnection, (SelectCommandInfo)queryInfo, (selectCommandInfo, dataReader) -> {
            LinkedList<String> dimMembers = new LinkedList<String>();
            Object[] rowBuffer = new Object[1];
            while (dataReader.next()) {
                dataReader.getValues(rowBuffer);
                dimMembers.add(rowBuffer[0].toString());
            }
            return dimMembers;
        }));
    }

    public static Set<String> getValidDimMemberSet(String cubeCatelog, String dimNumber, String[] memeberValBuf) {
        if (memeberValBuf == null) {
            return null;
        }
        HashSet<String> dimMemberSet = new HashSet<String>(Arrays.asList(memeberValBuf));
        if (!KdOlapServerHelper.isDimMemberExisted(cubeCatelog, dimNumber, memeberValBuf)) {
            List<String> olapDimMembers = KdOlapServerHelper.queryDimMember(cubeCatelog, dimNumber, null);
            dimMemberSet.retainAll(olapDimMembers);
        }
        return dimMemberSet;
    }
}

