/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils.schedule;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.ScheduleMsgInfo;
import kd.bos.schedule.api.ShardingParam;
import kd.bos.schedule.dao.dbImpl.DbJobOperation;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.fsa.utils.FSAJSONUtils;
import kd.data.fsa.utils.schedule.FSAScheduleRepeatUtil;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class FSAScheduleHelper {
    private static final Log logger = LogFactory.getLog(FSAScheduleHelper.class);
    private static final int[] cronDateArr = new int[]{13, 12, 11, 5, 2, 7, 1};
    private static final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FSA);

    public static DynamicObject loadScheduleSingle(String id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"sch_schedule");
    }

    public static String saveOrUpdate(DynamicObject dyo) {
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperationResult saveSyncLogResult = operationService.localInvokeOperation("save", new DynamicObject[]{dyo}, OperateOption.create());
        return saveSyncLogResult.getSuccessPkIds().get(0).toString();
    }

    public static void setScheduleAndJobStatus(List<String> idList, String status) {
        Map scheduleMap = BusinessDataServiceHelper.loadFromCache((Object[])idList.toArray(), (String)"sch_schedule");
        if (scheduleMap != null && !scheduleMap.isEmpty()) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            ArrayList<String> jobIdList = new ArrayList<String>(idList.size());
            Collection schedules = scheduleMap.values();
            for (DynamicObject dyo : schedules) {
                dyo.set("status", (Object)status);
                jobIdList.add(dyo.getString("job_id"));
                if ("1".equals(status)) {
                    scheduleManager.enableSchedule(dyo.getString("id"));
                    continue;
                }
                scheduleManager.disableSchedule(dyo.getString("id"));
            }
            SaveServiceHelper.update((DynamicObject[])schedules.toArray(new DynamicObject[0]));
            Map jobMap = BusinessDataServiceHelper.loadFromCache((Object[])jobIdList.toArray(), (String)"sch_job");
            if (jobMap != null && !jobMap.isEmpty()) {
                Collection jobs = jobMap.values();
                for (DynamicObject dyo : jobs) {
                    dyo.set("status", (Object)status);
                    if ("1".equals(status)) {
                        scheduleManager.enableJob(dyo.getString("id"));
                        continue;
                    }
                    scheduleManager.disableJob(dyo.getString("id"));
                }
                SaveServiceHelper.update((DynamicObject[])jobs.toArray(new DynamicObject[0]));
            }
        }
    }

    public static void deleteScheduleAndJob(List<String> idList) {
        Map scheduleMap = BusinessDataServiceHelper.loadFromCache((Object[])idList.toArray(), (String)"sch_schedule");
        QFilter filter = new QFilter("id", "in", idList);
        DeleteServiceHelper.delete((String)"sch_schedule", (QFilter[])filter.toArray());
        if (scheduleMap != null && !scheduleMap.isEmpty()) {
            ArrayList<String> jobIdList = new ArrayList<String>(idList.size());
            Collection schedules = scheduleMap.values();
            for (DynamicObject dyo : schedules) {
                jobIdList.add(dyo.getString("job_id"));
            }
            filter = new QFilter("id", "in", jobIdList);
            DeleteServiceHelper.delete((String)"sch_job", (QFilter[])filter.toArray());
        }
    }

    public static String executeSchedule(IFormView view, String id) {
        DynamicObject scheduleDyo = FSAScheduleHelper.loadScheduleSingle(id);
        if (scheduleDyo == null) {
            return "false";
        }
        DynamicObjectCollection entryCol = scheduleDyo.getDynamicObjectCollection("entryentity");
        if (entryCol == null || entryCol.isEmpty()) {
            return "false";
        }
        ScheduleMsgInfo scheduleMsgInfo = FSAScheduleHelper.buildScheduleMsgInfo(scheduleDyo);
        StringBuilder errMsgBuilder = new StringBuilder();
        for (DynamicObject dynamicObject : entryCol) {
            DynamicObject job = dynamicObject.getDynamicObject("jobnumber");
            if (job == null) continue;
            String jobId = (String)job.getPkValue();
            JobInfo jobInfo = ScheduleService.getInstance().getObjectFactory().getJobDao().get(jobId);
            if (!jobInfo.isEnable()) {
                errMsgBuilder.append(String.format(ResManager.loadKDString((String)"%s\u8c03\u5ea6\u4f5c\u4e1a,\u672a\u542f\u7528\u3002\r\n", (String)"FSAScheduleHelper_0", (String)"data-fsa-core", (Object[])new Object[0]), jobInfo.getName()));
            }
            jobInfo.setScheduleId(id);
            jobInfo.setScheduleMsgInfo(scheduleMsgInfo);
            FSAScheduleHelper.dispatchJob(jobInfo);
        }
        if (errMsgBuilder.length() > 0) {
            FormShowParameter showParameter = new FormShowParameter();
            String errMsg = errMsgBuilder.toString();
            showParameter.setCustomParam("errMsg", (Object)errMsg);
            showParameter.setFormId("sch_scheduletip_details");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(showParameter);
        } else {
            errMsgBuilder.append("true");
            view.showMessage(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u5df2\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u8fd0\u884c\u65e5\u5fd7\u5217\u8868\u3002", (String)"FSAScheduleHelper_1", (String)"data-fsa-core", (Object[])new Object[0]));
            cache.put(id, (Object)"true");
        }
        return errMsgBuilder.toString();
    }

    public static Map<String, Object> scheduleCron(String repeatMode, Date startTime, int cycleNum, int[] hour, int[] weekday, int[] day, boolean weekFlag, String th, String noWeek, int[] month, String dayOrWeek, String cronStr) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        if (StringUtils.isEmpty((String)repeatMode)) {
            resultMap.put("txtdesc", ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u91cd\u590d", (String)"FSAScheduleHelper_5", (String)"data-fsa-core", (Object[])new Object[0]));
            return resultMap;
        }
        CronStruct cron = new CronStruct();
        Calendar crStartTime = FSAScheduleHelper.getStartTime(startTime);
        cron.setSeconds("0");
        cron.setMinutes(String.valueOf(crStartTime.get(12)));
        cron.setHours(String.valueOf(crStartTime.get(11)));
        cron.setDayOfMonth(String.valueOf(crStartTime.get(5)));
        cron.setMonth(String.valueOf(crStartTime.get(2) + 1));
        cron.setDayOfWeek("?");
        cron.setYear(String.valueOf(crStartTime.get(1)));
        cron.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e", (String)"FSAScheduleHelper_2", (String)"data-fsa-core", (Object[])new Object[0]));
        String startTimeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(crStartTime.getTime());
        cron.getDescBuf().append(startTimeStr).append(ResManager.loadKDString((String)"\u8d77\uff0c\r\n", (String)"FSAScheduleHelper_3", (String)"data-fsa-core", (Object[])new Object[0]));
        switch (repeatMode) {
            case "n": {
                resultMap.put("txtdesc", ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u91cd\u590d", (String)"FSAScheduleHelper_5", (String)"data-fsa-core", (Object[])new Object[0]));
                return resultMap;
            }
            case "mi": {
                FSAScheduleRepeatUtil.repeatByHour(cron, repeatMode, hour);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"FSAScheduleHelper_6", (String)"data-fsa-core", (Object[])new Object[0])).append(cycleNum).append(ResManager.loadKDString((String)"\u5206\u949f\u91cd\u590d\u3002", (String)"FSAScheduleHelper_7", (String)"data-fsa-core", (Object[])new Object[0]));
                if (cycleNum > 1) {
                    cron.setMinutes("0/" + cycleNum);
                } else {
                    cron.setMinutes("*");
                }
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "h": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"FSAScheduleHelper_6", (String)"data-fsa-core", (Object[])new Object[0])).append(cycleNum).append(ResManager.loadKDString((String)"\u5c0f\u65f6\u91cd\u590d\u3002", (String)"FSAScheduleHelper_8", (String)"data-fsa-core", (Object[])new Object[0]));
                if (cycleNum > 1) {
                    cycleNum = Math.min(cycleNum, 23);
                    cron.setHours("0/" + cycleNum);
                } else {
                    cron.setHours("*");
                }
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "d": {
                if (cycleNum > 1) {
                    cycleNum = Math.min(cycleNum, 31);
                    String dayStr = String.valueOf(crStartTime.get(5));
                    cron.setDayOfMonth(dayStr + "/" + cycleNum);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf\u6708", (String)"FSAScheduleHelper_9", (String)"data-fsa-core", (Object[])new Object[0])).append(dayStr).append(ResManager.loadKDString((String)"\u65e5", (String)"FSAScheduleHelper_11", (String)"data-fsa-core", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5f00\u59cb", (String)"FSAScheduleHelper_10", (String)"data-fsa-core", (Object[])new Object[0]));
                } else {
                    cron.setDayOfMonth("*");
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"FSAScheduleHelper_6", (String)"data-fsa-core", (Object[])new Object[0])).append(cycleNum).append(ResManager.loadKDString((String)"\u5929", (String)"FSAScheduleHelper_12", (String)"data-fsa-core", (Object[])new Object[0]));
                FSAScheduleRepeatUtil.repeatByHour(cron, repeatMode, hour);
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"FSAScheduleHelper_13", (String)"data-fsa-core", (Object[])new Object[0]));
                break;
            }
            case "w": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"FSAScheduleHelper_6", (String)"data-fsa-core", (Object[])new Object[0])).append(cycleNum).append(ResManager.loadKDString((String)"\u5468", (String)"FSAScheduleHelper_14", (String)"data-fsa-core", (Object[])new Object[0]));
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setYear(null);
                FSAScheduleRepeatUtil.repeatByWeek(cron, startTime, weekday);
                FSAScheduleRepeatUtil.repeatByHour(cron, repeatMode, hour);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"FSAScheduleHelper_13", (String)"data-fsa-core", (Object[])new Object[0]));
                break;
            }
            case "m": {
                if (cycleNum > 1) {
                    cycleNum = Math.min(cycleNum, 12);
                    String monthStr = String.valueOf(crStartTime.get(2) + 1);
                    cron.setMonth(monthStr + "/" + cycleNum);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u4ece", (String)"FSAScheduleHelper_15", (String)"data-fsa-core", (Object[])new Object[0])).append(monthStr).append(ResManager.loadKDString((String)"\u6708", (String)"FSAScheduleHelper_16", (String)"data-fsa-core", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5f00\u59cb", (String)"FSAScheduleHelper_10", (String)"data-fsa-core", (Object[])new Object[0]));
                } else {
                    cron.setMonth("*");
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"FSAScheduleHelper_6", (String)"data-fsa-core", (Object[])new Object[0])).append(cycleNum).append(ResManager.loadKDString((String)"\u6708", (String)"FSAScheduleHelper_16", (String)"data-fsa-core", (Object[])new Object[0]));
                cron.setYear(null);
                FSAScheduleRepeatUtil.repeatByMonthDay(cron, startTime, dayOrWeek, day, th, noWeek);
                FSAScheduleRepeatUtil.repeatByHour(cron, repeatMode, hour);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"FSAScheduleHelper_13", (String)"data-fsa-core", (Object[])new Object[0]));
                break;
            }
            case "q": 
            case "y": {
                cycleNum = Math.min(cycleNum, 1);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"FSAScheduleHelper_6", (String)"data-fsa-core", (Object[])new Object[0])).append(cycleNum).append(ResManager.loadKDString((String)"\u5e74", (String)"FSAScheduleHelper_17", (String)"data-fsa-core", (Object[])new Object[0]));
                cron.setYear(null);
                FSAScheduleRepeatUtil.repeatByMonthly(cron, month, startTime, weekFlag, th, noWeek);
                if ("q".equals(repeatMode)) {
                    FSAScheduleRepeatUtil.repeatByMonthDay(cron, startTime, dayOrWeek, day, th, noWeek);
                }
                FSAScheduleRepeatUtil.repeatByHour(cron, repeatMode, hour);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"FSAScheduleHelper_13", (String)"data-fsa-core", (Object[])new Object[0]));
                break;
            }
            case "def": {
                resultMap.put("txtdesc", FSAScheduleHelper.genDefDesc(cronStr, crStartTime, cycleNum));
                return resultMap;
            }
        }
        cron.getDescBuf().append(ResManager.loadKDString((String)"\r\n\u9884\u8ba1\u6700\u8fd1\u5341\u6b21\u6267\u884c\u65f6\u95f4\uff1a\r\n", (String)"FSAScheduleHelper_4", (String)"data-fsa-core", (Object[])new Object[0]));
        cron.getDescBuf().append(FSAScheduleHelper.computeFireTimesStr(cron.toString(), crStartTime.getTime(), 10, cycleNum));
        resultMap.put("txtdesc", cron.getDescBuf().toString());
        resultMap.put("plan", cron);
        return resultMap;
    }

    private static String genDefDesc(String cronStr, Calendar crStartTime, int cycleNum) {
        StringBuilder descBuilder = new StringBuilder();
        descBuilder.append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e", (String)"FSAScheduleHelper_2", (String)"data-fsa-core", (Object[])new Object[0]));
        String startTimeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(crStartTime.getTime());
        descBuilder.append(startTimeStr).append(ResManager.loadKDString((String)"\u8d77\uff0c\r\n", (String)"FSAScheduleHelper_3", (String)"data-fsa-core", (Object[])new Object[0]));
        descBuilder.append(ResManager.loadKDString((String)"\r\n\u9884\u8ba1\u6700\u8fd1\u5341\u6b21\u6267\u884c\u65f6\u95f4\uff1a\r\n", (String)"FSAScheduleHelper_4", (String)"data-fsa-core", (Object[])new Object[0]));
        if (StringUtils.isEmpty((String)cronStr)) {
            return descBuilder.toString();
        }
        String recent = FSAScheduleHelper.computeFireTimesStr(cronStr, crStartTime.getTime(), 10, cycleNum);
        descBuilder.append(recent);
        return descBuilder.toString();
    }

    public static Calendar getStartTime(Date startTime) {
        Calendar crStartTime = Calendar.getInstance();
        if (startTime != null) {
            crStartTime.setTimeInMillis(startTime.getTime());
        }
        return crStartTime;
    }

    private static String computeFireTimesStr(String cronExp, Date startTime, Integer numTimes, int cycleNum) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            List<Date> dateList = FSAScheduleHelper.getTimesDate(cronExp, startTime, numTimes, cycleNum);
            ArrayList<String> dateStr = new ArrayList<String>(dateList.size());
            for (Date date : dateList) {
                dateStr.add(dateFormat.format(date));
            }
            return String.join((CharSequence)",\r\n", dateStr);
        }
        catch (ParseException e) {
            logger.error("computeFireTimesStr\uff1a", (Throwable)e);
            return "";
        }
    }

    private static List<Date> getTimesDate(String cronExp, Date startTime, Integer numTimes, int cycleNum) throws ParseException {
        ArrayList<Date> dateList;
        block6: {
            int cronDateIdx = -1;
            if (cycleNum > 1) {
                Object[] objArr = FSAScheduleHelper.setCycleNumSingleAndGetIdx(cronExp);
                cronDateIdx = (Integer)objArr[0];
                cronExp = (String)objArr[1];
            }
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cronExp);
            cronTriggerImpl.setStartTime(startTime);
            List<Date> cronDateList = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)numTimes);
            if (cronDateIdx > -1) {
                dateList = new ArrayList<Date>(numTimes);
                int cronDate = cronDateArr[cronDateIdx];
                Calendar calComp = Calendar.getInstance();
                calComp.setTime((Date)cronDateList.get(0));
                Calendar calTemp = Calendar.getInstance();
                int cnt = 0;
                while (true) {
                    for (Date date : cronDateList) {
                        calTemp.setTime(date);
                        if (calComp.get(cronDate) == calTemp.get(cronDate)) {
                            dateList.add(date);
                            if (++cnt != numTimes) continue;
                        } else {
                            if (calComp.compareTo(calTemp) >= 0) continue;
                            calComp.add(cronDate, cycleNum);
                            if (calComp.get(cronDate) != calTemp.get(cronDate)) continue;
                            dateList.add(date);
                            if (++cnt != numTimes) continue;
                        }
                        break block6;
                    }
                    cronTriggerImpl.setStartTime(new Date(((Date)cronDateList.get(cronDateList.size() - 1)).getTime() + 1000L));
                    cronDateList = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)numTimes);
                }
            }
            dateList = cronDateList;
        }
        return dateList;
    }

    public static List<Date> computeFireTimesDate(String cronExp, Date startTime, Date endTime, Integer numTimes, int cycleNum) {
        try {
            if (StringUtils.isEmpty((String)cronExp)) {
                return Collections.emptyList();
            }
            List<Date> dates = FSAScheduleHelper.getTimesDate(cronExp, startTime, numTimes, cycleNum);
            ArrayList<Date> returnList = new ArrayList<Date>(numTimes / 2);
            if (endTime != null) {
                for (Date date : dates) {
                    if (endTime.compareTo(date) < 0) break;
                    returnList.add(date);
                }
                return returnList;
            }
            return dates;
        }
        catch (ParseException e) {
            logger.error("computeFireTimesDate\uff1a", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static ScheduleMsgInfo buildScheduleMsgInfo(DynamicObject scheduleDyo) {
        ScheduleMsgInfo msgInfo = new ScheduleMsgInfo();
        DynamicObject schPrincipal = scheduleDyo.getDynamicObject("schprincipal");
        if (schPrincipal == null) {
            msgInfo.setSchPrincipal(0L);
        } else {
            msgInfo.setSchPrincipal(((Long)schPrincipal.getPkValue()).longValue());
        }
        DynamicObject msgReceiver = scheduleDyo.getDynamicObject("msgreceiver");
        if (msgReceiver == null) {
            msgInfo.setMsgreceiver(0L);
        } else {
            msgInfo.setMsgreceiver(((Long)msgReceiver.getPkValue()).longValue());
        }
        msgInfo.setFailNotify(scheduleDyo.getBoolean("sfailnotify"));
        msgInfo.setSuccessNotify(scheduleDyo.getBoolean("ssuccessnotify"));
        msgInfo.setNotifyType(scheduleDyo.getString("snotifytype"));
        msgInfo.setMsgContent(scheduleDyo.getString("smsgcontent"));
        msgInfo.setTimeOut(scheduleDyo.getBoolean("stimeout"));
        return msgInfo;
    }

    private static void dispatchJob(JobInfo jobInfo) {
        Map params;
        if (!jobInfo.isEnable()) {
            return;
        }
        if (StringUtils.isEmpty((String)jobInfo.getAppId())) {
            jobInfo.setAppId("fsa");
        }
        long groupId = 0L;
        jobInfo.setGroupId(groupId);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setExecuteTime(1);
        if (jobInfo.getRetryTime() > 0 || !jobInfo.getRouteMode().equals((Object)RouteMode.RAMDOM)) {
            groupId = DbJobOperation.getGroupMax();
            jobInfo.setGroupId(groupId);
        }
        if (jobInfo.getRouteMode() != null && jobInfo.getRouteMode().equals((Object)RouteMode.SHARDINGTASK) && (params = jobInfo.getParams()) != null && params.size() > 0) {
            Object shareParams = params.get("SHAREPARAMS");
            if (shareParams == null) {
                return;
            }
            List<Object> shareParamList = new ArrayList();
            try {
                shareParamList = FSAJSONUtils.jsonCastToList((String)shareParams, ShardingParam.class);
            }
            catch (Exception e) {
                logger.error("dispatchJob\uff1a", (Throwable)e);
                HashMap shareParamMap = FSAJSONUtils.cast((String)shareParams, HashMap.class);
                for (Map.Entry paramEntry : shareParamMap.entrySet()) {
                    shareParamList.add(new ShardingParam((String)paramEntry.getKey(), (String)paramEntry.getValue()));
                }
            }
            int index = 0;
            for (ShardingParam shardingParam : shareParamList) {
                jobInfo.setShardingParam(shardingParam);
                jobInfo.setShareIndex(++index);
                jobInfo.setExecuteTime(shareParamList.size());
                JobClient.dispatch((JobInfo)jobInfo);
            }
            return;
        }
        JobClient.dispatch((JobInfo)jobInfo);
    }

    public static boolean checkCron(String cron) {
        try {
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
            parser.parse(cron);
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cron);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)2);
            long leadTime = Math.abs(((Date)dates.get(1)).getTime() - ((Date)dates.get(0)).getTime());
            if (leadTime < 60000L) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("checkCron\uff1a", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getHostIpAddress() {
        String loginIP = RequestContext.get().getLoginIP();
        if (StringUtils.isEmpty((String)loginIP)) {
            logger.error("getHostIpAddress\uff1aip\u83b7\u53d6\u4e3a\u7a7a");
            loginIP = "";
        } else {
            loginIP = loginIP.split(",")[0];
        }
        if (loginIP.length() > 20) {
            logger.error("getHostIpAddress\uff1aip\u5206\u9694\u7b26\u6216\u7248\u672c\u66f4\u6362\uff0c\u539fip\uff1a" + loginIP);
            loginIP = loginIP.substring(0, 20);
        }
        return loginIP;
    }

    public static Object[] setCycleNumSingleAndGetIdx(String cron) {
        Object[] objArr = new Object[2];
        objArr[0] = -1;
        if (cron.contains("/")) {
            CharSequence[] crones = cron.split(" ");
            for (int i = 0; i < crones.length; ++i) {
                if (!crones[i].contains("/")) continue;
                crones[i] = "*";
                objArr[0] = i;
                break;
            }
            cron = String.join((CharSequence)" ", crones);
        }
        objArr[1] = cron;
        return objArr;
    }
}

