/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.utils.schedule;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.formplugin.CronStruct;
import kd.data.fsa.utils.schedule.FSAScheduleHelper;

public class FSAScheduleRepeatUtil {
    private static final Log logger = LogFactory.getLog(FSAScheduleRepeatUtil.class);
    private static final String[][] thResArr = new String[][]{{"\u6700\u540e\u4e00\u4e2a", "FSAScheduleRepeatUtil_9"}, {"\u7b2c\u4e00\u4e2a", "FSAScheduleRepeatUtil_4"}, {"\u7b2c\u4e8c\u4e2a", "FSAScheduleRepeatUtil_5"}, {"\u7b2c\u4e09\u4e2a", "FSAScheduleRepeatUtil_6"}, {"\u7b2c\u56db\u4e2a", "FSAScheduleRepeatUtil_7"}, {"\u7b2c\u4e94\u4e2a", "FSAScheduleRepeatUtil_8"}};
    private static final String[][] noWeekResArr = new String[][]{{"\u661f\u671f\u65e5", "FSAScheduleRepeatUtil_10"}, {"\u661f\u671f\u4e00", "FSAScheduleRepeatUtil_11"}, {"\u661f\u671f\u4e8c", "FSAScheduleRepeatUtil_12"}, {"\u661f\u671f\u4e09", "FSAScheduleRepeatUtil_13"}, {"\u661f\u671f\u56db", "FSAScheduleRepeatUtil_14"}, {"\u661f\u671f\u4e94", "FSAScheduleRepeatUtil_15"}, {"\u661f\u671f\u516d", "FSAScheduleRepeatUtil_16"}, {"\u81ea\u7136\u65e5", "FSAScheduleRepeatUtil_17"}, {"\u5de5\u4f5c\u65e5", "FSAScheduleRepeatUtil_18"}};
    private static final String[][] monthResArr = new String[][]{{"\u4e00\u6708", "FSAScheduleRepeatUtil_19"}, {"\u4e8c\u6708", "FSAScheduleRepeatUtil_20"}, {"\u4e09\u6708", "FSAScheduleRepeatUtil_21"}, {"\u56db\u6708", "FSAScheduleRepeatUtil_22"}, {"\u4e94\u6708", "FSAScheduleRepeatUtil_23"}, {"\u516d\u6708", "FSAScheduleRepeatUtil_24"}, {"\u4e03\u6708", "FSAScheduleRepeatUtil_25"}, {"\u516b\u6708", "FSAScheduleRepeatUtil_26"}, {"\u4e5d\u6708", "FSAScheduleRepeatUtil_27"}, {"\u5341\u6708", "FSAScheduleRepeatUtil_28"}, {"\u5341\u4e00\u6708", "FSAScheduleRepeatUtil_29"}, {"\u5341\u4e8c\u6708", "FSAScheduleRepeatUtil_30"}};

    public static CronStruct repeatByHour(CronStruct cron, String repeatMode, int[] hour) {
        StringBuilder cronExp = new StringBuilder();
        StringBuilder cronDesc = new StringBuilder();
        for (int h : hour) {
            cronExp.append(h).append(',');
            cronDesc.append(h).append(ResManager.loadKDString((String)"\u65f6", (String)"FSAScheduleRepeatUtil_0", (String)"data-fsa-core", (Object[])new Object[0])).append(',');
        }
        String cronExpStr = cronExp.toString();
        String cronDescStr = cronDesc.toString();
        if (cronExpStr.length() > 0) {
            cronExpStr = cronExpStr.substring(0, cronExpStr.length() - 1);
        } else {
            String string = cronExpStr = "mi".equals(repeatMode) ? "*" : cron.getHours();
        }
        if (cronDescStr.length() > 0) {
            cron.getDescBuf().append(cronDescStr, 0, cronDescStr.length() - 1);
        }
        cron.setHours(cronExpStr);
        return cron;
    }

    public static CronStruct repeatByMonthDay(CronStruct cron, Date startTime, String dayOrWeek, int[] day, String th, String noWeek) {
        if ("w".equals(dayOrWeek)) {
            FSAScheduleRepeatUtil.repeatByNoWeek(cron, th, noWeek);
        } else {
            String days;
            String conStr = ResManager.loadKDString((String)"\u7684", (String)"FSAScheduleRepeatUtil_3", (String)"data-fsa-core", (Object[])new Object[0]);
            if (day.length > 0 && day[day.length - 1] == 32) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"FSAScheduleRepeatUtil_1", (String)"data-fsa-core", (Object[])new Object[0]));
                days = "L,";
            } else {
                StringBuilder daysBuilder = new StringBuilder();
                for (int d : day) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)String.format("%d\u65e5", d), (String)"FSAScheduleRepeatUtil_2", (String)"data-fsa-core", (Object[])new Object[0]));
                    conStr = ",";
                    daysBuilder.append(d).append(',');
                }
                days = String.valueOf(daysBuilder);
            }
            days = days.length() == 0 ? (StringUtils.isBlank((CharSequence)cron.getDayOfMonth()) ? String.valueOf(FSAScheduleHelper.getStartTime(startTime).get(5)) : cron.getDayOfMonth()) : days.substring(0, days.length() - 1);
            cron.setDayOfMonth(days);
            if (!"?".equals(days)) {
                cron.setDayOfWeek("?");
            }
        }
        return cron;
    }

    public static CronStruct repeatByNoWeek(CronStruct cron, String th, String noWeek) {
        if (StringUtils.isNotBlank((CharSequence)th)) {
            try {
                int thIdx = "L".equalsIgnoreCase(th) ? 0 : Integer.parseInt(th);
                cron.getDescBuf().append(ResManager.loadKDString((String)thResArr[thIdx][0], (String)thResArr[thIdx][1], (String)"data-fsa-core", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error("repeatByNoWeek\uff1a", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)noWeek)) {
            try {
                int noWeekIdx = Integer.parseInt(noWeek) - 1;
                cron.getDescBuf().append(ResManager.loadKDString((String)noWeekResArr[noWeekIdx][0], (String)noWeekResArr[noWeekIdx][1], (String)"data-fsa-core", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error("repeatByNoWeek\uff1a", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)th) && StringUtils.isNotBlank((CharSequence)noWeek)) {
            boolean thFlag;
            boolean bl = thFlag = th.compareTo("1") >= 0 && th.compareTo("5") <= 0;
            if (noWeek.compareTo("1") >= 0 && noWeek.compareTo("8") < 0) {
                if (thFlag) {
                    cron.setDayOfWeek(noWeek + "#" + th);
                } else if (th.compareTo("L") == 0) {
                    cron.setDayOfWeek(noWeek + "L");
                }
                cron.setDayOfMonth("?");
            } else if (noWeek.equals("8")) {
                if (thFlag) {
                    cron.setDayOfMonth(th);
                } else if (th.compareTo("L") == 0) {
                    cron.setDayOfMonth("1L");
                }
                cron.setDayOfWeek("?");
            } else if (noWeek.equals("9")) {
                if (thFlag) {
                    String workday = String.valueOf(Integer.parseInt(th) + 1);
                    cron.setDayOfWeek(workday + "#" + th);
                } else if (th.compareTo("L") == 0) {
                    cron.setDayOfWeek("6L");
                }
                cron.setDayOfMonth("?");
            }
        }
        return cron;
    }

    public static CronStruct repeatByMonthly(CronStruct cron, int[] month, Date startTime, boolean weekFlag, String th, String noWeek) {
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"FSAScheduleRepeatUtil_3", (String)"data-fsa-core", (Object[])new Object[0]);
        StringBuilder monthsBuilder = new StringBuilder();
        for (int m : month) {
            int idx = m - 1;
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)monthResArr[idx][0], (String)monthResArr[idx][1], (String)"data-fsa-core", (Object[])new Object[0]));
            conStr = ",";
            monthsBuilder.append(m).append(',');
        }
        String months = String.valueOf(monthsBuilder);
        months = months.length() == 0 ? (StringUtils.isBlank((CharSequence)cron.getMonth()) ? String.valueOf(FSAScheduleHelper.getStartTime(startTime).get(2) + 1) : cron.getMonth()) : months.substring(0, months.length() - 1);
        cron.setMonth(months);
        if (weekFlag) {
            FSAScheduleRepeatUtil.repeatByNoWeek(cron, th, noWeek);
        }
        return cron;
    }

    public static CronStruct repeatByWeek(CronStruct cron, Date startTime, int[] weekday) {
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"FSAScheduleRepeatUtil_3", (String)"data-fsa-core", (Object[])new Object[0]);
        StringBuilder weekDaysBuilder = new StringBuilder();
        for (int w : weekday) {
            int idx = w - 1;
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)noWeekResArr[idx][0], (String)noWeekResArr[idx][1], (String)"data-fsa-core", (Object[])new Object[0]));
            conStr = ",";
            weekDaysBuilder.append(w).append(',');
        }
        String weekDays = String.valueOf(weekDaysBuilder);
        weekDays = weekDays.length() == 0 ? (StringUtils.isEmpty((CharSequence)cron.getDayOfWeek()) ? String.valueOf(FSAScheduleHelper.getStartTime(startTime).get(7)) : cron.getDayOfWeek()) : weekDays.substring(0, weekDays.length() - 1);
        if (!"?".equals(weekDays)) {
            cron.setDayOfMonth("?");
        }
        cron.setDayOfWeek(weekDays);
        return cron;
    }
}

