/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.service.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.algo.RawDataToDataSetWrapper;
import kd.data.disf.model.impl.BasePropModel;
import kd.data.disf.model.impl.IDataBaseModel;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskFactory;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.model.file.FSAFieldMappingModel;
import kd.data.fsa.model.file.FSAFieldMappingWithTimePatternModel;
import kd.data.fsa.model.file.FSAFileInfoModel;
import kd.data.fsa.model.sync.FSADataSyncTaskDimFilterModel;
import kd.data.fsa.model.sync.FSADataSyncTaskMemberModel;
import kd.data.fsa.model.sync.FSADataSyncTaskParamModel;
import kd.data.fsa.service.FSADataQueryService;
import kd.data.fsa.service.model.FSAQueryDataResult;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSADataCollectionHelper;
import kd.data.fsa.utils.FSADataversionUtils;
import kd.data.fsa.utils.FSAJSONUtils;
import kd.data.fsa.utils.FSAPreviewDataHelper;
import kd.data.fsa.utils.FSASyncTaskLogHelper;

public class FSADataQueryServiceImpl
implements FSADataQueryService {
    private static final Log logger = LogFactory.getLog(FSADataQueryServiceImpl.class);
    private AbstractDataSet abstractDataSet;

    public String submitWorkTask(int taskType, Long srcParamId, Map<String, List<Object[]>> filterParams) {
        Long taskId = null;
        String version = null;
        DynamicObject syncParam = BusinessDataServiceHelper.loadSingleFromCache((Object)srcParamId, (String)"fsa_syncparam");
        if (syncParam == null) {
            logger.info("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u540c\u6b65\u53c2\u6570\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u4e0d\u6267\u884c\u53d6\u6570");
            return null;
        }
        String tableNumber = syncParam.getString("tablenumber");
        if (StringUtils.isEmpty((String)tableNumber)) {
            logger.info("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u672a\u521b\u5efa\u6570\u636e\u8868\uff0c\u4e0d\u6267\u884c\u53d6\u6570");
            return null;
        }
        Long collectionId = syncParam.getLong("datacollection_id");
        DynamicObject colDoj = BusinessDataServiceHelper.loadSingleFromCache((String)"fsa_data_collection", (String)"paramsrc_tag,dataentryentity,dataentryentity.dimtype,dataentryentity.dimnumber,dataentryentity.srcname", (QFilter[])new QFilter("id", "=", (Object)collectionId).toArray());
        if (colDoj != null) {
            String paramSrcJson = colDoj.getString("paramsrc_tag");
            if (StringUtils.isEmpty((String)paramSrcJson)) {
                logger.info("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u6570\u636e\u96c6\u5408\u672a\u8bbe\u7f6e\u6765\u6e90\u53c2\u6570\uff0c\u4e0d\u6267\u884c\u53d6\u6570");
                return null;
            }
            Map configMap = FSADataCollectionHelper.getSrcParamMapFromJson((String)paramSrcJson);
            if (configMap == null || configMap.isEmpty()) {
                logger.info("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u6570\u636e\u96c6\u5408\u7684\u6765\u6e90\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u53d6\u6570");
                return null;
            }
            Boolean ignoreDimNull = syncParam.getBoolean("ignoredimnull");
            version = FSADataversionUtils.getVersionToDateString();
            FSAWorkTaskTypeEnum taskTypeEnum = FSAWorkTaskTypeEnum.getEnum((Integer)taskType);
            String srcType = syncParam.getString("datasrctype");
            if ("fileParamSource".equalsIgnoreCase(srcType)) {
                FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)JSON.parseObject((String)((String)configMap.get("fileUpload")), (TypeReference)new TypeReference<FSAFileInfoModel>(){}, (Feature[])new Feature[0]);
                if (fileInfoModel == null) {
                    logger.info("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u79bb\u7ebf\u6587\u4ef6\u5df2\u8fc7\u671f\uff0c\u4e0d\u6267\u884c\u53d6\u6570");
                    return null;
                }
                DynamicObjectCollection dyCol = colDoj.getDynamicObjectCollection("dataentryentity");
                if (dyCol != null && !dyCol.isEmpty()) {
                    LinkedList<FSAFieldMappingModel> fieldMappingModelList = new LinkedList<FSAFieldMappingModel>();
                    for (DynamicObject dyObj : dyCol) {
                        String dimensionType = dyObj.getString("dimtype");
                        String paramFieldNumber = dyObj.getString("dimnumber");
                        String fileSrcField = dyObj.getString("srcname");
                        FSAFieldMappingModel mappingModel = new FSAFieldMappingModel(dimensionType, paramFieldNumber, fileSrcField, null);
                        fieldMappingModelList.add(mappingModel);
                    }
                    taskId = FSASyncTaskLogHelper.createSyncTask((Long)srcParamId, (String)version, (FSAWorkTaskTypeEnum)taskTypeEnum);
                    FSAFieldMappingWithTimePatternModel fmwTpm = new FSAFieldMappingWithTimePatternModel("1", fieldMappingModelList);
                    FSAWorkTaskMeta meta = new FSAWorkTaskMeta(srcParamId.toString(), taskId, srcParamId, taskTypeEnum, Long.valueOf(Long.parseLong(version)), fileInfoModel, Boolean.TRUE, ignoreDimNull, fmwTpm, tableNumber, Boolean.TRUE);
                    IDataAbstractWorkTask task = FSAWorkTaskFactory.createFSAWorkTask((Integer)taskType, (IWorkTaskTransLog)meta, (boolean)true);
                    IDataWorkTaskManager.getInstance().submit((IDataWorkTask)task);
                }
            } else if ("bcmParamSource".equalsIgnoreCase(srcType)) {
                DynamicObjectCollection cols;
                Long moduleId = (Long)configMap.get("moduleId");
                FSADataSyncTaskParamModel taskParamModel = null;
                if (filterParams != null && !filterParams.isEmpty() && (cols = syncParam.getDynamicObjectCollection("dimentry")) != null && !cols.isEmpty()) {
                    ArrayList<FSADataSyncTaskDimFilterModel> dimFilter = new ArrayList<FSADataSyncTaskDimFilterModel>(filterParams.size());
                    for (DynamicObject dob : cols) {
                        String dimNumber;
                        List<Object[]> dimFilterList;
                        String filterMode = dob.getString("filtermode");
                        if (!"2".equals(filterMode) || (dimFilterList = filterParams.get(dimNumber = dob.getString("dimnumber"))) == null || dimFilterList.isEmpty()) continue;
                        ArrayList<FSADataSyncTaskMemberModel> members = new ArrayList<FSADataSyncTaskMemberModel>(dimFilterList.size());
                        for (Object[] objArr : dimFilterList) {
                            if (4 != objArr.length) continue;
                            String memberName = (String)objArr[0];
                            String memberNumber = (String)objArr[1];
                            Long memberId = (Long)objArr[2];
                            String memberLongNumber = (String)objArr[3];
                            FSADataSyncTaskMemberModel memberModel = new FSADataSyncTaskMemberModel(memberName, memberNumber, memberId, memberLongNumber);
                            members.add(memberModel);
                        }
                        String dimName = dob.getString("dimname");
                        String dimOldDimNumber = dob.getString("olddimnumber");
                        FSADataSyncTaskDimFilterModel dimFilterModel = new FSADataSyncTaskDimFilterModel(dimName, dimNumber, dimOldDimNumber, filterMode, members);
                        dimFilter.add(dimFilterModel);
                    }
                    taskParamModel = new FSADataSyncTaskParamModel("fsa_syncparamtask", dimFilter);
                    taskParamModel.setModelNumber(FSABcmDataProvider.getModelNumber((Long)moduleId));
                }
                taskId = FSASyncTaskLogHelper.createSyncTask((Long)srcParamId, (String)version, (FSAWorkTaskTypeEnum)taskTypeEnum);
                FSAWorkTaskMeta meta = new FSAWorkTaskMeta(Long.valueOf(0L), Long.valueOf(0L), srcParamId.toString(), taskId, srcParamId, taskTypeEnum, FSAJSONUtils.toJsonString(taskParamModel), true, tableNumber, Boolean.TRUE, ignoreDimNull, Long.valueOf(Long.parseLong(version)));
                IDataAbstractWorkTask task = FSAWorkTaskFactory.createFSAWorkTask((Integer)taskType, (IWorkTaskTransLog)meta, (boolean)true);
                IDataWorkTaskManager.getInstance().submit((IDataWorkTask)task);
            }
        }
        return FSAJSONUtils.toJsonString((Object)new IDataBaseModel(taskId, (Object)syncParam.getString("name"), version));
    }

    public String queryWorkTaskStatus(Long taskId) {
        QFilter taskIdFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject syncTask = QueryServiceHelper.queryOne((String)"fsa_rptdata_synctask", (String)"id,status,staticstatus_info_tag", (QFilter[])taskIdFilter.toArray());
        if (syncTask != null) {
            return FSAJSONUtils.toJsonString((Object)new IDataBaseModel((Object)taskId, (Object)syncTask.getString("status"), (Object)syncTask.getString("staticstatus_info_tag")));
        }
        return null;
    }

    public String getAvailableDataSyncParams(QFilter[] filterParam) {
        DynamicObjectCollection syncParamList = QueryServiceHelper.query((String)"fsa_syncparam", (String)"id,number,name", (QFilter[])filterParam, (String)"createtime desc");
        if (syncParamList != null && !syncParamList.isEmpty()) {
            LinkedList<BasePropModel> syncParamModelList = new LinkedList<BasePropModel>();
            for (DynamicObject syncParam : syncParamList) {
                BasePropModel propModel = new BasePropModel((Object)syncParam.getLong("id"), syncParam.getString("number"), (Object)syncParam.getString("name"));
                syncParamModelList.add(propModel);
            }
            return FSAJSONUtils.toJsonString(syncParamModelList);
        }
        return null;
    }

    public String getEntityVersions(Long srcParamId) {
        List versionList;
        DynamicObject syncParam = QueryServiceHelper.queryOne((String)"fsa_syncparam", (String)"name,number", (QFilter[])new QFilter("id", "=", (Object)srcParamId).toArray());
        if (syncParam != null && !(versionList = FSADataversionUtils.getEnableVersion((long)srcParamId, Collections.emptySet(), (boolean)false)).isEmpty()) {
            String syncParaNumber = syncParam.getString("number");
            String syncParaName = syncParam.getString("name");
            ArrayList<BasePropModel> versionModelList = new ArrayList<BasePropModel>(versionList.size());
            for (Long version : versionList) {
                BasePropModel propModel = new BasePropModel((Object)version, syncParaNumber, (Object)syncParaName);
                versionModelList.add(propModel);
            }
            return FSAJSONUtils.toJsonString(versionModelList);
        }
        return null;
    }

    public FSAQueryDataResult getQueryDataResult(Long srcParamId, Set<Long> excludedVersions, QFilter[] queryFilter, int startPos, int pageSize) {
        List enableVersion = FSADataversionUtils.getEnableVersion((long)srcParamId, excludedVersions, (boolean)false);
        if (enableVersion.isEmpty()) {
            logger.info(String.format("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u540c\u6b65\u53c2\u6570[%d]\u6ca1\u6709\u53ef\u7528\u6570\u636e\u7248\u672c\uff0c\u67e5\u8be2FSA\u6570\u636e\u8868\u8fd4\u56denull\u503c", srcParamId));
            return null;
        }
        RowMeta meta = null;
        LinkedList<Object[]> dataList = null;
        String entityName = null;
        DynamicObject syncParam = BusinessDataServiceHelper.loadSingleFromCache((Object)srcParamId, (String)"fsa_syncparam");
        if (syncParam != null) {
            String tableNumber = syncParam.getString("tablenumber");
            if (StringUtils.isEmpty((String)tableNumber)) {
                logger.info("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u6570\u636e\u8868\u4e3a\u7a7a\uff0c\u67e5\u8be2FSA\u6570\u636e\u8868\u8fd4\u56denull\u503c");
                return null;
            }
            Long colId = syncParam.getLong("datacollection_id");
            DynamicObject dataCol = BusinessDataServiceHelper.loadSingleFromCache((Object)colId, (String)"fsa_data_collection");
            if (dataCol == null) {
                logger.info("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u6570\u636e\u96c6\u5408\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2FSA\u6570\u636e\u8868\u8fd4\u56denull\u503c");
                return null;
            }
            entityName = FSACommonConstant.buildEntityName((String)tableNumber);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
            if (entityType == null) {
                logger.info(String.format("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u65e0\u6cd5\u627e\u5230\u6570\u636e\u6e90\u5b9e\u4f53\u5bf9\u8c61[%s]\uff0c\u67e5\u8be2FSA\u6570\u636e\u8868\u8fd4\u56denull\u503c", entityName));
                return null;
            }
            Set dimensionNumberSet = FSAPreviewDataHelper.getDimensionSetFromDataCol((DynamicObject)dataCol);
            String dimensionFields = null;
            String[] dimensionFieldArr = null;
            String selectFields = null;
            String[] selectFieldArr = null;
            StringBuilder dimensionBuilder = new StringBuilder();
            StringBuilder fieldsBuilder = new StringBuilder();
            DataEntityPropertyCollection propCol = entityType.getProperties();
            for (IDataEntityProperty prop : propCol) {
                String field = prop.getName();
                if ("id".equalsIgnoreCase(field) || "del".equalsIgnoreCase(field)) continue;
                if (dimensionNumberSet.contains(field.toLowerCase())) {
                    dimensionBuilder.append(',').append(field);
                }
                fieldsBuilder.append(',').append(field);
            }
            if (dimensionBuilder.length() > 0) {
                dimensionFields = dimensionBuilder.substring(1);
                dimensionFieldArr = dimensionFields.split(",");
            }
            if (fieldsBuilder.length() > 0) {
                selectFields = fieldsBuilder.substring(1);
                selectFieldArr = selectFields.split(",");
            }
            if (StringUtils.isEmpty((String)dimensionFields) || StringUtils.isEmpty((String)selectFields) || dimensionFieldArr == null || selectFieldArr == null) {
                logger.info("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u6ca1\u6709\u63d0\u4f9b\u53ef\u7528\u5b57\u6bb5\uff0c\u67e5\u8be2FSA\u6570\u636e\u8868\u8fd4\u56denull\u503c");
                return null;
            }
            AbstractDataSet originDs = (AbstractDataSet)QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])queryFilter, (String)"version desc");
            if (originDs != null) {
                this.abstractDataSet = originDs;
                if (startPos < 0) {
                    startPos = 0;
                }
                if (pageSize < 0) {
                    pageSize = 20;
                }
                if (pageSize > 500000) {
                    pageSize = 500000;
                }
                meta = originDs.getRowMeta();
                dataList = new LinkedList<Object[]>();
                HashSet<String> rowKeySet = enableVersion.size() > 1 ? new HashSet<String>(pageSize) : null;
                int rowIndex = -1;
                while (originDs.hasNext() && dataList.size() < pageSize) {
                    Row row = originDs.next();
                    if (rowKeySet != null) {
                        StringBuilder rowKeyValueBuilder = new StringBuilder();
                        for (String dimKey : dimensionFieldArr) {
                            Object obj = row.get(dimKey);
                            if (obj == null) continue;
                            rowKeyValueBuilder.append(',').append(obj);
                        }
                        if (!rowKeySet.add(rowKeyValueBuilder.substring(1)) || rowKeySet.size() < startPos) continue;
                    }
                    ++rowIndex;
                    Object[] objArr = new Object[selectFieldArr.length];
                    for (int i = 0; i < selectFieldArr.length; ++i) {
                        objArr[i] = row.get(i);
                    }
                    if (rowIndex < startPos) continue;
                    dataList.add(objArr);
                }
            }
        }
        return new FSAQueryDataResult(srcParamId, entityName, meta, dataList);
    }

    public String queryFSAEntityData(Long srcParamId, Set<Long> excludedVersions, QFilter[] queryFilter, int startPos, int pageSize) {
        FSAQueryDataResult dataResult = this.getQueryDataResult(srcParamId, excludedVersions, queryFilter, startPos, pageSize);
        return FSAJSONUtils.toJsonString((Object)dataResult);
    }

    public String getEntityCachedDatasetId(Long srcParamId, Set<Long> excludedVersions, QFilter[] queryFilter, int startPos, int pageSize) {
        RawDataToDataSetWrapper absDs;
        CachedDataSet cachedDataSet;
        FSAQueryDataResult dataResult = this.getQueryDataResult(srcParamId, excludedVersions, queryFilter, startPos, pageSize);
        if (dataResult != null && this.abstractDataSet != null && (cachedDataSet = (absDs = new RawDataToDataSetWrapper(dataResult.getEntityName(), this.abstractDataSet, dataResult.getDataList())).cache(CacheHint.getDefault())) != null) {
            return cachedDataSet.getCacheId();
        }
        return null;
    }

    public Map<String, Map<String, String>> getMembersDisplayInfo(Long dataCollectionId, String[] dimensionArray) {
        Map paramSrcTagMap;
        DynamicObject dataCol = BusinessDataServiceHelper.loadSingleFromCache((Object)dataCollectionId, (String)"fsa_data_collection");
        if (dataCol == null) {
            logger.info("FSA\u63a5\u53e3\u670d\u52a1\uff1a\u6570\u636e\u96c6\u5408\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u8fd4\u56denull\u503c");
            return null;
        }
        Map<String, Map<String, String>> colMemberDisplayInfo = new HashMap<String, Map<String, String>>(16);
        if ("bcmParamSource".equalsIgnoreCase(dataCol.getString("datasrctype")) && (paramSrcTagMap = FSADataCollectionHelper.getSrcParamFromCol((DynamicObject)dataCol)) != null && !paramSrcTagMap.isEmpty()) {
            HashMap viewAndModuleMap = new HashMap(2);
            viewAndModuleMap.put("organizationViewId", paramSrcTagMap.get("OrgView"));
            viewAndModuleMap.put("moduleId", paramSrcTagMap.get("moduleId"));
            colMemberDisplayInfo = FSAPreviewDataHelper.numberMappingNameMap(viewAndModuleMap, (String[])dimensionArray);
        }
        return colMemberDisplayInfo;
    }
}

