/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.FilterGridF7ClickEvent;
import kd.bos.form.control.events.FilterGridF7ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.AlarmConfig;
import kd.data.idi.data.AnalysisMode;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.statistics.AlarmHoverSettingRow;
import kd.data.idi.util.ExprDescUtils;
import kd.data.idi.util.FilterGridHelper;
import kd.data.idi.util.IDIJSONUtils;

public class IDIAlarmFormPlugin
extends AbstractFormPlugin
implements FilterGridF7ClickListener {
    private static final String CUSTPARAMKEY_ENTITY_NUMBER = "entitynumber";
    private static final String CUSTPARAMKEY_ONLYHEADFIELD = "onlyheadfield";
    private static final String CUSTOMPARAM_DETAIL_CONFIG = "detailConfig";
    private static final String CUSTOMPARAM_ANALYSISMODE = "analysisModel";
    private static final String KEY_FAIL_TEXT = "fail_text";
    private static final String KEY_FILTERGRID = "filtergridap";
    private static final String KEY_SUCCESS_TEXT = "success_text";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_CHECK_VOTE = "checkvote";
    private static final String KEY_STARTCONDITION = "startcondition";
    private static final String KEY_STARTCONDITIONJSON_TAG = "startconditionjson_tag";
    private static final String POINT_DEDUCT_CONFIG = "point_deduct_config";
    private static final String POINT_DEDUCT_CONFIG_VALUE = "point_deduct_config_value";
    private static final String FORMID_IDI_CONDITION_EDIT = "idi_condition_edit";
    private static final String ACTIONID_SET_START_CONDITION = "setStartCondition";
    private static final String FORMID_IDI_GENERAL_POINT_DEDUCT = "general_point_deduct";
    private static final String KEY_ANALYSIS_MODE = "analysis_mode";

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BTNOK, "propdisplayname"});
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        filterGrid.addFilterGridF7ClickEvents((FilterGridF7ClickListener)this);
    }

    private void checkFilterColumns(List<Map<String, Object>> cols, String billStatusField) {
        Iterator<Map<String, Object>> colsIterator = cols.iterator();
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_ENTITY_NUMBER);
        while (colsIterator.hasNext()) {
            Map<String, Object> item = colsIterator.next();
            String fieldEntityNumber = (String)item.get("entryEntity");
            String fieldName = (String)item.get("fieldName");
            boolean isBillStatus = StringUtils.isNotEmpty((CharSequence)billStatusField) && fieldName.equals(billStatusField);
            Object compareTypes = item.get("compareTypes");
            if (compareTypes instanceof List) {
                List compareTypeList = (List)compareTypes;
                boolean containDateGroup = false;
                ArrayList<CompareTypeDto> defaultDateCompareType = new ArrayList<CompareTypeDto>();
                Iterator compareTypesIterator = compareTypeList.iterator();
                while (compareTypesIterator.hasNext()) {
                    Object obj = compareTypesIterator.next();
                    if (obj instanceof CompareTypeDto) {
                        CompareTypeDto compareType = (CompareTypeDto)obj;
                        if (compareType.getGroupId() == 0) {
                            compareType.setInputCtlType(-1);
                            compareType.setNeedInput(false);
                            if (CompareTypeEnum.EQUAL.getId().equals(compareType.getId())) {
                                compareType.setName(new LocaleString(ResManager.loadKDString((String)"\u76f8\u7b49", (String)"IDIAlarmFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0])));
                                continue;
                            }
                            if (!CompareTypeEnum.NOTEQUAL.getId().equals(compareType.getId())) continue;
                            compareType.setName(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u76f8\u7b49", (String)"IDIAlarmFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0])));
                            continue;
                        }
                        if (compareType.getGroupId() == 5) {
                            containDateGroup = true;
                            if (CompareTypeEnum.TODAY.getId().equals(compareType.getId()) || CompareTypeEnum.YESTERDAY.getId().equals(compareType.getId())) {
                                compareType.setInputCtlType(-1);
                                compareType.setNeedInput(false);
                                defaultDateCompareType.add(compareType);
                            }
                            compareTypesIterator.remove();
                            continue;
                        }
                        if (isBillStatus && compareType.getGroupId() == 10) {
                            if (!CompareTypeEnum.CHECKBOXEQUAL.getId().equals(compareType.getId()) && !CompareTypeEnum.CHECKBOXNOTEQUAL.getId().equals(compareType.getId())) continue;
                            compareTypesIterator.remove();
                            continue;
                        }
                        if (compareType.getGroupId() == 4) {
                            if ("number".equalsIgnoreCase((String)item.get("type")) && (CompareTypeEnum.LESS.getId().equals(compareType.getId()) || CompareTypeEnum.LESSOREQUAL.getId().equals(compareType.getId()) || CompareTypeEnum.GREATER.getId().equals(compareType.getId()) || CompareTypeEnum.GREATEROREQUAL.getId().equals(compareType.getId()))) continue;
                            compareTypesIterator.remove();
                            continue;
                        }
                        if (compareType.getGroupId() == 7) {
                            compareType.setInputCtlType(-1);
                            compareType.setNeedInput(false);
                            if (CompareTypeEnum.ORGEQUAL.getId().equals(compareType.getId())) {
                                compareType.setName(new LocaleString(ResManager.loadKDString((String)"\u76f8\u7b49", (String)"IDIAlarmFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0])));
                                continue;
                            }
                            if (CompareTypeEnum.ORGNOTEQUAL.getId().equals(compareType.getId())) {
                                compareType.setName(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u76f8\u7b49", (String)"IDIAlarmFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0])));
                                continue;
                            }
                            compareTypesIterator.remove();
                            continue;
                        }
                        compareTypesIterator.remove();
                        continue;
                    }
                    compareTypesIterator.remove();
                }
                if (containDateGroup) {
                    List<CompareTypeDto> addCompareType = Arrays.asList(new CompareTypeDto("IDI_BETWEEN_1W", new LocaleString(ResManager.loadKDString((String)"1\u5468\u5185", (String)"IDIAlarmFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_2W", new LocaleString(ResManager.loadKDString((String)"2\u5468\u5185", (String)"IDIAlarmFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_1M", new LocaleString(ResManager.loadKDString((String)"1\u4e2a\u6708\u5185", (String)"IDIAlarmFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_0C", new LocaleString(ResManager.loadKDString((String)"\u672c\u6708\u5185", (String)"IDIAlarmFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_3M", new LocaleString(ResManager.loadKDString((String)"\u524d3\u4e2a\u6708", (String)"IDIAlarmFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_-3M", new LocaleString(ResManager.loadKDString((String)"\u540e3\u4e2a\u6708", (String)"IDIAlarmFormPlugin_8", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false));
                    for (CompareTypeDto dto : addCompareType) {
                        dto.setVisible(true);
                    }
                    compareTypeList.addAll(0, addCompareType);
                    if (!defaultDateCompareType.isEmpty()) {
                        compareTypeList.addAll(0, defaultDateCompareType);
                    }
                }
                if ("text".equalsIgnoreCase((String)item.get("type")) && entityNumber.equals(fieldEntityNumber)) {
                    CompareTypeDto similarType = new CompareTypeDto("SIMILAR", new LocaleString(ResManager.loadKDString((String)"\u76f8\u4f3c", (String)"IDIAlarmFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 0, -1, false, false, false, false);
                    similarType.setVisible(true);
                    compareTypeList.add(similarType);
                }
                if (!compareTypeList.isEmpty()) continue;
                colsIterator.remove();
                continue;
            }
            colsIterator.remove();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{POINT_DEDUCT_CONFIG, KEY_STARTCONDITION});
    }

    public void afterCreateNewData(EventObject e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_ENTITY_NUMBER);
        String onlyHeadField = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_ONLYHEADFIELD);
        IDataModel model = this.getModel();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            List cols = FilterGridHelper.getFilterColumns((MainEntityType)entityType, (!StringUtils.isBlank((CharSequence)onlyHeadField) && Boolean.parseBoolean(onlyHeadField) ? 1 : 0) != 0);
            String billStatusField = entityType instanceof BillEntityType ? ((BillEntityType)entityType).getBillStatus() : null;
            this.checkFilterColumns(cols, billStatusField);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(entityNumber);
        }
        String detailConfig = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOMPARAM_DETAIL_CONFIG);
        String analysisMode = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOMPARAM_ANALYSISMODE);
        boolean isNoScore = AnalysisMode.NOSCORE.getType().equals(analysisMode);
        if (StringUtils.isNotEmpty((CharSequence)detailConfig)) {
            List deductionGradeConfigList;
            IDICondition startCondition;
            AlarmConfig alarmConfig = (AlarmConfig)IDIJSONUtils.cast((String)detailConfig, AlarmConfig.class);
            this.getModel().setValue(KEY_SUCCESS_TEXT, (Object)(alarmConfig.getSuccessText() == null ? "" : alarmConfig.getSuccessText()));
            this.getModel().setValue(KEY_FAIL_TEXT, (Object)(alarmConfig.getFailText() == null ? "" : alarmConfig.getFailText()));
            this.getModel().setValue(KEY_CHECK_VOTE, (Object)alarmConfig.isCheckVote());
            List hoverSetting = alarmConfig.getHoverSetting();
            if (CollectionUtils.isNotEmpty((Collection)hoverSetting)) {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().batchCreateNewEntryRow("entryentity", hoverSetting.size());
                for (int i = 0; i < hoverSetting.size(); ++i) {
                    AlarmHoverSettingRow alarmHoverSettingRow = (AlarmHoverSettingRow)hoverSetting.get(i);
                    this.getModel().setValue("propname", (Object)alarmHoverSettingRow.getPropName(), i);
                    this.getModel().setValue("propdisplayname", (Object)alarmHoverSettingRow.getPropDisplayName(), i);
                    this.getModel().setValue("displayname", (Object)alarmHoverSettingRow.getDisplayName(), i);
                }
            }
            if ((startCondition = alarmConfig.getStartCondition()) != null) {
                model.setValue(KEY_STARTCONDITIONJSON_TAG, (Object)IDIJSONUtils.toJsonString((Object)startCondition));
                model.setValue(KEY_STARTCONDITION, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDIAlarmFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]), ExprDescUtils.getExprDesc((IDICondition)startCondition)));
            }
            if ((deductionGradeConfigList = alarmConfig.getDeductionGradeConfigList()) != null && !deductionGradeConfigList.isEmpty()) {
                model.setValue(POINT_DEDUCT_CONFIG, (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDIAlarmFormPlugin_16", (String)"data-idi-formplugin", (Object[])new Object[0]));
                model.setValue(POINT_DEDUCT_CONFIG_VALUE, (Object)IDIJSONUtils.toJsonString((Object)deductionGradeConfigList));
            }
        }
        if (isNoScore) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CHECK_VOTE});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        String detailConfig = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOMPARAM_DETAIL_CONFIG);
        if (StringUtils.isNotEmpty((CharSequence)detailConfig)) {
            AlarmConfig alarmConfig = (AlarmConfig)IDIJSONUtils.cast((String)detailConfig, AlarmConfig.class);
            filterGrid.SetValue(alarmConfig.getFilterCondition());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pointDeductConfig;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        if ("propdisplayname".equals(name)) {
            if (ObjectUtils.isEmpty((Object)changeData.getNewValue())) {
                model.setValue("propname", null);
            }
        } else if (POINT_DEDUCT_CONFIG.equals(name) && kd.bos.util.StringUtils.isEmpty((String)(pointDeductConfig = (String)this.getModel().getValue(POINT_DEDUCT_CONFIG)))) {
            this.getModel().setValue(POINT_DEDUCT_CONFIG_VALUE, (Object)"");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            boolean flag = this.validate();
            if (flag) {
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
                FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
                AlarmConfig alarmObj = new AlarmConfig();
                FilterCondition filterCondition = filterGridState.getFilterCondition();
                int leftBracketCount = 0;
                int rightBracketCount = 0;
                for (Object simpleFilterRow : filterCondition.getFilterRow()) {
                    leftBracketCount += simpleFilterRow.getLeftBracket().length();
                    rightBracketCount += simpleFilterRow.getRightBracket().length();
                }
                if (leftBracketCount != rightBracketCount) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01", (String)"IDIAlarmFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return;
                }
                alarmObj.setFilterCondition(filterCondition);
                alarmObj.setSuccessText((String)this.getModel().getValue(KEY_SUCCESS_TEXT));
                alarmObj.setFailText((String)this.getModel().getValue(KEY_FAIL_TEXT));
                alarmObj.setCheckVote(((Boolean)this.getModel().getValue(KEY_CHECK_VOTE)).booleanValue());
                ArrayList<AlarmHoverSettingRow> hoverSettingRows = new ArrayList<AlarmHoverSettingRow>();
                for (DynamicObject dynamicObject : this.getModel().getEntryEntity("entryentity")) {
                    String propName = dynamicObject.getString("propname");
                    String propDisplayName = dynamicObject.getString("propdisplayname");
                    String displayName = dynamicObject.getString("displayname");
                    hoverSettingRows.add(new AlarmHoverSettingRow(propName, propDisplayName, displayName));
                }
                alarmObj.setHoverSetting(hoverSettingRows);
                String generalPointDeduct = (String)this.getModel().getValue(POINT_DEDUCT_CONFIG_VALUE);
                List deductionGradeConfigList = IDIJSONUtils.jsonCastToList((String)generalPointDeduct, DeductionGradeConfig.class);
                alarmObj.setDeductionGradeConfigList(deductionGradeConfigList);
                IDICondition startCondition = null;
                String startConditionJson = (String)this.getModel().getValue(KEY_STARTCONDITIONJSON_TAG);
                if (kd.bos.util.StringUtils.isNotEmpty((String)startConditionJson)) {
                    startCondition = (IDICondition)IDIJSONUtils.cast((String)startConditionJson, IDICondition.class);
                }
                alarmObj.setStartCondition(startCondition);
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)alarmObj));
                this.getView().close();
            }
        } else if ("propdisplayname".equals(key)) {
            this.showFieldSelectList();
        } else if (KEY_STARTCONDITION.equals(key)) {
            this.showStartConditionForm();
        } else if (POINT_DEDUCT_CONFIG.equals(key)) {
            this.showPointDeductConfig();
        }
    }

    private void showPointDeductConfig() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_IDI_GENERAL_POINT_DEDUCT);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORMID_IDI_GENERAL_POINT_DEDUCT));
        showParameter.getCustomParams().put(POINT_DEDUCT_CONFIG_VALUE, this.getModel().getValue(POINT_DEDUCT_CONFIG_VALUE));
        showParameter.getCustomParams().put(KEY_ANALYSIS_MODE, this.getView().getFormShowParameter().getCustomParam(KEY_ANALYSIS_MODE));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showStartConditionForm() {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_ENTITY_NUMBER);
        if (entityNumber == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6e90\u5355\u201d\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"IDIAlarmFormPlugin_15", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String conditionJson = (String)this.getModel().getValue(KEY_STARTCONDITIONJSON_TAG);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_IDI_CONDITION_EDIT);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put(CUSTPARAMKEY_ENTITY_NUMBER, entityNumber);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONID_SET_START_CONDITION));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private boolean validate() {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_ENTITY_NUMBER);
        List<String> limitSelectEntryNumbers = this.getLimitSelectEntryNumbers();
        Set inValidEntryEntityNumbers = EntityMetadataCache.getDataEntityType((String)entityNumber).getAllEntities().keySet().stream().filter(number -> !number.equals(entityNumber)).filter(number -> !limitSelectEntryNumbers.contains(number)).collect(Collectors.toSet());
        int index = 1;
        for (DynamicObject hoverSetting : this.getModel().getEntryEntity("entryentity")) {
            String propName = hoverSetting.getString("propname");
            if (StringUtils.isBlank((CharSequence)propName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5c06\u60ac\u505c\u5c55\u793a\u5b57\u6bb5\u5f55\u5165\u5b8c\u6574\u3002", (String)"IDIAlarmFormPlugin_13", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (inValidEntryEntityNumbers.contains(propName.split("\\.")[0])) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60ac\u505c\u4fe1\u606f\u7b2c%s\u884c\u6240\u9009\u62e9\u7684\u5b57\u6bb5\u4e0d\u5728\u68c0\u67e5\u6761\u4ef6\u7684\u5206\u5f55\u5b57\u6bb5\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IDIAlarmFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]), index));
                return false;
            }
            ++index;
        }
        return true;
    }

    private void showFieldSelectList() {
        int pointIndex;
        DynamicProperty property;
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_ENTITY_NUMBER);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("idi_fieldlist");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam(CUSTPARAMKEY_ENTITY_NUMBER, (Object)entityNumber);
        String selectedPropName = (String)this.getModel().getValue("propname", this.getModel().getEntryCurrentRowIndex("entryentity"));
        if (StringUtils.isNotBlank((CharSequence)selectedPropName) && (property = EntityMetadataCache.getDataEntityType((String)entityNumber).getProperty(selectedPropName.split("\\.")[0])) instanceof EntryProp && (pointIndex = selectedPropName.indexOf(".")) > -1 && pointIndex + 1 < selectedPropName.length() - 1) {
            selectedPropName = selectedPropName.substring(pointIndex + 1);
        }
        fsp.setCustomParam("currentSelectField", (Object)selectedPropName);
        fsp.setCustomParam("limitfields", this.getLimitSelectEntryNumbers());
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fieldSelectPageCloseBack"));
        this.getView().showForm(fsp);
    }

    private List<String> getLimitSelectEntryNumbers() {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_ENTITY_NUMBER);
        ArrayList<String> limitEntryEntityNumberList = new ArrayList<String>(4);
        Map allFields = EntityMetadataCache.getDataEntityType((String)entityNumber).getAllFields();
        List filterRows = ((FilterGrid)this.getControl(KEY_FILTERGRID)).getFilterGridState().getFilterCondition().getFilterRow();
        for (SimpleFilterRow filterRow : filterRows) {
            String fieldName = filterRow.getFieldName().split("\\.")[0];
            IDataEntityType parentEntityType = ((IDataEntityProperty)allFields.get(fieldName)).getParent();
            String parentNumber = parentEntityType.getName();
            if (limitEntryEntityNumberList.contains(parentNumber) || !(parentEntityType instanceof EntryType)) continue;
            limitEntryEntityNumberList.add(parentNumber);
        }
        return limitEntryEntityNumberList;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int entryRowCount;
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if ("newentry".equals(keyName) && (entryRowCount = this.getModel().getEntryRowCount("entryentity")) >= 4) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60ac\u505c\u4fe1\u606f\u914d\u7f6e\u5206\u5f55\u53ea\u5141\u8bb8\u65b0\u589e4\u884c\u5206\u5f55\u3002", (String)"IDIAlarmFormPlugin_11", (String)"data-idi-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        if ("fieldSelectPageCloseBack".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            String[][] returnData = (String[][])closedCallBackEvent.getReturnData();
            int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            for (String[] field : returnData) {
                if (field == null) continue;
                this.getModel().setValue("propname", (Object)field[0], currentIndex);
                this.getModel().setValue("propdisplayname", (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDIAlarmFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]), field[1]), currentIndex);
                break;
            }
        } else if (ACTIONID_SET_START_CONDITION.equals(actionId)) {
            if (result != null) {
                this.dealReturnStartCondition(result.toString());
            }
        } else if (FORMID_IDI_GENERAL_POINT_DEDUCT.equals(actionId) && result != null) {
            List resultList = IDIJSONUtils.jsonCastToList((String)((String)result), DeductionGradeConfig.class);
            if (resultList.isEmpty()) {
                this.getModel().setValue(POINT_DEDUCT_CONFIG, (Object)"");
            } else {
                this.getModel().setValue(POINT_DEDUCT_CONFIG, (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDIAlarmFormPlugin_16", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue(POINT_DEDUCT_CONFIG_VALUE, result);
        }
    }

    private void dealReturnStartCondition(String conditionJson) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)conditionJson)) {
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class);
            if (condition == null) {
                this.getModel().setValue(KEY_STARTCONDITION, (Object)"");
                this.getModel().setValue(KEY_STARTCONDITIONJSON_TAG, (Object)"");
            } else {
                String exprTran = ExprDescUtils.getExprDesc((IDICondition)condition);
                this.getModel().setValue(KEY_STARTCONDITION, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDIAlarmFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]), exprTran));
                this.getModel().setValue(KEY_STARTCONDITIONJSON_TAG, (Object)conditionJson);
            }
        }
    }

    public void filterGridF7Click(FilterGridF7ClickEvent filterGridF7ClickEvent) {
        filterGridF7ClickEvent.setCancel(true);
    }
}

