/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.IBasedataField;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.FilterGridF7ClickEvent;
import kd.bos.form.control.events.FilterGridF7ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.data.idi.data.IDICondition;
import kd.data.idi.util.CompareColumnHelper;
import kd.data.idi.util.IDIJSONUtils;

public class IDICrossEntryRuleFormPlugin
extends AbstractFormPlugin
implements FilterGridF7ClickListener {
    private static final String CONTROL_BTNOK = "btnok";
    private static final String CONTROL_FILTER = "filtergridap";
    private static final String PARAM_SOURCEENTITYNUMBER = "entitynumber";
    private static final String PARAM_TARGETCONDITIONCONFIG = "formula";

    public void initialize() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(CONTROL_FILTER);
        filterGrid.addFilterGridF7ClickEvents((FilterGridF7ClickListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String sourceNumber = this.getSourceEntityNumber();
        if (sourceNumber != null && !sourceNumber.isEmpty()) {
            EntityTypeUtil helper = new EntityTypeUtil();
            List<Map<String, Object>> cols = this.createFieldMap(sourceNumber, helper);
            FilterGrid filterGrid = (FilterGrid)this.getControl(CONTROL_FILTER);
            CompareColumnHelper.processPropertyName((String)sourceNumber, cols);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(sourceNumber);
            filterGrid.setFieldColumns(cols);
        }
    }

    public void afterBindData(EventObject e) {
        IDICondition conditionObj;
        FilterCondition filterCondition;
        String conditionJson = this.getConditionJson();
        if (StringUtils.isNotEmpty((CharSequence)conditionJson) && (filterCondition = (conditionObj = (IDICondition)SerializationUtils.fromJsonString((String)conditionJson, IDICondition.class)).getFilterCondition()) != null) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(CONTROL_FILTER);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void filterGridF7Click(FilterGridF7ClickEvent e) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getSourceEntityNumber());
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)entityType, false);
        for (Map fieldMap : cols) {
            Integer fieldType;
            if (!e.getFieldName().equals(fieldMap.get("fieldName")) || (fieldType = (Integer)fieldMap.get("fieldType")) != 91 && fieldType != 93) continue;
            e.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        IDICondition condition;
        Control control = (Control)evt.getSource();
        if (CONTROL_BTNOK.equalsIgnoreCase(control.getKey()) && this.validate(condition = this.getCondition())) {
            this.getView().returnDataToParent((Object)IDIJSONUtils.toJsonString((Object)condition));
            this.getView().close();
        }
    }

    private List<Map<String, Object>> createFieldMap(String entityNumber, EntityTypeUtil helper) {
        List fieldEqualCompareType = CompareColumnHelper.getFieldEqualCompareType();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List filterFields = helper.getFilterFields((IDataEntityType)entityType, false);
        ArrayList<Map<String, Object>> resultFieldCols = new ArrayList<Map<String, Object>>(filterFields.size());
        Iterator filterFieldIterator = filterFields.iterator();
        HashSet baseDataIdSet = new HashSet(8);
        while (filterFieldIterator.hasNext()) {
            FilterField filterField = (FilterField)filterFieldIterator.next();
            if (!(filterField.getSrcFieldProp().getParent() instanceof EntryType)) continue;
            Map filterColumn = filterField.createFilterColumn();
            filterColumn.put("compareTypes", fieldEqualCompareType);
            if (filterField.getLatestParent() instanceof IBasedataField) {
                CompareColumnHelper.baseDataTextFieldCompare((FilterField)filterField, (Map)filterColumn);
                Map idColumn = CompareColumnHelper.genIdColumnMap((FilterField)filterField, baseDataIdSet, (MainEntityType)entityType, (List)fieldEqualCompareType);
                if (idColumn != null) {
                    resultFieldCols.add(idColumn);
                }
            }
            resultFieldCols.add(filterColumn);
        }
        return resultFieldCols;
    }

    private IDICondition getCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(CONTROL_FILTER);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String sourceNumber = this.getSourceEntityNumber();
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)sourceNumber);
        List<FilterField> sourceFields = this.addCompareField(sourceNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataType, filterGridState.getFilterCondition(), true, sourceFields);
        filterBuilder.setTimeService((ITimeService)this.getView().getService(ITimeService.class));
        filterBuilder.setUserService((IUserService)this.getView().getService(IUserService.class));
        filterBuilder.getFilterObject().addCompareFileds(sourceFields);
        filterBuilder.buildFilter(false);
        FilterObject fo = filterBuilder.getFilterObject();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.setFilter(fo.getFilter());
        IDICondition condition = new IDICondition();
        condition.setDescription(new LocaleString(fo.getFilter()));
        condition.setFilterCondition(fc);
        return condition;
    }

    private List<FilterField> addCompareField(String entityNumber) {
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List fieldFilter = helper.getFilterFields((IDataEntityType)sourceEntityType, false);
            List fieldEqualCompareType = CompareColumnHelper.getFieldEqualCompareType();
            ArrayList<FilterField> idFieldList = new ArrayList<FilterField>(10);
            HashSet idSet = new HashSet(10);
            for (FilterField ff : fieldFilter) {
                if (ff.getSrcFieldProp().getParent() instanceof EntryType) {
                    FilterField idFilterField;
                    ff.setCompareTypes(fieldEqualCompareType);
                    if (ff.getLatestParent() instanceof IBasedataField && (idFilterField = CompareColumnHelper.genIdField((FilterField)ff, idSet, (MainEntityType)sourceEntityType, (List)fieldEqualCompareType)) != null) {
                        idFieldList.add(idFilterField);
                    }
                }
                if (!(ff.getSrcFieldProp().getParent() instanceof SubEntryType)) continue;
                int parentPrefix = ff.getSrcFieldProp().getParent().getParent().getName().length() + 1;
                ff.setFullFieldName(ff.getFullFieldName().substring(parentPrefix));
            }
            fieldFilter.addAll(idFieldList);
            for (FilterField ff : fieldFilter) {
                ff.setFieldName(ff.getFullFieldName());
            }
            return fieldFilter;
        }
        return null;
    }

    private boolean validate(IDICondition condition) {
        IFormView view = this.getView();
        if (condition == null || condition.getFilterCondition() == null || condition.getDescription() == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5\u3001\u6bd4\u8f83\u6761\u4ef6\u3001\u76ee\u6807\u5355\u5b57\u6bb5\u8bf7\u5f55\u5165\u5b8c\u6574\u3002", (String)"IDIQueryTargetBillFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashSet<String> differentEntrySet = new HashSet<String>(2);
        FilterCondition filterCondition = condition.getFilterCondition();
        List filterRow = filterCondition.getFilterRow();
        if (filterRow != null && !filterRow.isEmpty()) {
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                String fieldName = simpleFilterRow.getFieldName();
                String valueName = ((FilterValue)simpleFilterRow.getValue().get(0)).getValue().toString();
                String leftEntryName = fieldName.substring(0, fieldName.indexOf(46));
                String rightEntryName = valueName.substring(0, valueName.indexOf(46));
                differentEntrySet.add(leftEntryName);
                differentEntrySet.add(rightEntryName);
                if (differentEntrySet.size() <= 2) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u914d\u7f6e\u4e24\u4e2a\u5206\u5f55\u95f4\u7684\u8de8\u5206\u5f55\u5173\u8054\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IDICrossEntryRuleFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private String getSourceEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAM_SOURCEENTITYNUMBER);
    }

    private String getConditionJson() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAM_TARGETCONDITIONCONFIG);
    }
}

