/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.EntryType;
import kd.bos.entity.FeatureOption;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.show.DimensionModel;
import kd.data.idi.data.show.FasindexModel;
import kd.data.idi.data.show.FasindexTableDataModel;

public class IDIDataRiskCheckPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(IDIDataRiskCheckPlugin.class);
    private static final String KEY_AUTOTEXT = "key_autotext";
    private static final String KEY_ENTRYENTITY = "entryentity";

    protected FasindexModel getEntryColumnAndData(IFormView view) {
        String entryInfoJson = (String)view.getFormShowParameter().getCustomParam("riskData");
        if (StringUtils.isEmpty((String)entryInfoJson)) {
            return null;
        }
        try {
            return (FasindexModel)JSONUtils.cast((String)entryInfoJson, FasindexModel.class);
        }
        catch (IOException ioException) {
            log.error("json cast Error\uff1a" + ioException.getMessage());
            this.getView().showTipNotification(ResManager.loadKDString((String)"JSON\u8f6c\u6362\u5f02\u5e38\u3002", (String)"IDIDataRiskCheckPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return null;
        }
    }

    public void initialize() {
        this.initRunTimeColumnMeta();
    }

    private void initRunTimeColumnMeta() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FasindexModel fasindexModel = this.getEntryColumnAndData(view);
        if (fasindexModel == null) {
            return;
        }
        MainEntityType mainType = model.getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        List tableData = fasindexModel.getTableData();
        if (tableData != null && !tableData.isEmpty()) {
            ArrayList<TextEdit> controlList = new ArrayList<TextEdit>(tableData.size() + 1);
            FasindexTableDataModel fasindexTableDataModel = (FasindexTableDataModel)tableData.get(0);
            List dimension = fasindexTableDataModel.getDimension();
            Container entryContainer = (Container)this.getControl(KEY_ENTRYENTITY);
            for (int i = 0; i < dimension.size() + 2; ++i) {
                LocaleString localeString = null;
                localeString = i == 0 ? new LocaleString(ResManager.loadKDString((String)"\u503c\u7c7b\u578b", (String)"IDIDataRiskCheckPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0])) : (i == 1 ? new LocaleString(ResManager.loadKDString((String)"\u6307\u6807\u503c", (String)"IDIDataRiskCheckPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0])) : new LocaleString(((DimensionModel)dimension.get(i - 2)).getKey()));
                EntryFieldAp entryFieldAp = new EntryFieldAp();
                TextField textField = new TextField();
                textField.setId(Uuid8.generateShortUuid());
                textField.setKey(KEY_AUTOTEXT + i);
                textField.setName(localeString);
                textField.setMustInput(true);
                textField.setEntityMetadata(entityMeta);
                entityMeta.getItems().add(textField);
                entryFieldAp.setId(Uuid8.generateShortUuid());
                entryFieldAp.setFieldId(Uuid8.generateShortUuid());
                entryFieldAp.setKey(KEY_AUTOTEXT + i);
                entryFieldAp.setName(localeString);
                entryFieldAp.setField((Field)textField);
                entryFieldAp.setWidth(new LocaleString("100px"));
                TextEdit textEdit = (TextEdit)entryFieldAp.buildRuntimeControl();
                textEdit.setFieldKey(KEY_AUTOTEXT + i);
                textEdit.setModel(model);
                textEdit.setView(view);
                textEdit.setEntryKey(KEY_ENTRYENTITY);
                entryContainer.getItems().add(textEdit);
                controlList.add(textEdit);
            }
            view.createControlIndex(controlList);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.buildColumnUI(view);
        this.buildDataToShowEntry(model, view);
    }

    private void buildDataToShowEntry(IDataModel model, IFormView view) {
        FasindexModel fasindexModel = this.getEntryColumnAndData(view);
        if (fasindexModel == null) {
            return;
        }
        List tableData = fasindexModel.getTableData();
        model.setValue("title", (Object)fasindexModel.getTitle());
        if (tableData != null && !tableData.isEmpty()) {
            for (FasindexTableDataModel tableDatum : tableData) {
                List dimension = tableDatum.getDimension();
                int entryRow = model.createNewEntryRow(KEY_ENTRYENTITY);
                for (int i = 0; i < dimension.size() + 2; ++i) {
                    String value;
                    if (i == 0) {
                        value = tableDatum.getValueType();
                        if (StringUtils.isEmpty((String)value)) {
                            value = ResManager.loadKDString((String)"\u672c\u671f\u503c", (String)"IDIDataRiskCheckPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]);
                        }
                    } else if (i == 1) {
                        value = tableDatum.getValue();
                        if (StringUtils.isEmpty((String)value) || "null".equals(value)) {
                            value = "-";
                        }
                    } else {
                        value = ((DimensionModel)dimension.get(i - 2)).getValue();
                        if (StringUtils.isEmpty((String)value) || "null".equals(value)) {
                            value = "-";
                        }
                    }
                    model.setValue(KEY_AUTOTEXT + i, (Object)value, entryRow);
                }
            }
            view.updateView(KEY_ENTRYENTITY);
        }
    }

    private void buildColumnUI(IFormView view) {
        try {
            FasindexModel fasindexModel = this.getEntryColumnAndData(view);
            if (fasindexModel == null) {
                return;
            }
            List tableData = fasindexModel.getTableData();
            if (tableData != null && !tableData.isEmpty()) {
                List dimension = ((FasindexTableDataModel)tableData.get(0)).getDimension();
                IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
                ArrayList<Map<String, Object>> columnList = new ArrayList<Map<String, Object>>(10);
                HashMap<String, Object> entryEntityMap = new HashMap<String, Object>(4);
                entryEntityMap.put("rk", "rk");
                entryEntityMap.put("fseq", "fseq");
                for (int i = 0; i < dimension.size() + 2; ++i) {
                    String name = i == 0 ? ResManager.loadKDString((String)"\u503c\u7c7b\u578b", (String)"IDIDataRiskCheckPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]) : (i == 1 ? ResManager.loadKDString((String)"\u6307\u6807\u503c", (String)"IDIDataRiskCheckPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]) : ((DimensionModel)dimension.get(i - 2)).getKey());
                    columnList.add(this.genColumn(KEY_AUTOTEXT + i, name, this.genTextEditor()));
                }
                entryEntityMap.put("columns", columnList);
                clientViewProxy.preInvokeControlMethod(KEY_ENTRYENTITY, "createGridColumns", new Object[]{entryEntityMap});
            }
        }
        catch (Exception ex) {
            log.error(String.format("PADynamicEntryFormPlugin.buildColumnUI error : %s", ex.getMessage()));
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType oldMainType = e.getOriginalEntityType();
            MainEntityType newMainType = (MainEntityType)oldMainType.clone();
            if (newMainType == null) {
                return;
            }
            IFormView view = this.getView();
            this.registerDynamicProps(newMainType, view);
            newMainType.createPropIndexsNoCache();
            e.setNewEntityType(newMainType);
        }
        catch (Exception ex) {
            log.error(String.format("PADynamicEntryFormPlugin.getEntityType error : %s", ex.getMessage()));
        }
    }

    private void registerDynamicProps(MainEntityType newMainType, IFormView view) {
        FasindexModel fasindexModel = this.getEntryColumnAndData(view);
        if (fasindexModel == null) {
            return;
        }
        List tableData = fasindexModel.getTableData();
        if (tableData != null && !tableData.isEmpty()) {
            List dimension = ((FasindexTableDataModel)tableData.get(0)).getDimension();
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(KEY_ENTRYENTITY);
            for (int i = 0; i < dimension.size() + 2; ++i) {
                LocaleString localeString = null;
                localeString = i == 0 ? new LocaleString(ResManager.loadKDString((String)"\u503c\u7c7b\u578b", (String)"IDIDataRiskCheckPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0])) : (i == 1 ? new LocaleString(ResManager.loadKDString((String)"\u6307\u6807\u503c", (String)"IDIDataRiskCheckPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0])) : new LocaleString(((DimensionModel)dimension.get(i - 2)).getKey()));
                TextProp textProp = new TextProp();
                textProp.setName(KEY_AUTOTEXT + i);
                textProp.setDisplayName(localeString);
                textProp.setFeatures(FeatureOption.Copyable.getValue());
                entryType.addProperty((DynamicProperty)textProp);
            }
        }
    }

    private Map<String, Object> genTextEditor() {
        HashMap<String, Object> editor = new HashMap<String, Object>(4);
        editor.put("mi", false);
        editor.put("type", "text");
        editor.put("showEditButton", Boolean.FALSE);
        editor.put("isshowtooltip", Boolean.TRUE);
        return editor;
    }

    private Map<String, Object> genColumn(String key, String column, Map<String, Object> editor) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("dataIndex", key);
        map.put("filter", true);
        map.put("l", 0);
        map.put("vi", 63);
        map.put("sort", true);
        map.put("w", new LocaleString("100px"));
        map.put("header", new LocaleString(column));
        map.put("editor", editor);
        map.put("visible", true);
        return map;
    }
}

