/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.util.FilterGridHelper;

public class IDIFieldListFormPlugin
extends AbstractFormPlugin {
    private static final String FIELD_ENTRYENTITY = "entryentity";
    private static final String FIELD_PROPDISPLAYNAME = "propdisplayname";
    private static final String FIELD_PROPNAME = "propname";
    private static final String CUSTOM_ENTITYNUMBER = "entitynumber";
    private static final String CUSTOM_CURRENTSELECTFIELD = "currentSelectField";
    private static final String CONTROL_BTNOK = "btnok";
    private static final String CUSTOM_ONLYHEADFIELD = "onlyheadfield";
    private static final String CONTROL_LIMITFIELDS = "limitfields";
    private static final String CUSTOM_ATTACHMENTFIELD = "attachmentField";
    private static final String CustomParam_ONLY_ATTACHMENTFILENAME = "onlyAttachmentFileName";
    private static final String CUSTOM_SUPPORTSUBENTRY = "supportSubEntry";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_BTNOK});
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        String currentSelectField = (String)fsp.getCustomParam(CUSTOM_CURRENTSELECTFIELD);
        List limitFieldSet = (List)fsp.getCustomParam(CONTROL_LIMITFIELDS);
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField(FIELD_PROPDISPLAYNAME, new Object[0]);
        tvs.addField(FIELD_PROPNAME, new Object[0]);
        int currentRowIndex = 0;
        int needSelectRowIndex = -1;
        String attachmentFieldJson = (String)fsp.getCustomParam(CUSTOM_ATTACHMENTFIELD);
        Object onlyAttachmentFileName = fsp.getCustomParam(CustomParam_ONLY_ATTACHMENTFILENAME);
        if (onlyAttachmentFileName != null && ((Boolean)onlyAttachmentFileName).booleanValue()) {
            needSelectRowIndex = 0;
            tvs.addRow(new Object[]{ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0", (String)"IDIFieldListFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), "filename"});
        } else if (attachmentFieldJson != null) {
            Map fieldClassifyMap = (Map)JSON.parseObject((String)attachmentFieldJson, (TypeReference)new TypeReference<Map<Long, List<AttachmentField>>>(){}, (Feature[])new Feature[0]);
            if (fieldClassifyMap != null && !fieldClassifyMap.isEmpty()) {
                ++currentRowIndex;
                tvs.addRow(new Object[]{ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0", (String)"IDIFieldListFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), "filename"});
                if ("filename".equalsIgnoreCase(currentSelectField)) {
                    needSelectRowIndex = 0;
                }
                for (Map.Entry entry : fieldClassifyMap.entrySet()) {
                    Long templateId = (Long)entry.getKey();
                    List value = (List)entry.getValue();
                    for (AttachmentField attachmentField : value) {
                        String fieldName = attachmentField.getFullName();
                        if (limitFieldSet != null && !limitFieldSet.isEmpty() && limitFieldSet.contains(fieldName)) continue;
                        String showFiledName = templateId != null ? templateId + "," + fieldName : fieldName;
                        tvs.addRow(new Object[]{attachmentField.getFullDisplayName(), showFiledName});
                        if (showFiledName.equalsIgnoreCase(currentSelectField)) {
                            needSelectRowIndex = currentRowIndex;
                        }
                        ++currentRowIndex;
                    }
                }
            }
        } else {
            String billEntityType = (String)fsp.getCustomParam(CUSTOM_ENTITYNUMBER);
            if (StringUtils.isNotEmpty((String)billEntityType)) {
                String onlyHeadField = (String)fsp.getCustomParam(CUSTOM_ONLYHEADFIELD);
                boolean isBillFlow = fsp.getCustomParam("isbillflow") == null ? false : (Boolean)fsp.getCustomParam("isbillflow");
                boolean isOnlyHeadField = !StringUtils.isBlank((String)onlyHeadField) && Boolean.parseBoolean(onlyHeadField);
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billEntityType);
                Map entityTypeMap = entityType.getAllEntities();
                List cols = this.isSupportSubEntry() ? FilterGridHelper.getAllFilterColumns((MainEntityType)entityType) : FilterGridHelper.getFilterColumns((MainEntityType)entityType, (boolean)isOnlyHeadField);
                for (Map map : cols) {
                    boolean isEntry;
                    String columnType;
                    String entryEntity = (String)map.get("entryEntity");
                    String fieldName = (String)map.get("fieldName");
                    String fieldCaption = (String)map.get("fieldCaption");
                    if (isBillFlow && !"date".equalsIgnoreCase(columnType = (String)map.get("type")) && !"datetime".equalsIgnoreCase(columnType)) continue;
                    String value = fieldName;
                    boolean entryEntityNotEmpty = StringUtils.isNotEmpty((String)entryEntity);
                    boolean bl = isEntry = !billEntityType.equals(entryEntity);
                    if (entryEntityNotEmpty && isEntry) {
                        EntityType entryType = (EntityType)entityTypeMap.get(entryEntity);
                        String string = value = entryType instanceof SubEntryType ? entryType.getParent().getName() + "." + entryEntity + "." + fieldName : entryEntity + "." + fieldName;
                    }
                    if (entryEntityNotEmpty && isEntry && limitFieldSet != null && !limitFieldSet.contains(entryEntity)) continue;
                    tvs.addRow(new Object[]{fieldCaption, value});
                    if (fieldName.equalsIgnoreCase(currentSelectField)) {
                        needSelectRowIndex = currentRowIndex;
                    }
                    ++currentRowIndex;
                }
            }
        }
        if (tvs.getCount() > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow(FIELD_ENTRYENTITY, tvs);
            model.endInit();
            view.updateView(FIELD_ENTRYENTITY);
        }
        if (needSelectRowIndex > -1) {
            EntryGrid entry = (EntryGrid)this.getControl(FIELD_ENTRYENTITY);
            entry.selectRows(needSelectRowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (CONTROL_BTNOK.equalsIgnoreCase(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(FIELD_ENTRYENTITY);
            int[] indexs = entry.getSelectRows();
            String[][] fields = new String[indexs.length][2];
            int i = 0;
            for (int index : indexs) {
                String[] row = new String[]{(String)this.getModel().getValue(FIELD_PROPNAME, index), (String)this.getModel().getValue(FIELD_PROPDISPLAYNAME, index)};
                fields[i++] = row;
            }
            this.getView().returnDataToParent((Object)fields);
            this.getView().close();
        }
    }

    private boolean isSupportSubEntry() {
        return Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_SUPPORTSUBENTRY));
    }
}

