/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.data.idi.data.BillControlTypeEnum;
import kd.data.idi.data.GradeItem;
import kd.data.idi.util.IDIJSONUtils;

public class IDIGradeFormPlugin
extends AbstractFormPlugin {
    private static final String CustomParam_GRADE_LIST_CONTENT = "gradeListContent";
    private static final String Key_BTNOK = "btnok";
    private static final String Key_CONDITION = "condition";
    private static final String Key_GRADECOLOR = "gradecolor";
    private static final String Key_GRADELIST = "gradelist";
    private static final String Key_MARKVALUE = "markvalue";
    private static final String Key_SCRIPT = "script";
    private static final String Key_MORE_THAN = "morethan";
    private static final String Key_OTHER = "other";
    private static final String Key_CONTROLTYPE = "controltype";
    private static Log logger = LogFactory.getLog(IDIGradeFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        String contentListStr = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_GRADE_LIST_CONTENT);
        ArrayList<GradeItem> gradeItemList = null;
        if (StringUtils.isNotEmpty((String)contentListStr) && !"[]".equals(contentListStr)) {
            gradeItemList = IDIJSONUtils.jsonCastToList((String)contentListStr, GradeItem.class);
        } else {
            gradeItemList = new ArrayList();
            GradeItem var1 = new GradeItem(Key_MORE_THAN, 60.0f, ResManager.loadKDString((String)"\u4f18\u79c0", (String)"IDIGradeFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), "green", BillControlTypeEnum.NOCONTROL);
            GradeItem var2 = new GradeItem(Key_OTHER, 0.0f, ResManager.loadKDString((String)"\u4e0d\u5408\u683c", (String)"IDIGradeFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]), "red", BillControlTypeEnum.NOCONTROL);
            gradeItemList.add(var1);
            gradeItemList.add(var2);
        }
        this.fillEntity(gradeItemList);
    }

    private void fillEntity(List<GradeItem> gradeItems) {
        for (GradeItem gradeItem : gradeItems) {
            int rowNum = this.getModel().createNewEntryRow(Key_GRADELIST);
            this.getModel().setValue(Key_CONDITION, (Object)gradeItem.getCondition(), rowNum);
            this.getModel().setValue(Key_MARKVALUE, (Object)Float.valueOf(gradeItem.getGrade()), rowNum);
            this.getModel().setValue(Key_GRADECOLOR, (Object)gradeItem.getShowColor(), rowNum);
            this.getModel().setValue(Key_SCRIPT, (Object)gradeItem.getShowScript(), rowNum);
            BillControlTypeEnum controlType = gradeItem.getBillControl() == null ? BillControlTypeEnum.NOCONTROL : gradeItem.getBillControl();
            this.getModel().setValue(Key_CONTROLTYPE, (Object)controlType.getType(), rowNum);
        }
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_BTNOK});
        this.addItemClickListeners(new String[]{Key_CONDITION});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (name.equalsIgnoreCase(Key_CONDITION)) {
            int currentRow = this.getModel().getEntryCurrentRowIndex(Key_GRADELIST);
            this.getModel().setValue(Key_MARKVALUE, (Object)0, currentRow);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "btnok": {
                String returnData = this.getReturnData();
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
            }
        }
    }

    private String getReturnData() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(Key_GRADELIST);
        ArrayList<GradeItem> gradeItemList = new ArrayList<GradeItem>(collection.size());
        for (DynamicObject obj : collection) {
            GradeItem gradeItem = new GradeItem();
            String condition = obj.getString(Key_CONDITION);
            gradeItem.setCondition(condition);
            gradeItem.setGrade(Float.parseFloat(obj.getString(Key_MARKVALUE)));
            gradeItem.setShowColor(obj.getString(Key_GRADECOLOR));
            gradeItem.setShowScript(obj.getString(Key_SCRIPT));
            gradeItem.setBillControl(BillControlTypeEnum.convert((String)obj.getString(Key_CONTROLTYPE)));
            gradeItemList.add(gradeItem);
        }
        return IDIJSONUtils.toJsonString(gradeItemList);
    }
}

