/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AnalysisMode;
import kd.data.idi.data.CustomInvoiceParam;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.InvoiceCheckItemType;
import kd.data.idi.data.InvoiceConfig;
import kd.data.idi.data.InvoiceConfigCustom;
import kd.data.idi.data.InvoiceDecisionRule;
import kd.data.idi.formplugin.IDIInvoiceCustomFormPlugin;
import kd.data.idi.util.IDIJSONUtils;

public class IDIInvoiceFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeClickListener {
    private static final String KEY_CONTROL_ITEMENTRY = "itementry";
    private static final String KEY_CONTROL_ADDITEM = "additem";
    private static final String KEY_CONTROL_OK = "btnok";
    private static final String KEY_CONTROL_PANEL = "configpanel";
    private static final String KEY_FIELD_COMPLETEDOFSTAMP = "iscompletedofstamp";
    private static final String KEY_FIELD_FROMDATE = "fromdate";
    private static final String KEY_FIELD_FROMDATEFIELD = "fromdatefield";
    private static final String KEY_FIELD_COMPANYFIELD = "companyfield";
    private static final String KEY_FIELD_INVOICETYPE_TXT = "invoicetype_txt";
    private static final String KEY_FIELD_CUSTOMCONFIGJSON = "customconfigjson";
    private static final String KEY_FIELD_INVOICETYPE = "invoicetype";
    private static final String KEY_FIELD_CHECKNAME = "checkname";
    private static final String KEY_PARAMETER_ENTITYNUMBER = "entitynumber";
    private static final String KEY_PARAMETER_DETAILCONFIG = "detailConfig";
    private static final String KEY_PARAMETER_ONLYHEADFIELD = "onlyheadfield";
    private static final String KEY_OPERATE_DELETEENTRY = "deleteentry";
    private static final String KEY_OPERATE_NEWRULEENTRY = "newruleentry";
    private static final String CustParamKey_TreeNodes = "treenodes";
    private static final String Key_RULE = "rule";
    private static final String Key_RULE_JSON = "rulejson";
    private static final String Key_RULE_LIST = "rulelist";
    private static final String FormId_IDI_CONDITION_EDIT = "idi_condition_edit";
    private static final String CustParamKey_FORMULA = "formula";
    private static final String ActionId_RULE = "rule";
    private static final String Key_TITLE = "title";
    private static final String Key_SHOWWORDS = "showwords";
    private static final String Key_ISPASS = "ispass";
    private static final String Key_STATUS = "status";
    private static final String KEY_OCRINVOICECONDITION = "ocrinvoicecondition";
    private static final String KEY_OCRINVOICEJSON = "ocrinvoicejson";
    private static final String SET_OCR_INVOICE_CONDITION = "setOcrInvoiceCondition";
    private Map<String, String> InvoiceTypeMap = null;
    private static final String Key_ANALYSIS_MODE = "analysis_mode";
    private static final String POINT_DEDUCT_CONFIG = "point_deduct_config";
    private static final String POINT_DEDUCT_CONFIG_VALUE = "point_deduct_config_value";
    private static final String PREPARE_ENTRYENTITY = "prepare_entryentity";
    private static final String CHECKITEM_NAME = "checkitem_name";
    private static final String IS_ENABLE = "is_enable";
    private static final String CHECKITEM_PARAMCONFIG = "checkitem_paramconfig";
    private static final String PARAMCONFIG_VALUE = "paramconfig_value";
    private static final String POINTS_DEDUCT_PROPORTION = "points_deduct_proportion";
    private static final String POINTS_DEDUCT_PROPORTION2 = "points_deduct_proportion2";
    private static final String FORMID_IDI_GENERAL_POINT_DEDUCT = "general_point_deduct";
    private static final String FORMID_IDI_INVOICE_PARAMCONFIG = "idi_invoice_paramconfig";
    private static final String KEY_NUMBERRANGE = "numberrange";
    private static final String KEY_FIELD_NOINVOICETIP = "noinvoicetip";
    private static final String KEY_SHOWALLCHECKTRUE = "showallchecktrue";
    private static final String KEY_USECUSTOMINVOICEPARAM = "usecustominvoiceparam";
    private static final String KEY_CUSTOMINVOICEPARAM = "custominvoiceparam";
    private static final String KEY_CUSTOMINVOICEPARAMJSON = "custominvoiceparamjson";
    private static final String ACTION_CUSTOMINVOICEPARAMACTION = "setcustominvoiceparam";
    private static final String KEY_STARTCONDITION = "startcondition";
    private static final String KEY_STARTCONDITIONJSON_TAG = "startconditionjson_tag";
    private static final String ActionId_SET_START_CONDITION = "setStartCondition";

    public void initialize() {
        super.initialize();
        EntryGrid customConfigEntry = (EntryGrid)this.getView().getControl(KEY_CONTROL_ITEMENTRY);
        customConfigEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FIELD_COMPLETEDOFSTAMP});
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = this.getSourceEntityNumber();
        String detailConfig = (String)fsp.getCustomParam(KEY_PARAMETER_DETAILCONFIG);
        String onlyHeadField = (String)fsp.getCustomParam(KEY_PARAMETER_ONLYHEADFIELD);
        boolean isOnlyHeadField = !StringUtils.isBlank((String)onlyHeadField) && Boolean.parseBoolean(onlyHeadField);
        List cols = null;
        if (StringUtils.isNotEmpty((String)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            cols = helper.getFilterColumns((IDataEntityType)entityType, isOnlyHeadField);
            this.initCompanyFieldCombo(entityType, isOnlyHeadField);
        }
        AbstractFormDataModel absModel = (AbstractFormDataModel)this.getModel();
        absModel.beginInit();
        TableValueSetter prepareTvs = new TableValueSetter(new String[0]);
        prepareTvs.addField(CHECKITEM_NAME, new Object[0]);
        prepareTvs.addField(IS_ENABLE, new Object[0]);
        prepareTvs.addField(CHECKITEM_PARAMCONFIG, new Object[0]);
        prepareTvs.addField(PARAMCONFIG_VALUE, new Object[0]);
        prepareTvs.addField(POINTS_DEDUCT_PROPORTION, new Object[0]);
        InvoiceConfig invoiceConfig = (InvoiceConfig)IDIJSONUtils.cast((String)detailConfig, InvoiceConfig.class);
        if (invoiceConfig != null) {
            this.getModel().setValue(KEY_USECUSTOMINVOICEPARAM, (Object)invoiceConfig.isUseCustomInvoiceParam());
            if (invoiceConfig.isUseCustomInvoiceParam()) {
                this.getModel().setValue(KEY_CUSTOMINVOICEPARAMJSON, (Object)IDIJSONUtils.toJsonString((Object)invoiceConfig.getCustomInvoiceParam()));
                this.getModel().setValue(KEY_CUSTOMINVOICEPARAM, (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        }
        String analysisMode = (String)this.getView().getFormShowParameter().getCustomParam(Key_ANALYSIS_MODE);
        boolean isNoScore = AnalysisMode.NOSCORE.getType().equalsIgnoreCase(analysisMode);
        prepareTvs.addRow(new Object[]{InvoiceCheckItemType.VERIFICATION_AUTHENTICITY.getDescription(), invoiceConfig == null ? null : Boolean.valueOf(invoiceConfig.isCertifiedOfInvoice()), "", "", isNoScore || invoiceConfig == null ? 0 : invoiceConfig.getCertifiedOfInvoiceDeductionGradePercent()});
        prepareTvs.addRow(new Object[]{InvoiceCheckItemType.INVOICE_REUSABLE.getDescription(), invoiceConfig == null ? null : Boolean.valueOf(invoiceConfig.isDuplicate()), "", "", isNoScore || invoiceConfig == null ? 0 : invoiceConfig.getDuplicateDeductionGradePercent()});
        prepareTvs.addRow(new Object[]{InvoiceCheckItemType.INVOICE_TITLE_INSPECTION.getDescription(), invoiceConfig == null ? null : Boolean.valueOf(invoiceConfig.isCheckInvoiceHeader()), "", "", isNoScore || invoiceConfig == null ? 0 : invoiceConfig.getCheckInvoiceHeaderDeductionGradePercent()});
        prepareTvs.addRow(new Object[]{InvoiceCheckItemType.BUYER_TAX_IDENTIFICATION_NUMBER.getDescription(), invoiceConfig == null ? null : Boolean.valueOf(invoiceConfig.isBuyerTaxCode()), "", "", isNoScore || invoiceConfig == null ? 0 : invoiceConfig.getBuyerTaxCodeDeductionGradePercent()});
        prepareTvs.addRow(new Object[]{InvoiceCheckItemType.VENDOR_INFORMATION_COMPLETE.getDescription(), invoiceConfig == null ? null : Boolean.valueOf(invoiceConfig.isCompletedOfSalerInfo()), "", "", isNoScore || invoiceConfig == null ? 0 : invoiceConfig.getCompletedOfSalerInfoDeductionGradePercent()});
        prepareTvs.addRow(new Object[]{InvoiceCheckItemType.BUYER_INFORMATION_COMPLETE.getDescription(), invoiceConfig == null ? null : Boolean.valueOf(invoiceConfig.isCompletedOfBuyerInfo()), "", "", isNoScore || invoiceConfig == null ? 0 : invoiceConfig.getCompletedOfBuyerInfoDeductionGradePercent()});
        prepareTvs.addRow(new Object[]{InvoiceCheckItemType.INVOICE_FULL_AMOUNT_INSPECTION.getDescription(), invoiceConfig == null ? null : Boolean.valueOf(invoiceConfig.isFullAmountOfAllInvoices()), invoiceConfig == null ? null : this.getNameByProperty(cols, invoiceConfig.getAmountFieldName()), invoiceConfig == null ? null : invoiceConfig.getAmountFieldName(), isNoScore || invoiceConfig == null ? 0 : invoiceConfig.getFullAmountOfAllInvoicesDeductionGradePercent()});
        HashMap<String, Object> paramConfigValueMap = new HashMap<String, Object>(2);
        paramConfigValueMap.put(KEY_FIELD_FROMDATEFIELD, invoiceConfig == null ? null : invoiceConfig.getRequestDateField());
        paramConfigValueMap.put(KEY_FIELD_FROMDATE, invoiceConfig == null ? null : invoiceConfig.getFromDate());
        prepareTvs.addRow(new Object[]{InvoiceCheckItemType.CROSS_YEAR_REIMBURSEMENT.getDescription(), invoiceConfig == null ? null : Boolean.valueOf(invoiceConfig.isCrossOneYear()), invoiceConfig == null ? null : this.getNameByProperty(cols, invoiceConfig.getRequestDateField()), paramConfigValueMap.get(KEY_FIELD_FROMDATEFIELD) == null && paramConfigValueMap.get(KEY_FIELD_FROMDATE) == null ? null : IDIJSONUtils.toJsonString(paramConfigValueMap), isNoScore || invoiceConfig == null ? 0 : invoiceConfig.getCrossOneYearDeductionGradePercent()});
        prepareTvs.addRow(new Object[]{InvoiceCheckItemType.CONTINUOUS_NUMBER.getDescription(), invoiceConfig == null ? null : Boolean.valueOf(invoiceConfig.isContinuousNumber()), invoiceConfig != null && invoiceConfig.isContinuousNumber() ? String.format(ResManager.loadKDString((String)"\u8fde\u53f7\u8303\u56f4\uff1a%s", (String)"IDIInvoiceFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]), invoiceConfig.getNumberRange()) : null, invoiceConfig != null && invoiceConfig.isContinuousNumber() ? String.valueOf(invoiceConfig.getNumberRange()) : null, isNoScore || invoiceConfig == null ? 0 : invoiceConfig.getContinuousNumberGradePercent()});
        absModel.batchCreateNewEntryRow(PREPARE_ENTRYENTITY, prepareTvs);
        absModel.endInit();
        this.getView().updateView(PREPARE_ENTRYENTITY);
        for (int k = 0; k < 9; ++k) {
            Boolean isEnable = (Boolean)this.getModel().getValue(IS_ENABLE, k);
            if (k < 6) {
                this.getView().setEnable(Boolean.FALSE, k, new String[]{CHECKITEM_PARAMCONFIG});
                this.getView().setEnable(isEnable, k, new String[]{POINTS_DEDUCT_PROPORTION});
                continue;
            }
            this.getView().setEnable(isEnable, k, new String[]{CHECKITEM_PARAMCONFIG, POINTS_DEDUCT_PROPORTION});
        }
        if (isNoScore) {
            this.getView().setVisible(Boolean.FALSE, new String[]{POINTS_DEDUCT_PROPORTION, POINTS_DEDUCT_PROPORTION2});
            this.getModel().setValue(POINTS_DEDUCT_PROPORTION, (Object)0);
            this.getModel().setValue(POINTS_DEDUCT_PROPORTION2, (Object)0);
        }
        this.InvoiceTypeMap = this.getInvoiceTypeCaption();
        if (invoiceConfig != null) {
            List itemList;
            List deductionGradeConfigList = invoiceConfig.getDeductionGradeConfigList();
            if (deductionGradeConfigList != null && !deductionGradeConfigList.isEmpty()) {
                this.getModel().setValue(POINT_DEDUCT_CONFIG, (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDIInvoiceFormPlugin_17", (String)"data-idi-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(POINT_DEDUCT_CONFIG_VALUE, (Object)IDIJSONUtils.toJsonString((Object)deductionGradeConfigList));
            }
            IDataModel model = this.getModel();
            if (invoiceConfig.getIdiCondition() != null) {
                model.setValue(KEY_OCRINVOICECONDITION, (Object)invoiceConfig.getIdiCondition().getExprTran());
                model.setValue(KEY_OCRINVOICEJSON, (Object)IDIJSONUtils.toJsonString((Object)invoiceConfig.getIdiCondition()));
            }
            model.setValue(KEY_FIELD_COMPANYFIELD, (Object)invoiceConfig.getCompanyFieldName());
            if (StringUtils.isEmpty((String)invoiceConfig.getNoInvoiceTip())) {
                model.setValue(KEY_FIELD_NOINVOICETIP, (Object)ResManager.loadKDString((String)"\u65e0\u53d1\u7968\u4fe1\u606f", (String)"IDIInvoiceFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]));
            } else {
                model.setValue(KEY_FIELD_NOINVOICETIP, (Object)invoiceConfig.getNoInvoiceTip());
            }
            IDICondition startCondition = invoiceConfig.getStartCondition();
            if (startCondition != null) {
                model.setValue(KEY_STARTCONDITIONJSON_TAG, (Object)IDIJSONUtils.toJsonString((Object)startCondition));
                this.getModel().setValue(KEY_STARTCONDITION, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDISchemaFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), this.getExprDesc(startCondition)));
            }
            if ((itemList = invoiceConfig.getCustomList()) != null && !itemList.isEmpty()) {
                AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
                abstractModel.beginInit();
                TableValueSetter tvs = new TableValueSetter(new String[0]);
                tvs.addField(KEY_FIELD_INVOICETYPE_TXT, new Object[0]);
                tvs.addField(KEY_FIELD_CUSTOMCONFIGJSON, new Object[0]);
                for (InvoiceConfigCustom item : itemList) {
                    if (StringUtils.isEmpty((String)item.getCheckName())) {
                        tvs.addRow(new Object[]{this.InvoiceTypeMap.get(item.getInvoiceType()), IDIJSONUtils.toJsonString((Object)item)});
                        continue;
                    }
                    tvs.addRow(new Object[]{item.getCheckName(), IDIJSONUtils.toJsonString((Object)item)});
                }
                abstractModel.batchCreateNewEntryRow(KEY_CONTROL_ITEMENTRY, tvs);
                abstractModel.endInit();
                this.getView().updateView(KEY_CONTROL_ITEMENTRY);
                this.updatePanel(0);
            } else {
                this.updatePanel(-1);
            }
        } else {
            this.getModel().setValue(KEY_FIELD_NOINVOICETIP, (Object)ResManager.loadKDString((String)"\u65e0\u53d1\u7968\u4fe1\u606f", (String)"IDIInvoiceFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
    }

    private String getNameByProperty(List<Map<String, Object>> cols, String property) {
        if (cols == null || StringUtils.isEmpty((String)property)) {
            return null;
        }
        for (Map<String, Object> map : cols) {
            if (!((String)map.get("fieldName")).equalsIgnoreCase(property)) continue;
            return (String)map.get("fieldCaption");
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int rowCount = this.getModel().getEntryRowCount(KEY_CONTROL_ITEMENTRY);
        if (rowCount > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_CONTROL_ITEMENTRY);
            entryGrid.selectRows(0);
        }
    }

    private void updatePanel(int i) {
        IDataModel model = this.getModel();
        if (i >= 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CONTROL_PANEL});
            String customConfigStr = (String)model.getValue(KEY_FIELD_CUSTOMCONFIGJSON, i);
            if (!StringUtils.isEmpty((String)customConfigStr)) {
                InvoiceConfigCustom config = (InvoiceConfigCustom)IDIJSONUtils.cast((String)customConfigStr, InvoiceConfigCustom.class);
                model.setValue(KEY_FIELD_INVOICETYPE, (Object)config.getInvoiceType());
                model.setValue(KEY_FIELD_CHECKNAME, (Object)config.getCheckName());
                model.deleteEntryData(Key_RULE_LIST);
                List ruleList = config.getRuleList();
                if (ruleList != null && !ruleList.isEmpty()) {
                    AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
                    abstractModel.beginInit();
                    TableValueSetter tvs = new TableValueSetter(new String[0]);
                    tvs.addField(Key_TITLE, new Object[0]);
                    tvs.addField(Key_SHOWWORDS, new Object[0]);
                    tvs.addField(Key_ISPASS, new Object[0]);
                    tvs.addField(Key_RULE_JSON, new Object[0]);
                    tvs.addField(Key_STATUS, new Object[0]);
                    tvs.addField("rule", new Object[0]);
                    tvs.addField(POINTS_DEDUCT_PROPORTION2, new Object[0]);
                    tvs.addField(KEY_SHOWALLCHECKTRUE, new Object[0]);
                    for (InvoiceDecisionRule rule : ruleList) {
                        IDICondition condition = rule.getCondition();
                        String ruleJson = condition == null ? "" : IDIJSONUtils.toJsonString((Object)condition);
                        tvs.addRow(new Object[]{rule.getName(), rule.getShowWords(), rule.isPass(), ruleJson, rule.getDecisionStatus(), this.getExprDesc(condition), rule.getDeductionGradePercent(), rule.isShowAllCheckTrue()});
                    }
                    abstractModel.batchCreateNewEntryRow(Key_RULE_LIST, tvs);
                    abstractModel.endInit();
                    this.getView().updateView(Key_RULE_LIST);
                } else {
                    int ruleCount = model.getEntryRowCount(Key_RULE_LIST);
                    if (ruleCount == 0) {
                        model.createNewEntryRow(Key_RULE_LIST);
                        model.createNewEntryRow(Key_RULE_LIST);
                    }
                }
            } else {
                model.setValue(KEY_FIELD_INVOICETYPE, (Object)"");
                model.setValue(KEY_FIELD_CHECKNAME, (Object)"");
                int ruleCount = model.getEntryRowCount(Key_RULE_LIST);
                if (ruleCount == 0) {
                    model.createNewEntryRow(Key_RULE_LIST);
                    model.createNewEntryRow(Key_RULE_LIST);
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CONTROL_PANEL});
            model.setValue(KEY_FIELD_INVOICETYPE, (Object)"");
            model.setValue(KEY_FIELD_CHECKNAME, (Object)"");
        }
    }

    private Map<String, String> getInvoiceTypeCaption() {
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_FIELD_INVOICETYPE);
        ComboProp prop = (ComboProp)comboEdit.getProperty();
        List itemList = prop.getComboItems();
        HashMap<String, String> map = new HashMap<String, String>(itemList.size());
        for (ValueMapItem item : itemList) {
            map.put(item.getValue(), item.getName().toString());
        }
        return map;
    }

    private void initCompanyFieldCombo(MainEntityType entityType, boolean isOnlyHeadField) {
        if (entityType == null) {
            return;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        Map propertyMap = entityType.getAllFields();
        for (IDataEntityProperty prop : propertyMap.values()) {
            if (!(prop instanceof OrgProp)) continue;
            ComboItem item = new ComboItem();
            item.setValue(IDIInvoiceFormPlugin.buildPropORMFullName(prop));
            item.setCaption(new LocaleString(this.getFullFieldCaption(prop)));
            list.add(item);
        }
        if (!list.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_FIELD_COMPANYFIELD);
            comboEdit.setComboItems(list);
        }
    }

    public static String buildPropORMFullName(IDataEntityProperty prop) {
        String fullPropName = prop.getParent() instanceof SubEntryType ? String.format("%s.%s.%s", prop.getParent().getParent().getName(), prop.getParent().getName(), prop.getName()) : (prop.getParent() instanceof EntryType ? String.format("%s.%s", prop.getParent().getName(), prop.getName()) : (prop.getName().startsWith(prop.getParent().getName() + "__") ? String.format("%s.%s", prop.getParent().getName(), prop.getName()) : prop.getName()));
        return fullPropName;
    }

    public String getFullFieldCaption(IDataEntityProperty prop) {
        String fullPropName = prop.getParent() instanceof SubEntryType ? String.format("%s.%s.%s", prop.getParent().getParent().getDisplayName().toString(), prop.getParent().getDisplayName().toString(), prop.getDisplayName().toString()) : (prop.getParent() instanceof EntryType ? String.format("%s.%s", prop.getParent().getDisplayName().toString(), prop.getDisplayName().toString()) : (prop.getDisplayName().toString().startsWith(prop.getParent().getDisplayName().toString() + "__") ? String.format("%s.%s", prop.getParent().getDisplayName().toString(), prop.getDisplayName().toString()) : prop.getDisplayName().toString()));
        return fullPropName;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String invoiceType;
        super.beforeDoOperation(evt);
        FormOperate formOperate = (FormOperate)evt.getSource();
        String operateKey = formOperate.getOperateKey();
        if (KEY_OPERATE_NEWRULEENTRY.equals(operateKey) && StringUtils.isEmpty((String)(invoiceType = (String)this.getModel().getValue(KEY_FIELD_INVOICETYPE)))) {
            evt.cancel = true;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7968\u636e\u7c7b\u578b\u201d\u3002", (String)"IDIInvoiceFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (propertyName) {
            case "rule": {
                if (!StringUtils.isEmpty((String)((String)newValue))) break;
                int curRow = this.getModel().getEntryCurrentRowIndex(Key_RULE_LIST);
                this.getModel().setValue(Key_RULE_JSON, (Object)"", curRow);
                this.getModel().setValue("rule", (Object)"", curRow);
                break;
            }
            case "invoicetype": {
                int rowCount = this.getModel().getEntryRowCount(KEY_CONTROL_ITEMENTRY);
                this.changeInvoiceType((String)newValue, rowCount);
                break;
            }
            case "checkname": {
                int rowCount = this.getModel().getEntryRowCount(KEY_CONTROL_ITEMENTRY);
                this.changeCheckName((String)newValue, rowCount);
                break;
            }
            case "ocrinvoicecondition": {
                String ocrInvoiceCondition = (String)this.getModel().getValue(KEY_OCRINVOICECONDITION);
                if (!StringUtils.isEmpty((String)ocrInvoiceCondition)) break;
                this.getModel().setValue(KEY_OCRINVOICEJSON, (Object)"");
                break;
            }
            case "point_deduct_config": {
                String pointDeductConfig = (String)this.getModel().getValue(POINT_DEDUCT_CONFIG);
                if (!StringUtils.isEmpty((String)pointDeductConfig)) break;
                this.getModel().setValue(POINT_DEDUCT_CONFIG_VALUE, (Object)"");
                break;
            }
            case "is_enable": {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(PREPARE_ENTRYENTITY);
                if (6 == currentRowIndex || 7 == currentRowIndex || 8 == currentRowIndex) {
                    this.getView().setEnable((Boolean)newValue, currentRowIndex, new String[]{CHECKITEM_PARAMCONFIG});
                }
                this.getView().setEnable((Boolean)newValue, currentRowIndex, new String[]{POINTS_DEDUCT_PROPORTION});
                if (!((Boolean)newValue).booleanValue()) {
                    this.getModel().setValue(CHECKITEM_PARAMCONFIG, null, currentRowIndex);
                    this.getModel().setValue(PARAMCONFIG_VALUE, null, currentRowIndex);
                    this.getModel().setValue(POINTS_DEDUCT_PROPORTION, null, currentRowIndex);
                    break;
                }
                if (8 != currentRowIndex) break;
                this.getModel().setValue(CHECKITEM_PARAMCONFIG, (Object)String.format(ResManager.loadKDString((String)"\u8fde\u53f7\u8303\u56f4\uff1a%s", (String)"IDIInvoiceFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]), 1), currentRowIndex);
                this.getModel().setValue(PARAMCONFIG_VALUE, (Object)"1", currentRowIndex);
                break;
            }
            case "checkitem_paramconfig": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(PREPARE_ENTRYENTITY);
                if (!StringUtils.isEmpty((String)((String)newValue))) break;
                this.getModel().setValue(PARAMCONFIG_VALUE, null, rowIndex);
                break;
            }
            case "custominvoiceparam": {
                if (!StringUtils.isEmpty((String)((String)newValue))) break;
                this.getModel().setValue(KEY_CUSTOMINVOICEPARAMJSON, null);
            }
        }
    }

    private void changeCheckName(String newCheckName, int rowCount) {
        int itemCurrentRowIndex;
        IDataModel model = this.getModel();
        if (rowCount > 0 && (itemCurrentRowIndex = model.getEntryCurrentRowIndex(KEY_CONTROL_ITEMENTRY)) < rowCount) {
            if (StringUtils.isEmpty((String)newCheckName)) {
                String invoiceType = (String)model.getValue(KEY_FIELD_INVOICETYPE);
                this.InvoiceTypeMap = this.getInvoiceTypeCaption();
                String invoiceText = this.InvoiceTypeMap.get(invoiceType);
                model.setValue(KEY_FIELD_INVOICETYPE_TXT, (Object)invoiceText, itemCurrentRowIndex);
            } else {
                model.setValue(KEY_FIELD_INVOICETYPE_TXT, (Object)newCheckName, itemCurrentRowIndex);
            }
        }
    }

    private void changeInvoiceType(String newInvoiceType, int rowCount) {
        IDataModel model = this.getModel();
        if (rowCount > 0) {
            int itemCurrentRowIndex = model.getEntryCurrentRowIndex(KEY_CONTROL_ITEMENTRY);
            String checkName = (String)model.getValue(KEY_FIELD_CHECKNAME);
            if (itemCurrentRowIndex < rowCount && StringUtils.isEmpty((String)checkName)) {
                this.InvoiceTypeMap = this.getInvoiceTypeCaption();
                String invoiceText = this.InvoiceTypeMap.get(newInvoiceType);
                model.setValue(KEY_FIELD_INVOICETYPE_TXT, (Object)invoiceText, itemCurrentRowIndex);
            }
            model.deleteEntryData(Key_RULE_LIST);
            int ruleCount = model.getEntryRowCount(Key_RULE_LIST);
            if (ruleCount == 0) {
                model.createNewEntryRow(Key_RULE_LIST);
                model.createNewEntryRow(Key_RULE_LIST);
            }
        }
    }

    private void updateTreeNode(TreeNode treeNode, MainEntityType billEntityType, String billNumber) {
        String newRootId = billNumber + "_billObj";
        treeNode.setId(newRootId);
        treeNode.setParentid("root");
        if (treeNode.getChildren() == null) {
            return;
        }
        Map entityTypeMap = billEntityType.getAllEntities();
        for (TreeNode node : treeNode.getChildren()) {
            node.setParentid(treeNode.getId());
            EntityType entityType = (EntityType)entityTypeMap.get(node.getId());
            String newNodeId = entityType instanceof SubEntryType ? treeNode.getId() + "." + entityType.getParent().getName() + "." + node.getId() : treeNode.getId() + "." + node.getId();
            node.setId(newNodeId);
            if (node.getChildren() == null) continue;
            this.updateTreeNodeChild(node);
        }
    }

    private void updateTreeNodeChild(TreeNode parentNode) {
        boolean isHeadField = parentNode.getId().endsWith("billhead");
        for (TreeNode node : parentNode.getChildren()) {
            node.setParentid(parentNode.getId());
            String newNodeId = isHeadField ? parentNode.getId().replace("billhead", node.getId()) : (node.getId().indexOf(46) > -1 ? parentNode.getId() + node.getId().substring(node.getId().lastIndexOf(46)) : parentNode.getId() + "." + node.getId());
            node.setId(newNodeId);
            if (node.getChildren() == null) continue;
            this.updateTreeNodeChild(node);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_CONTROL_ADDITEM, KEY_CONTROL_OK, "rule", KEY_OCRINVOICECONDITION, POINT_DEDUCT_CONFIG, CHECKITEM_PARAMCONFIG, KEY_CUSTOMINVOICEPARAM, KEY_STARTCONDITION});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "rule": {
                this.doClickRule();
                break;
            }
            case "btnok": {
                int rowCount = this.getModel().getEntryRowCount(KEY_CONTROL_ITEMENTRY);
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_CONTROL_ITEMENTRY);
                if (rowCount > 0 && currentRowIndex > -1) {
                    this.saveRuleToItem(currentRowIndex);
                }
                if (!this.validate()) break;
                String result = this.save();
                this.getView().returnDataToParent((Object)result);
                this.getView().close();
                break;
            }
            case "additem": {
                this.addItemEntry();
                break;
            }
            case "ocrinvoicecondition": {
                this.showOcrInvoiceCondition();
                break;
            }
            case "point_deduct_config": {
                this.showPointDeductConfig();
                break;
            }
            case "checkitem_paramconfig": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(PREPARE_ENTRYENTITY);
                String paramConfigValue = (String)this.getModel().getValue(PARAMCONFIG_VALUE, rowIndex);
                this.showCheckItemParamConfig(rowIndex, paramConfigValue);
                break;
            }
            case "custominvoiceparam": {
                IDIInvoiceCustomFormPlugin.openInvoiceCustomPage(this, this.getSourceEntityNumber(), (String)this.getModel().getValue(KEY_CUSTOMINVOICEPARAMJSON), ACTION_CUSTOMINVOICEPARAMACTION);
                break;
            }
            case "startcondition": {
                this.showStartConditionForm();
                break;
            }
        }
    }

    private void showStartConditionForm() {
        String entityNumber = this.getSourceEntityNumber();
        if (entityNumber == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6e90\u5355\u201d\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"IDISchemaFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        BillEntityType sourceBill = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        String conditionJson = (String)this.getModel().getValue(KEY_STARTCONDITIONJSON_TAG);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(CustParamKey_FORMULA, conditionJson);
        customParams.put(KEY_PARAMETER_ENTITYNUMBER, sourceBill.getName());
        this.showForm(FormId_IDI_CONDITION_EDIT, customParams, ActionId_SET_START_CONDITION);
    }

    private void showForm(String formId, Map<String, Object> customParam, String closeCallBackActionID) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6", (String)"IDISchemaFormPlugin_23", (String)"data-idi-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParams(customParam);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackActionID));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showPointDeductConfig() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_IDI_GENERAL_POINT_DEDUCT);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORMID_IDI_GENERAL_POINT_DEDUCT));
        showParameter.getCustomParams().put(POINT_DEDUCT_CONFIG_VALUE, this.getModel().getValue(POINT_DEDUCT_CONFIG_VALUE));
        showParameter.getCustomParams().put(Key_ANALYSIS_MODE, this.getView().getFormShowParameter().getCustomParam(Key_ANALYSIS_MODE));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showCheckItemParamConfig(int rowIndex, String paramConfigValue) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_IDI_INVOICE_PARAMCONFIG);
        showParameter.getCustomParams().put("rowIndex", rowIndex);
        showParameter.getCustomParams().put(KEY_PARAMETER_ENTITYNUMBER, this.getSourceEntityNumber());
        if (StringUtils.isNotEmpty((String)paramConfigValue)) {
            if (6 == rowIndex) {
                showParameter.getCustomParams().put("amountFieldName", paramConfigValue);
            } else if (7 == rowIndex) {
                Map paramConfigMap = (Map)IDIJSONUtils.cast((String)paramConfigValue, Map.class);
                if (paramConfigMap != null) {
                    showParameter.getCustomParams().put(KEY_FIELD_FROMDATEFIELD, paramConfigMap.get(KEY_FIELD_FROMDATEFIELD));
                    showParameter.getCustomParams().put(KEY_FIELD_FROMDATE, paramConfigMap.get(KEY_FIELD_FROMDATE));
                }
            } else if (8 == rowIndex) {
                showParameter.getCustomParams().put(KEY_NUMBERRANGE, paramConfigValue);
            }
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORMID_IDI_INVOICE_PARAMCONFIG));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showOcrInvoiceCondition() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PARAMETER_ENTITYNUMBER);
        Objects.requireNonNull(sourceBill);
        String ocrInvoiceJson = (String)this.getModel().getValue(KEY_OCRINVOICEJSON);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormId_IDI_CONDITION_EDIT);
        showParameter.getCustomParams().put(CustParamKey_FORMULA, ocrInvoiceJson);
        showParameter.getCustomParams().put(KEY_PARAMETER_ENTITYNUMBER, "bos_invoice");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SET_OCR_INVOICE_CONDITION));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void doClickRule() {
        String invoiceType = (String)this.getModel().getValue(KEY_FIELD_INVOICETYPE);
        String entityNumber = this.getSourceEntityNumber();
        if (StringUtils.isEmpty((String)invoiceType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7968\u636e\u7c7b\u578b\u201d\u3002", (String)"IDIInvoiceFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        int curRow = this.getModel().getEntryCurrentRowIndex(Key_RULE_LIST);
        String conditionJson = (String)this.getModel().getValue(Key_RULE_JSON, curRow);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormId_IDI_CONDITION_EDIT);
        showParameter.getCustomParams().put(CustParamKey_FORMULA, conditionJson);
        showParameter.getCustomParams().put(KEY_PARAMETER_ENTITYNUMBER, entityNumber);
        TreeNode root = this.getRuleTreeNode();
        String fldNodes = SerializationUtils.toJsonString((Object)root);
        showParameter.getCustomParams().put(CustParamKey_TreeNodes, fldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rule"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private TreeNode getRuleTreeNode() {
        String invoiceType = (String)this.getModel().getValue(KEY_FIELD_INVOICETYPE);
        String entityNumber = this.getSourceEntityNumber();
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u5355\u636e&\u7968\u636e\u5bf9\u8c61", (String)"IDIInvoiceFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]), true);
        root.setIsOpened(true);
        MainEntityType sourceBillEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        TreeNode sourceBillTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceBillEntityType, null);
        this.updateTreeNode(sourceBillTreeNode, sourceBillEntityType, sourceBillEntityType.getName());
        root.addChild(sourceBillTreeNode);
        sourceBillTreeNode.setIsOpened(false);
        MainEntityType invoiceEntityType = EntityMetadataCache.getDataEntityType((String)invoiceType);
        PropTreeBuildOption optionInvoiceType = new PropTreeBuildOption();
        optionInvoiceType.setOnlyPhysicsField(false);
        TreeNode invoiceTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)invoiceEntityType, (PropTreeBuildOption)optionInvoiceType);
        this.updateTreeNode(invoiceTreeNode, invoiceEntityType, invoiceEntityType.getName());
        root.addChild(invoiceTreeNode);
        invoiceTreeNode.setIsOpened(false);
        return root;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "rule": {
                this.receiveCondition((String)result);
                break;
            }
            case "setOcrInvoiceCondition": {
                this.receiveOcrInvoiceCondition((String)result);
                break;
            }
            case "general_point_deduct": {
                if (result == null) break;
                List resultList = IDIJSONUtils.jsonCastToList((String)((String)result), DeductionGradeConfig.class);
                if (resultList.isEmpty()) {
                    this.getModel().setValue(POINT_DEDUCT_CONFIG, (Object)"");
                } else {
                    this.getModel().setValue(POINT_DEDUCT_CONFIG, (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDIInvoiceFormPlugin_17", (String)"data-idi-formplugin", (Object[])new Object[0]));
                }
                this.getModel().setValue(POINT_DEDUCT_CONFIG_VALUE, result);
                break;
            }
            case "idi_invoice_paramconfig": {
                Map resultMap;
                if (result == null || (resultMap = (Map)IDIJSONUtils.cast((String)result.toString(), Map.class)) == null) break;
                int rowIndex = this.getModel().getEntryCurrentRowIndex(PREPARE_ENTRYENTITY);
                this.getModel().setValue(CHECKITEM_PARAMCONFIG, resultMap.get(CHECKITEM_PARAMCONFIG), rowIndex);
                this.getModel().setValue(PARAMCONFIG_VALUE, resultMap.get(PARAMCONFIG_VALUE), rowIndex);
                break;
            }
            case "setcustominvoiceparam": {
                if (StringUtils.isEmpty((String)((String)result))) break;
                this.getModel().setValue(KEY_CUSTOMINVOICEPARAM, (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(KEY_CUSTOMINVOICEPARAMJSON, result);
                break;
            }
            case "setStartCondition": {
                if (result == null) break;
                this.dealReturnStartCondition(result.toString());
                break;
            }
        }
    }

    private void receiveOcrInvoiceCondition(String result) {
        IDICondition condition;
        if (!StringUtils.isEmpty((String)result) && (condition = (IDICondition)IDIJSONUtils.cast((String)result, IDICondition.class)) != null) {
            String exprTran = this.getExprDesc(condition);
            this.getModel().setValue(KEY_OCRINVOICECONDITION, (Object)exprTran);
            this.getModel().setValue(KEY_OCRINVOICEJSON, (Object)result);
        }
    }

    private void receiveCondition(String conditionJson) {
        int curRow = this.getModel().getEntryCurrentRowIndex(Key_RULE_LIST);
        if (StringUtils.isNotEmpty((String)conditionJson)) {
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class);
            String exprTran = this.getExprDesc(condition);
            this.getModel().setValue(Key_RULE_JSON, (Object)conditionJson, curRow);
            this.getModel().setValue("rule", (Object)exprTran, curRow);
        }
    }

    private String getExprDesc(IDICondition condition) {
        if (condition == null) {
            return "";
        }
        String handDesc = condition.getDescription().toString();
        if (StringUtils.isNotEmpty((String)handDesc)) {
            return handDesc;
        }
        return StringUtils.isNotEmpty((String)condition.getExprTran()) ? condition.getExprTran() : condition.getExpression();
    }

    private void addItemEntry() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(KEY_CONTROL_ITEMENTRY);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CONTROL_PANEL});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_CONTROL_ITEMENTRY);
        entryGrid.selectRows(rowCount - 1);
    }

    private String save() {
        IDICondition idiCondition;
        String numRange;
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(KEY_CONTROL_ITEMENTRY);
        InvoiceConfig ic = new InvoiceConfig();
        IDICondition startCondition = null;
        String startConditionJson = (String)this.getModel().getValue(KEY_STARTCONDITIONJSON_TAG);
        if (StringUtils.isNotEmpty((String)startConditionJson)) {
            startCondition = (IDICondition)IDIJSONUtils.cast((String)startConditionJson, IDICondition.class);
        }
        ic.setStartCondition(startCondition);
        ic.setCompanyFieldName((String)model.getValue(KEY_FIELD_COMPANYFIELD));
        ic.setNoInvoiceTip((String)model.getValue(KEY_FIELD_NOINVOICETIP));
        boolean useCustomInvoiceParam = (Boolean)model.getValue(KEY_USECUSTOMINVOICEPARAM);
        ic.setUseCustomInvoiceParam(useCustomInvoiceParam);
        if (useCustomInvoiceParam) {
            String customInvoiceParamStr = (String)model.getValue(KEY_CUSTOMINVOICEPARAMJSON);
            CustomInvoiceParam cip = (CustomInvoiceParam)IDIJSONUtils.cast((String)customInvoiceParamStr, CustomInvoiceParam.class);
            ic.setCustomInvoiceParam(cip);
        }
        ic.setCertifiedOfInvoice(((Boolean)model.getValue(IS_ENABLE, 0)).booleanValue());
        ic.setDuplicate(((Boolean)model.getValue(IS_ENABLE, 1)).booleanValue());
        ic.setCheckInvoiceHeader(((Boolean)model.getValue(IS_ENABLE, 2)).booleanValue());
        ic.setBuyerTaxCode(((Boolean)model.getValue(IS_ENABLE, 3)).booleanValue());
        ic.setCompletedOfSalerInfo(((Boolean)model.getValue(IS_ENABLE, 4)).booleanValue());
        ic.setCompletedOfBuyerInfo(((Boolean)model.getValue(IS_ENABLE, 5)).booleanValue());
        ic.setFullAmountOfAllInvoices(((Boolean)model.getValue(IS_ENABLE, 6)).booleanValue());
        ic.setCrossOneYear(((Boolean)model.getValue(IS_ENABLE, 7)).booleanValue());
        ic.setContinuousNumber(((Boolean)model.getValue(IS_ENABLE, 8)).booleanValue());
        ic.setAmountFieldName((String)this.getModel().getValue(PARAMCONFIG_VALUE, 6));
        String paramConfigValue = (String)this.getModel().getValue(PARAMCONFIG_VALUE, 7);
        if (StringUtils.isNotEmpty((String)paramConfigValue)) {
            Map paramConfigMap = (Map)IDIJSONUtils.cast((String)paramConfigValue, Map.class);
            if (paramConfigMap.get(KEY_FIELD_FROMDATE) != null) {
                ic.setFromDate(new Date((Long)paramConfigMap.get(KEY_FIELD_FROMDATE)));
            }
            ic.setRequestDateField((String)paramConfigMap.get(KEY_FIELD_FROMDATEFIELD));
        }
        ic.setNumberRange(StringUtils.isEmpty((String)(numRange = (String)this.getModel().getValue(PARAMCONFIG_VALUE, 8))) ? null : Integer.valueOf(Integer.parseInt(numRange)));
        ic.setCertifiedOfInvoiceDeductionGradePercent(((Integer)this.getModel().getValue(POINTS_DEDUCT_PROPORTION, 0)).intValue());
        ic.setDuplicateDeductionGradePercent(((Integer)this.getModel().getValue(POINTS_DEDUCT_PROPORTION, 1)).intValue());
        ic.setCheckInvoiceHeaderDeductionGradePercent(((Integer)this.getModel().getValue(POINTS_DEDUCT_PROPORTION, 2)).intValue());
        ic.setBuyerTaxCodeDeductionGradePercent(((Integer)this.getModel().getValue(POINTS_DEDUCT_PROPORTION, 3)).intValue());
        ic.setCompletedOfSalerInfoDeductionGradePercent(((Integer)this.getModel().getValue(POINTS_DEDUCT_PROPORTION, 4)).intValue());
        ic.setCompletedOfBuyerInfoDeductionGradePercent(((Integer)this.getModel().getValue(POINTS_DEDUCT_PROPORTION, 5)).intValue());
        ic.setFullAmountOfAllInvoicesDeductionGradePercent(((Integer)this.getModel().getValue(POINTS_DEDUCT_PROPORTION, 6)).intValue());
        ic.setCrossOneYearDeductionGradePercent(((Integer)this.getModel().getValue(POINTS_DEDUCT_PROPORTION, 7)).intValue());
        ic.setContinuousNumberGradePercent(((Integer)this.getModel().getValue(POINTS_DEDUCT_PROPORTION, 8)).intValue());
        String ocrInvoiceJson = (String)model.getValue(KEY_OCRINVOICEJSON);
        if (StringUtils.isNotEmpty((String)ocrInvoiceJson) && (idiCondition = (IDICondition)IDIJSONUtils.cast((String)ocrInvoiceJson, IDICondition.class)) != null) {
            ic.setIdiCondition(idiCondition);
        }
        String generalPointDeduct = (String)model.getValue(POINT_DEDUCT_CONFIG_VALUE);
        List deductionGradeConfigList = IDIJSONUtils.jsonCastToList((String)generalPointDeduct, DeductionGradeConfig.class);
        ic.setDeductionGradeConfigList(deductionGradeConfigList);
        ArrayList<Object> list = new ArrayList<Object>(rowCount);
        ic.setCustomList(list);
        for (int i = 0; i < rowCount; ++i) {
            String customJson = (String)model.getValue(KEY_FIELD_CUSTOMCONFIGJSON, i);
            list.add(IDIJSONUtils.cast((String)customJson, InvoiceConfigCustom.class));
        }
        String result = IDIJSONUtils.toJsonString((Object)ic);
        return result;
    }

    private boolean validate() {
        IDataModel model = this.getModel();
        String companyField = (String)model.getValue(KEY_FIELD_COMPANYFIELD);
        if (StringUtils.isEmpty((String)companyField)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6e90\u5355\u201d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201c\u3002", (String)"IDIInvoiceFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        String noInvoiceTip = (String)model.getValue(KEY_FIELD_NOINVOICETIP);
        if (StringUtils.isEmpty((String)noInvoiceTip)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5355\u636e\u65e0\u53d1\u7968\u65f6\u7684\u63d0\u793a\u8bed\u3002", (String)"IDIInvoiceFormPlugin_15", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean useCustomInvoiceParam = (Boolean)model.getValue(KEY_USECUSTOMINVOICEPARAM);
        String customInvoiceParam = (String)model.getValue(KEY_CUSTOMINVOICEPARAMJSON);
        if (useCustomInvoiceParam && StringUtils.isEmpty((String)customInvoiceParam)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\u3002", (String)"IDIInvoiceFormPlugin_16", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean fullAmountOfInvoices = (Boolean)model.getValue(IS_ENABLE, 6);
        String fullAmountOfInvoicesConfig = (String)model.getValue(PARAMCONFIG_VALUE, 6);
        if (fullAmountOfInvoices && StringUtils.isEmpty((String)fullAmountOfInvoicesConfig)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u53d1\u7968\u91d1\u989d\u8db3\u989d\u67e5\u9a8c\u7684\u68c0\u67e5\u53c2\u6570\u914d\u7f6e\u3002", (String)"IDIInvoiceFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean crossOneYear = (Boolean)model.getValue(IS_ENABLE, 7);
        String crossOneYearConfig = (String)model.getValue(PARAMCONFIG_VALUE, 7);
        if (crossOneYear && StringUtils.isEmpty((String)crossOneYearConfig)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u662f\u5426\u8fdd\u89c4\u8de8\u5e74\u62a5\u9500\u7684\u68c0\u67e5\u53c2\u6570\u914d\u7f6e\u3002", (String)"IDIInvoiceFormPlugin_11", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean isContinuousNumber = (Boolean)model.getValue(IS_ENABLE, 8);
        String numRange = (String)model.getValue(PARAMCONFIG_VALUE, 8);
        if (isContinuousNumber && StringUtils.isEmpty((String)numRange)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u53d1\u7968\u8fde\u53f7\u68c0\u67e5\u7684\u68c0\u67e5\u53c2\u6570\u914d\u7f6e\u3002", (String)"IDIInvoiceFormPlugin_13", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        int rowCount = model.getEntryRowCount(KEY_CONTROL_ITEMENTRY);
        ArrayList<Integer> deleteList = new ArrayList<Integer>();
        boolean checkCustom = false;
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                String text = (String)model.getValue(KEY_FIELD_INVOICETYPE_TXT, i);
                String config = (String)model.getValue(KEY_FIELD_CUSTOMCONFIGJSON, i);
                InvoiceConfigCustom item = (InvoiceConfigCustom)IDIJSONUtils.cast((String)config, InvoiceConfigCustom.class);
                String invoiceType = item.getInvoiceType();
                if (StringUtils.isEmpty((String)invoiceType)) {
                    deleteList.add(i);
                    continue;
                }
                List ruleList = item.getRuleList();
                if (ruleList != null && !ruleList.isEmpty()) {
                    for (int ruleIndex = 0; ruleIndex < ruleList.size(); ++ruleIndex) {
                        InvoiceDecisionRule rule = (InvoiceDecisionRule)ruleList.get(ruleIndex);
                        if (StringUtils.isEmpty((String)rule.getName())) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\uff08%1$s\uff09\u68c0\u67e5\u9879\u7b2c%2$d\u884c\u89c4\u5219\u201c%3$s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IDIInvoiceFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]), text, ruleIndex + 1, ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"IDIInvoiceFormPlugin_8", (String)"data-idi-formplugin", (Object[])new Object[0])));
                            return false;
                        }
                        if (!StringUtils.isEmpty((String)rule.getShowWords())) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\uff08%1$s\uff09\u68c0\u67e5\u9879\u7b2c%2$d\u884c\u89c4\u5219\u201c%3$s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IDIInvoiceFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]), text, ruleIndex + 1, ResManager.loadKDString((String)"\u663e\u793a\u8bdd\u672f", (String)"IDIInvoiceFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0])));
                        return false;
                    }
                    continue;
                }
                checkCustom = true;
            }
        }
        int[] deleteArr = new int[deleteList.size()];
        for (int i = 0; i < deleteArr.length; ++i) {
            deleteArr[i] = (Integer)deleteList.get(i);
        }
        model.deleteEntryRows(KEY_CONTROL_ITEMENTRY, deleteArr);
        if (checkCustom) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u914d\u7f6e\u5747\u4e0d\u4e3a\u7a7a\u624d\u80fd\u4fdd\u5b58\u3002", (String)"IDIInvoiceFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (KEY_OPERATE_DELETEENTRY.equals(operateKey)) {
            int rowCount = this.getModel().getEntryRowCount(KEY_CONTROL_ITEMENTRY);
            if (rowCount > 0) {
                int itemCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_CONTROL_ITEMENTRY);
                this.getPageCache().put("currow", itemCurrentRowIndex + "");
                this.getPageCache().put("deleteMark", "deleteMark");
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CONTROL_PANEL});
                this.getModel().setValue(KEY_FIELD_INVOICETYPE, null);
                this.getModel().setValue(KEY_FIELD_CHECKNAME, null);
                this.getModel().deleteEntryData(Key_RULE_LIST);
            }
        }
    }

    private void saveRuleToItem(Integer rowIndex) {
        IDataModel model = this.getModel();
        int itemRowCount = model.getEntryRowCount(KEY_CONTROL_ITEMENTRY);
        if (rowIndex < itemRowCount) {
            InvoiceConfigCustom customConfig = new InvoiceConfigCustom();
            String invoiceType = (String)model.getValue(KEY_FIELD_INVOICETYPE);
            customConfig.setInvoiceType(invoiceType);
            String checkName = (String)model.getValue(KEY_FIELD_CHECKNAME);
            customConfig.setCheckName(checkName);
            if (StringUtils.isNotEmpty((String)checkName)) {
                model.setValue(KEY_FIELD_INVOICETYPE_TXT, (Object)checkName, rowIndex.intValue());
            } else {
                this.InvoiceTypeMap = this.getInvoiceTypeCaption();
                String invoiceText = this.InvoiceTypeMap.get(invoiceType);
                model.setValue(KEY_FIELD_INVOICETYPE_TXT, (Object)invoiceText, rowIndex.intValue());
            }
            List<InvoiceDecisionRule> formulaDataList = this.getFormulaData();
            customConfig.setRuleList(formulaDataList);
            String configItemStr = IDIJSONUtils.toJsonString((Object)customConfig);
            model.setValue(KEY_FIELD_CUSTOMCONFIGJSON, (Object)configItemStr, rowIndex.intValue());
        }
    }

    private List<InvoiceDecisionRule> getFormulaData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_RULE_LIST);
        ArrayList<InvoiceDecisionRule> ruleList = new ArrayList<InvoiceDecisionRule>();
        if (entryEntity != null && !entryEntity.isEmpty()) {
            for (DynamicObject obj : entryEntity) {
                String name = obj.getString(Key_TITLE);
                String showWords = obj.getString(Key_SHOWWORDS);
                boolean isPass = obj.getBoolean(Key_ISPASS);
                String status = obj.getString(Key_STATUS);
                String ruleJson = obj.getString(Key_RULE_JSON);
                boolean showAllCheckTrue = obj.getBoolean(KEY_SHOWALLCHECKTRUE);
                int deductionGradePercent = obj.getInt(POINTS_DEDUCT_PROPORTION2);
                if (StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)showWords) && StringUtils.isEmpty((String)ruleJson)) continue;
                IDICondition formulaObj = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class);
                InvoiceDecisionRule rule = new InvoiceDecisionRule();
                rule.setName(name);
                rule.setShowWords(showWords);
                rule.setPass(isPass);
                rule.setDecisionStatus(status);
                rule.setCondition(formulaObj);
                rule.setDeductionGradePercent(deductionGradePercent);
                rule.setShowAllCheckTrue(showAllCheckTrue);
                ruleList.add(rule);
            }
        }
        return ruleList;
    }

    private String getSourceEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(KEY_PARAMETER_ENTITYNUMBER);
    }

    public void entryRowClick(RowClickEvent evt) {
        String curRow = this.getPageCache().get("currow");
        int oldRows = -1;
        if (!StringUtils.isEmpty((String)curRow)) {
            oldRows = Integer.parseInt(curRow);
        }
        int newRow = evt.getRow();
        this.getPageCache().put("currow", String.valueOf(evt.getRow()));
        String deleteMark = this.getPageCache().get("deleteMark");
        if (oldRows > -1 && StringUtils.isEmpty((String)deleteMark)) {
            this.saveRuleToItem(oldRows);
        } else {
            this.getPageCache().remove("deleteMark");
        }
        this.updatePanel(newRow);
    }

    private void dealReturnStartCondition(String conditionJson) {
        if (StringUtils.isNotEmpty((String)conditionJson)) {
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class);
            if (condition == null) {
                this.getModel().setValue(KEY_STARTCONDITION, (Object)"");
                this.getModel().setValue(KEY_STARTCONDITIONJSON_TAG, (Object)"");
            } else {
                String exprTran = this.getExprDesc(condition);
                this.getModel().setValue(KEY_STARTCONDITION, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDISchemaFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), exprTran));
                this.getModel().setValue(KEY_STARTCONDITIONJSON_TAG, (Object)conditionJson);
            }
        }
    }
}

