/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.data.idi.data.NewsConfig;
import kd.data.idi.data.NewsInfo;
import kd.data.idi.data.show.BusinessCatalogs;
import kd.data.idi.util.IDIDisclaimerUtil;
import kd.data.idi.util.IDIJSONUtils;

public class IDINewsFormPlugin
extends AbstractFormPlugin {
    private static final String CustomParam_DETAIL_CONFIG = "detailConfig";
    private static final String CustomParam_ENTITY_NUMBER = "entitynumber";
    private static final String CustomParam_ONLYHEADFIELD = "onlyheadfield";
    private static final String Key_BTNOK = "btnok";
    private static final String Key_BUSINFO_URL = "businfourl";
    private static final String Key_CHECK_BUSINFO = "businfo";
    private static final String Key_CHECK_NEWS = "news";
    private static final String Key_LIST_FIELD = "list_field";
    private static final String Key_NEWS_URL = "newsurl";
    private static final String Key_NEWS_COUNT = "newscount";
    private static final String CLOSED_CALLBACK_DISCLAIMER = "closedCallbackDisclaimer";
    private static final String Key_IS_ENABLE = "is_enable";
    private static Log logger = LogFactory.getLog(IDINewsFormPlugin.class);
    private Map<String, String> urlMap = new HashMap<String, String>(){
        {
            this.put(IDINewsFormPlugin.Key_CHECK_NEWS, IDINewsFormPlugin.Key_NEWS_URL);
            this.put(IDINewsFormPlugin.Key_CHECK_BUSINFO, IDINewsFormPlugin.Key_BUSINFO_URL);
        }
    };

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_BTNOK});
    }

    public void click(EventObject evt) {
        String actionKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (actionKey = ctl.getKey()) {
            case "btnok": {
                if (!this.preVerity()) {
                    return;
                }
                IFormView view = this.getView();
                Boolean isEnable = (Boolean)view.getFormShowParameter().getCustomParam(Key_IS_ENABLE);
                if (!IDIDisclaimerUtil.disclaimerStatus() && isEnable.booleanValue()) {
                    IDIDisclaimerUtil.showDisclaimer((IFormView)view, (AbstractFormPlugin)this);
                    return;
                }
                this.returnDataToParent(view);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (CLOSED_CALLBACK_DISCLAIMER.equalsIgnoreCase(actionId)) {
            IFormView view = this.getView();
            if (Boolean.parseBoolean(returnData)) {
                this.returnDataToParent(view);
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u672a\u63a5\u53d7\u514d\u8d23\u58f0\u660e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u65b0\u95fb\u7c7b\u68c0\u67e5\u9879\u3002", (String)"IDINewsFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void returnDataToParent(IFormView view) {
        String returnData = this.getReturnData();
        view.returnDataToParent((Object)returnData);
        view.close();
    }

    private boolean preVerity() {
        HashMap<String, String> checkboxMap = new HashMap<String, String>(){
            {
                this.put(IDINewsFormPlugin.Key_CHECK_NEWS, IDINewsFormPlugin.Key_NEWS_URL);
                this.put(IDINewsFormPlugin.Key_CHECK_BUSINFO, IDINewsFormPlugin.Key_BUSINFO_URL);
            }
        };
        boolean isNewsTypeNull = true;
        for (String key : checkboxMap.keySet()) {
            boolean result = (Boolean)this.getModel().getValue(key);
            if (!result) continue;
            isNewsTypeNull = false;
        }
        if (isNewsTypeNull) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8d44\u8baf\u7c7b\u578b\u201d\u3002", (String)"IDINewsFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean checkBusinfo = (Boolean)this.getModel().getValue(Key_CHECK_BUSINFO);
        if (checkBusinfo) {
            int count = 0;
            for (BusinessCatalogs option : BusinessCatalogs.values()) {
                boolean result = (Boolean)this.getModel().getValue(option.getField());
                if (!result) continue;
                ++count;
            }
            if (count == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5de5\u5546\u4fe1\u606f\u7c7b\u578b\u201d\u3002", (String)"IDINewsFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (count > 5) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5c55\u793a\u5de5\u5546\u4fe1\u606f\u201d\u6700\u591a\u52fe\u90095\u9879\u3002", (String)"IDINewsFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private String getReturnData() {
        String[] checkBoxArr = new String[]{Key_CHECK_NEWS, Key_CHECK_BUSINFO};
        NewsConfig newsConfig = new NewsConfig();
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        newsConfig.setEntityNumber(entityNumber);
        String fieldName = (String)this.getModel().getValue(Key_LIST_FIELD);
        if (StringUtils.isNotEmpty((String)fieldName)) {
            newsConfig.setFiledName(fieldName);
        }
        ArrayList<NewsInfo> showTypes = new ArrayList<NewsInfo>();
        for (String s : checkBoxArr) {
            Boolean value = (Boolean)this.getModel().getValue(s);
            if (!value.booleanValue()) continue;
            NewsInfo newsInfo = new NewsInfo();
            if (s.equalsIgnoreCase(Key_CHECK_NEWS)) {
                String newsCount = (String)this.getModel().getValue(Key_NEWS_COUNT);
                newsInfo.setNewsCount(newsCount);
            }
            String url = (String)this.getModel().getValue(this.urlMap.get(s));
            newsInfo.setNewsType(s);
            newsInfo.setUrl(url);
            showTypes.add(newsInfo);
        }
        newsConfig.setNewsType(showTypes);
        boolean isBusInfo = (Boolean)this.getModel().getValue(Key_CHECK_BUSINFO);
        if (isBusInfo) {
            ArrayList<String> catalogs = new ArrayList<String>();
            for (BusinessCatalogs option : BusinessCatalogs.values()) {
                boolean result = (Boolean)this.getModel().getValue(option.getField());
                if (!result) continue;
                catalogs.add(option.getKeyWord());
            }
            newsConfig.setBusinessCatalogs(catalogs);
        }
        return IDIJSONUtils.toJsonString((Object)newsConfig);
    }

    public void afterCreateNewData(EventObject e) {
        MainEntityType entityType;
        EntityTypeUtil helper;
        Object cols;
        List<ComboItem> comboItems;
        this.initNewsCount();
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        String onlyHeadField = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ONLYHEADFIELD);
        String detailConfig = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_DETAIL_CONFIG);
        if (StringUtils.isNotEmpty((String)entityNumber) && (comboItems = this.createComboItem(entityNumber, (List<Map<String, Object>>)(cols = (helper = new EntityTypeUtil()).getFilterColumns((IDataEntityType)(entityType = EntityMetadataCache.getDataEntityType((String)entityNumber)), !StringUtils.isBlank((String)onlyHeadField) && Boolean.parseBoolean(onlyHeadField))))) != null) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(Key_LIST_FIELD);
            comboEdit.setComboItems(comboItems);
        }
        if (StringUtils.isNotEmpty((String)detailConfig)) {
            NewsConfig newsConfig = (NewsConfig)IDIJSONUtils.cast((String)detailConfig, NewsConfig.class);
            this.getModel().setValue(Key_LIST_FIELD, (Object)newsConfig.getFiledName());
            List newsTypes = newsConfig.getNewsType();
            if (newsTypes == null) {
                return;
            }
            for (NewsInfo var : newsTypes) {
                String type = var.getNewsType();
                String url = var.getUrl();
                this.getModel().setValue(type, (Object)Boolean.TRUE);
                this.getModel().setValue(this.urlMap.get(type), (Object)url);
                if (!StringUtils.isNumericString((String)var.getNewsCount())) continue;
                this.getModel().setValue(Key_NEWS_COUNT, (Object)var.getNewsCount());
            }
            List catalogs = newsConfig.getBusinessCatalogs();
            if (catalogs != null && !catalogs.isEmpty()) {
                for (String option : catalogs) {
                    BusinessCatalogs selectEnum = null;
                    for (BusinessCatalogs optionEnum : BusinessCatalogs.values()) {
                        if (!optionEnum.getKeyWord().equals(option)) continue;
                        selectEnum = optionEnum;
                        break;
                    }
                    if (selectEnum == null) continue;
                    this.getModel().setValue(selectEnum.getField(), (Object)Boolean.TRUE);
                }
            }
        }
    }

    private void initNewsCount() {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(Key_NEWS_COUNT);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(3);
        for (int i = 1; i <= 3; ++i) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%d \u6761", (String)"IDINewsFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]), i)));
            comboItem.setValue("" + i);
            list.add(comboItem);
        }
        comboEdit.setComboItems(list);
    }

    private List<ComboItem> createComboItem(String entityNumber, List<Map<String, Object>> listNodes) {
        if (listNodes == null) {
            return null;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(listNodes.size());
        for (Map<String, Object> map : listNodes) {
            int fieldType = (Integer)map.get("fieldType");
            if (fieldType != -9) continue;
            String entryEntity = (String)map.get("entryEntity");
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(fieldCaption);
            String value = fieldName;
            if (!StringUtils.isEmpty((String)entryEntity) && !entityNumber.equals(entryEntity)) {
                value = entryEntity + "." + fieldName;
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(localeString);
            comboItem.setValue(value);
            list.add(comboItem);
        }
        return list;
    }
}

