/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.ParamFactory;

public class IDIParamFormPlugin
extends AbstractFormPlugin {
    private static final String PARAMKEY_NUMALL = "numb_all";
    private static final String PARAMKEY_NUMBCLASSIFICATION = "numb_classification";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object isPreset = this.getModel().getValue("ispreset");
        if (isPreset != null && ((Boolean)isPreset).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"param_key", "param_desc"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs ev) {
        FormOperate fo;
        super.beforeDoOperation(ev);
        Object source = ev.getSource();
        if (source instanceof FormOperate && "save".equals((fo = (FormOperate)source).getOperateKey())) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            String paramKey = (String)model.getValue("param_key");
            String paramValue = (String)model.getValue("param_val");
            if ("attachment_recognition".equals(paramKey) && !this.checkRecognitionPattern(paramValue)) {
                ev.setCancel(true);
                return;
            }
            if (PARAMKEY_NUMALL.equals(paramKey) && !this.checkNumPattern(paramValue, 4000, ResManager.loadKDString((String)"\u53ea\u80fd\u8f93\u5165(0,4000]\u8303\u56f4\u5185\u7684\u6574\u6570\u3002", (String)"IDIParamFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]))) {
                ev.setCancel(true);
                return;
            }
            if (PARAMKEY_NUMBCLASSIFICATION.equals(paramKey)) {
                int max = ParamFactory.getNumbAll();
                String error = ResManager.loadKDString((String)"\u53ea\u80fd\u8f93\u5165(0, %d]\u8303\u56f4\u5185\u7684\u6574\u6570\u3002", (String)"IDIParamFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]);
                if (!this.checkNumPattern(paramValue, max, error = String.format(error, max))) {
                    ev.setCancel(true);
                    return;
                }
            }
            Object pkValue = model.getDataEntity().getPkValue();
            QFilter filter = new QFilter("param_key", "=", (Object)paramKey);
            if (pkValue != null) {
                filter.and(new QFilter("id", "!=", pkValue));
            }
            if (QueryServiceHelper.exists((String)"idi_param_config", (QFilter[])filter.toArray())) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u53c2\u6570\u540d\u91cd\u590d\u3002", (String)"IDIParamFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                ev.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs ev) {
        Object paramKey;
        super.afterDoOperation(ev);
        if ("save".equals(ev.getOperateKey()) && (paramKey = this.getModel().getValue("param_key")) != null) {
            CacheManager.del((String)"param", (String)paramKey.toString());
        }
    }

    private boolean checkNumPattern(String paramValue, int max, String errMsg) {
        int value;
        boolean result = false;
        if (StringUtils.isNotEmpty((String)paramValue) && paramValue.matches("^\\d+$") && (value = Integer.parseInt(paramValue)) > 0 && value <= max) {
            result = true;
        }
        if (!result) {
            this.getView().showTipNotification(errMsg);
        }
        return result;
    }

    private boolean checkRecognitionPattern(String recognitionVal) {
        if (recognitionVal == null || recognitionVal.isEmpty() || !recognitionVal.matches("^(0(\\.\\d{1,2})?|1(\\.0{1,2})?)$")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u89c4\u5219 \uff1a0\u2264\u7f6e\u4fe1\u5ea6\u22641\uff0c\u6700\u591a\u4fdd\u75592\u4f4d\u5c0f\u6570\u3002", (String)"IDIParamFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

