/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.property.IBasedataField;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.FilterGridF7ClickEvent;
import kd.bos.form.control.events.FilterGridF7ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.IDICondition;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.util.CompareColumnHelper;
import kd.data.idi.util.IDIJSONUtils;

public class IDIQueryTargetBillFormPlugin
extends AbstractFormPlugin
implements FilterGridF7ClickListener {
    private static final String CONTROL_BTNOK = "btnok";
    private static final String CONTROL_FILTER = "filtergridap";
    private static final String PARAM_SOURCEENTITYNUMBER = "entitynumber";
    private static final String PARAM_TARGETENTITYNUMBER = "targetEntityNumber";
    private static final String PARAM_TARGETCONDITIONCONFIG = "formula";
    private static final String PARAM_SUPPORTTARGETSELF = "targetSelf";

    public void initialize() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CONTROL_FILTER);
        filterGrid.addFilterGridF7ClickEvents((FilterGridF7ClickListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        String entityNumber = this.getTargetEntityNumber();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            EntityTypeUtil helper = new EntityTypeUtil();
            List<Map<String, Object>> cols = this.createFieldMap(entityNumber, helper, true);
            this.filterField(cols);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CONTROL_FILTER);
            CompareColumnHelper.processPropertyName((String)entityNumber, cols);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(entityNumber);
            String sourceNumber = this.getSourceEntityNumber();
            if (StringUtils.isNotBlank((CharSequence)sourceNumber)) {
                List<Map<String, Object>> sourceCols = this.createFieldMap(sourceNumber, helper, false);
                CompareColumnHelper.processPropertyName((String)sourceNumber, sourceCols);
                filterGrid.setFieldColumns(sourceCols);
            }
        }
        super.afterCreateNewData(e);
    }

    private List<Map<String, Object>> createFieldMap(String entityNumber, EntityTypeUtil helper, boolean isTarget) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        boolean targetSelf = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam(PARAM_SUPPORTTARGETSELF));
        String fieldDisplayPrefix = "";
        if (targetSelf) {
            String srcMesg = ResManager.loadKDString((String)"\u6e90\u5355", (String)"IDIDecisionFormPlugin_19", (String)"data-idi-formplugin", (Object[])new Object[0]);
            String targetMesg = ResManager.loadKDString((String)"\u76ee\u6807\u5355", (String)"IDIDecisionFormPlugin_20", (String)"data-idi-formplugin", (Object[])new Object[0]);
            String prefix = isTarget ? targetMesg : srcMesg;
            fieldDisplayPrefix = prefix + "_" + entityType.getDisplayName() + ".";
        }
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(10);
        List filterFields = helper.getFilterFields((IDataEntityType)entityType, false);
        Iterator filterFieldIterator = filterFields.iterator();
        HashSet idSet = new HashSet(10);
        List fieldEqualCompareType = CompareColumnHelper.getFieldEqualCompareType();
        while (filterFieldIterator.hasNext()) {
            FilterField filterField = (FilterField)filterFieldIterator.next();
            if (filterField.getSrcFieldProp().getParent() instanceof SubEntryType) continue;
            Map filterColumn = filterField.createFilterColumn();
            String fieldDisplayName = (String)filterColumn.get("fieldCaption");
            fieldDisplayName = fieldDisplayPrefix + fieldDisplayName;
            filterColumn.put("fieldCaption", fieldDisplayName);
            if (filterField.getLatestParent() instanceof IBasedataField) {
                CompareColumnHelper.baseDataTextFieldCompare((FilterField)filterField, (Map)filterColumn);
                List oldCompareList = (List)filterColumn.get("compareTypes");
                String type = (String)filterColumn.get("type");
                if (StringUtils.isNotEmpty((CharSequence)type) && type.contains("date")) {
                    oldCompareList.removeIf(ct -> ct.getId().equals(CompareTypeEnum.CURRENTUSER.getId()) || ct.getId().equals(CompareTypeEnum.NOTCURRENTUSER.getId()));
                }
                List fieldEqList = new ArrayList(5);
                fieldEqList = EntityTypeUtil.setCompareTypes(fieldEqList, (boolean)true, (boolean)true);
                List<Object> compareList = new ArrayList();
                compareList.addAll(oldCompareList);
                compareList.addAll(fieldEqList);
                compareList = compareList.stream().distinct().collect(Collectors.toList());
                filterColumn.put("compareTypes", compareList);
                Map idColumn = CompareColumnHelper.genIdColumnMap((FilterField)filterField, idSet, (MainEntityType)entityType, (List)fieldEqualCompareType);
                if (idColumn != null) {
                    String idFieldDisplayName = (String)idColumn.get("fieldCaption");
                    idFieldDisplayName = fieldDisplayPrefix + idFieldDisplayName;
                    idColumn.put("fieldCaption", idFieldDisplayName);
                    cols.add(idColumn);
                }
            }
            cols.add(filterColumn);
        }
        try {
            cols.addAll(ExecutorHelper.buildMulBaseDataFilter((String)entityNumber, (EntityTypeUtil)helper));
        }
        catch (Exception e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6dfb\u52a0\u591a\u9009\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u5931\u8d25\uff1a%s\u3002", (String)"IDIQueryTargetBillFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        return cols;
    }

    private void filterField(List<Map<String, Object>> fieldColumns) {
        if (fieldColumns == null) {
            return;
        }
        HashMap acceptCompareType = new HashMap();
        HashSet<String> set = new HashSet<String>();
        acceptCompareType.put(0, set);
        set.add(CompareTypeEnum.EQUAL.getId());
        set.add(CompareTypeEnum.NOTEQUAL.getId());
        set = new HashSet();
        acceptCompareType.put(5, set);
        set.add(CompareTypeEnum.TODAY.getId());
        set.add(CompareTypeEnum.YESTERDAY.getId());
        set = new HashSet();
        acceptCompareType.put(10, set);
        set.add(CompareTypeEnum.CHECKBOXIN.getId());
        set.add(CompareTypeEnum.NOTIN.getId());
        set = new HashSet();
        acceptCompareType.put(4, set);
        set.add(CompareTypeEnum.GREATER.getId());
        set.add(CompareTypeEnum.LESS.getId());
        set.add(CompareTypeEnum.GREATEROREQUAL.getId());
        set.add(CompareTypeEnum.LESSOREQUAL.getId());
        set = new HashSet();
        acceptCompareType.put(2, set);
        set.add(CompareTypeEnum.ISNULL.getId());
        set.add(CompareTypeEnum.ISNOTNULL.getId());
        set = new HashSet();
        acceptCompareType.put(9, set);
        set.add(CompareTypeEnum.FIELDEQUAL.getId());
        set = new HashSet();
        acceptCompareType.put(3, set);
        set.add(CompareTypeEnum.LIKE.getId());
        HashMap fieldTypeMap = new HashMap();
        Set compareTypeSet = new HashSet<Integer>();
        fieldTypeMap.put(-9, compareTypeSet);
        compareTypeSet.add(0);
        compareTypeSet.add(2);
        compareTypeSet.add(9);
        compareTypeSet.add(3);
        compareTypeSet = new HashSet();
        fieldTypeMap.put(91, compareTypeSet);
        fieldTypeMap.put(93, compareTypeSet);
        compareTypeSet.add(0);
        compareTypeSet.add(2);
        compareTypeSet.add(4);
        compareTypeSet.add(5);
        compareTypeSet.add(9);
        compareTypeSet = new HashSet();
        fieldTypeMap.put(4, compareTypeSet);
        fieldTypeMap.put(3, compareTypeSet);
        compareTypeSet.add(0);
        compareTypeSet.add(2);
        compareTypeSet.add(4);
        compareTypeSet.add(9);
        compareTypeSet = new HashSet();
        fieldTypeMap.put(12, compareTypeSet);
        compareTypeSet.add(10);
        for (Map<String, Object> fieldMap : fieldColumns) {
            String fieldName = String.valueOf(fieldMap.get("fieldName"));
            if (fieldName.contains(".fbasedataid")) continue;
            Object compareTypes = fieldMap.get("compareTypes");
            String entityId = (String)fieldMap.get("entityId");
            if ("bd_materialpurchaseinfo".equals(entityId)) {
                fieldMap.put("type", "text");
            }
            Integer fieldType = (Integer)fieldMap.get("fieldType");
            compareTypeSet = (Set)fieldTypeMap.get(fieldType);
            if (!(compareTypes instanceof List)) continue;
            List compareTypeList = (List)compareTypes;
            Iterator compareTypesIterator = compareTypeList.iterator();
            boolean containsDate = false;
            ArrayList<CompareTypeDto> defaultDateCompareType = new ArrayList<CompareTypeDto>();
            CompareTypeDto firstCompareType = null;
            while (compareTypesIterator.hasNext()) {
                Object obj = compareTypesIterator.next();
                if (!(obj instanceof CompareTypeDto)) continue;
                CompareTypeDto compareType = (CompareTypeDto)obj;
                int groupId = compareType.getGroupId();
                if (groupId == 5) {
                    containsDate = true;
                    if (CompareTypeEnum.TODAY.getId().equals(compareType.getId()) || CompareTypeEnum.YESTERDAY.getId().equals(compareType.getId())) {
                        compareType.setInputCtlType(-1);
                        compareType.setNeedInput(false);
                        defaultDateCompareType.add(compareType);
                        compareTypesIterator.remove();
                        continue;
                    }
                }
                if ((groupId == 7 || groupId == 8) && (CompareTypeEnum.ORGIN.getId().equals(compareType.getId()) || CompareTypeEnum.ORGNOTIN.getId().equals(compareType.getId()) || CompareTypeEnum.ITEMCLASSIN.getId().equals(compareType.getId()) || CompareTypeEnum.ITEMCLASSNOTIN.getId().equals(compareType.getId()))) {
                    compareTypesIterator.remove();
                    continue;
                }
                boolean needLimit = groupId != 6 && groupId != 7 && groupId != 8 && compareTypeSet != null;
                if (!needLimit) continue;
                Set idSet = (Set)acceptCompareType.get(groupId);
                if (!compareTypeSet.contains(groupId) || idSet == null || !idSet.contains(compareType.getId())) {
                    compareTypesIterator.remove();
                    continue;
                }
                if (!CompareTypeEnum.FIELDEQUAL.getId().equals(compareType.getId())) continue;
                firstCompareType = compareType;
                compareTypesIterator.remove();
            }
            if (containsDate) {
                List<CompareTypeDto> addCompareType = Arrays.asList(new CompareTypeDto("IDI_BETWEEN_1W", new LocaleString(ResManager.loadKDString((String)"1\u5468\u5185", (String)"IDIQueryTargetBillFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_2W", new LocaleString(ResManager.loadKDString((String)"2\u5468\u5185", (String)"IDIQueryTargetBillFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_1M", new LocaleString(ResManager.loadKDString((String)"1\u4e2a\u6708\u5185", (String)"IDIQueryTargetBillFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_2M", new LocaleString(ResManager.loadKDString((String)"2\u4e2a\u6708\u5185", (String)"IDIQueryTargetBillFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_1HY", new LocaleString(ResManager.loadKDString((String)"\u534a\u5e74\u5185", (String)"IDIQueryTargetBillFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_1Y", new LocaleString(ResManager.loadKDString((String)"1\u5e74\u5185", (String)"IDIQueryTargetBillFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false));
                for (CompareTypeDto dto : addCompareType) {
                    dto.setVisible(true);
                }
                compareTypeList.addAll(0, addCompareType);
                if (!defaultDateCompareType.isEmpty()) {
                    compareTypeList.addAll(0, defaultDateCompareType);
                }
            }
            if (firstCompareType == null) continue;
            Object deletedCompareType = this.deleteAndReturnCompareType(compareTypeList, firstCompareType.getId());
            if (deletedCompareType != null) {
                compareTypeList.add(0, deletedCompareType);
                continue;
            }
            compareTypeList.add(0, firstCompareType);
        }
    }

    private Object deleteAndReturnCompareType(List compareTypes, String compareTypeId) {
        if (CollectionUtils.isEmpty((Collection)compareTypes) || StringUtils.isEmpty((CharSequence)compareTypeId)) {
            return null;
        }
        Iterator compareTypesIterator = compareTypes.iterator();
        Object deletedCompareType = null;
        while (compareTypesIterator.hasNext()) {
            Object compareType = compareTypesIterator.next();
            if (compareType == null) continue;
            if (compareType instanceof CompareTypeDto) {
                if (!StringUtils.equals((CharSequence)((CompareTypeDto)compareType).getId(), (CharSequence)compareTypeId)) continue;
                deletedCompareType = compareType;
                compareTypesIterator.remove();
                continue;
            }
            if (!(compareType instanceof CompareType) || !StringUtils.equals((CharSequence)((CompareType)compareType).getId(), (CharSequence)compareTypeId)) continue;
            deletedCompareType = compareType;
            compareTypesIterator.remove();
        }
        return deletedCompareType;
    }

    private String getSourceEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAM_SOURCEENTITYNUMBER);
    }

    private String getTargetEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAM_TARGETENTITYNUMBER);
    }

    private String getConditionJson() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAM_TARGETCONDITIONCONFIG);
    }

    public void afterBindData(EventObject e) {
        IDICondition conditionObj;
        FilterCondition filterCondition;
        String conditionJson = this.getConditionJson();
        if (StringUtils.isNotEmpty((CharSequence)conditionJson) && (filterCondition = (conditionObj = (IDICondition)SerializationUtils.fromJsonString((String)conditionJson, IDICondition.class)).getFilterCondition()) != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CONTROL_FILTER);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void click(EventObject evt) {
        IDICondition condition;
        Control control = (Control)evt.getSource();
        if (CONTROL_BTNOK.equalsIgnoreCase(control.getKey()) && this.validate(condition = this.getCondition())) {
            this.getView().returnDataToParent((Object)IDIJSONUtils.toJsonString((Object)condition));
            this.getView().close();
        }
    }

    private boolean validate(IDICondition condition) {
        if (condition == null || condition.getFilterCondition() == null || condition.getDescription() == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5\u3001\u6bd4\u8f83\u6761\u4ef6\u3001\u76ee\u6807\u5355\u5b57\u6bb5\u8bf7\u5f55\u5165\u5b8c\u6574\u3002", (String)"IDIQueryTargetBillFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private IDICondition getCondition() {
        String targetEntityNumber = this.getTargetEntityNumber();
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
        FilterGrid filterGrid = (FilterGrid)this.getControl(CONTROL_FILTER);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String sourceNumber = this.getSourceEntityNumber();
        List<FilterField> sourceFields = this.addCompareField(sourceNumber);
        List<FilterField> targetFields = this.addCompareField(targetEntityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataType, filterGridState.getFilterCondition(), true, targetFields);
        filterBuilder.setTimeService((ITimeService)this.getView().getService(ITimeService.class));
        filterBuilder.setUserService((IUserService)this.getView().getService(IUserService.class));
        filterBuilder.getFilterObject().addCompareFileds(sourceFields);
        filterBuilder.buildFilter(false);
        FilterObject fo = filterBuilder.getFilterObject();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.setFilter(fo.getFilter());
        IDICondition condition = new IDICondition();
        condition.setDescription(new LocaleString(fo.getFilter()));
        condition.setFilterCondition(fc);
        return condition;
    }

    private List<FilterField> addCompareField(String entityNumber) {
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List fieldFilter = helper.getFilterFields((IDataEntityType)sourceEntityType, false);
            HashSet idSet = new HashSet(10);
            ArrayList<FilterField> idFieldList = new ArrayList<FilterField>(10);
            List fieldEqualCompareType = CompareColumnHelper.getFieldEqualCompareType();
            for (FilterField ff : fieldFilter) {
                FilterField idFilterField;
                if (ff.getSrcFieldProp().getParent() instanceof SubEntryType) continue;
                List compareTypes = ff.getCompareTypes();
                compareTypes = EntityTypeUtil.setCompareTypes((List)compareTypes, (boolean)true, (boolean)true);
                ff.setCompareTypes(compareTypes);
                if (!(ff.getLatestParent() instanceof IBasedataField) || (idFilterField = CompareColumnHelper.genIdField((FilterField)ff, idSet, (MainEntityType)sourceEntityType, (List)fieldEqualCompareType)) == null) continue;
                idFieldList.add(idFilterField);
            }
            fieldFilter.addAll(idFieldList);
            for (FilterField ff : fieldFilter) {
                ff.setFieldName(ff.getFullFieldName());
            }
            fieldFilter.addAll(ExecutorHelper.getMulBaseDataFilterFiled((String)entityNumber, (EntityTypeUtil)helper));
            return fieldFilter;
        }
        return null;
    }

    public void filterGridF7Click(FilterGridF7ClickEvent filterGridF7ClickEvent) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getTargetEntityNumber());
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)entityType, false);
        for (Map fieldMap : cols) {
            Integer fieldType;
            if (!filterGridF7ClickEvent.getFieldName().equals(fieldMap.get("fieldName")) || (fieldType = (Integer)fieldMap.get("fieldType")) != 91 && fieldType != 93) continue;
            filterGridF7ClickEvent.setCancel(true);
        }
    }
}

