/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class IDIReconciliationFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTNCHECK = "btn_check";
    private static final String KEY_RESULTTAG = "result_tag";
    private static final String[] KEY_FIELDS = new String[]{"isnot", "record", "intdata", "company", "date", "bizdate", "vouchertype", "voucherno", "settlementtype", "settlementno", "billtype", "billno", "desc", "debit", "credit"};
    private static final String KEY_ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNCHECK});
    }

    public void click(EventObject evt) {
        JSONObject jsonObject;
        IDataModel model;
        String dataStr;
        Control control = (Control)evt.getSource();
        if (KEY_BTNCHECK.equalsIgnoreCase(control.getKey()) && StringUtils.isNotEmpty((String)(dataStr = (String)(model = this.getModel()).getValue(KEY_RESULTTAG))) && "success".equals((jsonObject = JSON.parseObject((String)dataStr)).get((Object)"description"))) {
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            for (String field : KEY_FIELDS) {
                tvs.addField(field, new Object[0]);
            }
            JSONObject dataJosn = jsonObject.getJSONObject("data");
            String resultsStr = dataJosn.getString("results");
            if (StringUtils.isNotEmpty((String)resultsStr)) {
                JSONArray jsonArray = JSON.parseArray((String)resultsStr);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject rowData = jsonArray.getJSONObject(i);
                    JSONArray sourceData = rowData.getJSONArray("account");
                    JSONArray checkData = rowData.getJSONArray("journal");
                    this.fetTableData(sourceData, tvs);
                    this.fetTableData(checkData, tvs);
                }
            }
            AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
            dataModel.beginInit();
            dataModel.batchCreateNewEntryRow(KEY_ENTRYENTITY, tvs);
            dataModel.endInit();
            this.getView().updateView(KEY_ENTRYENTITY);
        }
    }

    private void fetTableData(JSONArray datas, TableValueSetter tvs) {
        if (datas != null && !datas.isEmpty()) {
            Object[] values = new Object[datas.size()];
            int k = 0;
            for (Object value : datas) {
                values[k++] = value;
            }
            tvs.addRow(values);
        }
    }

    private static class ReportModel {
        private Map<String, List<Map<String, List<String>>>> data;
        private String description;
        private String errorCode;

        private ReportModel() {
        }

        public Map<String, List<Map<String, List<String>>>> getData() {
            return this.data;
        }

        public void setData(Map<String, List<Map<String, List<String>>>> data) {
            this.data = data;
        }

        public String getDescription() {
            return this.description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }
    }
}

