/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin.decision;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.decision.constant.DecisionExtType;
import kd.data.idi.decision.constant.MicroServiceType;
import kd.data.idi.util.Pair;

public class IDIDecisionExtInfoFormPlugin
extends AbstractBasePlugIn {
    private static final String ENTRY_PARAM = "paramentryentity";
    private static final String ENTRY_FIELD_PARAM_NAME = "param_name";
    private static final String ENTRY_FIELD_PARAM_VALUE = "param_value";
    private static final String ENTRY_FIELD_PARAM_DESC = "param_desc";
    private static final String FIELD_METHODPARAMS = "methodparams_tag";
    private static final String FIELD_DETAILDISPLAYTYPE = "detaildisplaytype";
    private static final String FIELD_EXTTYPE = "ext_type";
    private static final String FIELD_SERVICETYPE = "service_type";
    private static final String FIELD_SRCENTITYNUM = "srcentitynum";
    private static final String FIELD_SRCENTITYNUMS = "srcentitynums";
    private static final String OPERATE_NEWENTRY_PARAM = "newentry_param";
    private static final String ActionId_SET_ENABLE = "setEnable";

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initSrcEntityNums();
        this.refreshParamEntry();
        this.initOtherFields();
    }

    private void initSrcEntityNums() {
        DynamicObject oldSrcEntityNum;
        MulBasedataDynamicObjectCollection srcEntityNums = (MulBasedataDynamicObjectCollection)this.getModel().getValue(FIELD_SRCENTITYNUMS);
        if ((srcEntityNums == null || srcEntityNums.isEmpty()) && (oldSrcEntityNum = (DynamicObject)this.getModel().getValue(FIELD_SRCENTITYNUM)) != null) {
            this.getModel().setValue(FIELD_SRCENTITYNUMS, (Object)new Object[]{oldSrcEntityNum.getPkValue()});
        }
    }

    private void refreshParamEntry() {
        List paramList;
        String methodParams = (String)this.getModel().getValue(FIELD_METHODPARAMS);
        if (!StringUtils.isBlank((String)methodParams) && (paramList = (List)SerializationUtils.fromJsonString((String)methodParams.trim(), List.class)) != null && !paramList.isEmpty()) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(ENTRY_PARAM);
            model.batchCreateNewEntryRow(ENTRY_PARAM, paramList.size());
            DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRY_PARAM);
            for (int i = 0; i < paramList.size(); ++i) {
                Map paramMap = (Map)paramList.get(i);
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                entry.set(ENTRY_FIELD_PARAM_NAME, paramMap.get(ENTRY_FIELD_PARAM_NAME));
                entry.set(ENTRY_FIELD_PARAM_VALUE, paramMap.get(ENTRY_FIELD_PARAM_VALUE));
                entry.set(ENTRY_FIELD_PARAM_DESC, paramMap.get(ENTRY_FIELD_PARAM_DESC));
            }
            model.endInit();
            model.setDataChanged(false);
            this.getView().updateView(ENTRY_PARAM);
        }
    }

    private void initOtherFields() {
        String serviceType;
        String detailDisplayType = (String)this.getModel().getValue(FIELD_DETAILDISPLAYTYPE);
        if (StringUtils.isNotEmpty((String)detailDisplayType)) {
            this.getModel().setValue(FIELD_DETAILDISPLAYTYPE, (Object)Integer.parseInt(detailDisplayType));
        }
        String extType = (String)this.getModel().getValue(FIELD_EXTTYPE);
        if (DecisionExtType.MSERVICE.getType().equals(extType) && StringUtils.isBlank((String)(serviceType = (String)this.getModel().getValue(FIELD_SERVICETYPE)))) {
            this.getModel().setValue(FIELD_SERVICETYPE, (Object)MicroServiceType.BIZ.getType());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection paramCol;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey)) {
            Pair<Boolean, String> paramVerifyResult = this.verifyEntryParams();
            if (Boolean.FALSE.equals(paramVerifyResult.getKey())) {
                args.setCancel(true);
                this.getView().showErrorNotification((String)paramVerifyResult.getValue());
            }
        } else if (OPERATE_NEWENTRY_PARAM.equals(operateKey) && (paramCol = this.getModel().getEntryEntity(ENTRY_PARAM)).size() >= 10) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u914d\u7f6e10\u4e2a\u53c2\u6570\u3002", (String)"IDIDecisionExtInfoFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
    }

    private Pair<Boolean, String> verifyEntryParams() {
        Pair result = null;
        DynamicObjectCollection paramCol = this.getModel().getEntryEntity(ENTRY_PARAM);
        if (paramCol.size() > 10) {
            result = new Pair((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u914d\u7f6e10\u4e2a\u53c2\u6570\u3002", (String)"IDIDecisionExtInfoFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return result;
        }
        HashSet<String> paramNameSet = new HashSet<String>(10);
        ArrayList<Map<String, String>> paramList = new ArrayList<Map<String, String>>(10);
        for (int i = 0; i < paramCol.size(); ++i) {
            DynamicObject paramDO = (DynamicObject)paramCol.get(i);
            String paramName = paramDO.getString(ENTRY_FIELD_PARAM_NAME);
            if (StringUtils.isBlank((String)paramName)) continue;
            if (paramNameSet.contains(paramName)) {
                result = new Pair((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u63a5\u53e3\u53c2\u6570\u540d[%1$s]\u91cd\u590d\u4e86\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IDIDecisionExtInfoFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]), paramName));
                return result;
            }
            paramNameSet.add(paramName);
            paramList.add(this.buildSingleEntryParam(paramDO));
        }
        this.getModel().setValue(FIELD_METHODPARAMS, (Object)SerializationUtils.toJsonString(paramList));
        return new Pair((Object)Boolean.TRUE, (Object)"");
    }

    private Map<String, String> buildSingleEntryParam(DynamicObject paramDO) {
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        paramMap.put(ENTRY_FIELD_PARAM_NAME, paramDO.getString(ENTRY_FIELD_PARAM_NAME));
        paramMap.put(ENTRY_FIELD_PARAM_VALUE, paramDO.getString(ENTRY_FIELD_PARAM_VALUE));
        paramMap.put(ENTRY_FIELD_PARAM_DESC, paramDO.getString(ENTRY_FIELD_PARAM_DESC));
        return paramMap;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.refreshParamEntry();
            long userId = Long.parseLong(RequestContext.get().getUserId());
            if ("0".equals(this.getModel().getValue("enable")) && PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"idi", (String)"idi_decision_extinfo", (String)"4730fc5d000000ac")) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u9a6c\u4e0a\u542f\u7528\uff1f", (String)"IDIDecisionExtInfoFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(ActionId_SET_ENABLE, this.getPluginName()), null, String.valueOf(args.getOperationResult().getSuccessPkIds().get(0)));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"IDIDecisionExtInfoFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (ActionId_SET_ENABLE.equalsIgnoreCase(actionId)) {
            if (MessageBoxResult.Yes == messageBoxResult) {
                String billIdStr = messageBoxClosedEvent.getCustomVaule();
                DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billIdStr, (String)"idi_decision_extinfo");
                billObj.set("enable", (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
                this.getModel().setValue("enable", (Object)"1");
                this.getModel().setDataChanged(false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"IDIDecisionExtInfoFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u9700\u542f\u7528\u540e\u624d\u5728\u201c\u51b3\u7b56\u65b9\u6848\u914d\u7f6e\u201d\u4e2d\u53ef\u89c1\u3002", (String)"IDIDecisionExtInfoFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

