/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin.mobile;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;

public class IDISampleMobileFormPlugin
extends AbstractMobFormPlugin {
    private static final String KEY_FIELD_OBJECTTYPE = "objecttype";
    private static final String KEY_FIELD_OBJECTID = "objectid";
    private static final String KEY_FIELD_OBJECTNUMBER = "objectnumber";
    private static final String KEY_FIELD_SCHEMANUMBER = "schemanumber";
    private static final String KEY_CONTROL_BTNOK = "btn_ok";
    private static final String KEY_CONTROL_BTNOBJECTID = "btn_objectid";
    private static final String KEY_CONTROL_FLEX = "dynamicpanel";
    private static final String KEY_CONTROL_OVERVIEW = "overview";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_CONTROL_BTNOK});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btn_ok": {
                this.execute();
                break;
            }
            case "overview": {
                this.showForm();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (KEY_FIELD_OBJECTID.equalsIgnoreCase(actionId) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            this.getModel().setValue(KEY_FIELD_OBJECTID, rows.get(0).getPrimaryKeyValue());
            this.getModel().setValue(KEY_FIELD_OBJECTNUMBER, (Object)rows.get(0).getBillNo());
        }
    }

    private void execute() {
        String objectType = (String)this.getModel().getValue(KEY_FIELD_OBJECTTYPE);
        if (StringUtils.isEmpty((CharSequence)objectType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u4e1a\u52a1\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"IDISampleMobileFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String billNumber = (String)this.getModel().getValue(KEY_FIELD_OBJECTNUMBER);
        if (StringUtils.isEmpty((CharSequence)billNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e1a\u52a1\u5355\u636e\u3002", (String)"IDISampleMobileFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject bill = QueryServiceHelper.queryOne((String)objectType, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNumber)});
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)bill.get("id"), (String)objectType);
        if (billObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"IDISampleMobileFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(KEY_FIELD_OBJECTID, bill.get("id"));
        String matchSchemaNumber = this.getSchemaNumber();
        List schemaNumberList = IDIStringUtils.strSplite((String)matchSchemaNumber);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"getSchemaSummary", (Object[])new Object[]{billObj, schemaNumberList});
        this.createXiaoK(result);
    }

    private void createXiaoK(String title) {
        FlexPanelAp root = new FlexPanelAp();
        root.setKey(KEY_CONTROL_FLEX);
        Map rootControlMap = root.createControl();
        List itemList = (List)this.createOverView(title).createControl().get("items");
        rootControlMap.put("items", itemList);
        this.getView().updateControlMetadata(KEY_CONTROL_FLEX, rootControlMap);
    }

    private FlexPanelAp createOverView(String result) {
        Map map = (Map)IDIJSONUtils.cast((String)result, Map.class);
        String status = (String)map.get("status");
        boolean isSucceed = "success".equals(status);
        String content = (String)map.get("content");
        FlexPanelAp rootPanel = new FlexPanelAp();
        rootPanel.setKey("overviewroot");
        rootPanel.setDirection("row");
        rootPanel.setWidth(new LocaleString("100%"));
        rootPanel.setGrow(1);
        FlexPanelAp viewPanel = new FlexPanelAp();
        viewPanel.setKey(KEY_CONTROL_OVERVIEW);
        viewPanel.setBackColor("#ffffff");
        viewPanel.setDirection("row");
        viewPanel.setAlignItems("center");
        viewPanel.setClickable(isSucceed);
        viewPanel.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7ZmxleC13cmFwOiBub3dyYXA7fSJ9");
        rootPanel.getItems().add(viewPanel);
        FlexPanelAp viewLeftPanel = new FlexPanelAp();
        viewLeftPanel.setKey("overviewleftflex");
        viewLeftPanel.setDirection("row");
        viewLeftPanel.setAlignItems("center");
        viewLeftPanel.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7ZmxleC13cmFwOiBub3dyYXA7fSJ9");
        viewPanel.getItems().add(viewLeftPanel);
        ImageAp imageap = new ImageAp();
        imageap.setImageKey("/images/pc/emotion/krobot_100_100.png");
        imageap.setWidth(new LocaleString("40px"));
        imageap.setHeight(new LocaleString("40px"));
        imageap.setKey("rabotk");
        imageap.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7bWluLWhlaWdodDogNDBweDttaW4td2lkdGg6IDQwcHg7fSJ9");
        viewLeftPanel.getItems().add(imageap);
        LabelAp labelap = new LabelAp();
        labelap.setKey("overviewtext");
        labelap.setName(new LocaleString(content));
        labelap.setFontSize(14);
        labelap.setForeColor("#768893");
        viewLeftPanel.getItems().add(labelap);
        FlexPanelAp viewRightPanel = new FlexPanelAp();
        viewRightPanel.setKey("overviewrightflex");
        viewRightPanel.setDirection("row");
        viewRightPanel.setJustifyContent("flex-end");
        viewPanel.getItems().add(viewRightPanel);
        if (isSucceed) {
            VectorAp vectorap = new VectorAp();
            vectorap.setKey("goresult");
            vectorap.setfontClass("kdfont kdfont-houfan");
            viewRightPanel.getItems().add(vectorap);
        }
        return rootPanel;
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (kd.bos.util.StringUtils.isNotEmpty((String)key) && key.equals(KEY_CONTROL_OVERVIEW)) {
            Container flexPanel = new Container();
            flexPanel.setKey(key);
            flexPanel.setView(this.getView());
            flexPanel.addClickListener((ClickListener)this);
            e.setControl((Control)flexPanel);
        }
    }

    private void showForm() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("idi_datainsight_mobile");
        String entityNumber = this.getEntityNumber();
        String billId = this.getBillId();
        String schemaNumber = this.getSchemaNumber();
        fsp.setCustomParam("entitynumber", (Object)entityNumber);
        fsp.setCustomParam("billid", (Object)billId);
        fsp.setCustomParam("schemenumber", (Object)schemaNumber);
        fsp.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm(fsp);
    }

    private String getEntityNumber() {
        String object = (String)this.getModel().getValue(KEY_FIELD_OBJECTTYPE);
        return object;
    }

    private String getBillId() {
        String billId = (String)this.getModel().getValue(KEY_FIELD_OBJECTID);
        return billId;
    }

    private String getSchemaNumber() {
        DynamicObject schemaNumber = (DynamicObject)this.getModel().getValue(KEY_FIELD_SCHEMANUMBER);
        return schemaNumber.getString("number");
    }
}

