/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Area;
import kd.data.idi.data.Decision;
import kd.data.idi.data.Schema;
import kd.data.idi.util.IDIJSONUtils;

public class IDISchemaUpgradeParallelServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute idiRoute = DBRoute.of((String)"bdai");
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(5);
        try (DataSet dataSet = DB.queryDataSet((String)"IDISchemaUpgradeParallelServiceImpl.IDISchemaUpgradeParallelServiceImpl", (DBRoute)idiRoute, (String)"select fid,frule_tag from t_idi_decisionschema");){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    String rule = row.getString("frule_tag");
                    boolean hasChange = false;
                    if (StringUtils.isNotEmpty((String)rule)) {
                        Schema schema = (Schema)IDIJSONUtils.cast((String)rule, Schema.class);
                        if (schema == null) continue;
                        List areaList = schema.getArea();
                        if (CollectionUtils.isNotEmpty((Collection)areaList)) {
                            for (Area area : areaList) {
                                List decisionList;
                                if (area == null) continue;
                                if (StringUtils.isEmpty((String)area.getPk())) {
                                    area.setPk(Uuid16.create().toString());
                                    hasChange = true;
                                }
                                if (!CollectionUtils.isNotEmpty((Collection)(decisionList = area.getDecision()))) continue;
                                for (Decision decision : decisionList) {
                                    if (decision == null || !StringUtils.isEmpty((String)decision.getPk())) continue;
                                    decision.setPk(Uuid16.create().toString());
                                    hasChange = true;
                                }
                            }
                        }
                        rule = IDIJSONUtils.toJsonString((Object)schema);
                    }
                    if (!hasChange) continue;
                    Object[] params = new Object[]{rule, row.getLong("fid")};
                    updateParamList.add(params);
                }
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo(e.getMessage());
        }
        int count = updateParamList.size();
        if (updateParamList.isEmpty()) {
            result.setSuccess(true);
            result.setLog("Schema is empty,do not need update");
        } else {
            try {
                String updateSql = " update t_idi_decisionschema set frule_tag = ? where fid = ? ";
                DB.executeBatch((DBRoute)idiRoute, (String)updateSql, updateParamList);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
            }
        }
        if (result.isSuccess()) {
            result.setLog("total of modified data " + count);
        }
        return result;
    }
}

