/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.idi.decision.service.SchemaDecisionService;

public class IDIDecisionExtinfoOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new IDIDecisionExtinfoValidator());
    }

    private static class IDIDecisionExtinfoValidator
    extends AbstractValidator {
        private IDIDecisionExtinfoValidator() {
        }

        public void validate() {
            String operateType = this.getOperateType();
            if ("delete".equals(operateType)) {
                this.validateDeleteEntry();
            }
        }

        private void validateDeleteEntry() {
            if (this.dataEntities == null) {
                return;
            }
            Object[] pkIds = new Object[this.dataEntities.length];
            for (int i = 0; i < this.dataEntities.length; ++i) {
                pkIds[i] = this.dataEntities[i].getValue("id");
            }
            DynamicObjectCollection decisionList = QueryServiceHelper.query((String)"idi_decision_extinfo", (String)"id,number,issysset", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
            SchemaDecisionService schemaDecisionService = new SchemaDecisionService();
            for (int i = 0; i < decisionList.size(); ++i) {
                DynamicObject decision = (DynamicObject)decisionList.get(i);
                String decisionNum = decision.getString("number");
                List relationList = schemaDecisionService.querySchemaByDecision(new String[]{decisionNum});
                int finalI = i;
                relationList.forEach(relation -> {
                    String errorMsgTemplate = ResManager.loadKDString((String)"\u68c0\u67e5\u9879[%1$s]\u5728\u65b9\u6848[%2$s]\u4e2d\u5df2\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"IDIDecisionExtinfoOp_0", (String)"data-idi-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(this.dataEntities[finalI], String.format(errorMsgTemplate, relation.getDecisionNum(), relation.getSchemaNum()));
                });
                if (!decision.getBoolean("issysset")) continue;
                String errorMsgTemplate = ResManager.loadKDString((String)"[%1$s]\u4e3a\u7cfb\u7edf\u9884\u7f6e\u7684\u68c0\u67e5\u9879\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"IDIDecisionExtinfoOp_1", (String)"data-idi-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(this.dataEntities[finalI], String.format(errorMsgTemplate, decisionNum));
            }
        }
    }
}

