/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.dataconverter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Area;
import kd.data.idi.data.AreaResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.dataconverter.IIDIDataConverter;
import kd.data.idi.decision.openapi.ApiDecisionResultItem;
import kd.data.idi.util.IDIJSONUtils;

public class IDISchemaResultJFDataConvert
implements IIDIDataConverter<SchemaResult, Map<String, Object>, Schema> {
    @Override
    public Map<String, Object> convertObject(SchemaResult schemaResult, Schema schema) {
        HashMap<String, Object> schemaResultMap = new HashMap<String, Object>();
        String schemaStatus = "succeed";
        List<AreaResult> areaResultList = schemaResult.getAreaResults();
        ArrayList areaResultMapList = new ArrayList(areaResultList.size());
        if (CollectionUtils.isNotEmpty(areaResultList)) {
            for (AreaResult areaResult : areaResultList) {
                HashMap<String, Object> areaResultMap = new HashMap<String, Object>(4);
                Area area = areaResult.getArea();
                areaResultMap.put("area", area.getTitle());
                List<DecisionResult> decisionResultList = areaResult.getDecisionResults();
                if (CollectionUtils.isEmpty(decisionResultList)) continue;
                ArrayList list = new ArrayList(decisionResultList.size());
                for (DecisionResult decisionResult : decisionResultList) {
                    Decision decision;
                    String matchType;
                    MatchType matchTypeEnum;
                    if (decisionResult == null) continue;
                    String decisionResultStatus = decisionResult.getStatus();
                    if ("none".equals(decisionResultStatus)) {
                        schemaStatus = "failed";
                        decisionResultStatus = "failed";
                    }
                    if ((matchTypeEnum = MatchType.convertFromMatchType(matchType = (decision = decisionResult.getDecision()).getMatchType())) != MatchType.LINKUP_BILL && MatchType.containsType(matchType)) continue;
                    HashMap<String, Object> itemResultMap = new HashMap<String, Object>();
                    itemResultMap.put("decision", decision.getName());
                    itemResultMap.put("status", decisionResultStatus);
                    List<Map<String, Object>> result = matchTypeEnum == MatchType.LINKUP_BILL ? this.buildLinkBillResult(decisionResult) : this.buildCustomResult(decisionResult);
                    itemResultMap.put("resultdescripts", result);
                    list.add(itemResultMap);
                    areaResultMap.put("decisionresults", list);
                    areaResultMapList.add(areaResultMap);
                }
            }
        }
        schemaResultMap.put("status", schemaStatus);
        schemaResultMap.put("arearesults", areaResultMapList);
        return schemaResultMap;
    }

    @Override
    public Map<String, Object> convertObject(DynamicObject schemaResult, List<DynamicObject> itemResultList) {
        HashMap<String, Object> schemaResultMap = new HashMap<String, Object>();
        schemaResultMap.put("billid", schemaResult.getString("billid"));
        schemaResultMap.put("billtype", schemaResult.getString("billtype"));
        schemaResultMap.put("schemaid", String.valueOf(schemaResult.get("schema")));
        schemaResultMap.put("createdate", schemaResult.getDate("createdate"));
        schemaResultMap.put("status", schemaResult.getString("status"));
        LinkedHashMap<String, ArrayList<DynamicObject>> itemMap = new LinkedHashMap<String, ArrayList<DynamicObject>>(10);
        for (DynamicObject itemDynamicObject : itemResultList) {
            String area = itemDynamicObject.getString("area");
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)itemMap.get(area);
            if (list == null) {
                list = new ArrayList<DynamicObject>(10);
                itemMap.put(area, list);
            }
            list.add(itemDynamicObject);
        }
        ArrayList areaResultList = new ArrayList(itemMap.size());
        Set itemEntrySet = itemMap.entrySet();
        for (Map.Entry itemEntry : itemEntrySet) {
            HashMap<String, Object> areaResult = new HashMap<String, Object>();
            String areaName = (String)itemEntry.getKey();
            areaResult.put("area", areaName);
            List decisionResultList = (List)itemEntry.getValue();
            ArrayList list = new ArrayList(decisionResultList.size());
            for (DynamicObject itemResult : decisionResultList) {
                DecisionResult decisionResult;
                String matchType = itemResult.getString("matchtype");
                MatchType matchTypeEnum = MatchType.convertFromMatchType(matchType);
                if (matchTypeEnum != MatchType.LINKUP_BILL && MatchType.containsType(matchType)) continue;
                HashMap<String, Object> itemResultMap = new HashMap<String, Object>();
                itemResultMap.put("decision", itemResult.getString("item"));
                itemResultMap.put("status", itemResult.getString("status"));
                String decisionResultStr = itemResult.getString("result_tag");
                if (StringUtils.isNotEmpty((String)decisionResultStr) && (decisionResult = (DecisionResult)IDIJSONUtils.cast((String)decisionResultStr, DecisionResult.class)) != null) {
                    List<Map<String, Object>> result = matchTypeEnum == MatchType.LINKUP_BILL ? this.buildLinkBillResult(decisionResult) : this.buildCustomResult(decisionResult);
                    itemResultMap.put("resultdescripts", result);
                }
                list.add(itemResultMap);
            }
            areaResult.put("decisionresults", list);
            areaResultList.add(areaResult);
        }
        schemaResultMap.put("arearesults", areaResultList);
        return schemaResultMap;
    }

    private List<Map<String, Object>> buildLinkBillResult(DecisionResult decisionResult) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(3);
        List<LinkUpBillResult> linkUpBillResultList = decisionResult.getLinkUpBillResults();
        if (linkUpBillResultList != null && !linkUpBillResultList.isEmpty()) {
            for (LinkUpBillResult linkUpBillResult : linkUpBillResultList) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("showtext", linkUpBillResult.getShowText());
                resultMap.put("popover", this.buildPopover(linkUpBillResult.getFrontEndResult()));
                result.add(resultMap);
            }
        } else {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("showtext", decisionResult.getShowText());
            resultMap.put("popover", this.buildPopover(decisionResult.getFrontEndResult()));
            result.add(resultMap);
        }
        return result;
    }

    private Map<String, Object> buildPopover(DecisionFrontEndResult frontEndResult) {
        if (frontEndResult != null) {
            HashMap<String, Object> popoverMap = new HashMap<String, Object>(3);
            List<List<HoverContent>> hoverContent = frontEndResult.getHoverContent();
            if (hoverContent == null || hoverContent.isEmpty()) {
                return null;
            }
            popoverMap.put("tableStyle", frontEndResult.isTableStyle());
            ArrayList dataList = new ArrayList(hoverContent.size());
            popoverMap.put("contents", dataList);
            if (frontEndResult.isTableStyle()) {
                List<HoverContent> titleList = hoverContent.get(0);
                LinkedHashMap dataMap = new LinkedHashMap(titleList.size());
                for (HoverContent content : titleList) {
                    ArrayList valueList = new ArrayList(hoverContent.size() - 1);
                    dataMap.put(content.getContent(), valueList);
                    HashMap<String, Object> popoverDataMap = new HashMap<String, Object>();
                    popoverDataMap.put("title", content.getContent());
                    popoverDataMap.put("values", valueList);
                    dataList.add(popoverDataMap);
                }
                for (int rowIndex = 1; rowIndex < hoverContent.size(); ++rowIndex) {
                    List<HoverContent> rowData = hoverContent.get(rowIndex);
                    for (int columnIndex = 0; columnIndex < rowData.size(); ++columnIndex) {
                        String title = titleList.get(columnIndex).getContent();
                        List columnDataList = (List)dataMap.get(title);
                        columnDataList.add(rowData.get(columnIndex).getContent());
                    }
                }
            } else {
                for (int rowIndex = 0; rowIndex < hoverContent.size(); ++rowIndex) {
                    List<HoverContent> rowData = hoverContent.get(rowIndex);
                    HashMap<String, Object> popoverDataMap = new HashMap<String, Object>();
                    ArrayList<String> valueList = new ArrayList<String>(hoverContent.size() - 1);
                    popoverDataMap.put("values", valueList);
                    dataList.add(popoverDataMap);
                    for (int columnIndex = 0; columnIndex < rowData.size(); ++columnIndex) {
                        HoverContent hc = rowData.get(columnIndex);
                        if (HoverContent.ContentType.TITLE == hc.getType()) {
                            popoverDataMap.put("title", hc.getContent());
                            continue;
                        }
                        valueList.add(rowData.get(columnIndex).getContent());
                    }
                }
            }
            return popoverMap;
        }
        return null;
    }

    private List<Map<String, Object>> buildCustomResult(DecisionResult decisionResult) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(3);
        List<ApiDecisionResultItem> apiDecisionResultItemList = decisionResult.getApiDecisionResultItems();
        if (apiDecisionResultItemList != null && !apiDecisionResultItemList.isEmpty()) {
            for (ApiDecisionResultItem apiDecisionResultItem : apiDecisionResultItemList) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("showtext", apiDecisionResultItem.getShowText());
                DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
                decisionFrontEndResult.setHoverContent(apiDecisionResultItem.getHoverContents());
                decisionFrontEndResult.setTableStyle(true);
                resultMap.put("popover", this.buildPopover(decisionFrontEndResult));
                result.add(resultMap);
            }
        }
        return result;
    }
}

