/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DimensionTypeEnum;
import kd.data.idi.data.FasindexConfig;
import kd.data.idi.data.FasindexResult;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.FasindexHelper;
import kd.data.idi.engine.SchemaExecutorLogger;

public class FasindexExecutor
implements DecisionExecutor {
    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        DecisionResult result = new DecisionResult();
        result.setDecision(decision);
        FasindexConfig config = decision.getFasindexConfig();
        Long fasindexId = config.getFasindexId();
        try {
            DynamicObject fasObj = BusinessDataServiceHelper.loadSingle((Object)fasindexId, (String)"pa_fasindex");
            config.setFasindexName(fasObj.getString("name"));
            config.setFasindexNumber(fasObj.getString("number"));
        }
        catch (Exception e) {
            SchemaExecutorLogger.error(e);
            String message = ResManager.loadKDString((String)"\u6307\u6807\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u9009\u62e9", (String)"FasindexExecutor_3", (String)"data-idi-core", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", message), new Object[]{message});
        }
        String fasindexField = config.getFasindexNumber();
        List<FasindexConfig.DimensionValue> dimensionValueList = config.getDimensionValueList();
        Map<Object, DynamicObject> dimensionMap = this.queryDimension(dimensionValueList);
        DynamicObject sourceBill = context.getSelfBill();
        HashMap<Long, Map<Object, Object>> dataConvertMap = new HashMap<Long, Map<Object, Object>>();
        HashMap<Long, Object[]> params = new HashMap<Long, Object[]>(dimensionValueList.size());
        FasindexConfig.DimensionValue period = null;
        for (FasindexConfig.DimensionValue dimensionValue : dimensionValueList) {
            Object[] objectArray;
            HashMap<Object, Object> dimensionConvertMap;
            Long key = dimensionValue.getDimensionId();
            DynamicObject dimensionObj = dimensionMap.get(key);
            dimensionValue.setDimensionName(dimensionObj.getString("name"));
            dimensionValue.setDimensionNumber(dimensionObj.getString("number"));
            dimensionValue.setDimensionType(DimensionTypeEnum.getEnum(dimensionObj.getString("dimensiontype")));
            boolean isFix = dimensionValue.isFix();
            boolean isBasedata = dimensionValue.isBasedata();
            boolean isPeriodDim = dimensionValue.isPeriodDimension();
            if (isPeriodDim) {
                period = dimensionValue;
            }
            if ((dimensionConvertMap = (HashMap<Object, Object>)dataConvertMap.get(key)) == null) {
                dimensionConvertMap = new HashMap<Object, Object>();
                dataConvertMap.put(key, dimensionConvertMap);
            }
            if (isFix) {
                Object fixValue = isBasedata ? Long.valueOf(dimensionValue.getFixValue()) : dimensionValue.getFixValue();
                Object[] objs = new Object[]{fixValue};
                params.put(key, objs);
                dimensionConvertMap.put(fixValue, dimensionValue.getDisplayFixValue());
                continue;
            }
            if (StringUtils.isEmpty((String)dimensionValue.getProperty())) {
                params.put(key, new Object[0]);
                if (dimensionValue.getDimensionType() != DimensionTypeEnum.COMBO) continue;
                HashMap<Object, Object> finalDimensionConvertMap = dimensionConvertMap;
                dimensionObj.getDynamicObjectCollection("entryentityenums").forEach(row -> finalDimensionConvertMap.put(row.getString("value"), row.getString("title")));
                continue;
            }
            ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.getValueAndNameByName(sourceBill, dimensionValue.getProperty(), false);
            Object value = valueAndName.getValue();
            if (value instanceof List) {
                List valueList = (List)value;
                Object[] objs = new Object[valueList.size()];
                boolean isDate = false;
                int index = 0;
                for (Object o : valueList) {
                    isDate = o instanceof Date;
                    if (o instanceof DynamicObject) {
                        DynamicObject valueObj = (DynamicObject)o;
                        dimensionConvertMap.put(valueObj.getPkValue(), valueObj.getString("name"));
                        objs[index++] = valueObj.getPkValue();
                        continue;
                    }
                    if (isDate) continue;
                    dimensionConvertMap.put(o, o);
                    objs[index++] = o;
                }
                if (isDate) {
                    Object o;
                    Map<Date, Long> periodMap = FasindexHelper.dateConvertPeriod(key, valueList);
                    index = 0;
                    o = periodMap.entrySet().iterator();
                    while (o.hasNext()) {
                        Map.Entry dateLongEntry = (Map.Entry)o.next();
                        if (dateLongEntry.getValue() == null) continue;
                        objs[index++] = dateLongEntry.getValue();
                    }
                    if (index < objs.length) {
                        Object[] newObjs = new Object[index];
                        System.arraycopy(objs, 0, newObjs, 0, index);
                        objs = newObjs;
                    }
                }
                params.put(key, index == 0 ? new Object[]{} : objs);
                continue;
            }
            if ((value = this.paramValueConvert(value, isPeriodDim, key, dimensionConvertMap)) == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = value;
            }
            params.put(key, objectArray);
        }
        List<FasindexConfig.ValueTypeEnum> valueTypeList = config.getValueTypeList();
        List<FasindexParam> fasindexParamList = this.processValueType(valueTypeList, params, period);
        FasindexResult fasindexResult = new FasindexResult();
        ArrayList<FasindexResult.FasindexCardDataResult> cardList = new ArrayList<FasindexResult.FasindexCardDataResult>(10);
        fasindexResult.setCardData(cardList);
        HashMap<Long, Map<Object, Object>> unConvertDataMap = new HashMap<Long, Map<Object, Object>>();
        for (FasindexParam fasindexParam : fasindexParamList) {
            SchemaExecutorLogger.info("start query fasindex, param:" + fasindexParam, new Object[0]);
            long start = System.currentTimeMillis();
            this.queryFasindexData(fasindexId, fasindexField, fasindexParam, dimensionValueList, dataConvertMap, cardList, unConvertDataMap);
            SchemaExecutorLogger.info("end query fasindex, cost:" + (System.currentTimeMillis() - start), new Object[0]);
        }
        long start = System.currentTimeMillis();
        this.convertDisplay(unConvertDataMap, cardList);
        SchemaExecutorLogger.info("convertDisplay, cost:" + (System.currentTimeMillis() - start), new Object[0]);
        result.setFasindexResult(fasindexResult);
        fasindexResult.setTitle(config.getFasindexName());
        return result;
    }

    private Map<Object, DynamicObject> queryDimension(List<FasindexConfig.DimensionValue> dimensionValueList) {
        Object[] ids = dimensionValueList.stream().map(config -> config.getDimensionId()).collect(Collectors.toList()).toArray(new Object[0]);
        return BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"pa_dimension");
    }

    private Object paramValueConvert(Object data, boolean isPeriodDim, Long dimensionId, Map<Object, Object> dimensionConvertMap) {
        boolean isDate = data instanceof Date;
        Object result = data;
        if (isDate && isPeriodDim) {
            result = isDate ? FasindexHelper.dateConvertPeriod(dimensionId, (Date)data) : data;
            dimensionConvertMap.put(data, isDate ? String.valueOf(data) : data);
        } else if (data instanceof DynamicObject) {
            DynamicObject valueObj = (DynamicObject)data;
            result = valueObj.getPkValue();
            dimensionConvertMap.put(valueObj.getPkValue(), valueObj.getString("name"));
        } else {
            dimensionConvertMap.put(data, data);
        }
        return result;
    }

    private void convertDisplay(Map<Long, Map<Object, Object>> unConvertDataMap, List<FasindexResult.FasindexCardDataResult> cardList) {
        Map<Object, Object> valueDisplayMap;
        Set<Map.Entry<Long, Map<Object, Object>>> set = unConvertDataMap.entrySet();
        Set<Long> idSet = unConvertDataMap.keySet();
        Map<Object, DynamicObject> dimensionObjMap = FasindexHelper.queryDimension(idSet);
        for (Map.Entry<Long, Map<Object, Object>> entry : set) {
            Map<Object, Object> valueMap = entry.getValue();
            Long dimensionId = entry.getKey();
            DynamicObject dimensionObj = dimensionObjMap.get(dimensionId);
            valueDisplayMap = FasindexHelper.queryDimensionValueDisplay(dimensionObj, valueMap.keySet());
            entry.setValue(valueDisplayMap);
        }
        for (FasindexResult.FasindexCardDataResult cardDataResult : cardList) {
            List<FasindexResult.FasindexRow> dimensionValueList = cardDataResult.getDimension();
            for (FasindexResult.FasindexRow fasindexRow : dimensionValueList) {
                valueDisplayMap = unConvertDataMap.get(fasindexRow.dimensionId);
                if (valueDisplayMap == null) continue;
                Object displayValue = valueDisplayMap.get(fasindexRow.value);
                Object object = fasindexRow.value = displayValue == null ? fasindexRow.value : displayValue;
                if (!"0".equals(String.valueOf(fasindexRow.value))) continue;
                fasindexRow.value = "";
            }
        }
    }

    private void queryFasindexData(Long fasindexId, String fasindexField, FasindexParam fasindexParam, List<FasindexConfig.DimensionValue> dimensionValueList, Map<Long, Map<Object, Object>> dataConvertMap, List<FasindexResult.FasindexCardDataResult> cardList, Map<Long, Map<Object, Object>> unConvertDataMap) {
        Map<String, Object> stringObjectMap = null;
        try {
            stringObjectMap = FasindexHelper.commitComparisonCalculate(fasindexId, fasindexParam.getParam(), fasindexParam.getComparison());
            SchemaExecutorLogger.info("after query fasindex, param:" + fasindexParam, new Object[0]);
        }
        catch (Exception e) {
            SchemaExecutorLogger.error(e);
            String message = e.getMessage();
            if (message != null && message.contains(ResManager.loadKDString((String)"\u5df2\u88ab\u7981\u7528", (String)"FasindexExecutor_1", (String)"data-idi-core", (Object[])new Object[0]))) {
                message = ResManager.loadKDString((String)"\u6307\u6807\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u542f\u7528\u6216\u91cd\u65b0\u9009\u62e9", (String)"FasindexExecutor_2", (String)"data-idi-core", (Object[])new Object[0]);
            }
            throw new KDBizException((Throwable)e, new ErrorCode("", message), new Object[]{e.getMessage()});
        }
        if (stringObjectMap != null && !stringObjectMap.isEmpty()) {
            if (stringObjectMap.get("cacheId") != null && StringUtils.isNotEmpty((String)stringObjectMap.get("cacheId").toString())) {
                int subRowIndex;
                CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)stringObjectMap.get("cacheId").toString());
                int rowIndex = 0;
                int stepCount = 1000;
                do {
                    subRowIndex = 0;
                    Iterator iterator = cacheDataSet.iterator(rowIndex, stepCount);
                    rowIndex += stepCount;
                    while (iterator.hasNext()) {
                        ++subRowIndex;
                        Row next = (Row)iterator.next();
                        FasindexResult.FasindexCardDataResult cardDataResult = new FasindexResult.FasindexCardDataResult();
                        cardList.add(cardDataResult);
                        ArrayList<FasindexResult.FasindexRow> cardRowList = new ArrayList<FasindexResult.FasindexRow>(dimensionValueList.size());
                        cardDataResult.setDimension(cardRowList);
                        String periodField = null;
                        Long periodDimension = null;
                        for (FasindexConfig.DimensionValue dimensionValue : dimensionValueList) {
                            String field = dimensionValue.getDimensionNumber();
                            if (dimensionValue.isPeriodDimension()) {
                                periodField = field;
                                periodDimension = dimensionValue.getDimensionId();
                            }
                            Object value = next.get(field);
                            Map<Object, Object> dimensionConvertMap = dataConvertMap.get(dimensionValue.getDimensionId());
                            Object display = value;
                            if (!dimensionConvertMap.isEmpty()) {
                                display = dimensionConvertMap.get(value);
                            }
                            if ((display == null || dimensionConvertMap.isEmpty()) && dimensionValue.isBasedata()) {
                                if (!this.isInvalid(value)) {
                                    Map unConvertMap = unConvertDataMap.computeIfAbsent(dimensionValue.getDimensionId(), key -> new HashMap(10));
                                    unConvertMap.putIfAbsent(value, display);
                                    display = value;
                                } else {
                                    display = "";
                                }
                            }
                            FasindexResult.FasindexRow dimensionRow = new FasindexResult.FasindexRow();
                            dimensionRow.dimensionId = dimensionValue.getDimensionId();
                            dimensionRow.displayDimension = dimensionValue.getDimensionName();
                            dimensionRow.value = display;
                            cardRowList.add(dimensionRow);
                        }
                        List<String> fieldList = fasindexParam.valueField(fasindexField);
                        int index = 0;
                        for (String field : fieldList) {
                            if (index > 0) {
                                cardDataResult = cardDataResult.clone();
                                cardList.add(cardDataResult);
                            }
                            Object value = next.get(field);
                            cardDataResult.setValue(value);
                            if (fasindexParam instanceof FasindexParamYQCompose) {
                                Map unConvertMap;
                                Map comparisonMap;
                                FasindexConfig.ValueTypeEnum valueType = fasindexParam.getValueType(field);
                                cardDataResult.setValueType(fasindexParam.getValueType(field));
                                FasindexResult.FasindexRow periodRow = null;
                                for (FasindexResult.FasindexRow fasindexRow : cardDataResult.getDimension()) {
                                    if (!fasindexRow.dimensionId.equals(periodDimension)) continue;
                                    periodRow = fasindexRow;
                                    break;
                                }
                                if (valueType == FasindexConfig.ValueTypeEnum.C_05) {
                                    comparisonMap = (Map)stringObjectMap.get("comparisonMap");
                                    if (periodRow != null && comparisonMap != null && comparisonMap.get("yoy") != null) {
                                        Map periodToYMap = (Map)comparisonMap.get("yoy");
                                        Long yPeriod = (Long)periodToYMap.get(next.getLong(periodField));
                                        periodRow.value = yPeriod;
                                        unConvertMap = unConvertDataMap.computeIfAbsent(periodDimension, key -> new HashMap(10));
                                        unConvertMap.putIfAbsent(periodRow.value, periodRow.value);
                                    }
                                }
                                if (valueType == FasindexConfig.ValueTypeEnum.C_06) {
                                    comparisonMap = (Map)stringObjectMap.get("comparisonMap");
                                    if (periodRow != null && comparisonMap != null && comparisonMap.get("qoq") != null) {
                                        Map periodToQMap = (Map)comparisonMap.get("qoq");
                                        Long qPeriod = (Long)periodToQMap.get(next.getLong(periodField));
                                        periodRow.value = qPeriod;
                                        unConvertMap = unConvertDataMap.computeIfAbsent(periodDimension, key -> new HashMap(10));
                                        unConvertMap.putIfAbsent(periodRow.value, periodRow.value);
                                    }
                                }
                            } else {
                                cardDataResult.setValueType(StringUtils.isEmpty((String)periodField) ? fasindexParam.getValueType(0L) : fasindexParam.getValueType(next.getLong(periodField)));
                            }
                            ++index;
                        }
                    }
                } while (subRowIndex != 0 && subRowIndex % stepCount == 0);
            } else if (stringObjectMap.get("code") != null && StringUtils.isNotEmpty((String)stringObjectMap.get("code").toString())) {
                String message = (String)stringObjectMap.get("message");
                SchemaExecutorLogger.error(message);
                throw new KDBizException(message);
            }
        }
    }

    private boolean isInvalid(Object value) {
        return "0".equals(String.valueOf(value));
    }

    private List<FasindexParam> processValueType(List<FasindexConfig.ValueTypeEnum> valueTypeList, Map<Long, Object[]> params, FasindexConfig.DimensionValue periodDim) {
        FasindexParam compose;
        ArrayList<FasindexParam> paramList = new ArrayList<FasindexParam>(valueTypeList.size());
        ArrayList<FasindexParam> originalParamList = new ArrayList<FasindexParam>(3);
        boolean hasYOY = false;
        boolean hasQOQ = false;
        for (FasindexConfig.ValueTypeEnum valueTypeEnum : valueTypeList) {
            FasindexParam fp2 = new FasindexParam();
            fp2.valueType = valueTypeEnum;
            HashMap<Long, Object[]> paramMap = new HashMap<Long, Object[]>(params.size());
            paramMap.putAll(params);
            fp2.paramMap = paramMap;
            if (valueTypeEnum == FasindexConfig.ValueTypeEnum.C_05 || valueTypeEnum == FasindexConfig.ValueTypeEnum.C_06 || valueTypeEnum == FasindexConfig.ValueTypeEnum.C_00) {
                if (valueTypeEnum != FasindexConfig.ValueTypeEnum.C_00) {
                    fp2.periodDimensionId = periodDim.getDimensionId();
                }
                originalParamList.add(fp2);
                continue;
            }
            if (valueTypeEnum == FasindexConfig.ValueTypeEnum.C_01 || valueTypeEnum == FasindexConfig.ValueTypeEnum.C_02) {
                hasYOY = true;
            }
            if (valueTypeEnum == FasindexConfig.ValueTypeEnum.C_03 || valueTypeEnum == FasindexConfig.ValueTypeEnum.C_04) {
                hasQOQ = true;
            }
            paramList.add(fp2);
        }
        if (originalParamList.isEmpty() || hasYOY && hasQOQ) {
            compose = new FasindexParamYQCompose();
            compose.paramMap = params;
            compose.yorqFasindexParamList = paramList;
            compose.originalList = originalParamList;
            ArrayList<FasindexParam> newParamList = new ArrayList<FasindexParam>(2);
            newParamList.add(compose);
            return newParamList;
        }
        if (hasYOY && !hasQOQ) {
            return this.composeParam(params, paramList, originalParamList, fp -> fp.valueType == FasindexConfig.ValueTypeEnum.C_05 || fp.valueType == FasindexConfig.ValueTypeEnum.C_00);
        }
        if (hasQOQ && !hasYOY) {
            return this.composeParam(params, paramList, originalParamList, fp -> fp.valueType == FasindexConfig.ValueTypeEnum.C_06 || fp.valueType == FasindexConfig.ValueTypeEnum.C_00);
        }
        if (paramList.isEmpty() && originalParamList.size() > 1) {
            compose = new FasindexParamOriginalCompose();
            for (FasindexParam fasindexParam : originalParamList) {
                fasindexParam.periodDimensionId = periodDim.getDimensionId();
            }
            ((FasindexParamOriginalCompose)compose).composeList = originalParamList;
            ((FasindexParamOriginalCompose)compose).periodDimensionId = periodDim.getDimensionId();
            paramList.add(compose);
        } else {
            paramList.addAll(originalParamList);
        }
        return paramList;
    }

    private List<FasindexParam> composeParam(Map<Long, Object[]> params, List<FasindexParam> paramList, List<FasindexParam> originalParamList, Function<FasindexParam, Boolean> isselect) {
        ArrayList<FasindexParam> newParamList = new ArrayList<FasindexParam>(2);
        FasindexParamYQCompose compose = new FasindexParamYQCompose();
        compose.paramMap = params;
        compose.yorqFasindexParamList = paramList;
        ArrayList<FasindexParam> yParamList = new ArrayList<FasindexParam>();
        ArrayList<FasindexParam> otherParamList = new ArrayList<FasindexParam>();
        for (FasindexParam fp : originalParamList) {
            if (isselect.apply(fp).booleanValue()) {
                yParamList.add(fp);
                continue;
            }
            otherParamList.add(fp);
        }
        compose.originalList = yParamList;
        newParamList.add(compose);
        newParamList.addAll(otherParamList);
        return newParamList;
    }

    private class FasindexParamYQCompose
    extends FasindexParam {
        public List<FasindexParam> yorqFasindexParamList;
        public List<FasindexParam> originalList;
        private Map<String, FasindexConfig.ValueTypeEnum> valueFieldToTypeMap;

        private FasindexParamYQCompose() {
        }

        @Override
        public Map<Long, Object[]> getParam() {
            return this.paramMap;
        }

        @Override
        public Map<String, Object> getComparison() {
            HashMap<String, Object> comparison = new HashMap<String, Object>(1);
            StringBuilder comparisonType = new StringBuilder();
            for (FasindexParam fasindexParam : this.yorqFasindexParamList) {
                comparisonType.append(fasindexParam.valueType.getType()).append(',');
            }
            comparison.put("comparisonType", comparisonType.substring(0, comparisonType.length() - 1));
            return comparison;
        }

        @Override
        public List<String> valueField(String fasindexField) {
            int index;
            List<String> fieldList;
            ArrayList<String> valueFieldList = new ArrayList<String>(10);
            this.valueFieldToTypeMap = new HashMap<String, FasindexConfig.ValueTypeEnum>(10);
            Object[] array = new Object[7];
            Map<FasindexConfig.ValueTypeEnum, Integer> indexMap = this.getValueSort();
            for (FasindexParam fasindexParam : this.yorqFasindexParamList) {
                fieldList = fasindexParam.valueField(fasindexField);
                this.valueFieldToTypeMap.put(fieldList.get(0), fasindexParam.valueType);
                index = indexMap.get((Object)fasindexParam.valueType);
                array[index] = fieldList;
            }
            if (this.originalList != null) {
                for (FasindexParam fasindexParam : this.originalList) {
                    switch (fasindexParam.valueType) {
                        case C_00: {
                            fieldList = fasindexParam.valueField(fasindexField);
                            index = indexMap.get((Object)fasindexParam.valueType);
                            array[index] = fieldList;
                            this.valueFieldToTypeMap.put(fieldList.get(0), fasindexParam.valueType);
                            break;
                        }
                        case C_05: {
                            String yoyField = "_yoy_" + fasindexField;
                            ArrayList<String> yoyFieldList = new ArrayList<String>(2);
                            yoyFieldList.add(yoyField);
                            int yIndex = indexMap.get((Object)fasindexParam.valueType);
                            array[yIndex] = yoyFieldList;
                            this.valueFieldToTypeMap.put(yoyField, fasindexParam.valueType);
                            break;
                        }
                        case C_06: {
                            String qoqField = "_qoq_" + fasindexField;
                            ArrayList<String> qoqFieldList = new ArrayList<String>(2);
                            qoqFieldList.add(qoqField);
                            int qIndex = indexMap.get((Object)fasindexParam.valueType);
                            array[qIndex] = qoqFieldList;
                            this.valueFieldToTypeMap.put(qoqField, fasindexParam.valueType);
                        }
                    }
                }
            }
            for (Object o : array) {
                if (o == null) continue;
                List fieldList2 = (List)o;
                valueFieldList.addAll(fieldList2);
            }
            return valueFieldList;
        }

        private Map<FasindexConfig.ValueTypeEnum, Integer> getValueSort() {
            HashMap<FasindexConfig.ValueTypeEnum, Integer> map = new HashMap<FasindexConfig.ValueTypeEnum, Integer>();
            map.put(FasindexConfig.ValueTypeEnum.C_00, 0);
            map.put(FasindexConfig.ValueTypeEnum.C_05, 1);
            map.put(FasindexConfig.ValueTypeEnum.C_02, 2);
            map.put(FasindexConfig.ValueTypeEnum.C_01, 3);
            map.put(FasindexConfig.ValueTypeEnum.C_06, 4);
            map.put(FasindexConfig.ValueTypeEnum.C_04, 5);
            map.put(FasindexConfig.ValueTypeEnum.C_03, 6);
            return map;
        }

        @Override
        public FasindexConfig.ValueTypeEnum getValueType(Object valueField) {
            return this.valueFieldToTypeMap.get((String)valueField);
        }

        @Override
        public String toString() {
            return "FasindexParamYQCompose{yorqFasindexParamList=" + this.yorqFasindexParamList + ", originalList=" + this.originalList + ", valueFieldToTypeMap=" + this.valueFieldToTypeMap + ", param=" + this.paramToString(this.paramMap) + '}';
        }
    }

    private class FasindexParamOriginalCompose
    extends FasindexParam {
        public List<FasindexParam> composeList;

        private FasindexParamOriginalCompose() {
        }

        @Override
        public Map<Long, Object[]> getParam() {
            Map<Long, Object[]> templateParamMap = this.composeList.get(0).getParam();
            HashMap<Long, Object[]> paramMap = new HashMap<Long, Object[]>();
            paramMap.putAll(templateParamMap);
            ArrayList<Object> periodList = new ArrayList<Object>(10);
            for (int i = 0; i < this.composeList.size(); ++i) {
                Object[] periodIds = this.composeList.get(i).getParam().get(this.periodDimensionId);
                if (periodIds == null) continue;
                for (Object o : periodIds) {
                    periodList.add(o);
                }
            }
            paramMap.put(this.periodDimensionId, periodList.toArray(new Object[0]));
            return paramMap;
        }

        @Override
        public Map<String, Object> getComparison() {
            HashMap<String, Object> comparison = new HashMap<String, Object>(1);
            comparison.put("comparisonType", "00");
            return comparison;
        }

        @Override
        public List<String> valueField(String fasindexField) {
            ArrayList<String> valueFieldList = new ArrayList<String>(2);
            valueFieldList.add("_index_" + fasindexField);
            return valueFieldList;
        }

        @Override
        public FasindexConfig.ValueTypeEnum getValueType(Object periodId) {
            for (FasindexParam fasindexParam : this.composeList) {
                Object[] periodIds;
                for (Object id : periodIds = fasindexParam.getParam().get(this.periodDimensionId)) {
                    if (!Objects.equals(String.valueOf(periodId), String.valueOf(id))) continue;
                    return fasindexParam.getValueType(periodId);
                }
            }
            throw new KDBizException("not find valuetype, periodid:" + periodId);
        }

        @Override
        public String toString() {
            return "FasindexParamOriginalCompose{composeList=" + this.composeList + ", periodDimensionId=" + this.periodDimensionId + '}';
        }
    }

    private class FasindexParam {
        public Map<Long, Object[]> paramMap;
        public FasindexConfig.ValueTypeEnum valueType;
        public Long periodDimensionId;
        public Map<Long, Object[]> processedParamMap;

        private FasindexParam() {
        }

        public Map<Long, Object[]> getParam() {
            if (this.valueType == FasindexConfig.ValueTypeEnum.C_05 || this.valueType == FasindexConfig.ValueTypeEnum.C_06) {
                if (this.processedParamMap != null) {
                    return this.processedParamMap;
                }
                HashMap<Long, Object[]> newParamMap = new HashMap<Long, Object[]>();
                newParamMap.putAll(this.paramMap);
                Object[] periodIds = (Object[])newParamMap.get(this.periodDimensionId);
                if (periodIds == null || periodIds.length == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u548c\u4e0a\u671f\uff0c\u5fc5\u987b\u8bbe\u7f6e\u671f\u95f4\u503c", (String)"FasindexExecutor_0", (String)"data-idi-core", (Object[])new Object[0]));
                }
                Set<Long> newPeriodIdSet = this.valueType == FasindexConfig.ValueTypeEnum.C_05 ? FasindexHelper.samePeriodOnPreviousYear(this.periodDimensionId, periodIds) : FasindexHelper.previousPeriod(this.periodDimensionId, periodIds);
                Object[] newPeriodIds = newPeriodIdSet.toArray(new Object[0]);
                newParamMap.put(this.periodDimensionId, newPeriodIds);
                this.processedParamMap = newParamMap;
                return newParamMap;
            }
            return this.paramMap;
        }

        public Map<String, Object> getComparison() {
            HashMap<String, Object> comparison = new HashMap<String, Object>(1);
            comparison.put("comparisonType", this.valueType == FasindexConfig.ValueTypeEnum.C_05 || this.valueType == FasindexConfig.ValueTypeEnum.C_06 ? "00" : this.valueType.getType());
            return comparison;
        }

        public List<String> valueField(String fasindexField) {
            ArrayList<String> valueField = new ArrayList<String>(2);
            String field = this.valueType == FasindexConfig.ValueTypeEnum.C_05 || this.valueType == FasindexConfig.ValueTypeEnum.C_06 || this.valueType == FasindexConfig.ValueTypeEnum.C_00 ? "_index_" + fasindexField : "_C" + this.valueType.getType() + '_';
            valueField.add(field);
            return valueField;
        }

        public FasindexConfig.ValueTypeEnum getValueType(Object periodId) {
            return this.valueType;
        }

        public String toString() {
            return "FasindexParam{paramMap=" + this.paramToString(this.paramMap) + ", valueType=" + (Object)((Object)this.valueType) + ", periodDimensionId=" + this.periodDimensionId + ", processedParamMap=" + this.paramToString(this.processedParamMap) + '}';
        }

        protected String paramToString(Map<Long, Object[]> printParamMap) {
            StringBuilder mapBuilder = new StringBuilder();
            mapBuilder.append('{');
            if (printParamMap != null) {
                for (Map.Entry<Long, Object[]> longEntry : printParamMap.entrySet()) {
                    mapBuilder.append(longEntry.getKey()).append('=').append('[');
                    for (Object o : longEntry.getValue()) {
                        mapBuilder.append(o).append(',');
                    }
                    mapBuilder.setCharAt(mapBuilder.length() - 1, ']');
                    mapBuilder.append(',');
                }
                mapBuilder.setCharAt(mapBuilder.length() - 1, '}');
            } else {
                mapBuilder.append('}');
            }
            return mapBuilder.toString();
        }
    }
}

