/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.data.idi.model.BaseHighLight;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.BillInfo;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.IDICompareType;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.LinkUpBillConfig;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.Relation;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.engine.BillCheckResult;
import kd.data.idi.engine.BillCountLimitValidator;
import kd.data.idi.engine.BillLinkRelation;
import kd.data.idi.engine.CustomizedRelationBillChecker;
import kd.data.idi.engine.DeductionGrade;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptLocaleFieldHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.SelfBillDecisionExecutor;
import kd.data.idi.engine.customrule.DecisionRuleAnalysisDTO;
import kd.data.idi.engine.customrule.EntryRowRelation;
import kd.data.idi.engine.customrule.EntryRowRelationDTO;
import kd.data.idi.engine.customrule.NoEntryRowRelation;
import kd.data.idi.engine.front.LinkUpBillFront;
import kd.data.idi.engine.functions.ArrayDiffFunc;
import kd.data.idi.engine.functions.CustomFuncEnum;
import kd.data.idi.engine.functions.CustomFuncInfoChain;
import kd.data.idi.engine.functions.SubsetFunc;
import kd.data.idi.engine.functions.SumEntryFunc;
import kd.data.idi.engine.linkupbill.EntryIndexRelation;
import kd.data.idi.engine.linkupbill.MulEntryValidator;
import kd.data.idi.engine.linkupbill.SubRelation;
import kd.data.idi.exception.CountLimitException;
import kd.data.idi.util.BillDecisionUtil;
import kd.data.idi.util.HighLightBuilder;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.ObjectValueCompareUtil;
import kd.data.idi.util.SystemParamHelper;
import org.apache.commons.lang.ObjectUtils;

public class LinkUpBillDecisionExecutor
extends SelfBillDecisionExecutor {
    private DeductionGrade deductionGrade = null;
    private int conditionSrcEntrySize = 0;

    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        if (decision.getLinkUpBillConfig() == null) {
            SchemaExecutorLogger.info(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0a\u6e38\u5355\u636e\u7684\u914d\u7f6e\u4fe1\u606f\uff01", (String)"LinkUpBillDecisionExecutor_4", (String)"data-idi-core", (Object[])new Object[0]), new Object[0]);
            return null;
        }
        LinkUpBillConfig linkUpBillConfig = decision.getLinkUpBillConfig();
        if (linkUpBillConfig.getCheckType() == null) {
            SchemaExecutorLogger.info(ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e\u7684\u68c0\u67e5\u76ee\u6807\u9879\u6ca1\u6709\u503c\uff01", (String)"LinkUpBillDecisionExecutor_5", (String)"data-idi-core", (Object[])new Object[0]), new Object[0]);
            return null;
        }
        if (linkUpBillConfig.getRelation() == null) {
            SchemaExecutorLogger.info(ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e\u7684\u6e90\u5355\u4e0e\u76ee\u6807\u5355\u5173\u7cfb\u9879\u6ca1\u6709\u503c\uff01", (String)"LinkUpBillDecisionExecutor_6", (String)"data-idi-core", (Object[])new Object[0]), new Object[0]);
            return null;
        }
        this.deductionGrade = new DeductionGrade(context);
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        if (billObj == null) {
            return this.notMatchStartCondition(context, decision);
        }
        MainEntityType srcEntityType = context.getSrcEntityType();
        HashMap<String, Object> ctx = new HashMap<String, Object>(1);
        ctx.put(context.getEntityType() + "_billObj", billObj);
        String startConditionEntry = null;
        ArrayList<Integer> matchStartConditionEntryIndexList = new ArrayList<Integer>(1);
        IDICondition startCondition = decision.getStartCondition();
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript())) {
            Set<String> propSet = ScriptUtils.getEntries(srcEntityType, startCondition.getScript(), new String[]{context.getEntityType()});
            if (propSet.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u652f\u6301\u8de8\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"LinkUpBillDecisionExecutor_12", (String)"data-idi-core", (Object[])new Object[0]));
            }
            DynamicObjectType dynamicObjectType = billObj.getDynamicObjectType();
            if (propSet.size() == 1) {
                startConditionEntry = propSet.iterator().next();
                if (!this.canStart(decision, ctx, dynamicObjectType, matchStartConditionEntryIndexList, startConditionEntry)) {
                    return this.notMatchStartCondition(context, decision);
                }
                SchemaExecutorLogger.info("idi startCondition sourceEntry : %s, match entry index : %s", startConditionEntry, IDIJSONUtils.toJsonString(matchStartConditionEntryIndexList));
            } else if (!this.canStart(decision, ctx, dynamicObjectType, matchStartConditionEntryIndexList, null)) {
                return this.notMatchStartCondition(context, decision);
            }
        }
        List<BillLinkRelation> bills = this.getLinkUpBills(context, decision, billObj);
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        int targetBillCount = this.countLinkUp(bills);
        String billName = linkUpBillConfig.getRelation() == Relation.SELF ? this.getBillDisplayName(context) : decision.getMatchBill().getBillDisplayName();
        if (targetBillCount == 0) {
            String formatMessage = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u76ee\u6807\u5355%2$s\u4e0d\u5b58\u5728", (String)"LinkUpBillDecisionExecutor_3", (String)"data-idi-core", (Object[])new Object[0]), decision.getName(), billName);
            if (LinkUpBillConfig.CheckType.CheckBillExists == linkUpBillConfig.getCheckType()) {
                String words = linkUpBillConfig.getTargetNotExistWords();
                if (StringUtils.isNotEmpty((String)words)) {
                    formatMessage = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s", (String)"LinkUpBillDecisionExecutor_8", (String)"data-idi-core", (Object[])new Object[0]), decision.getName(), words);
                }
                if (LinkUpBillConfig.CheckType.CheckBillExists == linkUpBillConfig.getCheckType() && linkUpBillConfig.isExitAlarm()) {
                    decisionResult.setStatus("green");
                } else {
                    decisionResult.setStatus("alarming");
                    this.deductionGrade.deduct(new BigDecimal(100));
                }
            } else {
                this.deductionGrade.deduct(linkUpBillConfig.getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.NO_BILL);
                boolean isPass = this.findDeductionGradeConfigPass(linkUpBillConfig.getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.NO_BILL);
                decisionResult.setStatus(isPass ? "empty" : "alarming");
            }
            decisionResult.setShowText(formatMessage);
            decisionResult.setDeductPercent(this.deductionGrade.getValue());
            decisionResult.setDecision(decision);
            return decisionResult;
        }
        CustomFuncInfoChain customFuncInfoChain = new CustomFuncInfoChain(this.buildScript(decision.getRules()), null);
        if (LinkUpBillConfig.CheckType.CheckBillContent == linkUpBillConfig.getCheckType()) {
            this.dealCustomFuncIfSelfRelation(decision, billObj, startConditionEntry, matchStartConditionEntryIndexList, customFuncInfoChain, context);
            IDICondition crossEntryRule = decision.getLinkUpBillConfig().getCrossEntryRule();
            try {
                if (Relation.SELF == linkUpBillConfig.getRelation() && (this.isCrossEntryCheck(srcEntityType, customFuncInfoChain) || crossEntryRule != null)) {
                    decisionResult = this.checkCrossEntryRuleBillContent(context, decision, startConditionEntry, matchStartConditionEntryIndexList, customFuncInfoChain, srcEntityType);
                }
                customFuncInfoChain.setDealScript(this.buildRuleScriptFor(decision.getRules()));
                decisionResult = this.checkBillContent(context, decision, bills, startConditionEntry, matchStartConditionEntryIndexList, customFuncInfoChain, srcEntityType);
            }
            catch (CountLimitException countLimitException) {
                return this.buildDecisionResultByCountLimitException(decision, context, countLimitException.getMessage());
            }
        } else {
            String words = linkUpBillConfig.getTargetExistWords();
            String formatMessage = StringUtils.isNotEmpty((String)words) ? String.format(ResManager.loadKDString((String)"%s", (String)"LinkUpBillDecisionExecutor_9", (String)"data-idi-core", (Object[])new Object[0]), words) : String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355%s\u5b58\u5728", (String)"LinkUpBillDecisionExecutor_2", (String)"data-idi-core", (Object[])new Object[0]), billName);
            decisionResult.setShowText(formatMessage);
            if (linkUpBillConfig.isExitAlarm()) {
                decisionResult.setStatus("alarming");
                this.deductionGrade.deduct(new BigDecimal(100));
            } else {
                decisionResult.setStatus("green");
            }
            ArrayList<BillCheckResult> billCheckResults = new ArrayList<BillCheckResult>();
            for (BillLinkRelation relation : bills) {
                if (startConditionEntry != null && startConditionEntry.equals(relation.getSrcEntryName()) && !matchStartConditionEntryIndexList.contains(relation.getSrcEntryIndex())) continue;
                List<DynamicObject> linkBillObjList = relation.getLinkBillObjs();
                for (int index = 0; index < linkBillObjList.size(); ++index) {
                    if (relation.getLinkEntryName() != null && relation.getLinkEntryIndexList() != null && relation.getLinkEntryIndexList().size() > index) {
                        List<Integer> entryIndexList = relation.getLinkEntryIndexList().get(index);
                        for (Integer entryIndex : entryIndexList) {
                            BillCheckResult billCheckResult = new BillCheckResult();
                            billCheckResult.setSrcObj(relation.getSrcBillObj());
                            billCheckResult.setSrcEntryName(relation.getSrcEntryName());
                            billCheckResult.setSrcEntryIndex(relation.getSrcEntryIndex());
                            billCheckResult.setLinkObj(linkBillObjList.get(index));
                            billCheckResult.setLinkEntryName(relation.getLinkEntryName());
                            billCheckResult.setLinkEntryIndex(entryIndex);
                            billCheckResults.add(billCheckResult);
                        }
                        continue;
                    }
                    BillCheckResult billCheckResult = new BillCheckResult();
                    billCheckResult.setSrcObj(relation.getSrcBillObj());
                    billCheckResult.setSrcEntryName(relation.getSrcEntryName());
                    billCheckResult.setSrcEntryIndex(relation.getSrcEntryIndex());
                    billCheckResult.setLinkObj(linkBillObjList.get(index));
                    billCheckResults.add(billCheckResult);
                }
            }
            LinkUpBillFront linkUpBillFront = new LinkUpBillFront(decision, billCheckResults, customFuncInfoChain);
            decisionResult.setFrontEndResult(linkUpBillFront.build());
        }
        if (CollectionUtils.isNotEmpty(decisionResult.getLinkUpBillResults())) {
            for (LinkUpBillResult linkUpBillResult : decisionResult.getLinkUpBillResults()) {
                DecisionFrontEndResult frontEndResult = linkUpBillResult.getFrontEndResult();
                if (!ParamFactory.getBoolean("remove_duplicates", false) || !this.isNotExistExtraFuncColumn(decision, frontEndResult)) continue;
                List<List<HoverContent>> distinctFrontHoverContentList = this.distinctFrontHoverContentList(frontEndResult.getHoverContent());
                frontEndResult.setHoverContent(distinctFrontHoverContentList);
            }
        } else {
            DecisionFrontEndResult frontEndResult = decisionResult.getFrontEndResult();
            if (ParamFactory.getBoolean("remove_duplicates", false) && this.isNotExistExtraFuncColumn(decision, frontEndResult)) {
                List<List<HoverContent>> distinctFrontHoverContentList = this.distinctFrontHoverContentList(frontEndResult.getHoverContent());
                frontEndResult.setHoverContent(distinctFrontHoverContentList);
            }
        }
        this.log(context, decision, decisionResult, ctx);
        decisionResult.setDeductPercent(this.deductionGrade.getValue());
        return decisionResult;
    }

    private DecisionResult buildDecisionResultByCountLimitException(Decision decision, SchemaContext context, String showText) {
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        decisionResult.setShowText(showText);
        decisionResult.setDeductPercent(new DeductionGrade(context).getValue());
        if (context.isBillControl()) {
            decisionResult.setStatus("green");
        } else {
            decisionResult.setStatus("alarming");
        }
        return decisionResult;
    }

    private boolean isNotExistExtraFuncColumn(Decision decision, DecisionFrontEndResult frontEndResult) {
        if (CollectionUtils.isEmpty(decision.getFrontEndConfig().getHoverFieldContents()) || frontEndResult == null || CollectionUtils.isEmpty(frontEndResult.getHoverContent()) || CollectionUtils.isEmpty((Collection)frontEndResult.getHoverContent().get(0))) {
            return false;
        }
        return decision.getFrontEndConfig().getHoverFieldContents().size() == frontEndResult.getHoverContent().get(0).size();
    }

    private List<List<HoverContent>> distinctFrontHoverContentList(List<List<HoverContent>> hoverContent) {
        ArrayList<List<HoverContent>> newHoverContentList = new ArrayList<List<HoverContent>>();
        for (List<HoverContent> hoverContents : hoverContent) {
            boolean contain = false;
            if (CollectionUtils.isNotEmpty(newHoverContentList)) {
                for (List list : newHoverContentList) {
                    boolean eq = true;
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        if (ObjectUtils.equals((Object)((HoverContent)list.get(i1)).getContent(), (Object)hoverContents.get(i1).getContent())) continue;
                        eq = false;
                        break;
                    }
                    if (!eq) continue;
                    contain = true;
                    break;
                }
            }
            if (contain) continue;
            newHoverContentList.add(hoverContents);
        }
        return newHoverContentList;
    }

    private DecisionResult notMatchStartCondition(SchemaContext context, Decision decision) {
        SchemaExecutorLogger.info(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6\uff01", (String)"LinkUpBillDecisionExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), new Object[0]);
        LinkUpBillConfig linkUpBillConfig = decision.getLinkUpBillConfig();
        boolean isPass = this.findDeductionGradeConfigPass(linkUpBillConfig.getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH);
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setStatus(isPass ? "empty" : "alarming");
        decisionResult.setShowText(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"ExceptionTipEnum_2", (String)"data-idi-core", (Object[])new Object[0]));
        this.deductionGrade.deduct(linkUpBillConfig.getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH);
        decisionResult.setDeductPercent(this.deductionGrade.getValue());
        decisionResult.setDecision(decision);
        return decisionResult;
    }

    private boolean isCrossEntryCheck(MainEntityType srcEntityType, CustomFuncInfoChain customFuncInfoChain) {
        Set<String> srcRuleEntrySet = ScriptUtils.getLeastLevelEntries(srcEntityType, customFuncInfoChain.getDealScript(), new String[]{srcEntityType.getName()});
        if (srcRuleEntrySet.size() > 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u8de82\u4e2a\u5206\u5f55\u3001\u5b50\u5206\u5f55\uff0c\u8bf7\u4fee\u6539\u68c0\u67e5\u89c4\u5219\u3002", (String)"LinkUpBillDecisionExecutor_15", (String)"data-idi-core", (Object[])new Object[0]));
        }
        return srcRuleEntrySet.size() > 1;
    }

    private String getBillDisplayName(SchemaContext context) {
        MainEntityType mainType = context.getSrcEntityType();
        if (mainType != null) {
            return mainType.getDisplayName().toString();
        }
        return null;
    }

    private int countLinkUp(List<BillLinkRelation> linkupBillObjs) {
        int count = 0;
        for (BillLinkRelation relation : linkupBillObjs) {
            count += relation.getLinkBillObjs().size();
        }
        return count;
    }

    private DecisionResult checkCrossEntryRuleBillContent(SchemaContext context, Decision decision, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, CustomFuncInfoChain customFuncInfoChain, MainEntityType mainType) {
        DecisionResult decisionResult;
        ArrayList<LinkUpBillResult> linkUpBillResults = new ArrayList<LinkUpBillResult>(1);
        HashMap<Integer, List<BillCheckResult>> ruleBillMap = new HashMap<Integer, List<BillCheckResult>>();
        IDICondition crossEntryRule = decision.getLinkUpBillConfig().getCrossEntryRule();
        DynamicObject srcBillObj = context.getSelfBill();
        String entity = context.getEntityType();
        EntryRowRelationDTO rowRelationDTO = null;
        List<Object> decisionRules = new ArrayList(0);
        String firstEntryNumber = ScriptUtils.getFirstEntryNumber(this.buildScript(decision.getRules()), mainType);
        List<DecisionRule> decisionRuleList = decision.getRules();
        if (crossEntryRule != null && crossEntryRule.getFilterCondition() != null && !crossEntryRule.getFilterCondition().getFilterRow().isEmpty() && !(decisionRules = EntryRowRelation.matchEntryNumber(decisionRuleList, crossEntryRule, entity, mainType, customFuncInfoChain.getFuncValueMap())).isEmpty()) {
            rowRelationDTO = EntryRowRelation.getEntryRowIndexRelation(crossEntryRule, srcBillObj, entity, startConditionEntry, matchStartConditionEntryIndexList, linkUpBillResults, decision, context.isBillControl());
        }
        if (crossEntryRule != null && rowRelationDTO != null) {
            int compareRowSize = rowRelationDTO.getDataCount();
            LinkedHashMap<Integer, Set<Integer>> entryIdMap = rowRelationDTO.getEntryIdMap();
            for (Map.Entry<Integer, Set<Integer>> entry : entryIdMap.entrySet()) {
                Set<Integer> value = entry.getValue();
                Integer keyIndex = entry.getKey();
                Iterator<Integer> iterator = value.iterator();
                while (iterator.hasNext()) {
                    Integer valueIndex = iterator.next();
                    boolean currentRowAtLeastOneRuleMatch = false;
                    for (int ruleIndex = 0; ruleIndex < decisionRules.size(); ++ruleIndex) {
                        DecisionRuleAnalysisDTO ruleAnalysisDTO = (DecisionRuleAnalysisDTO)decisionRules.get(ruleIndex);
                        DecisionRule decisionRule = decisionRuleList.get(ruleAnalysisDTO.getDecisionRuleIndex());
                        String ruleScript = ruleAnalysisDTO.getRuleScript();
                        if (!customFuncInfoChain.getFuncValueMap().isEmpty()) {
                            for (Map.Entry<String, Object> replaceEntry : customFuncInfoChain.getFuncValueMap().entrySet()) {
                                ruleScript = ruleScript.replace(replaceEntry.getKey(), replaceEntry.getValue().toString());
                            }
                        }
                        String fieldBelongEntry = ruleAnalysisDTO.getFieldBelongEntry();
                        String fieldProp = ruleAnalysisDTO.getFieldProp();
                        String valueBelongEntry = ruleAnalysisDTO.getValueBelongEntry();
                        String valueProp = ruleAnalysisDTO.getValueProp();
                        int fieldBelongEntryIndex = rowRelationDTO.getEntryFlag().equals(fieldBelongEntry) ? keyIndex : valueIndex;
                        int valueBelongEntryIndex = rowRelationDTO.getEntryFlag().equals(valueBelongEntry) ? keyIndex : valueIndex;
                        boolean matchRule = false;
                        IDICompareType idiCompareType = ruleAnalysisDTO.getIdiCompareType();
                        if (idiCompareType == null) continue;
                        DynamicObjectCollection sourceEntryCol = null;
                        DynamicObjectCollection targetEntryCol = null;
                        if (rowRelationDTO.isTrueSubEntry()) {
                            Map<Integer, DynamicObjectCollection> trueSubEntryCollectionMap = rowRelationDTO.getTrueSubEntryCollectionMap();
                            Map<String, String> subParentEntryMap = rowRelationDTO.getSubParentEntryMap();
                            if (StringUtils.isNotEmpty((String)subParentEntryMap.get(fieldBelongEntry))) {
                                sourceEntryCol = trueSubEntryCollectionMap.get(valueBelongEntryIndex);
                                targetEntryCol = rowRelationDTO.getEntryCollectionMap().get(subParentEntryMap.get(fieldBelongEntry));
                            } else if (StringUtils.isNotEmpty((String)subParentEntryMap.get(valueBelongEntry))) {
                                sourceEntryCol = rowRelationDTO.getEntryCollectionMap().get(subParentEntryMap.get(valueBelongEntry));
                                targetEntryCol = trueSubEntryCollectionMap.get(fieldBelongEntryIndex);
                            }
                        } else {
                            sourceEntryCol = rowRelationDTO.getEntryCollectionMap().get(fieldBelongEntry);
                            targetEntryCol = rowRelationDTO.getEntryCollectionMap().get(valueBelongEntry);
                        }
                        if (sourceEntryCol != null && targetEntryCol != null && ruleScript.contains(valueBelongEntry) && ruleScript.contains(fieldBelongEntry)) {
                            DynamicObject sourceObj = (DynamicObject)sourceEntryCol.get(fieldBelongEntryIndex);
                            DynamicObject targetObj = (DynamicObject)targetEntryCol.get(valueBelongEntryIndex);
                            if (sourceObj != null && targetObj != null) {
                                matchRule = ruleScript.indexOf(fieldBelongEntry) < ruleScript.indexOf(valueBelongEntry) ? ObjectValueCompareUtil.valueCompare(sourceObj.get(fieldProp), targetObj.get(valueProp), idiCompareType) : ObjectValueCompareUtil.valueCompare(targetObj.get(valueProp), sourceObj.get(fieldProp), idiCompareType);
                            }
                        }
                        if (!matchRule) continue;
                        currentRowAtLeastOneRuleMatch = true;
                        BigDecimal rowOfEntryPercent = BigDecimal.valueOf(decisionRule.getDeductionGradePercent(), 0).divide(BigDecimal.valueOf(compareRowSize, 0), 6, RoundingMode.HALF_UP);
                        BigDecimal percent = decisionRule.isPass() ? rowOfEntryPercent : DecisionResult.HUNDRED;
                        this.deductionGrade.deduct(percent);
                        BillCheckResult billCheckResult = new BillCheckResult();
                        billCheckResult.setSrcObj(srcBillObj);
                        billCheckResult.setSrcEntryName(fieldBelongEntry);
                        billCheckResult.setSrcEntryIndex(fieldBelongEntryIndex);
                        billCheckResult.setLinkObj(srcBillObj);
                        billCheckResult.setLinkEntryName(valueBelongEntry);
                        billCheckResult.setLinkEntryIndex(valueBelongEntryIndex);
                        billCheckResult.setDeductPercent(percent);
                        LinkUpBillResult billResult = null;
                        for (LinkUpBillResult result1 : linkUpBillResults) {
                            if (result1.getMatchRule() != ruleIndex) continue;
                            billResult = result1;
                            break;
                        }
                        if (billResult == null) {
                            billResult = new LinkUpBillResult();
                            billResult.setMatchRule(ruleIndex);
                            billResult.setPass(decisionRule.isPass());
                            billResult.setShowText(decisionRule.getName());
                            billResult.setStatus(decisionRule.getDecisionStatus());
                            billResult.addDeductPercent(percent);
                            linkUpBillResults.add(billResult);
                        }
                        ruleBillMap.computeIfAbsent(ruleIndex, k -> new ArrayList()).add(billCheckResult);
                        break;
                    }
                    this.isOutOfCount(linkUpBillResults, ruleBillMap, decision.getName());
                    if (currentRowAtLeastOneRuleMatch) continue;
                    this.noAnyRuleMatchDeduct(decision.getLinkUpBillConfig().getDeductionGradeConfigList(), compareRowSize);
                }
            }
            if (decision.needShowAllCheckTrue()) {
                this.processShowAllCheckTrue(linkUpBillResults, decision.getRules());
            }
            if (decision.needShowAllEntryCheckTrue()) {
                BillDecisionUtil.processShowAllEntryCheckTrue(rowRelationDTO, linkUpBillResults, ruleBillMap, decision.getRules(), firstEntryNumber, this.deductionGrade);
            }
            HighLightBuilder highLightBuilder = new HighLightBuilder();
            ArrayList<BaseHighLight> highLightList = new ArrayList<BaseHighLight>(5);
            for (LinkUpBillResult billResult : linkUpBillResults) {
                int matchRule = billResult.getMatchRule();
                List billCheckResultList = (List)ruleBillMap.get(matchRule);
                if (!billResult.isPass()) {
                    LinkUpBillFront linkUpBillFront = new LinkUpBillFront(decision, billCheckResultList, customFuncInfoChain);
                    linkUpBillFront.setRelationDTO(rowRelationDTO);
                    billResult.setFrontEndResult(linkUpBillFront.build());
                }
                if (matchRule <= -1) continue;
                DecisionRule decisionRule = decision.getRules().get(matchRule);
                if (!context.isNeedHighLight()) continue;
                highLightBuilder.buildLinkUpBillDecisionHighLight(matchRule, decisionRule.getRule().getScript(), mainType.getName(), null, mainType, null, billCheckResultList, false, highLightList, customFuncInfoChain.getFuncValueMap(), true);
            }
            decisionResult = new DecisionResult();
            decisionResult.setDecision(decision);
            decisionResult.setOneVoteVeto(false);
            decisionResult.setLinkUpBillResults(linkUpBillResults);
            if (CollectionUtils.isNotEmpty(highLightList)) {
                decisionResult.setHighLightList(highLightList);
            }
        } else {
            DynamicObject billObj = ExecutorHelper.getSelfBill(context);
            List<BillLinkRelation> bills = this.getLinkUpBills(context, decision, billObj);
            EntryRowRelationDTO relationDTO = NoEntryRowRelation.checkExecute(context, decision, bills, startConditionEntry, matchStartConditionEntryIndexList, ruleBillMap, linkUpBillResults, this.deductionGrade, customFuncInfoChain.getFuncValueMap());
            if (decision.needShowAllCheckTrue()) {
                this.processShowAllCheckTrue(linkUpBillResults, decision.getRules());
            }
            if (decision.needShowAllEntryCheckTrue()) {
                BillDecisionUtil.processShowAllEntryCheckTrue(relationDTO, linkUpBillResults, ruleBillMap, decision.getRules(), firstEntryNumber, this.deductionGrade);
            }
            HighLightBuilder highLightBuilder = new HighLightBuilder();
            ArrayList<BaseHighLight> highLightList = new ArrayList<BaseHighLight>(5);
            for (LinkUpBillResult billResult : linkUpBillResults) {
                int matchRule = billResult.getMatchRule();
                List billCheckResultList = (List)ruleBillMap.get(matchRule);
                if (!billResult.isPass()) {
                    LinkUpBillFront linkUpBillFront = new LinkUpBillFront(decision, billCheckResultList, customFuncInfoChain);
                    linkUpBillFront.setRelationDTO(relationDTO);
                    billResult.setFrontEndResult(linkUpBillFront.build());
                }
                if (matchRule <= -1) continue;
                DecisionRule decisionRule = decision.getRules().get(matchRule);
                if (!context.isNeedHighLight()) continue;
                highLightBuilder.buildLinkUpBillDecisionHighLight(matchRule, decisionRule.getRule().getScript(), mainType.getName(), null, mainType, null, billCheckResultList, false, highLightList, customFuncInfoChain.getFuncValueMap(), true);
            }
            decisionResult = new DecisionResult();
            decisionResult.setDecision(decision);
            decisionResult.setOneVoteVeto(false);
            decisionResult.setLinkUpBillResults(linkUpBillResults);
            if (CollectionUtils.isNotEmpty(highLightList)) {
                decisionResult.setHighLightList(highLightList);
            }
        }
        if (CollectionUtils.isEmpty(linkUpBillResults)) {
            decisionResult.setStatus("empty");
        }
        return decisionResult;
    }

    private void noAnyRuleMatchDeduct(List<DeductionGradeConfig> deductionGradeConfigList, int compareDataSize) {
        if (deductionGradeConfigList == null) {
            return;
        }
        for (DeductionGradeConfig deductionGradeConfig : deductionGradeConfigList) {
            if (deductionGradeConfig.getItem() != DeductionGradeConfig.DeductionGradeItem.NO_MATCH_RULE) continue;
            if (compareDataSize == 0) {
                this.deductionGrade.deduct(deductionGradeConfig.getPercent());
                break;
            }
            BigDecimal noAnyRuleMatchPercent = BigDecimal.valueOf(deductionGradeConfig.getPercent(), 0).divide(BigDecimal.valueOf(compareDataSize, 0), 6, RoundingMode.HALF_UP);
            this.deductionGrade.deduct(noAnyRuleMatchPercent);
            break;
        }
    }

    private DecisionResult checkBillContent(SchemaContext context, Decision decision, List<BillLinkRelation> relations, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, CustomFuncInfoChain customFuncInfoChain, MainEntityType srcEntityType) {
        boolean onlyFunc;
        String linkTypeNumber;
        String srcEntityTypeNumber = context.getEntityType();
        boolean targetSelf = false;
        if (decision.getLinkUpBillConfig().getRelation() == Relation.SELF) {
            linkTypeNumber = context.getEntityType();
        } else {
            linkTypeNumber = decision.getMatchBill().getEntityNumber();
            targetSelf = srcEntityTypeNumber.equalsIgnoreCase(linkTypeNumber);
        }
        MainEntityType linkEntityType = EntityMetadataCache.getDataEntityType((String)linkTypeNumber);
        ArrayList<LinkUpBillResult> linkUpBillResults = new ArrayList<LinkUpBillResult>();
        ArrayList<EntryIndexRelation> entryIndexRelationList = new ArrayList<EntryIndexRelation>();
        String script = customFuncInfoChain.getDealScript();
        String removeCustomFuncScript = ScriptUtils.replaceCustomFuncOfScript(script);
        String linkMainVarName = targetSelf ? "targetisself_" + linkTypeNumber : linkTypeNumber;
        String[] billTypes = new String[]{srcEntityTypeNumber, linkMainVarName};
        MulEntryValidator srcValidator = ScriptUtils.getEntriesForValidate(srcEntityType, removeCustomFuncScript, billTypes, "");
        if (!srcValidator.validate()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u4e0d\u652f\u6301\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"LinkUpBillDecisionExecutor_13", (String)"data-idi-core", (Object[])new Object[0]));
        }
        String sourceBillEntryName = srcValidator.getEntryName();
        MulEntryValidator linkValidator = ScriptUtils.getEntriesForValidate(linkEntityType, removeCustomFuncScript, billTypes, targetSelf ? "targetisself_" : "");
        if (!linkValidator.validate()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u4e0d\u652f\u6301\u76ee\u6807\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"LinkUpBillDecisionExecutor_14", (String)"data-idi-core", (Object[])new Object[0]));
        }
        String linkBillEntryName = linkValidator.getEntryName();
        if (startConditionEntry != null && !matchStartConditionEntryIndexList.isEmpty() && sourceBillEntryName == null) {
            sourceBillEntryName = startConditionEntry;
        }
        boolean recalculateDeduct = startConditionEntry != null && !matchStartConditionEntryIndexList.isEmpty() && startConditionEntry.equals(sourceBillEntryName);
        HashMap<Integer, List<BillCheckResult>> ruleBillMap = new HashMap<Integer, List<BillCheckResult>>();
        BigDecimal percent = null;
        int sourceBillEntrySizeDeductGrade = this.conditionSrcEntrySize;
        if (Relation.CUSTOM == decision.getLinkUpBillConfig().getRelation() && sourceBillEntrySizeDeductGrade != 0) {
            percent = recalculateDeduct ? DecisionResult.HUNDRED.divide(BigDecimal.valueOf(matchStartConditionEntryIndexList.size(), 0), 6, RoundingMode.HALF_UP) : DecisionResult.HUNDRED.divide(BigDecimal.valueOf(sourceBillEntrySizeDeductGrade, 0), 6, RoundingMode.HALF_UP);
        }
        ScriptLocaleFieldHandler localeFieldHandler = new ScriptLocaleFieldHandler();
        HashMap<DynamicObject, String> billScriptMap = new HashMap<DynamicObject, String>(10);
        this.processFunction(relations, localeFieldHandler, billTypes, decision, customFuncInfoChain, script, billScriptMap);
        for (BillLinkRelation relation : relations) {
            BillCountLimitValidator limitCountValidator;
            DynamicObject srcBillObj = relation.getSrcBillObj();
            int sourceBillEntrySize = 0;
            if (StringUtils.isNotEmpty((String)sourceBillEntryName)) {
                DynamicObjectCollection srcEntryCol = srcBillObj.getDynamicObjectCollection(sourceBillEntryName);
                if (!CollectionUtils.isNotEmpty((Collection)srcEntryCol)) continue;
                sourceBillEntrySize = srcEntryCol.size();
                if (sourceBillEntrySizeDeductGrade == 0 && Relation.CUSTOM != decision.getLinkUpBillConfig().getRelation()) {
                    sourceBillEntrySizeDeductGrade = sourceBillEntrySize;
                }
            }
            if ((limitCountValidator = BillCountLimitValidator.getInstance()).isOutOfCountBySystemParam(sourceBillEntrySize, "srcentrylimitcount")) {
                String showText = String.format(ResManager.loadKDString((String)"{%s}\uff1a\u5355\u636e\u6d89\u53ca\u7684\u68c0\u67e5\u5206\u5f55\u884c\u6570\u5df2\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u7684\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"LinkUpBillDecisionExecutor_19", (String)"data-idi-core", (Object[])new Object[0]), decision.getName());
                throw new CountLimitException(showText);
            }
            int srcLoopSize = Math.max(1, sourceBillEntrySize);
            if (percent == null) {
                int matchStartConditionEntryRow = recalculateDeduct ? matchStartConditionEntryIndexList.size() : srcLoopSize;
                percent = DecisionResult.HUNDRED.divide(BigDecimal.valueOf(matchStartConditionEntryRow, 0), 6, RoundingMode.HALF_UP);
            }
            if (sourceBillEntrySize > 0 && sourceBillEntryName != null) {
                this.processSrcEntryIndex(billScriptMap, srcEntityTypeNumber, sourceBillEntryName, "_exerelationtemp_.getSrcEntryIndex()", targetSelf);
            }
            for (int srcIndex = 0; srcIndex < srcLoopSize; ++srcIndex) {
                if (recalculateDeduct && !matchStartConditionEntryIndexList.contains(srcIndex)) continue;
                EntryIndexRelation eirTemplate = new EntryIndexRelation();
                eirTemplate.setSrcBillObj(srcBillObj);
                if (sourceBillEntrySize > 0 && sourceBillEntryName != null) {
                    if (sourceBillEntryName.equals(relation.getSrcEntryName()) && relation.getSrcEntryIndex() != -1 && srcIndex != relation.getSrcEntryIndex()) continue;
                    eirTemplate.setSrcEntryName(sourceBillEntryName);
                    eirTemplate.setSrcEntryIndex(srcIndex);
                }
                eirTemplate.setLinkEntryName(linkBillEntryName);
                BigDecimal srcSubPercent = percent;
                if (sourceBillEntrySize > 0 && sourceBillEntryName != null && srcValidator.hasSubEntry()) {
                    String srcSubEntryName;
                    DynamicObjectCollection srcEntryCols = srcBillObj.getDynamicObjectCollection(sourceBillEntryName);
                    DynamicObject srcEntryObj = (DynamicObject)srcEntryCols.get(srcIndex);
                    DynamicObjectCollection srcSubEntry = srcEntryObj.getDynamicObjectCollection(srcSubEntryName = srcValidator.getSubEntryName());
                    if (CollectionUtils.isEmpty((Collection)srcSubEntry)) continue;
                    int srcSubEntrySize = srcSubEntry.size();
                    if (sourceBillEntryName.equals(relation.getSrcEntryName()) && srcSubEntrySize != 0) {
                        srcSubPercent = percent.divide(BigDecimal.valueOf(srcSubEntrySize, 0), 6, RoundingMode.HALF_UP);
                    }
                    if (limitCountValidator.isOutOfCountBySystemParam(srcSubEntrySize, "srcchildentrylimitcount")) {
                        String showText = String.format(ResManager.loadKDString((String)"{%s}\uff1a\u5355\u636e\u6d89\u53ca\u7684\u68c0\u67e5\u5206\u5f55\u884c\u6570\u5df2\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u7684\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"LinkUpBillDecisionExecutor_19", (String)"data-idi-core", (Object[])new Object[0]), decision.getName());
                        throw new CountLimitException(showText);
                    }
                    int srcSubLoopSize = Math.max(1, srcSubEntrySize);
                    if (srcSubEntrySize > 0) {
                        this.processSrcSubEntryIndex(billScriptMap, srcEntityTypeNumber, sourceBillEntryName, "_exerelationtemp_\\.getSrcEntryIndex\\(\\)", srcSubEntryName, "_exerelationtemp_.getSubRelation().getSrcSubEntryIndex()", targetSelf);
                    }
                    for (int srcSubIndex = 0; srcSubIndex < srcSubLoopSize; ++srcSubIndex) {
                        SubRelation sr = new SubRelation();
                        sr.setSrcSubEntryName(srcSubEntryName);
                        sr.setSrcSubEntryIndex(srcSubEntrySize > 0 ? srcSubIndex : -1);
                        eirTemplate.setSubRelation(sr);
                        this.checkBillContentLink2(decision, relation, eirTemplate, billScriptMap, srcSubPercent, linkMainVarName, localeFieldHandler, billTypes, linkValidator, customFuncInfoChain, entryIndexRelationList);
                    }
                } else {
                    this.checkBillContentLink2(decision, relation, eirTemplate, billScriptMap, srcSubPercent, linkMainVarName, localeFieldHandler, billTypes, linkValidator, customFuncInfoChain, entryIndexRelationList);
                }
                if (!limitCountValidator.isOutOfCountBySystemParam(entryIndexRelationList.size(), "resultlimitcount")) continue;
                String showText = String.format(ResManager.loadKDString((String)"{%s}\uff1a\u5355\u636e\u6d89\u53ca\u7684\u68c0\u67e5\u7ed3\u679c\u6570\u5df2\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u7684\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"LinkUpBillDecisionExecutor_20", (String)"data-idi-core", (Object[])new Object[0]), decision.getName());
                throw new CountLimitException(showText);
            }
            if (!limitCountValidator.isOutOfCountBySystemParam(entryIndexRelationList.size(), "resultlimitcount")) continue;
            String showText = String.format(ResManager.loadKDString((String)"{%s}\uff1a\u5355\u636e\u6d89\u53ca\u7684\u68c0\u67e5\u7ed3\u679c\u6570\u5df2\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u7684\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"LinkUpBillDecisionExecutor_20", (String)"data-idi-core", (Object[])new Object[0]), decision.getName());
            throw new CountLimitException(showText);
        }
        boolean matchedRule = this.batchExeRule(linkUpBillResults, entryIndexRelationList, srcEntityTypeNumber, linkTypeNumber, decision, ruleBillMap, targetSelf);
        if (!matchedRule) {
            this.deductionGrade.deduct(decision.getLinkUpBillConfig().getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.NO_MATCH_RULE);
        }
        if (Relation.CUSTOM == decision.getLinkUpBillConfig().getRelation() && sourceBillEntrySizeDeductGrade - relations.size() > 0 && percent != null) {
            percent = percent.multiply(BigDecimal.valueOf(sourceBillEntrySizeDeductGrade - relations.size(), 0), DecisionResult.DECIMAL4);
            this.deductionGrade.deduct(decision.getLinkUpBillConfig().getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.NO_BILL, percent);
        }
        if (decision.needShowAllCheckTrue()) {
            this.processShowAllCheckTrue(linkUpBillResults, decision.getRules());
        }
        if (decision.needShowAllEntryCheckTrue()) {
            this.processShowAllEntryCheckTrue(linkUpBillResults, ruleBillMap, decision.getRules());
        }
        if (Relation.SELF != decision.getLinkUpBillConfig().getRelation()) {
            this.deleteExcessiveFunctionValue(customFuncInfoChain, ruleBillMap);
        }
        EntryRowRelationDTO relationDTO = null;
        IDICondition crossEntryRule = decision.getLinkUpBillConfig().getCrossEntryRule();
        Set<String> vars = ScriptFormIdHandler.extractVariables(removeCustomFuncScript, new String[]{srcEntityTypeNumber});
        String typePrefix = srcEntityTypeNumber + "_billObj.";
        HashSet<String> varSet = new HashSet<String>(3);
        for (String var : vars) {
            if (!var.startsWith(typePrefix)) continue;
            varSet.add(var.substring(typePrefix.length()));
        }
        boolean bl = onlyFunc = !customFuncInfoChain.getFuncValueMap().isEmpty() && Relation.SELF == decision.getLinkUpBillConfig().getRelation() && CollectionUtils.isEmpty(varSet);
        if (onlyFunc && crossEntryRule != null && crossEntryRule.getFilterCondition() != null && !crossEntryRule.getFilterCondition().getFilterRow().isEmpty()) {
            relationDTO = EntryRowRelation.getEntryRowIndexRelation(crossEntryRule, context.getSelfBill(), srcEntityTypeNumber, startConditionEntry, matchStartConditionEntryIndexList, null, decision, context.isBillControl());
        }
        HighLightBuilder highLightBuilder = new HighLightBuilder();
        ArrayList<BaseHighLight> highLightList = new ArrayList<BaseHighLight>(5);
        for (LinkUpBillResult billResult : linkUpBillResults) {
            int matchRule = billResult.getMatchRule();
            List billCheckResultList = (List)ruleBillMap.get(matchRule);
            if (!billResult.isPass()) {
                LinkUpBillFront linkUpBillFront = new LinkUpBillFront(decision, billCheckResultList, customFuncInfoChain);
                linkUpBillFront.setRelationDTO(relationDTO);
                linkUpBillFront.setOnlyFunc(onlyFunc);
                billResult.setFrontEndResult(linkUpBillFront.build());
            }
            if (matchRule <= -1) continue;
            DecisionRule decisionRule = decision.getRules().get(matchRule);
            if (!context.isNeedHighLight()) continue;
            highLightBuilder.buildLinkUpBillDecisionHighLight(matchRule, decisionRule.getRule().getScript(), srcEntityTypeNumber, decision.getLinkUpBillConfig().getRelation() == Relation.SELF ? null : linkTypeNumber, srcEntityType, decision.getLinkUpBillConfig().getRelation() == Relation.SELF ? null : linkEntityType, billCheckResultList, targetSelf, highLightList, customFuncInfoChain.getFuncValueMap(), false);
        }
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        decisionResult.setOneVoteVeto(false);
        decisionResult.setLinkUpBillResults(linkUpBillResults);
        if (CollectionUtils.isNotEmpty(highLightList)) {
            decisionResult.setHighLightList(highLightList);
        }
        if (!matchedRule) {
            decisionResult.setShowText(ResManager.loadKDString((String)"\u672a\u547d\u4e2d\u4efb\u4f55\u4e00\u4e2a\u68c0\u67e5\u89c4\u5219\u3002", (String)"LinkUpBillDecisionExecutor_18", (String)"data-idi-core", (Object[])new Object[0]));
            boolean isPass = this.findDeductionGradeConfigPass(decision.getLinkUpBillConfig().getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.NO_MATCH_RULE);
            decisionResult.setStatus(isPass ? "empty" : "alarming");
        } else if (CollectionUtils.isEmpty(linkUpBillResults)) {
            decisionResult.setStatus("empty");
        }
        return decisionResult;
    }

    private void deleteExcessiveFunctionValue(CustomFuncInfoChain customFuncInfoChain, Map<Integer, List<BillCheckResult>> ruleBillMap) {
        if (ruleBillMap.isEmpty() || customFuncInfoChain.getFuncValueMap() == null || customFuncInfoChain.getFuncValueMap().isEmpty()) {
            return;
        }
        HashSet<DynamicObject> linkObjSet = new HashSet<DynamicObject>(10);
        for (List<BillCheckResult> valueList : ruleBillMap.values()) {
            for (BillCheckResult billCheckResult : valueList) {
                linkObjSet.add(billCheckResult.getLinkObj());
            }
        }
        Map<String, Object> funcValueMap = customFuncInfoChain.getFuncValueMap();
        Set<Map.Entry<String, Object>> funcValueEntrySet = funcValueMap.entrySet();
        for (Map.Entry entry : funcValueEntrySet) {
            String key = (String)entry.getKey();
            Object funcValue = entry.getValue();
            if (!(funcValue instanceof Map)) continue;
            Map targetFuncValueMap = (Map)funcValue;
            HashMap newTargetFuncValueMap = new HashMap(targetFuncValueMap.size());
            targetFuncValueMap.forEach((linkObj, mseg) -> {
                if (linkObjSet.contains(linkObj)) {
                    newTargetFuncValueMap.put(linkObj, mseg);
                }
            });
            funcValueMap.put(key, newTargetFuncValueMap);
        }
    }

    private void processSrcSubEntryIndex(Map<DynamicObject, String> billScriptMap, String entityTypeNumber, String entryName, String indexStr, String subEntryName, String subIndexStr, boolean targetSelf) {
        Set<Map.Entry<DynamicObject, String>> billScriptEntrySet = billScriptMap.entrySet();
        for (Map.Entry<DynamicObject, String> dynamicObjectStringEntry : billScriptEntrySet) {
            DynamicObject bill = dynamicObjectStringEntry.getKey();
            String script = dynamicObjectStringEntry.getValue();
            String subEntryScript = ScriptUtils.setSubEntryIndexSingle(script, entityTypeNumber, entryName, indexStr, subEntryName, subIndexStr, targetSelf);
            billScriptMap.put(bill, subEntryScript);
        }
    }

    private void processSrcEntryIndex(Map<DynamicObject, String> billScriptMap, String entityTypeNumber, String entryName, String indexStr, boolean targetSelf) {
        Set<Map.Entry<DynamicObject, String>> billScriptEntrySet = billScriptMap.entrySet();
        for (Map.Entry<DynamicObject, String> dynamicObjectStringEntry : billScriptEntrySet) {
            DynamicObject bill = dynamicObjectStringEntry.getKey();
            String script = dynamicObjectStringEntry.getValue();
            String entryScript = ScriptUtils.setEntryIndexSingle(script, entityTypeNumber, entryName, indexStr, targetSelf);
            billScriptMap.put(bill, entryScript);
        }
    }

    private void processFunction(List<BillLinkRelation> relations, ScriptLocaleFieldHandler localeFieldHandler, String[] billTypes, Decision decision, CustomFuncInfoChain customFuncInfoChain, String script, Map<DynamicObject, String> billScriptMap) {
        for (BillLinkRelation relation : relations) {
            DynamicObject srcBillObj = relation.getSrcBillObj();
            String srcLocaleScript = localeFieldHandler.processLocaleField(script, billTypes, srcBillObj);
            if (Relation.SELF == decision.getLinkUpBillConfig().getRelation()) {
                String srcScript = billScriptMap.get(srcBillObj);
                if (!StringUtils.isEmpty((String)srcScript)) break;
                srcScript = this.getCurrentLoopScriptAfterDealCustomFunc(customFuncInfoChain, relation.getSrcBillObj(), null, srcLocaleScript);
                billScriptMap.put(srcBillObj, srcScript);
                continue;
            }
            List<DynamicObject> linkBillObjs = relation.getLinkBillObjs();
            if (!CollectionUtils.isNotEmpty(linkBillObjs)) continue;
            for (DynamicObject linkBillObj : linkBillObjs) {
                String linkScript = billScriptMap.get(linkBillObj);
                if (!StringUtils.isEmpty((String)linkScript)) continue;
                String linkLocaleScript = localeFieldHandler.processLocaleField(srcLocaleScript, billTypes, linkBillObj);
                linkLocaleScript = this.getCurrentLoopScriptAfterDealCustomFunc(customFuncInfoChain, relation.getSrcBillObj(), linkBillObj, linkLocaleScript);
                billScriptMap.put(linkBillObj, linkLocaleScript);
            }
        }
    }

    private boolean batchExeRule(List<LinkUpBillResult> linkUpBillResults, List<EntryIndexRelation> entryIndexRelationList, String srcEntityTypeNumber, String linkTypeNumber, Decision decision, Map<Integer, List<BillCheckResult>> ruleBillMap, boolean targetSelf) {
        if (CollectionUtils.isEmpty(entryIndexRelationList)) {
            return true;
        }
        Map entryIndexRelationMap = entryIndexRelationList.stream().collect(Collectors.groupingBy(eir -> eir.getScript(), Collectors.toList()));
        if (entryIndexRelationMap.isEmpty()) {
            return true;
        }
        int resultLimitCount = (Integer)SystemParamHelper.getParam("resultlimitcount");
        if (entryIndexRelationMap.size() > resultLimitCount) {
            SchemaExecutorLogger.info("classify RESULT_LIMIT_COUNT " + resultLimitCount, new Object[0]);
        }
        boolean matchRule = false;
        entryIndexRelationMap.forEach((script, exeParamList) -> {
            String forScript;
            String linkMainVarName;
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put("_exerelation_", exeParamList);
            ctx.put(srcEntityTypeNumber + "_billObj", ((EntryIndexRelation)exeParamList.get(0)).getSrcBillObj());
            boolean hasLink = srcEntityTypeNumber.equals(linkTypeNumber) && targetSelf || !srcEntityTypeNumber.equals(linkTypeNumber);
            String string = linkMainVarName = targetSelf ? "targetisself_" + linkTypeNumber : linkTypeNumber;
            if (hasLink) {
                ctx.put(linkMainVarName + "_billObj", ((EntryIndexRelation)exeParamList.get(0)).getLinkBillObj());
            }
            if (exeParamList.size() > 1) {
                String srcEntityParam = srcEntityTypeNumber + "_billObj = _exerelationtemp_.getSrcBillObj();\n";
                String linkEntityParam = "";
                if (hasLink) {
                    linkEntityParam = linkMainVarName + "_billObj = _exerelationtemp_.getLinkBillObj();\n";
                }
                String runScript = srcEntityParam + linkEntityParam + script;
                forScript = this.buildScriptFor(runScript);
            } else {
                forScript = this.buildScriptFor((String)script);
            }
            ScriptFormIdHandler.runScript(srcEntityTypeNumber, linkTypeNumber, ctx, forScript);
        });
        for (EntryIndexRelation entryIndexRelation : entryIndexRelationList) {
            SubRelation sr;
            int matchRuleIndex = entryIndexRelation.getMatchRuleIndex();
            if (matchRuleIndex <= -1) continue;
            matchRule = true;
            BillCheckResult billCheckResult = new BillCheckResult();
            billCheckResult.setSrcObj(entryIndexRelation.getSrcBillObj());
            billCheckResult.setSrcEntryName(entryIndexRelation.getSrcEntryName());
            billCheckResult.setSrcEntryIndex(entryIndexRelation.getSrcEntryIndex());
            DynamicObject linkObj = entryIndexRelation.getLinkBillObj();
            if (linkObj != null) {
                billCheckResult.setLinkObj(linkObj);
                billCheckResult.setLinkEntryName(entryIndexRelation.getLinkEntryName());
                billCheckResult.setLinkEntryIndex(entryIndexRelation.getLinkEntryIndex());
            }
            billCheckResult.setSubRelation((sr = entryIndexRelation.getSubRelation()) == null ? null : sr);
            LinkUpBillResult billResult = null;
            for (LinkUpBillResult result1 : linkUpBillResults) {
                if (result1.getMatchRule() != matchRuleIndex) continue;
                billResult = result1;
                break;
            }
            DecisionRule decisionRule = decision.getRules().get(matchRuleIndex);
            if (billResult == null) {
                billResult = new LinkUpBillResult();
                billResult.setMatchRule(matchRuleIndex);
                billResult.setPass(decisionRule.isPass());
                billResult.setShowText(decisionRule.getName());
                billResult.setStatus(decisionRule.getDecisionStatus());
                linkUpBillResults.add(billResult);
            }
            BigDecimal deductPercent = this.deductionGrade.deductPercent(decisionRule.getDeductionGradePercent(), entryIndexRelation.getDeductionPercent());
            billResult.addDeductPercent(deductPercent);
            billCheckResult.setDeductPercent(deductPercent);
            ruleBillMap.computeIfAbsent(matchRuleIndex, k -> new ArrayList()).add(billCheckResult);
            this.isOutOfCount(linkUpBillResults, ruleBillMap, decision.getName());
        }
        return matchRule;
    }

    private void checkBillContentLink2(Decision decision, BillLinkRelation relation, EntryIndexRelation eir, Map<DynamicObject, String> billScriptMap, BigDecimal srcSubPercent, String linkMainVarName, ScriptLocaleFieldHandler localeFieldHandler, String[] billTypes, MulEntryValidator linkValidator, CustomFuncInfoChain customFuncInfoChain, List<EntryIndexRelation> exeRelationList) {
        DynamicObject srcBillObj = relation.getSrcBillObj();
        BillCountLimitValidator limitCountValidator = BillCountLimitValidator.getInstance();
        if (Relation.SELF == decision.getLinkUpBillConfig().getRelation()) {
            EntryIndexRelation srcParam = eir.clone();
            srcParam.setScript(billScriptMap.get(srcBillObj));
            srcParam.setDeductionPercent(srcSubPercent);
            exeRelationList.add(srcParam);
        } else {
            int linkBillIndex = -1;
            String linkBillEntryName = eir.getLinkEntryName();
            List<DynamicObject> linkBillObjList = relation.getLinkBillObjs();
            BigDecimal targetBillPercent = srcSubPercent.divide(BigDecimal.valueOf(linkBillObjList.size(), 0), 6, RoundingMode.HALF_UP);
            for (DynamicObject linkObj : linkBillObjList) {
                List<Integer> linkEntryIndexes;
                String srcExecuteScript;
                ++linkBillIndex;
                int linkEntrySize = 0;
                if (linkBillEntryName != null) {
                    DynamicObjectCollection linkEntryCol = linkObj.getDynamicObjectCollection(linkBillEntryName);
                    if (linkEntryCol == null || linkEntryCol.isEmpty()) continue;
                    linkEntrySize = linkEntryCol.size();
                }
                String linkExeScript = srcExecuteScript = billScriptMap.get(linkObj);
                if (linkEntrySize > 0 && linkBillEntryName != null) {
                    linkExeScript = ScriptUtils.setEntryIndexSingle(srcExecuteScript, linkMainVarName, linkBillEntryName, "_exerelationtemp_.getLinkEntryIndex()", false);
                }
                if (limitCountValidator.isOutOfCountBySystemParam(linkEntrySize, "tarentrylimitcount")) {
                    String showText = String.format(ResManager.loadKDString((String)"{%s}\uff1a\u5355\u636e\u6d89\u53ca\u7684\u68c0\u67e5\u5206\u5f55\u884c\u6570\u5df2\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u7684\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"LinkUpBillDecisionExecutor_19", (String)"data-idi-core", (Object[])new Object[0]), decision.getName());
                    throw new CountLimitException(showText);
                }
                int linkLoopSize = Math.max(1, linkEntrySize);
                BigDecimal targetEntryPercent = targetBillPercent;
                if (linkBillEntryName != null && linkBillEntryName.equals(relation.getLinkEntryName()) && relation.getLinkEntryIndexList() != null && linkBillIndex < relation.getLinkEntryIndexList().size() && CollectionUtils.isNotEmpty(linkEntryIndexes = relation.getLinkEntryIndexList().get(linkBillIndex))) {
                    if (limitCountValidator.isOutOfCountBySystemParam(linkEntryIndexes.size(), "tarentrylimitcount")) {
                        String showText = String.format(ResManager.loadKDString((String)"{%s}\uff1a\u5355\u636e\u6d89\u53ca\u7684\u68c0\u67e5\u5206\u5f55\u884c\u6570\u5df2\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u7684\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"LinkUpBillDecisionExecutor_19", (String)"data-idi-core", (Object[])new Object[0]), decision.getName());
                        throw new CountLimitException(showText);
                    }
                    linkLoopSize = Math.max(1, linkEntryIndexes.size());
                }
                for (int linkLoopIndex = 0; linkLoopIndex < linkLoopSize; ++linkLoopIndex) {
                    int linkIndex = linkLoopIndex;
                    if (linkEntrySize > 0 && linkBillEntryName != null && linkBillEntryName.equals(relation.getLinkEntryName())) {
                        List<Integer> linkEntryIndexes2;
                        if (relation.getLinkEntryIndexList() == null || linkBillIndex >= relation.getLinkEntryIndexList().size() || !CollectionUtils.isNotEmpty(linkEntryIndexes2 = relation.getLinkEntryIndexList().get(linkBillIndex)) || linkLoopIndex >= linkEntryIndexes2.size()) continue;
                        linkIndex = linkEntryIndexes2.get(linkLoopIndex);
                        targetEntryPercent = targetBillPercent.divide(BigDecimal.valueOf(linkEntryIndexes2.size(), 0), 6, RoundingMode.HALF_UP);
                    }
                    BigDecimal linkSubPercent = targetEntryPercent;
                    String linkEntryExecuteScript = linkExeScript;
                    if (linkEntrySize > 0 && linkBillEntryName != null && linkValidator.hasSubEntry()) {
                        String linkSubEntryName;
                        DynamicObjectCollection linkEntryCol = linkObj.getDynamicObjectCollection(linkBillEntryName);
                        DynamicObject linkEntryObj = (DynamicObject)linkEntryCol.get(linkIndex);
                        DynamicObjectCollection linkSubEntry = linkEntryObj.getDynamicObjectCollection(linkSubEntryName = linkValidator.getSubEntryName());
                        if (CollectionUtils.isEmpty((Collection)linkSubEntry)) continue;
                        int linkSubEntrySize = linkSubEntry.size();
                        if (linkBillEntryName.equals(relation.getLinkEntryName()) && linkSubEntrySize != 0) {
                            linkSubPercent = targetEntryPercent.divide(BigDecimal.valueOf(linkSubEntrySize, 0), 6, RoundingMode.HALF_UP);
                        }
                        if (limitCountValidator.isOutOfCountBySystemParam(linkSubEntrySize, "tarchildentrylimitcount")) {
                            String showText = String.format(ResManager.loadKDString((String)"{%s}\uff1a\u5355\u636e\u6d89\u53ca\u7684\u68c0\u67e5\u5206\u5f55\u884c\u6570\u5df2\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u7684\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"LinkUpBillDecisionExecutor_19", (String)"data-idi-core", (Object[])new Object[0]), decision.getName());
                            throw new CountLimitException(showText);
                        }
                        int linkSubLoopSize = Math.max(1, linkSubEntrySize);
                        if (linkSubEntrySize > 0) {
                            linkExeScript = ScriptUtils.setSubEntryIndexSingle(linkEntryExecuteScript, linkMainVarName, linkBillEntryName, "_exerelationtemp_\\.getLinkEntryIndex\\(\\)", linkSubEntryName, "_exerelationtemp_.getSubRelation().getLinkSubEntryIndex()", false);
                        }
                        for (int linkSubIndex = 0; linkSubIndex < linkSubLoopSize; ++linkSubIndex) {
                            EntryIndexRelation linkParam = eir.clone();
                            linkParam.setLinkBillObj(linkObj);
                            linkParam.setLinkEntryIndex(linkIndex);
                            SubRelation sr = linkParam.getSubRelation() == null ? new SubRelation() : linkParam.getSubRelation();
                            linkParam.setSubRelation(sr);
                            sr.setLinkSubEntryName(linkSubEntryName);
                            sr.setLinkSubEntryIndex(linkSubEntrySize > 0 ? linkSubIndex : -1);
                            linkParam.setScript(linkExeScript);
                            linkParam.setDeductionPercent(linkSubPercent);
                            exeRelationList.add(linkParam);
                            if (!limitCountValidator.isOutOfCountBySystemParam(exeRelationList.size(), "resultlimitcount")) continue;
                            String showText = String.format(ResManager.loadKDString((String)"{%s}\uff1a\u5355\u636e\u6d89\u53ca\u7684\u68c0\u67e5\u7ed3\u679c\u6570\u5df2\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u7684\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"LinkUpBillDecisionExecutor_20", (String)"data-idi-core", (Object[])new Object[0]), decision.getName());
                            throw new CountLimitException(showText);
                        }
                        continue;
                    }
                    SubRelation sr = null;
                    EntryIndexRelation linkParam = eir.clone();
                    linkParam.setLinkBillObj(linkObj);
                    linkParam.setLinkEntryIndex(linkIndex);
                    if (linkParam.getSubRelation() != null) {
                        sr = linkParam.getSubRelation();
                        sr.setLinkSubEntryName(null);
                        sr.setLinkSubEntryIndex(-1);
                    }
                    linkParam.setScript(linkExeScript);
                    linkParam.setDeductionPercent(targetEntryPercent);
                    exeRelationList.add(linkParam);
                    if (!limitCountValidator.isOutOfCountBySystemParam(exeRelationList.size(), "resultlimitcount")) continue;
                    String showText = String.format(ResManager.loadKDString((String)"{%s}\uff1a\u5355\u636e\u6d89\u53ca\u7684\u68c0\u67e5\u7ed3\u679c\u6570\u5df2\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u7684\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"LinkUpBillDecisionExecutor_20", (String)"data-idi-core", (Object[])new Object[0]), decision.getName());
                    throw new CountLimitException(showText);
                }
            }
        }
    }

    private String getCurrentLoopScriptAfterDealCustomFunc(CustomFuncInfoChain totalChain, DynamicObject srcBillObj, DynamicObject linkObj, String currentLoopScript) {
        CustomFuncInfoChain currentChain = new CustomFuncInfoChain(currentLoopScript, null);
        this.dealCustomFuncWhenExistTarget(srcBillObj, linkObj, currentChain);
        Map<String, Object> targetFuncValueMap = currentChain.getFuncValueMap();
        if (targetFuncValueMap != null && !targetFuncValueMap.isEmpty()) {
            targetFuncValueMap.forEach((k, v) -> {
                if (v instanceof Map) {
                    Map valueMap = (Map)totalChain.getFuncValueMap().get(k);
                    if (valueMap == null) {
                        totalChain.getFuncValueMap().put((String)k, v);
                    } else {
                        valueMap.putAll((Map)v);
                    }
                } else {
                    totalChain.getFuncValueMap().put((String)k, v);
                }
            });
        }
        totalChain.getEntrySet().addAll(currentChain.getEntrySet());
        return currentChain.getDealScript();
    }

    private void processShowAllCheckTrue(List<LinkUpBillResult> linkUpBillResults, List<DecisionRule> ruleList) {
        if (CollectionUtils.isEmpty(linkUpBillResults) || CollectionUtils.isEmpty(ruleList)) {
            return;
        }
        HashMap<DecisionRule, List> map = new HashMap<DecisionRule, List>(linkUpBillResults.size());
        for (LinkUpBillResult linkUpBillResult : linkUpBillResults) {
            int index = linkUpBillResult.getMatchRule();
            if (index <= -1) continue;
            DecisionRule rule2 = ruleList.get(index);
            List list = map.computeIfAbsent(rule2, k -> new ArrayList(linkUpBillResults.size()));
            list.add(linkUpBillResult);
        }
        if (map.size() > 1) {
            map.forEach((rule, dataList) -> {
                if (rule.isShowAllCheckTrue()) {
                    for (LinkUpBillResult linkUpBillResult : dataList) {
                        this.deductionGrade.deductNegate(linkUpBillResult.getDeductPercent());
                    }
                    linkUpBillResults.removeAll((Collection<?>)dataList);
                }
            });
        }
    }

    private void processShowAllEntryCheckTrue(List<LinkUpBillResult> linkUpBillResults, Map<Integer, List<BillCheckResult>> ruleBillMap, List<DecisionRule> ruleList) {
        ArrayList<LinkUpBillResult> removeList = new ArrayList<LinkUpBillResult>(linkUpBillResults.size());
        for (LinkUpBillResult linkUpBillResult : linkUpBillResults) {
            DecisionRule decisionRule;
            int ruleIndex = linkUpBillResult.getMatchRule();
            if (ruleIndex < 0 || !(decisionRule = ruleList.get(ruleIndex)).isShowAllEntryCheckTrue()) continue;
            List<BillCheckResult> billCheckResults = ruleBillMap.get(ruleIndex);
            HashMap<Integer, Map> classifyMap = new HashMap<Integer, Map>(10);
            for (BillCheckResult billCheckResult : billCheckResults) {
                if (StringUtils.isEmpty((String)billCheckResult.getSrcEntryName())) break;
                Integer srcEntryIndex = billCheckResult.getSrcEntryIndex();
                Map groupMap = classifyMap.computeIfAbsent(srcEntryIndex, key -> new HashMap(10));
                DynamicObject linkObj = billCheckResult.getLinkObj();
                List linkEntryList = groupMap.computeIfAbsent(linkObj, key -> new ArrayList(10));
                linkEntryList.add(billCheckResult);
            }
            int errorGroupCount = 0;
            ArrayList showBillCheckResults = new ArrayList(billCheckResults.size());
            Collection groupCol = classifyMap.values();
            for (Map value : groupCol) {
                boolean allCheckTrue = true;
                Set entrySet = value.entrySet();
                ArrayList entryBillCheckResults = new ArrayList(10);
                for (Map.Entry dynamicObjectListEntry : entrySet) {
                    DynamicObject linkObj = (DynamicObject)dynamicObjectListEntry.getKey();
                    List bcr = (List)dynamicObjectListEntry.getValue();
                    String linkEntryName = ((BillCheckResult)bcr.get(0)).getLinkEntryName();
                    if (StringUtils.isEmpty((String)linkEntryName)) {
                        entryBillCheckResults.addAll(bcr);
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((String)linkEntryName)) continue;
                    DynamicObjectCollection entryCols = linkObj.getDynamicObjectCollection(linkEntryName);
                    int entrySize = entryCols.size();
                    if (entrySize != bcr.size()) {
                        allCheckTrue = false;
                        for (BillCheckResult billCheckResult : bcr) {
                            this.deductionGrade.deductNegate(billCheckResult.getDeductPercent());
                        }
                        break;
                    }
                    entryBillCheckResults.addAll(bcr);
                }
                if (allCheckTrue) {
                    showBillCheckResults.addAll(entryBillCheckResults);
                    continue;
                }
                ++errorGroupCount;
            }
            if (errorGroupCount == classifyMap.size()) {
                removeList.add(linkUpBillResult);
                continue;
            }
            ruleBillMap.put(ruleIndex, showBillCheckResults);
        }
        linkUpBillResults.removeAll(removeList);
    }

    private void isOutOfCount(List<LinkUpBillResult> results, Map<Integer, List<BillCheckResult>> ruleBillMap, String decisionName) {
        int count = 0;
        for (LinkUpBillResult linkUpBillResult : results) {
            if (linkUpBillResult.isPass()) continue;
            ++count;
        }
        int resultCount = 0;
        for (List<BillCheckResult> list : ruleBillMap.values()) {
            resultCount += list.size();
        }
        BillCountLimitValidator billCountLimitValidator = BillCountLimitValidator.getInstance();
        if (billCountLimitValidator.isOutOfCountBySystemParam(Math.max(count, resultCount), "resultlimitcount")) {
            String string = String.format(ResManager.loadKDString((String)"{%s}\uff1a\u5355\u636e\u6d89\u53ca\u7684\u68c0\u67e5\u7ed3\u679c\u6570\u5df2\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u7684\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"LinkUpBillDecisionExecutor_20", (String)"data-idi-core", (Object[])new Object[0]), decisionName);
            throw new CountLimitException(string);
        }
    }

    private List<BillLinkRelation> getLinkUpBills(SchemaContext context, Decision decision, DynamicObject billObj) {
        List<BillLinkRelation> bills = new ArrayList<BillLinkRelation>();
        BillInfo matchBill = decision.getMatchBill();
        LinkUpBillConfig linkUpBillConfig = decision.getLinkUpBillConfig();
        if (Relation.BOTP == linkUpBillConfig.getRelation()) {
            Map<String, HashSet<Long>> linkUpBills = ExecutorHelper.getLinkUpBills(billObj.getLong("id"), context.getEntityType());
            HashSet<Long> matchBillIds = linkUpBills.get(matchBill.getEntityNumber());
            if (matchBillIds != null && matchBillIds.size() > 0) {
                BillLinkRelation relation = new BillLinkRelation();
                relation.setSrcBillObj(billObj);
                Set<String> selectors = this.getTargetBillSelectors(matchBill.getEntityNumber(), context.getEntityType(), decision);
                List<DynamicObject> linkBills = ExecutorHelper.getBillBatch(matchBill.getEntityNumber(), matchBillIds, selectors);
                relation.setLinkBillObjs(linkBills);
                bills.add(relation);
            }
        } else if (Relation.LINKDOWN == linkUpBillConfig.getRelation()) {
            Map<String, HashSet<Long>> linkDownBills = ExecutorHelper.loadLinkDownBillIds(context.getBillId(), context.getEntityType());
            HashSet<Long> matchBillIds = linkDownBills.get(matchBill.getEntityNumber());
            if (matchBillIds != null && matchBillIds.size() > 0) {
                BillLinkRelation relation = new BillLinkRelation();
                relation.setSrcBillObj(billObj);
                Set<String> selectors = this.getTargetBillSelectors(matchBill.getEntityNumber(), context.getEntityType(), decision);
                List<DynamicObject> linkBills = ExecutorHelper.getBillBatch(matchBill.getEntityNumber(), matchBillIds, selectors);
                relation.setLinkBillObjs(linkBills);
                bills.add(relation);
            }
        } else if (Relation.CUSTOM == linkUpBillConfig.getRelation()) {
            CustomizedRelationBillChecker customizedRelationBillChecker = new CustomizedRelationBillChecker(billObj, matchBill, decision, linkUpBillConfig);
            bills = customizedRelationBillChecker.queryBills();
            this.conditionSrcEntrySize = customizedRelationBillChecker.getConditions().getSrc_entry_size();
        } else {
            BillLinkRelation relation = new BillLinkRelation();
            relation.setSrcBillObj(billObj);
            ArrayList<DynamicObject> linkBills = new ArrayList<DynamicObject>();
            linkBills.add(billObj);
            relation.setLinkBillObjs(linkBills);
            bills.add(relation);
        }
        return bills;
    }

    private Set<String> getTargetBillSelectors(String targetBillType, String sourceBillType, Decision decision) {
        DecisionFrontEndConfig frontEndConfig;
        HashSet<String> varSet = new HashSet<String>();
        List<DecisionRule> ruleList = decision.getRules();
        if (ruleList != null) {
            boolean targetIsSelf = targetBillType.equals(sourceBillType);
            String targetBillVar = targetIsSelf ? "targetisself_" + targetBillType : targetBillType;
            for (DecisionRule decisionRule : ruleList) {
                decisionRule.extractProperties(varSet, targetBillVar, new String[]{sourceBillType, targetBillVar});
            }
        }
        if ((frontEndConfig = decision.getFrontEndConfig()) != null) {
            frontEndConfig.extractProperties(varSet, targetBillType, false);
        }
        return varSet;
    }

    private boolean canStart(Decision decision, Map<String, Object> ctx, DynamicObjectType mainType, List<Integer> matchStartConditionEntryIndexList, String entryName) {
        if (decision.getStartCondition() != null && StringUtils.isNotEmpty((String)decision.getStartCondition().getScript())) {
            boolean matchData;
            String entityType = mainType.getName();
            IDICondition condition = decision.getStartCondition();
            String script = condition.getScript();
            DynamicObject bizObj = (DynamicObject)ctx.get(entityType + "_billObj");
            int sourceEntrySize = StringUtils.isEmpty((String)entryName) ? 1 : bizObj.getDynamicObjectCollection(entryName).size();
            ctx.put("rowSize", sourceEntrySize);
            ctx.put("__matchEntryIndexList__", matchStartConditionEntryIndexList);
            ScriptLocaleFieldHandler scriptLocaleFieldHandler = new ScriptLocaleFieldHandler();
            String localeScript = scriptLocaleFieldHandler.processLocaleField(script, new String[]{entityType}, bizObj);
            String entryScript = ScriptUtils.supportEntryPropertyStringIndex(mainType, localeScript, "i");
            String ifStem = "if(%s){\n  __matchEntryIndexList__.add(i);\n}";
            String ifScript = String.format(ifStem, entryScript);
            String forStem = "for(var i=0; i<rowSize; i++){\n%s}";
            String forScript = String.format(forStem, ifScript);
            ScriptFormIdHandler.runScript(entityType, null, ctx, forScript);
            boolean bl = matchData = !matchStartConditionEntryIndexList.isEmpty();
            if (StringUtils.isEmpty((String)entryName)) {
                matchStartConditionEntryIndexList.clear();
            }
            return matchData;
        }
        return true;
    }

    private void dealCustomFuncIfSelfRelation(Decision decision, DynamicObject srcObj, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, CustomFuncInfoChain customFuncInfoChain, SchemaContext context) {
        String srcEntity = srcObj.getDataEntityType().getName();
        if (Relation.SELF == decision.getLinkUpBillConfig().getRelation()) {
            List<DecisionRuleAnalysisDTO> matchRelation;
            EntryRowRelationDTO rowRelationDto = null;
            IDICondition crossEntryRule = decision.getLinkUpBillConfig().getCrossEntryRule();
            List<DecisionRule> decisionRuleList = decision.getRules();
            String entity = context.getEntityType();
            if (crossEntryRule != null && crossEntryRule.getFilterCondition() != null && !crossEntryRule.getFilterCondition().getFilterRow().isEmpty() && !(matchRelation = EntryRowRelation.matchEntryNumber(decisionRuleList, crossEntryRule, entity, EntityMetadataCache.getDataEntityType((String)entity), customFuncInfoChain.getFuncValueMap())).isEmpty()) {
                rowRelationDto = EntryRowRelation.getEntryRowIndexRelation(crossEntryRule, srcObj, srcEntity, startConditionEntry, matchStartConditionEntryIndexList, null, decision, context.isBillControl());
            }
            this.loopDealFuncByCustomEnum(customFuncInfoChain, srcObj, null, startConditionEntry, matchStartConditionEntryIndexList, rowRelationDto);
        }
    }

    private void dealCustomFuncWhenExistTarget(DynamicObject srcObj, DynamicObject targetObj, CustomFuncInfoChain customFuncInfoChain) {
        this.loopDealFuncByCustomEnum(customFuncInfoChain, srcObj, targetObj, null, null, null);
    }

    private void loopDealFuncByCustomEnum(CustomFuncInfoChain customFuncInfoChain, DynamicObject srcObj, DynamicObject targetObj, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, EntryRowRelationDTO entryRowIndexRelationDto) {
        block5: for (CustomFuncEnum value : CustomFuncEnum.values()) {
            switch (value) {
                case ARRAY_DIFF: {
                    ArrayDiffFunc.dealFunc(customFuncInfoChain, srcObj, targetObj, startConditionEntry, matchStartConditionEntryIndexList);
                    continue block5;
                }
                case SUM_ENTRY: {
                    SumEntryFunc.dealFunc(customFuncInfoChain, srcObj, targetObj, startConditionEntry, matchStartConditionEntryIndexList, entryRowIndexRelationDto);
                    continue block5;
                }
                case SUB_SET: {
                    SubsetFunc.dealFunc(customFuncInfoChain, srcObj, targetObj, startConditionEntry, matchStartConditionEntryIndexList);
                    continue block5;
                }
            }
        }
    }

    private boolean findDeductionGradeConfigPass(List<DeductionGradeConfig> deductionGradeConfigList, DeductionGradeConfig.DeductionGradeItem item) {
        if (CollectionUtils.isNotEmpty(deductionGradeConfigList)) {
            for (DeductionGradeConfig config : deductionGradeConfigList) {
                if (!config.getItem().getType().equals(item.getType())) continue;
                return config.isPass();
            }
        }
        return DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH == item;
    }
}

