/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptEngine;

public class ScriptFormIdHandler {
    private static final String preFix = "idi";
    private static final Pattern pa = Pattern.compile("^\\d\\S*$");

    public static Object runScript(String sourceEntity, String targetEntity, Map<String, Object> paramMap, String script) {
        Object result;
        SchemaExecutorLogger.info("ScriptFormIdHandler runScript, sourceEntity : %s, targetEntity : %s", sourceEntity, targetEntity);
        SchemaExecutorLogger.info("before process sourceEntity, script:%s", script);
        String sourceProcessScript = ScriptFormIdHandler.processNumberEntity(sourceEntity, paramMap, script);
        SchemaExecutorLogger.info("after process sourceEntity, script:%s", sourceProcessScript);
        long startTime = System.currentTimeMillis();
        if (!sourceEntity.equals(targetEntity)) {
            String finalScripr = ScriptFormIdHandler.processNumberEntity(targetEntity, paramMap, sourceProcessScript);
            SchemaExecutorLogger.info("after process targetEntity, script:%s", finalScripr);
            result = ScriptEngine.getEngine().runScript(finalScripr, paramMap);
        } else {
            result = ScriptEngine.getEngine().runScript(sourceProcessScript, paramMap);
        }
        SchemaExecutorLogger.info("run script\u3002cost\uff1a " + (System.currentTimeMillis() - startTime), new Object[0]);
        return result;
    }

    protected static String processNumberEntity(String entitynumber, Map<String, Object> paramMap, String script) {
        SchemaExecutorLogger.info("start processNumberEntity entity:" + entitynumber, new Object[0]);
        long startTime = System.currentTimeMillis();
        if (ScriptFormIdHandler.isStartWithNumber(entitynumber)) {
            SchemaExecutorLogger.info("need processNumberEntity cost:" + (System.currentTimeMillis() - startTime), new Object[0]);
            startTime = System.currentTimeMillis();
            String newEntity = preFix + entitynumber;
            Set<String> keySet = paramMap.keySet();
            ArrayList<String> keyList = new ArrayList<String>(keySet);
            for (String key : keyList) {
                if (!key.startsWith(entitynumber)) continue;
                Object billObj = paramMap.remove(key);
                String newBillObjParamKey = key.replaceAll(entitynumber, newEntity);
                paramMap.put(newBillObjParamKey, billObj);
            }
            SchemaExecutorLogger.info("processNumberEntity cost:" + (System.currentTimeMillis() - startTime), new Object[0]);
            return script.replaceAll(entitynumber, newEntity);
        }
        SchemaExecutorLogger.info("not need processNumberEntity cost:" + (System.currentTimeMillis() - startTime), new Object[0]);
        return script;
    }

    protected static boolean isStartWithNumber(String entityNumber) {
        if (StringUtils.isNotEmpty((String)entityNumber)) {
            Matcher m = pa.matcher(entityNumber);
            return m.matches();
        }
        return false;
    }

    public static Set<String> extractVariables(String script, String[] entityNumbers) {
        HashSet<String> fieldSet = new HashSet<String>(10);
        if (entityNumbers != null && entityNumbers.length > 0) {
            String entityReplaceScript = script;
            HashMap<String, String> newEntityMap = new HashMap<String, String>(entityNumbers.length);
            for (String entityNumber : entityNumbers) {
                String newEntity;
                if (!ScriptFormIdHandler.isStartWithNumber(entityNumber) || newEntityMap.containsKey(newEntity = preFix + entityNumber)) continue;
                newEntityMap.put(newEntity, entityNumber);
                entityReplaceScript = entityReplaceScript.replaceAll(entityNumber, newEntity);
            }
            Set<String> scriptFieldSet = ScriptEngine.getEngine().extractVariables(entityReplaceScript);
            Iterator<String> iterator = scriptFieldSet.iterator();
            while (iterator.hasNext()) {
                String scriptField;
                String oldField = scriptField = iterator.next();
                for (Map.Entry stringStringEntry : newEntityMap.entrySet()) {
                    String newEntity = (String)stringStringEntry.getKey();
                    if (!oldField.startsWith(newEntity)) continue;
                    oldField = oldField.replaceAll(newEntity, (String)stringStringEntry.getValue());
                    break;
                }
                fieldSet.add(oldField);
            }
        }
        return fieldSet;
    }
}

