/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.ai.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.HttpClientUtils;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ai.service.ISimilarService;
import kd.data.idi.engine.ai.service.ServerInfo;
import kd.data.idi.util.IDIJSONUtils;

public class SimilarServiceImpl
implements ISimilarService {
    @Override
    public List<Integer> textSimilar(String text, List<String> textList) {
        String url = this.getServiceUrl();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("text", text);
        params.put("textList", textList);
        ServerInfo.addAILogParam(params);
        try {
            String paramJson = IDIJSONUtils.toJsonString(params);
            SchemaExecutorLogger.info("textSimilar params: " + paramJson, new Object[0]);
            long start = System.currentTimeMillis();
            String resp = HttpClientUtils.postAppJson((String)url, new HashMap(), params);
            long end = System.currentTimeMillis();
            SchemaExecutorLogger.info(String.format("textSimilar takes time: %sms", end - start), new Object[0]);
            SchemaExecutorLogger.info("textSimilar resp: " + resp, new Object[0]);
            SimilarTextResult result = (SimilarTextResult)IDIJSONUtils.cast((String)resp, SimilarTextResult.class);
            if (result.getCode() != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u672c\u76f8\u4f3c\u8ba1\u7b97\u5931\u8d25,%s", (String)"SimilarServiceImpl_0", (String)"data-idi-core", (Object[])new Object[0]), result.err));
            }
            return result.getSimilarTextSeqs();
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u6587\u672c\u76f8\u4f3c\u8ba1\u7b97\u9047\u5230\u95ee\u9898", (String)"SimilarServiceImpl_1", (String)"data-idi-core", (Object[])new Object[0])), new Object[0]);
        }
    }

    private String getServiceUrl() {
        return ServerInfo.getAIHost() + "/repeatexpense";
    }

    protected static class SimilarTextResult {
        private int code;
        private String err;
        private List<Integer> similarTextSeqs;

        protected SimilarTextResult() {
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getErr() {
            return this.err;
        }

        public void setErr(String err) {
            this.err = err;
        }

        public List<Integer> getSimilarTextSeqs() {
            return this.similarTextSeqs;
        }

        public void setSimilarTextSeqs(List<Integer> similarTextSeqs) {
            this.similarTextSeqs = similarTextSeqs;
        }
    }
}

