/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.attachment;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.attachment.CheckMethodEnum;
import kd.data.idi.data.attachment.OriginAttachRecord;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.IDITaskManager;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.attachment.AIParam;
import kd.data.idi.engine.attachment.AIRecognizerErrorInfo;
import kd.data.idi.engine.attachment.AIRecognizerParam;
import kd.data.idi.engine.attachment.AIRecognizerResult;
import kd.data.idi.engine.attachment.AIRecognizerResultBase;
import kd.data.idi.engine.attachment.AIRecognizerSuccessInfo;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.Attachment;
import kd.data.idi.engine.attachment.AttachmentDataSourceEnum;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.engine.attachment.AttachmentTypeEnum;
import kd.data.idi.engine.attachment.IAttachmentService;
import kd.data.idi.util.AttachmentFieldHelper;
import kd.data.idi.util.AttachmentResultRecordHelper;

public class AIAttachmentServiceImpl
implements IAttachmentService<AIRecognizerResult> {
    @Override
    public List<AttachmentField> queryTemplateField(AIParam fieldQueryParam) {
        CheckMethodEnum checkMethod = fieldQueryParam.getCheckMethod();
        String entityNumber = fieldQueryParam.getEntityNumber();
        ArrayList<AttachmentField> fieldList = new ArrayList<AttachmentField>();
        switch (checkMethod) {
            case PRESET: {
                Long validTemplateId = fieldQueryParam.getValidTemplateId();
                return this.queryPresetField(validTemplateId, entityNumber);
            }
            case CUSTOM: {
                Long customTemplateId = fieldQueryParam.getCustomTemplateId();
                AITemplate template = this.queryTemplateNumber(customTemplateId);
                return this.queryCustomField(entityNumber, template);
            }
            case RECOGNIZER: {
                Long recognizerId = fieldQueryParam.getRecognizerId();
                return this.queryClassifierField(recognizerId, entityNumber);
            }
        }
        return fieldList;
    }

    private List<AttachmentField> queryClassifierField(Long classifierId, String entityNumber) {
        ArrayList<AttachmentField> fieldList = new ArrayList<AttachmentField>(10);
        List<AITemplate> templateList = this.queryTemplateByRecognizer(classifierId);
        if (!templateList.isEmpty()) {
            for (AITemplate template : templateList) {
                fieldList.addAll(this.queryCustomField(entityNumber, template));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bc6\u522b\u5668\u4e0b\u65e0\u6a21\u677f\uff0c\u65e0\u6cd5\u67e5\u8be2\u5b57\u6bb5", (String)"AIAttachmentServiceImpl_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        return fieldList;
    }

    private List<AITemplate> queryTemplateByRecognizer(Long classifierId) {
        ArrayList<AITemplate> templateList = new ArrayList<AITemplate>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AIAttachmentServiceImpl.queryClassfierField", (String)"cvp_cls_info", (String)"template_infos.included_template.id,template_infos.included_template.number,template_infos.included_template.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)classifierId)}, null);){
            for (Row row : dataSet) {
                templateList.add(new AITemplate(row.getLong("template_infos.included_template.id"), row.getString("template_infos.included_template.number"), row.getString("template_infos.included_template.name")));
            }
        }
        return templateList;
    }

    private List<AttachmentField> queryPresetField(Long validTemplateId, String entityNumber) {
        AITemplate template = this.queryTemplateNumber(validTemplateId);
        template.setCustomTemplate(false);
        long start = System.currentTimeMillis();
        List<AttachmentField> fieldList = this.queryAIField(entityNumber, template);
        SchemaExecutorLogger.info("  cost time %d for queryPresetField ", System.currentTimeMillis() - start);
        return fieldList;
    }

    private List<AttachmentField> queryAIField(String entityNumber, AITemplate template) {
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrTemplateFiledsService", (String)"getFiledInfoByNumber", (Object[])new Object[]{entityNumber, template.getNumber()});
        ArrayList<AttachmentField> fieldList = new ArrayList<AttachmentField>(10);
        if (StringUtils.isEmpty((String)resultStr)) {
            return fieldList;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)resultStr);
        String errorCode = jsonObject.getString("errorCode");
        if ("0".equals(errorCode)) {
            JSONObject dataJson = jsonObject.getJSONObject("data");
            JSONArray recognitionAreaFiled = dataJson.getJSONArray("recognitionAreaFiled");
            for (int index = 0; index < recognitionAreaFiled.size(); ++index) {
                JSONObject fieldJson = recognitionAreaFiled.getJSONObject(index);
                AttachmentField af = new AttachmentField(fieldJson.getString("filed"), fieldJson.getString("desc"), false, template);
                fieldList.add(af);
            }
            JSONArray tableArray = dataJson.getJSONArray("tableFiled");
            if (tableArray != null && !tableArray.isEmpty()) {
                for (int index = 0; index < tableArray.size(); ++index) {
                    JSONObject tableJson = tableArray.getJSONObject(index);
                    JSONObject tableTitle = tableJson.getJSONObject("tableInfo");
                    AttachmentField title = new AttachmentField(tableTitle.getString("filed"), tableTitle.getString("desc"), true, template);
                    fieldList.add(title);
                    JSONArray tableHeadArray = tableJson.getJSONArray("tableHeader");
                    if (tableHeadArray == null || tableHeadArray.isEmpty()) continue;
                    for (int headIndex = 0; headIndex < tableHeadArray.size(); ++headIndex) {
                        JSONObject tableHead = tableHeadArray.getJSONObject(headIndex);
                        AttachmentField head = new AttachmentField(tableHead.getString("filed"), tableHead.getString("desc"), false, template, title);
                        fieldList.add(head);
                    }
                }
            }
        } else {
            throw new KDBizException(jsonObject.getString("description"));
        }
        return fieldList;
    }

    private List<AttachmentField> queryCustomField(String entityNumber, AITemplate template) {
        long start = System.currentTimeMillis();
        List<AttachmentField> fieldList = this.queryAIField(entityNumber, template);
        SchemaExecutorLogger.info("cost time %d for queryCustomField", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        AttachmentFieldHelper.processField(fieldList, template);
        SchemaExecutorLogger.info("cost time %d for processField", System.currentTimeMillis() - start);
        return fieldList;
    }

    @Override
    public AIRecognizerResult recognizer(AIRecognizerParam param) {
        CheckMethodEnum checkMethod = param.getCheckMethod();
        List<Attachment> attachmentList = param.getAttachmentList();
        if (attachmentList == null || attachmentList.isEmpty()) {
            return null;
        }
        String entityNumber = param.getEntityNumber();
        AIRecognizerResult aiRecognizerResult = new AIRecognizerResult();
        switch (checkMethod) {
            case PRESET: 
            case CUSTOM: {
                Long templateId = checkMethod == CheckMethodEnum.PRESET ? param.getValidTemplateId() : param.getCustomTemplateId();
                AITemplate template = this.queryTemplateNumber(templateId);
                template.setCustomTemplate(checkMethod == CheckMethodEnum.CUSTOM);
                AttachmentTypeEnum attachmentTypeEnum = AttachmentTypeEnum.getEnum(checkMethod, template.getNumber());
                this.processAttachment(attachmentList, entityNumber, param.getBillNo(), template, attachmentTypeEnum, aiRecognizerResult);
                break;
            }
            case RECOGNIZER: {
                Long recognizerId = param.getRecognizerId();
                this.processRecognizerAttachment(attachmentList, entityNumber, param.getBillNo(), recognizerId, AttachmentTypeEnum.RECOGNIZER, aiRecognizerResult);
                List<AITemplate> templateList = this.queryTemplateByRecognizer(recognizerId);
                List<AIRecognizerSuccessInfo> successInfoList = aiRecognizerResult.getDetailDatas();
                if (successInfoList == null || successInfoList.isEmpty()) break;
                for (AIRecognizerSuccessInfo aiRecognizerSuccessInfo : successInfoList) {
                    Long id = aiRecognizerSuccessInfo.getTemplate().getId();
                    Optional<AITemplate> templateObj = templateList.stream().filter(aiTemplate -> id.equals(aiTemplate.getId())).findFirst();
                    templateObj.ifPresent(aiRecognizerSuccessInfo::setTemplate);
                }
                break;
            }
        }
        return aiRecognizerResult;
    }

    private void processRecognizerAttachment(List<Attachment> attachmentList, String entityNumber, String billNo, Long recognizerId, AttachmentTypeEnum attachmentTypeEnum, AIRecognizerResult aiRecognizerResult) {
        if (attachmentList.size() > 1) {
            RequestContext context = RequestContext.get();
            AITemplate template = new AITemplate();
            template.setId(recognizerId);
            SchemaContext sc = SchemaContext.get();
            Function<Attachment, AIAttachmentRecognizerTask> function = at -> new AIAttachmentRecognizerClassifyTask(entityNumber, billNo, template, (Attachment)at, attachmentTypeEnum, context, sc);
            SchemaExecutorLogger.info("mul thread process recognizer attachment", new Object[0]);
            this.mulProcessAttachment(attachmentList, entityNumber, template, attachmentTypeEnum, aiRecognizerResult, function);
        } else {
            Attachment attachment = attachmentList.get(0);
            attachment.buildFileMD5();
            AIRecognizerSuccessInfo aiRecord = AttachmentResultRecordHelper.getAiRecord(null, attachment.getFileMD5());
            if (aiRecord != null) {
                aiRecognizerResult.addInfo(aiRecord);
                SchemaExecutorLogger.info("AIAttachmentServiceImpl processRecognizerAttachment hit recognition result", new Object[0]);
                return;
            }
            String fileName = attachment.getFileName();
            String fileType = attachment.getFileType();
            long fileSize = attachment.getSize();
            String filePath = attachment.getFileId();
            String storageType = "att";
            long start = System.currentTimeMillis();
            String dataText = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrClassifierService", (String)"singleClassify", (Object[])new Object[]{entityNumber, recognizerId, fileName, fileType, fileSize, filePath, storageType});
            SchemaExecutorLogger.info("Attachment result filename:%s, data:%s", attachment.getFileName(), dataText);
            AIRecognizerResultBase aiRecognizerResultBase = attachmentTypeEnum.parseAttachment(dataText, null, attachment);
            aiRecognizerResult.addInfo(aiRecognizerResultBase);
            SchemaExecutorLogger.info("cost time %d for single task process Attachment on recognizer", System.currentTimeMillis() - start);
            try {
                OriginAttachRecord originAttachRecord = new OriginAttachRecord(RequestContext.get().getTraceId(), entityNumber, billNo, AttachmentDataSourceEnum.AI.getDataSource(), dataText);
                AttachmentResultRecordHelper.saveOriginAttachRecord(originAttachRecord);
                if ("0".equals(aiRecognizerResultBase.getErrorCode())) {
                    AttachmentResultRecordHelper.saveAiProcessResultIfNotExist(recognizerId, attachment.getFileMD5(), JSON.toJSONString((Object)aiRecognizerResultBase));
                }
            }
            catch (Exception ex) {
                SchemaExecutorLogger.error("AIAttachmentServiceImpl processRecognizerAttachment save record error", ex);
            }
        }
    }

    private void processAttachment(List<Attachment> attachmentList, String entityNumber, String billNo, AITemplate template, AttachmentTypeEnum attachmentTypeEnum, AIRecognizerResult aiRecognizerResult) {
        if (attachmentList.size() > 1) {
            RequestContext context = RequestContext.get();
            SchemaContext sc = SchemaContext.get();
            Function<Attachment, AIAttachmentRecognizerTask> function = at -> new AIAttachmentRecognizerTask(entityNumber, billNo, template, (Attachment)at, attachmentTypeEnum, context, sc);
            SchemaExecutorLogger.info("mul thread process custom attachment", new Object[0]);
            this.mulProcessAttachment(attachmentList, entityNumber, template, attachmentTypeEnum, aiRecognizerResult, function);
        } else {
            Attachment attachment = attachmentList.get(0);
            String fileData = attachment.toBase64();
            attachment.buildFileMD5();
            AIRecognizerSuccessInfo recognizerSuccessInfo = AttachmentResultRecordHelper.getAiRecord(template.getId(), attachment.getFileMD5());
            if (recognizerSuccessInfo != null) {
                aiRecognizerResult.addInfo(recognizerSuccessInfo);
                SchemaExecutorLogger.info("AIAttachmentServiceImpl processAttachment single attachment hit recognition result", new Object[0]);
                return;
            }
            long start = System.currentTimeMillis();
            SchemaExecutorLogger.info("Start invoke AI mservice, single attachement ", new Object[0]);
            String dataText = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"distinguishOcrImage", (Object[])new Object[]{entityNumber, template.getNumber(), fileData});
            SchemaExecutorLogger.info("Attachment result filename:%s, data:%s", attachment.getFileName(), dataText);
            AIRecognizerResultBase aiRecognizerResultBase = attachmentTypeEnum.parseAttachment(dataText, template, attachment);
            aiRecognizerResult.addInfo(aiRecognizerResultBase);
            SchemaExecutorLogger.info("cost time %d for single task process Attachment", System.currentTimeMillis() - start);
            try {
                OriginAttachRecord originAttachRecord = new OriginAttachRecord(RequestContext.get().getTraceId(), entityNumber, billNo, AttachmentDataSourceEnum.AI.getDataSource(), dataText);
                AttachmentResultRecordHelper.saveOriginAttachRecord(originAttachRecord);
                if ("0".equals(aiRecognizerResultBase.getErrorCode())) {
                    AttachmentResultRecordHelper.saveAiProcessResultIfNotExist(template.getId(), attachment.getFileMD5(), JSON.toJSONString((Object)aiRecognizerResultBase));
                }
            }
            catch (Exception ex) {
                SchemaExecutorLogger.error("AIAttachmentServiceImpl processAttachment single attachment save record error", ex);
            }
        }
    }

    private void mulProcessAttachment(List<Attachment> attachmentList, String entityNumber, AITemplate template, AttachmentTypeEnum attachmentTypeEnum, AIRecognizerResult aiRecognizerResult, Function<Attachment, AIAttachmentRecognizerTask> function) {
        Future checkFuture;
        long start = System.currentTimeMillis();
        LinkedBlockingDeque<Future<AIRecognizerResultBase>> futureList = new LinkedBlockingDeque<Future<AIRecognizerResultBase>>(attachmentList.size());
        HashMap<Future<AIRecognizerResultBase>, Attachment> futureMap = new HashMap<Future<AIRecognizerResultBase>, Attachment>(attachmentList.size());
        for (Attachment attachment : attachmentList) {
            AIAttachmentRecognizerTask task = function.apply(attachment);
            Future<AIRecognizerResultBase> future = IDITaskManager.submitAI(task);
            futureList.push(future);
            futureMap.put(future, attachment);
        }
        while (!futureList.isEmpty() && (checkFuture = (Future)futureList.pop()) != null) {
            try {
                AIRecognizerResultBase data = (AIRecognizerResultBase)checkFuture.get(12L, TimeUnit.SECONDS);
                if (data != null) {
                    aiRecognizerResult.addInfo(data);
                }
                SchemaExecutorLogger.info("AIAttachmentServiceImpl.mulProcessAttachment, attachment data: %s", data);
            }
            catch (Exception e) {
                checkFuture.cancel(true);
                SchemaExecutorLogger.error(e);
                Attachment attachment = (Attachment)futureMap.get(checkFuture);
                AIRecognizerErrorInfo errorInfo = new AIRecognizerErrorInfo();
                errorInfo.setErrorCode("500");
                errorInfo.setDescription(ResManager.loadKDString((String)"\u591a\u7ebf\u7a0b\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u5904\u7406", (String)"AIAttachmentServiceImpl_0", (String)"data-idi-core", (Object[])new Object[0]));
                errorInfo.setFileName(attachment.getFileName());
                aiRecognizerResult.addErrorInfo(errorInfo);
            }
        }
        SchemaExecutorLogger.info("cost time %d for mul task process attachment", System.currentTimeMillis() - start);
    }

    private AITemplate queryTemplateNumber(Long templateId) {
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"cvp_template_base", (String)"number,name");
        return new AITemplate(templateId, tempObj.getString("number"), tempObj.getString("name"));
    }

    private static class AIAttachmentRecognizerClassifyTask
    extends AIAttachmentRecognizerTask {
        public AIAttachmentRecognizerClassifyTask(String entityNumber, String billNo, AITemplate template, Attachment attachment, AttachmentTypeEnum attachmentTypeEnum, RequestContext taskContext, SchemaContext schemaContext) {
            super(entityNumber, billNo, template, attachment, attachmentTypeEnum, taskContext, schemaContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AIRecognizerResultBase call() {
            SchemaContext.create(this.schemaContext);
            this.attachment.buildFileMD5();
            AIRecognizerSuccessInfo aiRecord = AttachmentResultRecordHelper.getAiRecord(null, this.attachment.getFileMD5());
            if (aiRecord != null) {
                SchemaExecutorLogger.info("AIAttachmentServiceImpl AIAttachmentRecognizerClassifyTask attachment hit recognition result", new Object[0]);
                return aiRecord;
            }
            RequestContext.copyAndSet((RequestContext)this.taskContext);
            long start = System.currentTimeMillis();
            long classifierId = this.template.getId();
            String fileName = this.attachment.getFileName();
            String fileType = this.attachment.getFileType();
            long fileSize = this.attachment.getSize();
            String filePath = this.attachment.getFileId();
            String storageType = "att";
            String dataText = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrClassifierService", (String)"singleClassify", (Object[])new Object[]{this.entityNumber, classifierId, fileName, fileType, fileSize, filePath, storageType});
            SchemaExecutorLogger.info("Attachment result filename:%s, data:%s", this.attachment.getFileName(), dataText);
            SchemaExecutorLogger.info("cost time %d for mul task process Attachment on recognizer in thread ", System.currentTimeMillis() - start);
            AIRecognizerResultBase aiRecognizerResultBase = this.attachmentTypeEnum.parseAttachment(dataText, null, this.attachment);
            try {
                OriginAttachRecord originAttachRecord = new OriginAttachRecord(this.taskContext.getTraceId(), this.entityNumber, this.billNo, AttachmentDataSourceEnum.AI.getDataSource(), dataText);
                AttachmentResultRecordHelper.saveOriginAttachRecord(originAttachRecord);
                if ("0".equals(aiRecognizerResultBase.getErrorCode())) {
                    AttachmentResultRecordHelper.saveAiProcessResultIfNotExist(classifierId, this.attachment.getFileMD5(), JSON.toJSONString((Object)aiRecognizerResultBase));
                }
            }
            catch (Exception ex) {
                SchemaExecutorLogger.error("AIAttachmentServiceImpl AIAttachmentRecognizerClassifyTask attachment save record error", ex);
            }
            finally {
                SchemaContext.remove();
            }
            return aiRecognizerResultBase;
        }
    }

    private static class AIAttachmentRecognizerTask
    implements Callable<AIRecognizerResultBase> {
        String entityNumber;
        String billNo;
        AITemplate template;
        Attachment attachment;
        AttachmentTypeEnum attachmentTypeEnum;
        RequestContext taskContext;
        SchemaContext schemaContext;

        public AIAttachmentRecognizerTask(String entityNumber, String billNo, AITemplate template, Attachment attachment, AttachmentTypeEnum attachmentTypeEnum, RequestContext taskContext, SchemaContext schemaContext) {
            this.entityNumber = entityNumber;
            this.billNo = billNo;
            this.template = template;
            this.attachment = attachment;
            this.attachmentTypeEnum = attachmentTypeEnum;
            this.taskContext = taskContext;
            this.schemaContext = schemaContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AIRecognizerResultBase call() {
            SchemaContext.create(this.schemaContext);
            RequestContext.copyAndSet((RequestContext)this.taskContext);
            long start = System.currentTimeMillis();
            String sb = "IDI_AI_" + this.entityNumber + "_" + this.template.getNumber() + "_" + this.attachment.getAttrId();
            String ckey = sb.toLowerCase();
            SchemaExecutorLogger.info("IDI: pget data text from cache, cache key:" + ckey, new Object[0]);
            Object dataText = CacheManager.getLocalMemoryCache().get(ckey);
            if (ObjectUtils.isEmpty((Object)dataText)) {
                String fileData = this.attachment.toBase64();
                this.attachment.buildFileMD5();
                String fileMd5 = this.attachment.getFileMD5();
                Long templateId = this.template.getId();
                AIRecognizerSuccessInfo recognizerSuccessInfo = AttachmentResultRecordHelper.getAiRecord(templateId, fileMd5);
                if (recognizerSuccessInfo != null) {
                    SchemaExecutorLogger.info("AIAttachmentServiceImpl AIAttachmentRecognizerTask attachment hit recognition result", new Object[0]);
                    return recognizerSuccessInfo;
                }
                SchemaExecutorLogger.info("Start invoke AI mservice ", new Object[0]);
                dataText = DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"distinguishOcrImage", (Object[])new Object[]{this.entityNumber, this.template.getNumber(), fileData});
                SchemaExecutorLogger.info("Attachment result filename:%s, data:%s", this.attachment.getFileName(), dataText);
                SchemaExecutorLogger.info("cost time %d for mul task process Attachment in thread ", System.currentTimeMillis() - start);
                SchemaExecutorLogger.info("IDI: put data text into cache, cache key:" + ckey, new Object[0]);
                CacheManager.getLocalMemoryCache().put(ckey, dataText);
                AIRecognizerResultBase aiRecognizerResultBase = this.attachmentTypeEnum.parseAttachment(String.valueOf(dataText), this.template, this.attachment);
                try {
                    OriginAttachRecord originAttachRecord = new OriginAttachRecord(this.taskContext.getTraceId(), this.entityNumber, this.billNo, AttachmentDataSourceEnum.AI.getDataSource(), String.valueOf(dataText));
                    AttachmentResultRecordHelper.saveOriginAttachRecord(originAttachRecord);
                    if ("0".equals(aiRecognizerResultBase.getErrorCode())) {
                        AttachmentResultRecordHelper.saveAiProcessResultIfNotExist(templateId, fileMd5, JSON.toJSONString((Object)aiRecognizerResultBase));
                    }
                }
                catch (Exception ex) {
                    SchemaExecutorLogger.error("AIAttachmentServiceImpl AIAttachmentRecognizerTask attachment save record error", ex);
                }
                finally {
                    SchemaContext.remove();
                }
                return aiRecognizerResultBase;
            }
            SchemaExecutorLogger.info("IDI: get data text from cache, data text : " + dataText, new Object[0]);
            SchemaContext.remove();
            return this.attachmentTypeEnum.parseAttachment(String.valueOf(dataText), this.template, this.attachment);
        }
    }
}

