/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.courier.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.courier.service.CourierParam;

public class CourierLogisticParser {
    public static DynamicObject parse(String content) {
        if (StringUtils.isEmpty((String)content)) {
            return null;
        }
        JSONObject resultJson = JSONObject.parseObject((String)content);
        int status = resultJson.getInteger("status");
        if (status == 200) {
            JSONObject dataJson = resultJson.getJSONObject("data");
            JSONObject lastJson = dataJson.getJSONObject("last_result");
            String order = lastJson.getString("kuaidi_num");
            DynamicObject courierObj = BusinessDataServiceHelper.newDynamicObject((String)"idi_logistics_info");
            String companyCode = lastJson.getString("company_code");
            String companyName = lastJson.getString("com_name");
            courierObj.set("kuaidinum", (Object)order);
            courierObj.set("companycode", (Object)companyCode);
            courierObj.set("kuadicomname", (Object)companyName);
            String logisticStatus = lastJson.getString("state");
            String isCheck = lastJson.getString("is_check");
            courierObj.set("state", (Object)logisticStatus);
            courierObj.set("ischeck", (Object)isCheck);
            JSONArray dataArray = lastJson.getJSONArray("data");
            if (dataArray != null && !dataArray.isEmpty()) {
                DynamicObjectCollection cols = courierObj.getDynamicObjectCollection("dataentryentity");
                cols.clear();
                int seq = 0;
                for (int i = dataArray.size() - 1; i >= 0; --i) {
                    JSONObject logisticJson = dataArray.getJSONObject(i);
                    String areaCode = logisticJson.getString("area_code");
                    String areaName = logisticJson.getString("area_name");
                    String context = logisticJson.getString("context");
                    String ftime = logisticJson.getString("f_time");
                    String logisticStatusStr = logisticJson.getString("status");
                    DynamicObject logisticObj = cols.addNew();
                    logisticObj.set("areacode", (Object)areaCode);
                    logisticObj.set("areaname", (Object)areaName);
                    logisticObj.set("context", (Object)context);
                    logisticObj.set("ftime", (Object)ftime);
                    logisticObj.set("status", (Object)logisticStatusStr);
                    logisticObj.set("seq", (Object)seq);
                    ++seq;
                    if (i != dataArray.size() - 1) continue;
                    courierObj.set("sendtime", (Object)ftime);
                }
            }
            return courierObj;
        }
        return null;
    }

    public static DynamicObject parseError(String content, CourierParam param) {
        DynamicObject error = BusinessDataServiceHelper.newDynamicObject((String)"idi_logistics_errorinfo");
        error.set("order", (Object)param.getOrder());
        error.set("compnaynum", (Object)param.getCompanyNum());
        error.set("mobile", (Object)param.getMobile());
        error.set("companyname", (Object)param.getComapnyName());
        error.set("createtime", (Object)new Date());
        if (!StringUtils.isEmpty((String)content)) {
            JSONObject resultJson = JSONObject.parseObject((String)content);
            String status = resultJson.getString("status");
            error.set("code", (Object)status);
            error.set("message", (Object)("401".equals(status) ? ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u5feb\u9012\u5355\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e", (String)"CourierLogisticParser_0", (String)"data-idi-core", (Object[])new Object[0]) : resultJson.getString("message")));
        } else {
            error.set("message", (Object)"logistics is null");
        }
        return error;
    }

    public static DynamicObject createError(String message, CourierParam param) {
        DynamicObject error = BusinessDataServiceHelper.newDynamicObject((String)"idi_logistics_errorinfo");
        error.set("message", (Object)message);
        error.set("order", (Object)param.getOrder());
        error.set("compnaynum", (Object)param.getCompanyNum());
        error.set("mobile", (Object)param.getMobile());
        error.set("companyname", (Object)param.getComapnyName());
        error.set("createtime", (Object)new Date());
        return error;
    }
}

