/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.data.idi.export.IDataExImport;

public abstract class DynamicExImport
implements IDataExImport {
    protected static final String ALGO_KEY = "IDIDynamicExImport.load";
    private final boolean byImport;
    private boolean importSuccess;
    private final Object[] primaryKeyValues;
    private final Set<String> excludeSet = new HashSet<String>();
    volatile transient Map<String, IDataEntityProperty> dctFields = null;
    private final Map<String, DynamicExImport> ref = new HashMap<String, DynamicExImport>();
    protected final Map<String, Map<Object, DynamicObject>> dynaMaps;
    private MainEntityType dataEntityType;

    public DynamicExImport() {
        this.dynaMaps = null;
        this.primaryKeyValues = null;
        this.byImport = true;
        this.dataEntityType = null;
    }

    public DynamicExImport(Map<String, Map<Object, DynamicObject>> maps, Object[] primaryKeyValues) {
        this(maps, primaryKeyValues, true);
    }

    public DynamicExImport(Map<String, Map<Object, DynamicObject>> maps, Object[] primaryKeyValues, boolean byImport) {
        this.dynaMaps = maps;
        this.primaryKeyValues = primaryKeyValues;
        this.byImport = byImport;
        this.dynaMaps.put(this.getKey(), new HashMap());
        this.init();
    }

    protected final void init() {
        this.dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        this.fillExcludeProperties(this.excludeSet);
        this.fillRef(this.ref);
    }

    public String getEntityName() {
        return "";
    }

    protected String getSelect() {
        return "";
    }

    public String getSelectProperties() {
        String select = this.getSelect();
        if (StringUtils.isBlank((CharSequence)select)) {
            return String.join((CharSequence)",", this.getAllFields().keySet());
        }
        return select;
    }

    public QFilter getQFilter() {
        return null;
    }

    public boolean byImport() {
        return this.byImport;
    }

    public Object[] getPrimaryKeyValues() {
        return this.primaryKeyValues;
    }

    public String orderBy() {
        return "";
    }

    protected Map<String, DynamicExImport> getRef() {
        return this.ref;
    }

    public boolean isImportSuccess() {
        return this.importSuccess;
    }

    public void setImportSuccess(boolean importSuccess) {
        this.importSuccess = importSuccess;
    }

    protected DynamicObject getDynamic(String key, Object number) {
        Map<Object, DynamicObject> ref = this.dynaMaps.get(key);
        return ref != null ? ref.get(number) : null;
    }

    protected void putDynamic(DynamicObject newDyn) {
        this.putDynamic(null, newDyn);
    }

    protected void putDynamic(DynamicObject importDyn, DynamicObject newDyn) {
        if (newDyn != null) {
            this.dynaMaps.get(this.getKey()).put(newDyn.get("number"), newDyn);
        }
    }

    protected void fillExcludeProperties(Set<String> excludeSet) {
        excludeSet.add("creator");
        excludeSet.add("createtime");
        excludeSet.add("modifier");
        excludeSet.add("modifytime");
    }

    protected void fillRef(Map<String, DynamicExImport> ref) {
    }

    protected DynamicObject validDynamic(DynamicObject importDyn) {
        return importDyn;
    }

    protected DynamicObject validDynamic(DynamicObject importDyn, DynamicObject newDynamic) {
        return newDynamic;
    }

    @Override
    public Object loadData() {
        QFilter qFilter = this.getQFilter();
        if (qFilter == null || qFilter.getValue() == null) {
            return null;
        }
        ArrayList<Object> idList = new ArrayList<Object>();
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY, this.getEntityName(), "id", qFilter.toArray(), this.orderBy(), 100, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        DynamicObjectType type = this.getSubEntityType(this.getEntityName(), this.getSelectProperties());
        DynamicObject[] load = BusinessDataReader.load((Object[])idList.toArray(), (DynamicObjectType)type, (Boolean)Boolean.TRUE);
        if (load != null) {
            for (DynamicObject dynamicObject : load) {
                dynamicObject.getDataEntityState().setFromDatabase(false);
            }
            return this.orderBy(load, idList, this.orderBy());
        }
        return null;
    }

    private DynamicObject[] orderBy(DynamicObject[] dynamicObjArr, List<Object> idList, String orderBy) {
        if (StringUtils.isBlank((CharSequence)orderBy) || idList.size() <= 1) {
            return dynamicObjArr;
        }
        HashMap<Object, DynamicObject> maps = new HashMap<Object, DynamicObject>(dynamicObjArr.length);
        for (DynamicObject o : dynamicObjArr) {
            maps.put(o.getPkValue(), o);
        }
        ArrayList<DynamicObject> listDyn = new ArrayList<DynamicObject>(dynamicObjArr.length);
        for (Object id : idList) {
            DynamicObject o;
            o = (DynamicObject)maps.get(id);
            if (o == null) continue;
            listDyn.add(o);
        }
        return listDyn.toArray(new DynamicObject[0]);
    }

    private DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (StringUtils.isNotEmpty((CharSequence)selectProperties)) {
            String[] properties = selectProperties.split(",");
            HashSet<String> select = new HashSet<String>(properties.length);
            for (String prop : properties) {
                select.add(prop.trim());
            }
            return dataEntityType.getSubEntityType(select);
        }
        return dataEntityType;
    }

    @Override
    public void parseImport(String dynBase64) {
        if (StringUtils.isNotBlank((CharSequence)dynBase64)) {
            DynamicObject[] dynamicObjArr = (DynamicObject[])this.deSerialize(dynBase64);
            if (dynamicObjArr == null) {
                return;
            }
            for (DynamicObject importDyn : dynamicObjArr) {
                DynamicObject validDynamic = this.validDynamic(importDyn);
                if (validDynamic == null) continue;
                DynamicObject newDynamic = this.importDynamicObjectToNew(validDynamic);
                this.putDynamic(validDynamic, this.validDynamic(validDynamic, newDynamic));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u5bfc\u5165\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u662f\u5426\u88ab\u4fee\u6539\u8fc7\u3002", (String)"DynamicExImport_3", (String)"data-idi-core", (Object[])new Object[0]));
        }
    }

    private DynamicObject importDynamicObjectToNew(DynamicObject importDyn) {
        DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)this.getEntityName());
        newDyn.set("id", (Object)DB.genGlobalLongId());
        List<IDataEntityProperty> fields = this.getFields();
        Map<String, IDataEntityProperty> allFields = this.getAllFields();
        for (IDataEntityProperty property : fields) {
            if (property instanceof ICollectionProperty) {
                DynamicObjectCollection imprtDynColl = importDyn.getDynamicObjectCollection(property.getName());
                DynamicObjectCollection newDynColl = newDyn.getDynamicObjectCollection(property.getName());
                for (int i = 0; i < imprtDynColl.size(); ++i) {
                    DynamicObject importCollDyn = (DynamicObject)imprtDynColl.get(i);
                    DynamicObject newCollDyn = newDynColl.addNew();
                    IDataEntityType itemType = ((ICollectionProperty)property).getItemType();
                    if (property instanceof EntryProp) {
                        DataEntityPropertyCollection properties = itemType.getProperties();
                        for (IDataEntityProperty dp : properties) {
                            if (allFields.containsKey(property.getName() + "." + dp.getName())) {
                                this.setDynamicObjectValue(newCollDyn, importCollDyn, dp);
                                continue;
                            }
                            if (!"seq".equals(dp.getName())) continue;
                            dp.setValueFast((Object)newCollDyn, (Object)(i + 1));
                        }
                        continue;
                    }
                    if (!(property instanceof MulBasedataProp) || !allFields.containsKey(property.getName())) continue;
                    IDataEntityProperty fbasedataid = (IDataEntityProperty)itemType.getProperties().get((Object)"fbasedataid");
                    this.setDynamicObjectValue(newCollDyn, importCollDyn, fbasedataid);
                }
                continue;
            }
            this.setDynamicObjectValue(newDyn, importDyn, property);
        }
        this.setCommonFields(newDyn);
        return newDyn;
    }

    private void setCommonFields(DynamicObject newDyn) {
        DataEntityPropertyCollection properties = newDyn.getDynamicObjectType().getProperties();
        long userId = RequestContext.get().getCurrUserId();
        this.setValueFast((IDataEntityProperty)properties.get((Object)"creator"), newDyn, userId);
        this.setValueFast((IDataEntityProperty)properties.get((Object)"createtime"), newDyn, new Date());
        this.setValueFast((IDataEntityProperty)properties.get((Object)"modifier"), newDyn, userId);
        this.setValueFast((IDataEntityProperty)properties.get((Object)"modifytime"), newDyn, new Date());
    }

    private void setValueFast(IDataEntityProperty property, DynamicObject newDyn, Object obj) {
        if (property != null) {
            property.setValueFast((Object)newDyn, obj);
        }
    }

    private Map<String, IDataEntityProperty> getAllFields() {
        this.createDctFields();
        return this.dctFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDctFields() {
        if (this.dctFields == null) {
            DynamicExImport dynamicExImport = this;
            synchronized (dynamicExImport) {
                LinkedHashMap<String, IDataEntityProperty> collMap = new LinkedHashMap<String, IDataEntityProperty>();
                Map allFields = this.dataEntityType.getAllFields();
                String cusSelect = this.getSelect();
                if (StringUtils.isNotBlank((CharSequence)cusSelect)) {
                    String[] split;
                    for (String field : split = cusSelect.split(",")) {
                        IDataEntityProperty property = (IDataEntityProperty)allFields.get(field);
                        this.putPropertyToCollMap(collMap, property);
                    }
                } else {
                    Collection values = allFields.values();
                    for (IDataEntityProperty property : values) {
                        this.putPropertyToCollMap(collMap, property);
                    }
                }
                this.dctFields = collMap;
            }
        }
    }

    private void putPropertyToCollMap(Map<String, IDataEntityProperty> collMap, IDataEntityProperty property) {
        IDataEntityType parent = property.getParent();
        if (parent.getName().equals(this.getEntityName())) {
            collMap.put(property.getName(), property);
            if (property instanceof LargeTextProp) {
                IDataEntityProperty tagProperty = (IDataEntityProperty)parent.getProperties().get((Object)(property.getName() + "_tag"));
                collMap.put(tagProperty.getName(), tagProperty);
            }
        } else {
            collMap.put(parent.getName() + "." + property.getName(), property);
            if (property instanceof LargeTextProp) {
                IDataEntityProperty tagProperty = (IDataEntityProperty)parent.getProperties().get((Object)(property.getName() + "_tag"));
                collMap.put(parent.getName() + "." + tagProperty.getName(), tagProperty);
            }
        }
    }

    private List<IDataEntityProperty> getFields() {
        DataEntityPropertyCollection properties = this.dataEntityType.getProperties();
        String cusSelect = this.getSelect();
        if (StringUtils.isNotBlank((CharSequence)cusSelect)) {
            String[] split = cusSelect.split(",");
            Set set = Arrays.stream(split).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            return properties.stream().filter(property -> set.contains(property.getName())).collect(Collectors.toList());
        }
        Map fields = this.dataEntityType.getFields();
        return properties.stream().filter(property -> !(property instanceof DynamicLocaleProperty)).filter(property -> property instanceof ICollectionProperty || fields.containsKey(property.getName())).filter(property -> !this.excludeSet.contains(property.getName())).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDynamicObjectValue(DynamicObject newDyn, DynamicObject importDyn, IDataEntityProperty property) {
        Object value;
        if (property instanceof ICollectionProperty) {
            return;
        }
        IDataEntityProperty importProp = (IDataEntityProperty)importDyn.getDynamicObjectType().getProperties().get((Object)property.getName());
        if (importProp == null) {
            if (!property.hasDefaultValue() || !(property instanceof DynamicProperty)) return;
            value = ((DynamicProperty)property).getDefaultValue();
        } else {
            value = importDyn.get(property.getName());
        }
        if (property instanceof MuliLangTextProp) {
            property.setValueFast((Object)newDyn, (Object)(value == null ? null : String.valueOf(value)));
            return;
        } else if (property instanceof LargeTextProp) {
            property.setValueFast((Object)newDyn, value);
            String propTag = property.getName() + "_tag";
            newDyn.set(propTag, importDyn.get(propTag));
            return;
        } else if (property instanceof BasedataProp) {
            DynamicObject val = (DynamicObject)value;
            String refKey = "fbasedataid".equals(property.getName()) ? property.getParent().getName() : property.getName();
            DynamicExImport exImport = this.getRef().get(refKey);
            if (exImport != null && val != null) {
                String number = val.getString("number");
                if (!StringUtils.isNotEmpty((CharSequence)number)) return;
                DynamicObject dynamic = this.getDynamic(exImport.getKey(), number);
                if (dynamic == null) throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s:\u5bfc\u5165\u6570\u636e\u5173\u8054\u5c5e\u6027\u7f3a\u5931\uff0c\u7f16\u53f7\u4e3a%2$s\u7684\u57fa\u7840\u8d44\u6599(%3$s)\u65e0\u6cd5\u627e\u5230\u3002", (String)"DynamicExImport_0", (String)"data-idi-core", (Object[])new Object[0]), this.getTip(), number, this.getEntityCaption(exImport.getEntityName())));
                property.setValueFast((Object)newDyn, (Object)dynamic);
                return;
            } else {
                DynamicObject link = this.loadDynamic((DynamicObject)value);
                property.setValueFast((Object)newDyn, (Object)link);
                if (value != null || !(property instanceof ItemClassProp)) return;
                IDataEntityProperty refIdProp = ((ItemClassProp)property).getRefIdProp();
                Object refId = importDyn.get(refIdProp.getName());
                refIdProp.setValueFast((Object)newDyn, refId);
            }
            return;
        } else {
            property.setValueFast((Object)newDyn, value);
        }
    }

    private DynamicObject loadDynamic(DynamicObject value) {
        if (value == null) {
            return null;
        }
        DynamicObjectType objectType = value.getDynamicObjectType();
        String entityName = objectType.getName();
        String number = value.getString("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            return null;
        }
        DynamicObject[] fromByNumber = BusinessDataServiceHelper.load((String)entityName, (String)"number", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (fromByNumber.length == 1) {
            return fromByNumber[0];
        }
        if (fromByNumber.length > 1) {
            DynamicObject fromSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)value.getPkValue(), (DynamicObjectType)objectType);
            if (fromSystem != null && StringUtils.equals((CharSequence)number, (CharSequence)fromSystem.getString("number"))) {
                return fromSystem;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s:\u5bfc\u5165\u6570\u636e\u5173\u8054\u5c5e\u6027\uff0c\u7f16\u53f7\u4e3a%2$s\u7684\u57fa\u7840\u8d44\u6599(%3$s)\u627e\u5230\u591a\u4e2a\uff0c\u65e0\u6cd5\u5173\u8054\u3002", (String)"DynamicExImport_1", (String)"data-idi-core", (Object[])new Object[0]), this.getTip(), number, this.getEntityCaption(entityName)));
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s:\u5bfc\u5165\u6570\u636e\u5173\u8054\u5c5e\u6027\u7f3a\u5931\uff0c\u7f16\u53f7\u4e3a%2$s\u7684\u57fa\u7840\u8d44\u6599(%3$s)\u65e0\u6cd5\u627e\u5230\u3002", (String)"DynamicExImport_2", (String)"data-idi-core", (Object[])new Object[0]), this.getTip(), number, this.getEntityCaption(entityName)));
    }

    protected String getEntityCaption(String entityName) {
        return FormMetadataCache.getFormConfig((String)entityName).getCaption().getLocaleValue();
    }
}

