/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.util.StringUtils;
import kd.data.idi.data.attachment.AttachmentFieldTypeEnum;
import kd.data.idi.engine.SchemaExecutorLogger;

public class AttachmentFieldValueHelper {
    private static final Pattern pattern = Pattern.compile("^[1-9]\\d*$");

    public static AttachmentFieldTypeEnum getFieldType(String field, Object fieldTypeObj, Map<String, String> fieldTypeMap) {
        String fieldType = String.valueOf(fieldTypeObj);
        if (fieldTypeObj == null || StringUtils.isEmpty((String)fieldType)) {
            fieldType = fieldTypeMap.get(field);
        }
        return AttachmentFieldTypeEnum.convertFieldType(fieldType);
    }

    public static Object getValueByFieldType(AttachmentFieldTypeEnum fieldTypeEnum, Object originValue) {
        if (fieldTypeEnum == null) {
            return originValue;
        }
        try {
            String originValueStr = String.valueOf(originValue);
            boolean originValueEmpty = originValue == null || StringUtils.isEmpty((String)originValueStr);
            switch (fieldTypeEnum) {
                case Boolean: {
                    if ("1".equals(originValueStr)) {
                        return Boolean.TRUE;
                    }
                    if ("0".equals(originValueStr)) {
                        return Boolean.FALSE;
                    }
                    return originValue;
                }
                case Date: {
                    if (originValueEmpty) {
                        return originValue;
                    }
                    if (originValueStr.contains("/")) {
                        originValueStr = originValueStr.replaceAll("/", "-");
                    }
                    if (originValueStr.contains("|")) {
                        originValueStr = originValueStr.replaceAll("\\|", "-");
                    }
                    if (originValueStr.length() <= 10) {
                        return new SimpleDateFormat("yyyy-MM-dd").parse(originValueStr);
                    }
                    if (originValueStr.length() <= 19) {
                        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(originValueStr);
                    }
                }
                case BigDecimal: {
                    if (originValueEmpty) {
                        return new BigDecimal("0.00");
                    }
                    if (pattern.matcher(originValueStr).matches()) {
                        return new BigDecimal(originValueStr).setScale(2, RoundingMode.FLOOR);
                    }
                    return originValue;
                }
            }
            return originValue;
        }
        catch (ParseException ex) {
            SchemaExecutorLogger.error("AttachmentFieldValueHelper getValueByFieldType error", ex);
            return originValue;
        }
    }
}

