/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.util.StringUtils;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.engine.BillCheckResult;
import kd.data.idi.engine.DeductionGrade;
import kd.data.idi.engine.customrule.EntryRowRelationDTO;

public class BillDecisionUtil {
    public static void processShowAllEntryCheckTrue(EntryRowRelationDTO relationDTO, List<LinkUpBillResult> linkUpBillResults, Map<Integer, List<BillCheckResult>> ruleBillMap, List<DecisionRule> ruleList, String firstEntryNumber, DeductionGrade deductionGrade) {
        ArrayList<LinkUpBillResult> removeList = new ArrayList<LinkUpBillResult>(linkUpBillResults.size());
        LinkedHashMap<Integer, Set<Integer>> matchIndexMap = relationDTO.getEntryIdMap();
        for (LinkUpBillResult linkUpBillResult : linkUpBillResults) {
            List<BillCheckResult> billCheckResults;
            DecisionRule decisionRule;
            int ruleIndex = linkUpBillResult.getMatchRule();
            if (ruleIndex < 0 || !(decisionRule = ruleList.get(ruleIndex)).isShowAllEntryCheckTrue() || (billCheckResults = ruleBillMap.get(ruleIndex)).isEmpty()) continue;
            HashMap<Integer, List> classifyMap = new HashMap<Integer, List>(10);
            int errorGroupCount = 0;
            ArrayList showBillCheckResults = new ArrayList(billCheckResults.size());
            for (BillCheckResult billCheckResult : billCheckResults) {
                if (StringUtils.isEmpty((String)billCheckResult.getSrcEntryName()) || StringUtils.isEmpty((String)billCheckResult.getLinkEntryName())) break;
                Integer srcEntryIndex = null;
                srcEntryIndex = firstEntryNumber.equals(billCheckResult.getSrcEntryName()) ? Integer.valueOf(billCheckResult.getSrcEntryIndex()) : Integer.valueOf(billCheckResult.getLinkEntryIndex());
                List linkEntryList = classifyMap.computeIfAbsent(srcEntryIndex, key -> new ArrayList(10));
                linkEntryList.add(billCheckResult);
            }
            for (Map.Entry entry : classifyMap.entrySet()) {
                Integer srcIndex = (Integer)entry.getKey();
                if (firstEntryNumber.equals(relationDTO.getEntryFlag()) && matchIndexMap.get(srcIndex) != null && matchIndexMap.get(srcIndex).size() == ((List)entry.getValue()).size() || firstEntryNumber.equals(relationDTO.getTargetEntryFlag()) && matchIndexMap.size() == ((List)entry.getValue()).size()) {
                    showBillCheckResults.addAll((Collection)entry.getValue());
                    continue;
                }
                for (BillCheckResult billCheckResult : (List)entry.getValue()) {
                    deductionGrade.deductNegate(billCheckResult.getDeductPercent());
                }
                ++errorGroupCount;
            }
            if (errorGroupCount == classifyMap.size()) {
                removeList.add(linkUpBillResult);
                continue;
            }
            ruleBillMap.put(ruleIndex, showBillCheckResults);
        }
        linkUpBillResults.removeAll(removeList);
    }
}

