/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;

public class CompareColumnHelper {
    public static void baseDataTextFieldCompare(FilterField filterField, Map<String, Object> filterColumn) {
        if (filterField.getFieldType() == -9) {
            filterColumn.put("type", "text");
        }
    }

    public static List<CompareType> getFieldEqualCompareType() {
        List commonCompareTypes = EntityTypeUtil.setCompareTypes(Collections.emptyList(), (boolean)true, (boolean)true);
        Iterator compareTypeIterator = commonCompareTypes.iterator();
        while (compareTypeIterator.hasNext()) {
            CompareType next = (CompareType)compareTypeIterator.next();
            String compareTypeId = next.getId();
            if (compareTypeId.equals(CompareTypeEnum.FIELDEQUAL.getId())) continue;
            compareTypeIterator.remove();
        }
        return commonCompareTypes;
    }

    public static Map<String, Object> genIdColumnMap(FilterField filterField, Set<String> idSet, MainEntityType entityType, List<CompareType> fieldEqualCompareType) {
        BasedataProp basedataProp;
        IDataEntityProperty prop;
        String fullFieldName = filterField.getFieldName();
        String caption = filterField.getCaption().toString();
        if (StringUtils.isBlank((CharSequence)fullFieldName)) {
            return null;
        }
        String key = null;
        if (fullFieldName.indexOf(46) > -1) {
            key = fullFieldName.substring(0, fullFieldName.lastIndexOf(46));
            caption = caption.substring(0, caption.lastIndexOf(46));
        }
        if (key == null) {
            return null;
        }
        if (idSet.add(key = key + "_id") && (prop = (basedataProp = (BasedataProp)filterField.getLatestParent()).getRefIdProp()) instanceof IFieldHandle) {
            FilterField idFilterField = ((IFieldHandle)prop).createFilterField(entityType, prop.getName());
            Map idColumn = idFilterField.createFilterColumn();
            idColumn.put("entryEntity", filterField.getEntityKey());
            idColumn.put("fieldName", key);
            idColumn.put("fieldCaption", caption);
            idColumn.put("compareGroupID", "9");
            idColumn.put("compareTypes", fieldEqualCompareType);
            return idColumn;
        }
        return null;
    }

    public static FilterField genIdField(FilterField filterField, Set<String> idSet, MainEntityType entityType, List<CompareType> fieldEqualCompareType) {
        BasedataProp basedataProp;
        IDataEntityProperty prop;
        String fieldName = filterField.getFieldName();
        String fullFieldName = filterField.getFullFieldName();
        String caption = filterField.getCaption().toString();
        if (StringUtils.isBlank((CharSequence)fullFieldName)) {
            return null;
        }
        String key = null;
        if (fieldName.indexOf(46) > -1) {
            key = fieldName.substring(0, fieldName.lastIndexOf(46));
            fullFieldName = fullFieldName.substring(0, fullFieldName.lastIndexOf(46));
            caption = caption.substring(0, caption.lastIndexOf(46));
        }
        if (key == null) {
            return null;
        }
        key = key + "_id";
        fullFieldName = fullFieldName + "_id";
        if (idSet.add(key) && (prop = (basedataProp = (BasedataProp)filterField.getLatestParent()).getRefIdProp()) instanceof IFieldHandle) {
            FilterField idFilterField = new FilterField(entityType, filterField.getSrcFieldProp(), null, null, null);
            idFilterField.setCaption(new LocaleString(caption));
            idFilterField.setFieldName(key);
            idFilterField.setFullFieldName(fullFieldName);
            idFilterField.setCompareGroupID("9");
            idFilterField.setCompareTypes(fieldEqualCompareType);
            return idFilterField;
        }
        return null;
    }

    public static List<Map<String, Object>> createEntrySeq(MainEntityType entityType) {
        List<FilterField> filterFields = CompareColumnHelper.createEntrySeqField(entityType);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(filterFields.size());
        for (FilterField filterField : filterFields) {
            list.add(filterField.createFilterColumn());
        }
        return list;
    }

    public static List<FilterField> createEntrySeqField(MainEntityType entityType) {
        String billType = entityType.getName();
        ArrayList<FilterField> list = new ArrayList<FilterField>(16);
        Map entityMap = entityType.getAllEntities();
        for (Map.Entry entry : entityMap.entrySet()) {
            DynamicProperty seqProp;
            String key = (String)entry.getKey();
            EntityType entryEntity = (EntityType)entry.getValue();
            if (key.equals(billType) || entryEntity instanceof SubEntryType || (seqProp = entryEntity.getProperty("seq")) == null) continue;
            IFieldHandle seqField = (IFieldHandle)seqProp;
            List seqFields = seqField.createFilterFields(entityType);
            list.addAll(seqFields);
        }
        return list;
    }

    public static void processPropertyName(String entityNumber, List<Map<String, Object>> fieldColumn) {
        for (Map<String, Object> map : fieldColumn) {
            String fieldName;
            String entryEntity = (String)map.get("entryEntity");
            String value = fieldName = (String)map.get("fieldName");
            if (kd.bos.util.StringUtils.isNotEmpty((String)entryEntity) && !entityNumber.equals(entryEntity)) {
                value = entryEntity + "." + fieldName;
            }
            map.put("fieldName", value);
        }
    }
}

