/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.EntryProp;

public class DynamicObjectCopyMergeUtil {
    public static DynamicObject mergeDynamicObject(DynamicObject sourceObj, DynamicObject targetObj) {
        if (sourceObj == null || targetObj == null) {
            return targetObj;
        }
        DynamicObjectType sourceObjDataEntityType = sourceObj.getDynamicObjectType();
        DataEntityPropertyCollection properties = sourceObjDataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if (property instanceof EntryProp) {
                int entryIndex;
                EntryProp entryProp = (EntryProp)property;
                DynamicObjectCollection sourceEntryData = sourceObj.getDynamicObjectCollection((IDataEntityProperty)entryProp);
                DynamicObjectCollection targetEntryData = targetObj.getDynamicObjectCollection(propertyName);
                int sourceSize = sourceEntryData.size();
                int targetSize = targetEntryData.size();
                for (entryIndex = 0; entryIndex < sourceSize; ++entryIndex) {
                    DynamicObject targetRowData;
                    DynamicObject sourceRowData = (DynamicObject)sourceEntryData.get(entryIndex);
                    if (entryIndex >= targetSize) {
                        targetRowData = targetEntryData.addNew();
                        DynamicObjectCopyMergeUtil.mergeDynamicObject(sourceRowData, targetRowData);
                        continue;
                    }
                    targetRowData = (DynamicObject)targetEntryData.get(entryIndex);
                    DynamicObjectCopyMergeUtil.mergeDynamicObject(sourceRowData, targetRowData);
                }
                if (sourceSize < targetSize) {
                    for (entryIndex = targetSize - 1; entryIndex >= sourceSize; --entryIndex) {
                        targetEntryData.remove(entryIndex);
                    }
                }
                targetObj.set(propertyName, (Object)targetEntryData);
                continue;
            }
            Object value = property.getValue((Object)sourceObj);
            targetObj.set(propertyName, value);
        }
        return targetObj;
    }
}

