/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class InvoiceParser {
    private static final String INVOICEFORM = "idi_invoice";
    private static final String BILLID = "billid";
    private static final String INVOICEDATE = "invoicedate";
    private static final String IMAGENUMBER = "imagenumber";
    private static final String CREATETIME = "createtime";
    private static final String INVOICECODE = "invoicecode";
    private static final String INVOICETYPE = "invoicetype";
    private static final String INVOICENO = "invoiceno";
    private static final String ENTRYKEYVALUE = "entrykeyvalue";
    private static final String INVOICEKEY = "invoicekey";
    private static final String INVOICEVALUE = "invoicevalue";
    private static String DUPLICATEFIELD = "indexfield";
    private static final String INVOICEID = "invoiceid";
    private static final String IMAGENO = "imagenumber";
    private static final String IMAGEPAGE = "imagepage";

    public static String getImageNumber(String billIdStr) {
        DynamicObject bill = QueryServiceHelper.queryOne((String)"billimagemaintain", (String)"imagenumber", (QFilter[])new QFilter[]{new QFilter("\r\nbillid", "=", (Object)billIdStr)});
        if (bill == null) {
            return "";
        }
        return bill.getString("imagenumber");
    }

    public static List<DynamicObject> parseInvoiceResult(String result, String billIdStr) {
        JSONObject resultJson = JSONObject.parseObject((String)result);
        String errorCode = resultJson.getString("errcode");
        String imageNumber = InvoiceParser.getImageNumber(billIdStr);
        if ("0000".equals(errorCode)) {
            JSONObject dataJson = resultJson.getJSONObject("data");
            if (dataJson == null) {
                return null;
            }
            JSONArray invoiceJsonArray = dataJson.getJSONArray("invoice");
            if (invoiceJsonArray != null && !invoiceJsonArray.isEmpty()) {
                ArrayList<DynamicObject> successInvoiceList = new ArrayList<DynamicObject>(invoiceJsonArray.size());
                for (int i = 0; i < invoiceJsonArray.size(); ++i) {
                    DynamicObject invoiceObj = InvoiceParser.recognizeSuccessInvoice(invoiceJsonArray.getJSONObject(i), billIdStr, imageNumber);
                    InvoiceParser.trainAndPlanInvoiceHandle(invoiceObj);
                    successInvoiceList.add(invoiceObj);
                }
                return successInvoiceList;
            }
        }
        return null;
    }

    public static void trainAndPlanInvoiceHandle(DynamicObject invoiceData) {
        String key = InvoiceParser.buildTrainAndPlanInvoiceKey(invoiceData);
        if (StringUtils.isNotEmpty((String)key)) {
            invoiceData.set(DUPLICATEFIELD, (Object)key);
        }
    }

    public static DynamicObject recognizeSuccessInvoice(JSONObject data, String billIdStr, String imageNumber) {
        DynamicObject entryKeyValue;
        DynamicObject invoiceObj = BusinessDataServiceHelper.newDynamicObject((String)INVOICEFORM);
        invoiceObj.set(BILLID, (Object)billIdStr);
        invoiceObj.set("imagenumber", (Object)imageNumber);
        invoiceObj.set(INVOICECODE, (Object)(data.getString("invoiceCode") == null ? "" : data.getString("invoiceCode")));
        String invoiceDate = data.getString("invoiceDate");
        invoiceObj.set(INVOICEDATE, (Object)invoiceDate);
        String invoiceType = data.getString("invoiceType") == null ? "" : data.getString("invoiceType");
        invoiceObj.set(INVOICETYPE, (Object)invoiceType);
        invoiceObj.set(INVOICENO, (Object)(data.getString("invoiceNo") == null ? "" : data.getString("invoiceNo")));
        invoiceObj.set(CREATETIME, (Object)new Date());
        String checkStatus = data.getString("checkStatus");
        String isTrue = "2".equals(checkStatus) ? "0" : "1";
        JSONArray items = data.getJSONArray("items");
        if (items != null) {
            DynamicObjectCollection entryEntityCollection = invoiceObj.getDynamicObjectCollection("entryentity");
            DynamicObjectType entryEntityType = entryEntityCollection.getDynamicObjectType();
            for (int i = 0; i < items.size(); ++i) {
                JSONObject ser = items.getJSONObject(i);
                Iterator iterator = ser.entrySet().iterator();
                while (iterator.hasNext()) {
                    DynamicObject entryEntity = new DynamicObject(entryEntityType);
                    Map.Entry entry = (Map.Entry)iterator.next();
                    entryEntity.set("invoiceentrykey", entry.getKey());
                    entryEntity.set("invoiceentryvalue", entry.getValue());
                    entryEntity.set("invoiceentryindex", (Object)i);
                    entryEntityCollection.add((Object)entryEntity);
                }
            }
        }
        DynamicObjectCollection entryKeyValueCollection = invoiceObj.getDynamicObjectCollection(ENTRYKEYVALUE);
        DynamicObjectType entryKeyValueType = entryKeyValueCollection.getDynamicObjectType();
        Iterator iterator = data.entrySet().iterator();
        while (iterator.hasNext()) {
            entryKeyValue = new DynamicObject(entryKeyValueType);
            Map.Entry entry = (Map.Entry)iterator.next();
            entryKeyValue.set(INVOICEKEY, entry.getKey());
            entryKeyValue.set(INVOICEVALUE, entry.getValue());
            entryKeyValueCollection.add((Object)entryKeyValue);
        }
        entryKeyValue = new DynamicObject(entryKeyValueType);
        entryKeyValue.set(INVOICEKEY, (Object)"isTrue");
        entryKeyValue.set(INVOICEVALUE, (Object)isTrue);
        entryKeyValueCollection.add((Object)entryKeyValue);
        return invoiceObj;
    }

    public static String buildTrainAndPlanInvoiceKey(DynamicObject invoiceData) {
        String invoiceType = invoiceData.getString(INVOICETYPE);
        if (StringUtils.isNotEmpty((String)invoiceType) && ("9".equals(invoiceType) || "10".equals(invoiceType))) {
            String[] fields = "9".equals(invoiceType) ? InvoiceParser.getTrainField() : InvoiceParser.getPlanField();
            DynamicObjectCollection entryKeyValueCollection = invoiceData.getDynamicObjectCollection(ENTRYKEYVALUE);
            StringBuilder duduplicate = new StringBuilder();
            for (String field : fields) {
                for (DynamicObject dynamicObject : entryKeyValueCollection) {
                    String invoiceKey = dynamicObject.getString(INVOICEKEY);
                    if (!field.equalsIgnoreCase(invoiceKey) || !StringUtils.isNotEmpty((String)dynamicObject.getString(INVOICEVALUE))) continue;
                    duduplicate.append(field).append('=').append(dynamicObject.getString(INVOICEVALUE)).append('|');
                }
            }
            return duduplicate.length() > 0 ? duduplicate.substring(0, duduplicate.length() - 1) : "";
        }
        return "";
    }

    public static String[] getTrainField() {
        return new String[]{"printingSequenceNo", "trainNum", "invoiceDate"};
    }

    public static String[] getPlanField() {
        return new String[]{"electronicTicketNum", "customerIdentityNum", "printNum"};
    }

    public static List<Map<String, Object>> convertInvoiceMap(List<DynamicObject> invoiceList) {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>(invoiceList.size());
        for (DynamicObject invoice : invoiceList) {
            HashMap<String, Object> invoiceMap = new HashMap<String, Object>();
            invoiceMap.put(INVOICEID, invoice.getPkValue());
            invoiceMap.put(INVOICENO, invoice.getString(INVOICENO));
            invoiceMap.put("imagenumber", invoice.getString("imagenumber"));
            invoiceMap.put(IMAGEPAGE, invoice.getString(IMAGEPAGE));
            invoiceMap.put(INVOICECODE, invoice.getString(INVOICECODE));
            invoiceMap.put(INVOICETYPE, invoice.getString(INVOICETYPE));
            invoiceMap.put(DUPLICATEFIELD, invoice.getString(DUPLICATEFIELD));
            DynamicObjectCollection invoiceEntry = invoice.getDynamicObjectCollection(ENTRYKEYVALUE);
            for (DynamicObject entry : invoiceEntry) {
                invoiceMap.put(entry.getString(INVOICEKEY).toLowerCase(), entry.get(INVOICEVALUE));
            }
            DynamicObjectCollection entryEntityCollection = invoice.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)entryEntityCollection)) {
                ArrayList itemList = new ArrayList(3);
                int rowIndex = -1;
                HashMap<String, Object> rowMap = new HashMap<String, Object>(15);
                for (DynamicObject dynamicObject : entryEntityCollection) {
                    int index = dynamicObject.getInt("invoiceentryindex");
                    if (rowIndex != index) {
                        rowMap = new HashMap(15);
                        itemList.add(rowMap);
                        rowIndex = index;
                    }
                    String key = dynamicObject.getString("invoiceentrykey");
                    if ("taxamount".equals(key = key.toLowerCase(Locale.ENGLISH))) {
                        key = "itemtaxamount";
                    }
                    Object value = dynamicObject.get("invoiceentryvalue");
                    rowMap.put(key, value);
                }
                invoiceMap.put("items", itemList);
            }
            values.add(invoiceMap);
        }
        return values;
    }
}

