/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.engine;

import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.formula.platform.api.BaseFormulaFunctions;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.kscript.IFunctionProvider;
import kd.bos.kscript.runtime.Interpreter;

public class ScriptEngine {
    private static ScriptEngine engine;
    private static ThreadLocal<Interpreter> interpreterThreadLocal;

    private ScriptEngine() {
    }

    public static ScriptEngine getEngine() {
        if (engine == null) {
            engine = new ScriptEngine();
        }
        return engine;
    }

    private Interpreter getInterpreter() {
        Interpreter interpreter = interpreterThreadLocal.get();
        if (interpreter == null) {
            interpreter = new Interpreter();
            interpreter.funcProviderList.clear();
            interpreter.addFunctionProvider((IFunctionProvider)new BaseFormulaFunctions());
            interpreter.setForBot(true);
            interpreterThreadLocal.set(interpreter);
        }
        return interpreter;
    }

    public Object runScript(String script, Map ctx) {
        Interpreter interpreter = this.getInterpreter();
        try {
            return FormulaEngine.runFormula((Interpreter)interpreter, (String)script, (Map)ctx);
        }
        catch (RunFormulaException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    static {
        interpreterThreadLocal = new ThreadLocal();
    }
}

