/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.earlywarn.log.WarnScheduleOperationType;
import kd.bos.entity.earlywarn.log.WarnScheduleStatus;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.earlywarn.warn.EarlyWarnReader;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleMetadata;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleReader;
import kd.bos.service.earlywarn.EarlyWarnServiceResult;
import kd.bos.service.earlywarn.engine.action.EngineLog;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.earlywarn.WarnScheduleMetaServiceHelper;

public class EarlyWarnHelper {
    private static final Log logger = LogFactory.getLog(EarlyWarnHelper.class);
    private static final String KEY_EXECUTE = "execute";

    private EarlyWarnHelper() {
    }

    public static EarlyWarnServiceResult execute() {
        if (!WarnScheduleReader.idExists((String)"1484148923634296832")) {
            logger.error("[DATA-RSA] RiskEvent WarnSchedule notExists");
            throw new KDBizException(ResManager.loadKDString((String)"\u98ce\u9669\u9884\u8b66\u76d1\u63a7\u65b9\u6848\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664\uff01", (String)"EarlyWarnHelper_0", (String)"data-rsa-core", (Object[])new Object[0]));
        }
        WarnScheduleMetadata warnScheduleMetadata = WarnScheduleMetaServiceHelper.loadMetaById((String)"1484148923634296832", (boolean)false);
        if (warnScheduleMetadata == null) {
            logger.error("[DATA-RSA] RiskEvent WarnSchedule is notExists");
            throw new KDBizException(ResManager.loadKDString((String)"\u98ce\u9669\u9884\u8b66\u76d1\u63a7\u65b9\u6848\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664\uff01", (String)"EarlyWarnHelper_0", (String)"data-rsa-core", (Object[])new Object[0]));
        }
        String earlyWarnId = warnScheduleMetadata.getWarnSchedule().getEarlyWarnId();
        if (!EarlyWarnReader.idExists((String)earlyWarnId)) {
            logger.error("[DATA-RSA] RiskEvent WarnSchedule is notExists");
            throw new KDBizException(ResManager.loadKDString((String)"\u98ce\u9669\u9884\u8b66\u76d1\u63a7\u65b9\u6848\u4e2d\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664\uff01", (String)"EarlyWarnHelper_1", (String)"data-rsa-core", (Object[])new Object[0]));
        }
        EngineLog engineLog = EngineLog.getInstance((String)"1484148923634296832", (WarnScheduleOperationType)WarnScheduleOperationType.Manual);
        try {
            engineLog.logNow(ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c", (String)"EarlyWarnHelper_2", (String)"data-rsa-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u98ce\u9669\u9884\u8b66\u76d1\u63a7\u65b9\u6848\u624b\u5de5\u6267\u884c\u5f00\u59cb", (String)"EarlyWarnHelper_3", (String)"data-rsa-core", (Object[])new Object[0]));
            logger.info("[DATA-RSA] RiskEvent WarnSchedule invokeBOSService begin");
            EarlyWarnServiceResult result = (EarlyWarnServiceResult)DispatchServiceHelper.invokeBOSService((String)"rsa", (String)"EarlyWarnService", (String)KEY_EXECUTE, (Object[])new Object[]{"1484148923634296832", WarnScheduleOperationType.Manual.toString(), engineLog.getEarlyWarnLogId()});
            engineLog.logNow(ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c", (String)"EarlyWarnHelper_2", (String)"data-rsa-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u98ce\u9669\u9884\u8b66\u76d1\u63a7\u65b9\u6848\u624b\u5de5\u6267\u884c\u7ed3\u675f", (String)"EarlyWarnHelper_4", (String)"data-rsa-core", (Object[])new Object[0]));
            logger.info("[DATA-RSA] RiskEvent WarnSchedule invokeBOSService end");
            EarlyWarnServiceResult.Status status = result.getStatus();
            if (EarlyWarnServiceResult.Status.SUCCESS == status) {
                engineLog.end(WarnScheduleStatus.Success);
            } else {
                engineLog.end(WarnScheduleStatus.Failure);
            }
            return result;
        }
        catch (Exception e) {
            engineLog.end(WarnScheduleStatus.Failure);
            logger.error("[DATA-RSA] RiskEvent WarnSchedule invokeBOSService EarlyWarnService error!", (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[]{ResManager.loadKDString((String)"\u8c03\u7528\u9884\u8b66\u8fdc\u7a0b\u670d\u52a1\u63a5\u53e3\u5f02\u5e38", (String)"EarlyWarnHelper_5", (String)"data-rsa-core", (Object[])new Object[0])});
        }
    }
}

