/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class MessageSendHelper {
    private static final Log logger = LogFactory.getLog(MessageSendHelper.class);

    private MessageSendHelper() {
    }

    public static List<Long> sendEvalWithMessage(List<Object> evalWithIds) {
        ArrayList<Long> resultIds = new ArrayList<Long>(evalWithIds.size());
        Map evalWithDynMap = BusinessDataServiceHelper.loadFromCache((Object[])evalWithIds.toArray(), (String)"rsa_evalwith");
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>(evalWithDynMap.size());
        DynamicObject messageTimple = BusinessDataServiceHelper.loadSingle((String)"msg_template", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"rsa_evalwith_notice")});
        for (DynamicObject evalWith : evalWithDynMap.values()) {
            MessageInfo messageInfo = new MessageInfo();
            String content = null;
            if (messageTimple != null) {
                Map msgtemplateMap = (Map)SerializationUtils.fromJsonString((String)messageTimple.getString("msgtemplate"), Map.class);
                messageInfo.setMessageTitle((ILocaleString)new LocaleString((String)msgtemplateMap.get("title")));
                content = (String)msgtemplateMap.get("content");
                content = content.replace("{model.dutyorg.name}", evalWith.getString("dutyorg.name")).replace("{model.billno}", evalWith.getString("billno"));
            } else {
                messageInfo.setTitle(ResManager.loadKDString((String)"\u98ce\u9669\u8bc4\u4f30\u5f85\u529e\u901a\u77e5", (String)"MessageSendHelper_0", (String)"data-rsa-core", (Object[])new Object[0]));
                content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u4e00\u5f20 %1$s \u7684\u98ce\u9669\u8bc4\u4f30\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a %2$s \uff09\u5f85\u60a8\u5904\u7406\uff0c\u8bf7\u60a8\u70b9\u51fb\u8be5\u901a\u77e5\u94fe\u63a5\u8df3\u8f6c\u5904\u7406\uff0c\u6216\u6839\u636e\u8def\u5f84\uff1a\u8d22\u52a1\u98ce\u9669\u7ba1\u7406-\u98ce\u9669\u8bc4\u4f30-\u534f\u540c\u8bc4\u4f30\u5904\u7406\uff0c\u524d\u5f80\u5217\u8868\u5904\u7406\u3002", (String)"MessageSendHelper_1", (String)"data-rsa-core", (Object[])new Object[0]), evalWith.getString("dutyorg.name"), evalWith.getString("billno"));
            }
            messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=rsa_riskeval_layout&pkId=" + evalWith.getLong("id"));
            messageInfo.setMessageContent((ILocaleString)new LocaleString(content));
            messageInfo.setUserIds(Collections.singletonList(evalWith.getLong("evaluser.id")));
            messageInfo.setType("message");
            messageInfo.setEntityNumber("rsa_evalwith");
            messageInfo.setNotifyType(messageTimple != null && StringUtils.isNotEmpty((CharSequence)messageTimple.getString("msgchannel")) ? messageTimple.getString("msgchannel") : "mcenter");
            messageInfo.setPubaccNumber("systempubacc");
            messageInfoList.add(messageInfo);
        }
        for (MessageInfo messageInfo : messageInfoList) {
            resultIds.add(MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo));
        }
        return resultIds;
    }

    public static long sendEvalAckMessage(DynamicObject evalAck) {
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)evalAck.getLong("dutyorg"), (String)"bos_org");
        String orgName = org.getString("name");
        String billNo = evalAck.getString("billno");
        MessageInfo messageInfo = new MessageInfo();
        DynamicObject messageTimple = BusinessDataServiceHelper.loadSingle((String)"msg_template", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"rsa_evalack_notice")});
        String content = null;
        if (messageTimple != null) {
            Map msgtemplateMap = (Map)SerializationUtils.fromJsonString((String)messageTimple.getString("msgtemplate"), Map.class);
            messageInfo.setMessageTitle((ILocaleString)new LocaleString((String)msgtemplateMap.get("title")));
            content = (String)msgtemplateMap.get("content");
            content = content.replace("{model.dutyorg.name}", orgName).replace("{model.billno}", billNo);
        } else {
            messageInfo.setTitle(ResManager.loadKDString((String)"\u98ce\u9669\u8bc4\u4f30\u7ed3\u679c\u786e\u8ba4\u5f85\u529e\u901a\u77e5", (String)"MessageSendHelper_2", (String)"data-rsa-core", (Object[])new Object[0]));
            content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u4e00\u5f20 %1$s \u7684\u98ce\u9669\u8bc4\u4f30\u786e\u8ba4\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a %2$s \uff09\u5f85\u60a8\u5904\u7406\uff0c\u8bf7\u60a8\u70b9\u51fb\u8be5\u901a\u77e5\u94fe\u63a5\u8df3\u8f6c\u5904\u7406\uff0c\u6216\u6839\u636e\u8def\u5f84\uff1a\u8d22\u52a1\u98ce\u9669\u7ba1\u7406-\u98ce\u9669\u8bc4\u4f30-\u534f\u540c\u8bc4\u4f30\u5904\u7406\uff0c\u524d\u5f80\u5217\u8868\u5904\u7406\u3002", (String)"MessageSendHelper_3", (String)"data-rsa-core", (Object[])new Object[0]), orgName, billNo);
        }
        messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=rsa_evalack_layout&pkId=" + evalAck.getLong("id"));
        messageInfo.setMessageContent((ILocaleString)new LocaleString(content));
        messageInfo.setUserIds(Collections.singletonList(evalAck.getLong("ackuser.id")));
        messageInfo.setType("message");
        messageInfo.setEntityNumber("rsa_evalwith");
        messageInfo.setNotifyType(messageTimple != null && StringUtils.isNotEmpty((CharSequence)messageTimple.getString("msgchannel")) ? messageTimple.getString("msgchannel") : "mcenter");
        messageInfo.setPubaccNumber("systempubacc");
        return MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public static List<Long> sendCallBackEvalMessage(List<Object> evalWithIds) {
        ArrayList<Long> resultIds = new ArrayList<Long>(evalWithIds.size());
        Map evalWithDynMap = BusinessDataServiceHelper.loadFromCache((Object[])evalWithIds.toArray(), (String)"rsa_evalwith");
        ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>(evalWithDynMap.size());
        DynamicObject messageTimple = BusinessDataServiceHelper.loadSingle((String)"msg_template", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"rsa_evalcallback_notice")});
        for (DynamicObject evalWith : evalWithDynMap.values()) {
            MessageInfo messageInfo = new MessageInfo();
            String content = null;
            if (messageTimple != null) {
                Map msgtemplateMap = (Map)SerializationUtils.fromJsonString((String)messageTimple.getString("msgtemplate"), Map.class);
                messageInfo.setMessageTitle((ILocaleString)new LocaleString((String)msgtemplateMap.get("title")));
                content = (String)msgtemplateMap.get("content");
                content = content.replace("{model.dutyorg.name}", evalWith.getString("dutyorg.name")).replace("{model.billno}", evalWith.getString("billno"));
            } else {
                messageInfo.setTitle(ResManager.loadKDString((String)"\u98ce\u9669\u8bc4\u4f30\u5f85\u529e\u901a\u77e5", (String)"MessageSendHelper_0", (String)"data-rsa-core", (Object[])new Object[0]));
                content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u5f20 %1$s \u7684\u98ce\u9669\u8bc4\u4f30\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a %2$s \uff09\u9700\u91cd\u65b0\u5904\u7406\uff0c\u8bf7\u60a8\u70b9\u51fb\u8be5\u901a\u77e5\u94fe\u63a5\u8df3\u8f6c\u5904\u7406\uff0c\u6216\u6839\u636e\u8def\u5f84\uff1a\u8d22\u52a1\u98ce\u9669\u7ba1\u7406-\u98ce\u9669\u8bc4\u4f30-\u534f\u540c\u8bc4\u4f30\u5904\u7406\uff0c\u524d\u5f80\u5217\u8868\u5904\u7406\u3002", (String)"MessageSendHelper_4", (String)"data-rsa-core", (Object[])new Object[0]), evalWith.getString("dutyorg.name"), evalWith.getString("billno"));
            }
            messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=rsa_riskeval_layout&pkId=" + evalWith.getLong("id"));
            messageInfo.setMessageContent((ILocaleString)new LocaleString(content));
            messageInfo.setUserIds(Collections.singletonList(evalWith.getLong("evaluser.id")));
            messageInfo.setType("message");
            messageInfo.setEntityNumber("rsa_evalwith");
            messageInfo.setNotifyType(messageTimple != null && StringUtils.isNotEmpty((CharSequence)messageTimple.getString("msgchannel")) ? messageTimple.getString("msgchannel") : "mcenter");
            messageInfo.setPubaccNumber("systempubacc");
            messageInfoList.add(messageInfo);
        }
        for (MessageInfo messageInfo : messageInfoList) {
            resultIds.add(MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo));
        }
        return resultIds;
    }
}

