/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgHelper {
    private static final Log logger = LogFactory.getLog(OrgHelper.class);

    private OrgHelper() {
    }

    public static List<Long> getPermOrgList(String entityNumber, String permItemId) {
        String appId = AppMetadataCache.getAppInfo((String)"rsa").getAppId();
        long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return OrgHelper.getAllOrgList();
        }
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)appId, (String)entityNumber, (String)permItemId);
        if (permOrgResult.hasAllOrgPerm()) {
            return OrgHelper.getAllOrgList();
        }
        return permOrgResult.getHasPermOrgs();
    }

    public static Long getSingleUserPermOrg(long userId, String entityNumber, String permItemId) {
        String appId = AppMetadataCache.getAppInfo((String)"rsa").getAppId();
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return OrgUnitServiceHelper.getRootOrgId();
        }
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)appId, (String)entityNumber, (String)permItemId);
        if (permOrgResult.hasAllOrgPerm()) {
            return OrgUnitServiceHelper.getRootOrgId();
        }
        List hasPermOrgList = permOrgResult.getHasPermOrgs();
        if (hasPermOrgList == null || hasPermOrgList.isEmpty()) {
            return OrgUnitServiceHelper.getRootOrgId();
        }
        return (Long)hasPermOrgList.get(0);
    }

    public static List<Long> getPermSubOrgList(String entityNumber, String permItemId) {
        String appId = AppMetadataCache.getAppInfo((String)"rsa").getAppId();
        long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return OrgHelper.getAllSubOrgList();
        }
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)appId, (String)entityNumber, (String)permItemId);
        if (permOrgResult.hasAllOrgPerm()) {
            return OrgHelper.getAllSubOrgList();
        }
        return OrgHelper.getSubOrgList(permOrgResult.getHasPermOrgs());
    }

    public static List<Long> getAllOrgList() {
        return OrgUnitServiceHelper.getAllOrg((String)"15");
    }

    public static List<Long> getAllSubOrgList() {
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        return OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", Collections.singletonList(rootOrgId), (boolean)false);
    }

    public static List<Long> getSubOrgList(List<Long> orgList) {
        return OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgList, (boolean)true);
    }

    public static List<Long> filterOrgDuty(List<Long> orgIds) {
        return OrgUnitServiceHelper.filterOrgDuty(orgIds, (String)"15");
    }

    public static boolean isLeaf(Long orgId) {
        QFilter defaultFilter = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter numberFilter = new QFilter("view.treetype", "=", (Object)"15");
        DynamicObject orgStructureDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (QFilter[])new QFilter[]{defaultFilter, numberFilter});
        long viewId = orgStructureDy == null ? 0L : orgStructureDy.getLong("view.id");
        return OrgServiceHelper.isLeaf((long)orgId, (long)viewId);
    }
}

