/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.data.rsa.helper.OrgHelper;

public class UserHelper {
    private static final String ALGO_KEY = UserHelper.class.getName();

    private UserHelper() {
    }

    public static Map<Long, Long> getUserMainOrgMap(Set<Long> userIdSet) {
        QFilter idFilter = new QFilter("id", "in", userIdSet);
        QFilter partJobFilter = new QFilter("entryentity.ispartjob", "=", (Object)"0");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bos_user", (String)"id,entryentity.dpt.id", (QFilter[])new QFilter[]{idFilter, partJobFilter}, null);){
            HashMap<Long, Long> userMainOrgMap = new HashMap<Long, Long>();
            for (Row row : dataSet) {
                userMainOrgMap.put(row.getLong("id"), row.getLong("entryentity.dpt.id"));
            }
            List<Long> orgUnitIdList = OrgHelper.filterOrgDuty(new ArrayList<Long>(userMainOrgMap.values()));
            HashMap<Long, Long> userOrgMap = new HashMap<Long, Long>(userIdSet.size());
            for (Long userId : userIdSet) {
                if (userMainOrgMap.containsKey(userId)) {
                    Long mainOrgId = (Long)userMainOrgMap.get(userId);
                    if (orgUnitIdList.contains(mainOrgId)) {
                        userOrgMap.put(userId, mainOrgId);
                        continue;
                    }
                    Long orgId = OrgHelper.getSingleUserPermOrg(userId, "rsa_evalwith", "47150e89000000ac");
                    userOrgMap.put(userId, orgId);
                    continue;
                }
                Long orgId = OrgHelper.getSingleUserPermOrg(userId, "rsa_evalwith", "47150e89000000ac");
                userOrgMap.put(userId, orgId);
            }
            HashMap<Long, Long> hashMap = userOrgMap;
            return hashMap;
        }
    }

    public static Long getUserMainOrg(Long userId) {
        List<Long> orgIdList;
        long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
        if (userMainOrgId != 0L && (orgIdList = OrgHelper.filterOrgDuty(Collections.singletonList(userMainOrgId))) != null && !orgIdList.isEmpty()) {
            return orgIdList.get(0);
        }
        return OrgHelper.getSingleUserPermOrg(userId, "rsa_evalwith", "47150e89000000ac");
    }
}

