/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.func;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.data.rsa.utils.AlgoUtil;

public class RiskAnaEntryReduceGroupFunc
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = -8272816936701165846L;
    private final RowMeta rowMeta;

    public RiskAnaEntryReduceGroupFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        Row inherentRow;
        Row residueRow;
        HashMap<String, Row> rowMap = new HashMap<String, Row>(4);
        while (iterator.hasNext()) {
            Row row = iterator.next();
            String name = row.getString("anaentryentity.a_name");
            BigDecimal occScore = row.getBigDecimal("anaentryentity.a_occscore");
            BigDecimal resultScore = row.getBigDecimal("anaentryentity.a_resultscore");
            if (occScore == null || occScore.compareTo(BigDecimal.ZERO) <= 0 || resultScore == null || resultScore.compareTo(BigDecimal.ZERO) <= 0) continue;
            rowMap.put(name, row);
        }
        if (rowMap.containsKey("1") && (residueRow = (Row)rowMap.get("1")) != null) {
            collector.collect(AlgoUtil.rowToObjects(residueRow, this.rowMeta));
            return;
        }
        if (rowMap.containsKey("0") && (inherentRow = (Row)rowMap.get("0")) != null) {
            collector.collect(AlgoUtil.rowToObjects(inherentRow, this.rowMeta));
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

