/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.func;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;

public class RiskHeatMapFilterFunc
extends FilterFunction {
    private static final long serialVersionUID = 3573997141454057895L;
    private final Map<String, Object> extraParamMap;

    public RiskHeatMapFilterFunc(Map<String, Object> extraParamMap) {
        this.extraParamMap = extraParamMap;
    }

    public boolean test(Row row) {
        if (this.extraParamMap.isEmpty()) {
            return true;
        }
        JSONArray xRange = (JSONArray)this.extraParamMap.get("xRange");
        JSONArray yRange = (JSONArray)this.extraParamMap.get("yRange");
        BigDecimal resultScoreMin = new BigDecimal((Integer)xRange.get(0));
        BigDecimal resultScoreMax = new BigDecimal((Integer)xRange.get(1));
        BigDecimal occScoreMin = new BigDecimal((Integer)yRange.get(0));
        BigDecimal occScoreMax = new BigDecimal((Integer)yRange.get(1));
        BigDecimal occScore = row.getBigDecimal("anaentryentity.a_occscore");
        BigDecimal resultScore = row.getBigDecimal("anaentryentity.a_resultscore");
        if (resultScore.compareTo(resultScoreMin) <= 0 || resultScore.compareTo(resultScoreMax) > 0) {
            return false;
        }
        return occScore.compareTo(occScoreMin) > 0 && occScore.compareTo(occScoreMax) <= 0;
    }
}

